/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.inventory;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.item.ItemCleaver;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.tileentity.TileEntityUpgrades;
import rafradek.TF2weapons.util.TF2Util;

public class ContainerUpgrades
extends Container {
    public IInventory upgradedItem = new InventoryBasic("", false, 1);
    private final World world;
    private final BlockPos pos;
    public EntityPlayer player;
    public int currentRecipe = -1;
    public TileEntityUpgrades station;
    public ArrayList<TF2Attribute> applicable;
    public int playerCredits;
    public int[] transactions;
    public int[] transactionsCost;

    public ContainerUpgrades(EntityPlayer player, InventoryPlayer playerInventory, TileEntityUpgrades station, World worldIn, BlockPos posIn) {
        this.station = station;
        this.player = player;
        this.world = worldIn;
        this.pos = posIn;
        this.applicable = new ArrayList();
        this.transactions = new int[0];
        this.transactionsCost = new int[0];
        this.func_75146_a(new Slot(this.upgradedItem, 0, 108, 8){

            public void func_75218_e() {
                super.func_75218_e();
                ContainerUpgrades.this.refreshData();
                ContainerUpgrades.this.transactions = new int[ContainerUpgrades.this.applicable.size()];
                ContainerUpgrades.this.transactionsCost = new int[ContainerUpgrades.this.applicable.size()];
            }

            public boolean func_75214_a(@Nullable ItemStack stack) {
                if (stack.func_190926_b()) {
                    return false;
                }
                return stack.func_77973_b() instanceof ItemFromData && (stack.func_77976_d() == 1 || stack.func_77973_b() instanceof ItemCleaver);
            }
        });
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)playerInventory, i1 + k * 9 + 9, 36 + i1 * 18, 143 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.func_75146_a(new Slot((IInventory)playerInventory, l, 36 + l * 18, 201));
        }
    }

    public void refreshData() {
        this.applicable.clear();
        for (int i = 0; i < this.station.attributeList.size(); ++i) {
            if (this.upgradedItem.func_70301_a(0).func_190926_b() || this.station.attributeList.get(i) == null || !this.station.attributeList.get(i).canApply(this.upgradedItem.func_70301_a(0))) continue;
            this.applicable.add(this.station.attributeList.get(i));
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        int exp = TF2Util.getExperiencePoints(this.player);
        if (this.playerCredits != exp) {
            this.playerCredits = exp;
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71112_a((Container)this, 0, exp);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        if (id == 0) {
            this.playerCredits = data;
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        ItemStack itemstack;
        super.func_75134_a(playerIn);
        if (!this.world.field_72995_K && !(itemstack = this.upgradedItem.func_70304_b(0)).func_190926_b()) {
            playerIn.func_71019_a(itemstack, false);
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.world.func_180495_p(this.pos).func_177230_c() != TF2weapons.blockUpgradeStation ? false : playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    @Nullable
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, 1, 28, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= 1 && index < 28 ? !this.func_75135_a(itemstack1, 0, 1, false) : !this.func_75135_a(itemstack1, 1, 28, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    public boolean func_75140_a(EntityPlayer playerIn, int id) {
        ItemStack stack = this.upgradedItem.func_70301_a(0);
        NBTTagCompound stacktag = stack.func_77978_p();
        int expPoints = TF2Util.getExperiencePoints(playerIn);
        if (id >= 0) {
            boolean austrAdd;
            int idEnch = Math.min(this.applicable.size() - 1, Math.max(id / 2, 0));
            boolean adding = id % 2 == 0;
            TF2Attribute attr = this.applicable.get(idEnch).getAttributeReplacement(stack);
            TF2Attribute attrorig = this.applicable.get(idEnch);
            if (attr == null || stack.func_190926_b() || !attr.canApply(stack)) {
                return false;
            }
            int cost = attr.getUpgradeCost(stack);
            int currLevel = attr.calculateCurrLevel(stack);
            int austrUpgrade = stacktag.func_74764_b("AusUpg") ? (int)stacktag.func_74765_d("AusUpg") : -1;
            boolean bl = austrAdd = currLevel == attr.numLevels && attr.austrUpgrade != 0.0f && stacktag.func_74767_n("Australium") && austrUpgrade != attr.id;
            if (adding && currLevel < this.station.attributes.get(attrorig) && expPoints >= cost && cost + stacktag.func_74762_e("TotalSpent") <= TF2Attribute.getMaxExperience(stack, playerIn)) {
                NBTTagCompound tag = stacktag.func_74775_l("Attributes");
                String key = String.valueOf(attr.id);
                if (!stacktag.func_74764_b("AttributesOrig")) {
                    stacktag.func_74782_a("AttributesOrig", (NBTBase)stacktag.func_74775_l("Attributes").func_74737_b());
                }
                if (!tag.func_74764_b(key)) {
                    tag.func_74776_a(key, attr.defaultValue);
                }
                tag.func_74776_a(key, tag.func_74760_g(key) + attr.getPerLevel(stack));
                stacktag.func_74768_a("TotalCost", stacktag.func_74762_e("TotalCost") + attr.cost);
                stacktag.func_74768_a("TotalSpent", stacktag.func_74762_e("TotalSpent") + cost);
                if (currLevel == attr.numLevels - 1 && attr.numLevels > 1) {
                    stacktag.func_74768_a("LastUpgradesCost", (int)((float)stacktag.func_74762_e("LastUpgradesCost") + (float)attr.cost * (attr.numLevels > 2 ? 3.0f : 1.5f)));
                }
                TF2Util.setExperiencePoints(playerIn, expPoints - cost);
                int n = idEnch;
                this.transactions[n] = this.transactions[n] + 1;
                int n2 = idEnch;
                this.transactionsCost[n2] = this.transactionsCost[n2] + cost;
            } else if (adding && austrAdd) {
                NBTTagCompound tag = stacktag.func_74775_l("Attributes");
                String key = String.valueOf(attr.id);
                if (!stacktag.func_74764_b("AttributesOrig")) {
                    stacktag.func_74782_a("AttributesOrig", (NBTBase)stacktag.func_74775_l("Attributes").func_74737_b());
                }
                tag.func_74776_a(key, tag.func_74760_g(key) + attr.getPerLevel(stack) * attr.austrUpgrade);
                if (austrUpgrade != -1) {
                    tag.func_74776_a(String.valueOf(austrUpgrade), tag.func_74760_g(String.valueOf(austrUpgrade)) - TF2Attribute.attributes[austrUpgrade].getPerLevel(stack) * TF2Attribute.attributes[austrUpgrade].austrUpgrade);
                }
                stacktag.func_74777_a("AusUpg", (short)attr.id);
            } else if (!adding && this.transactions[idEnch] > 0) {
                String key;
                cost = this.transactionsCost[idEnch];
                int count = this.transactions[idEnch];
                NBTTagCompound tag = stacktag.func_74775_l("Attributes");
                if (!tag.func_74764_b(key = String.valueOf(attr.id))) {
                    return false;
                }
                if (attr.id == austrUpgrade) {
                    tag.func_74776_a(key, tag.func_74760_g(key) - attr.getPerLevel(stack) * attr.austrUpgrade);
                    stacktag.func_82580_o("AusUpg");
                }
                tag.func_74776_a(key, tag.func_74760_g(key) - attr.getPerLevel(stack) * (float)count);
                if (tag.func_74760_g(key) == attr.defaultValue) {
                    tag.func_82580_o(key);
                }
                stacktag.func_74768_a("TotalCost", stacktag.func_74762_e("TotalCost") - attr.cost * count);
                stacktag.func_74768_a("TotalSpent", stacktag.func_74762_e("TotalSpent") - cost);
                if (currLevel >= attr.numLevels && attr.numLevels > 1) {
                    stacktag.func_74768_a("LastUpgradesCost", (int)((float)stacktag.func_74762_e("LastUpgradesCost") - (float)attr.cost * (attr.numLevels > 2 ? 3.0f : 1.5f)));
                }
                TF2Util.setExperiencePoints(playerIn, expPoints + cost);
                this.transactions[idEnch] = 0;
                this.transactionsCost[idEnch] = 0;
            }
        } else if (id == -1 && stacktag.func_74764_b("AttributesOrig") && stacktag.func_74762_e("TotalSpent") > 0) {
            stacktag.func_74782_a("Attributes", stacktag.func_74781_a("AttributesOrig").func_74737_b());
            stacktag.func_74768_a("LastUpgradesCost", 0);
            TF2Util.setExperiencePoints(playerIn, expPoints + stacktag.func_74762_e("TotalSpent"));
            stacktag.func_74768_a("TotalSpent", 0);
            stacktag.func_74768_a("TotalCost", 0);
            for (int i = 0; i < this.transactions.length; ++i) {
                this.transactions[i] = 0;
                this.transactionsCost[i] = 0;
            }
            stacktag.func_82580_o("AusUpg");
        }
        return true;
    }
}

