/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.projectile;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.projectile.EntityProjectileBase;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.util.TF2Util;

public class EntityStickybomb
extends EntityProjectileBase {
    public int stickCooldown;

    public EntityStickybomb(World p_i1756_1_) {
        super(p_i1756_1_);
        this.func_70105_a(0.3f, 0.3f);
    }

    @Override
    public void initProjectile(EntityLivingBase shooter, EnumHand hand, ItemStack weapon) {
        super.initProjectile(shooter, hand, weapon);
        this.func_70105_a(0.3f, 0.3f);
        this.setType((int)TF2Attribute.getModifier("Weapon Mode", this.usedWeapon, 0.0f, shooter));
    }

    @Override
    public float getPitchAddition() {
        return 3.0f;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_94541_c() && !TF2Util.isOnSameTeam(source.func_76346_g(), (Entity)this.shootingEntity)) {
            this.addStickCooldown();
        }
        return super.func_70097_a(source, damage);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    public int getArmTime() {
        return Math.round(TF2Attribute.getModifier("Arm Time", this.usedWeapon, 0.8f, this.shootingEntity) * 20.0f);
    }

    public boolean func_70067_L() {
        return this.isSticked();
    }

    @Override
    public void onHitGround(int x, int y, int z, RayTraceResult mop) {
    }

    @Override
    public void onHitMob(Entity entityHit, RayTraceResult mop) {
    }

    public double maxMotion() {
        return Math.max(this.field_70159_w, Math.max(this.field_70181_x, this.field_70179_y));
    }

    @Override
    public void spawnParticles(double x, double y, double z) {
    }

    public void addStickCooldown() {
        this.stickCooldown = 20;
        this.setSticked(false);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.stickCooldown > 0) {
            --this.stickCooldown;
        }
        if (this.shootingEntity == null || !this.shootingEntity.func_70089_S()) {
            this.func_70106_y();
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K) {
            ((WeaponsCapability)this.shootingEntity.getCapability(TF2weapons.WEAPONS_CAP, null)).activeBomb.remove((Object)this);
        }
    }

    @Override
    protected float getSpeed() {
        return 0.7667625f;
    }

    @Override
    public double getGravity() {
        return 0.0381f;
    }

    @Override
    public boolean isSticky() {
        return this.stickCooldown <= 0;
    }

    @Override
    public boolean useCollisionBox() {
        return true;
    }

    @Override
    public int getMaxTime() {
        return 72000;
    }

    @Override
    public float getExplosionSize() {
        return 3.05f;
    }

    @Override
    public void onHitBlockX() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    @Override
    public void onHitBlockY(Block block) {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    @Override
    public void onHitBlockZ() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public boolean func_184202_aL() {
        return super.func_184202_aL() || this.getType() == 1 && this.field_70170_p.field_72995_K && this.shootingEntity == ClientProxy.getLocalPlayer() && this.field_70173_aa >= this.getArmTime() && TF2Util.lookingAt(this.shootingEntity, 30.0, this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Override
    public float getDistanceToTarget(Entity target, double x, double y, double z) {
        if (this.field_70173_aa >= 100) {
            return ((ItemWeapon)this.usedWeapon.func_77973_b()).getWeaponDamageFalloff(this.usedWeapon);
        }
        return super.getDistanceToTarget(target, x, y, z);
    }
}

