/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.projectile;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.entity.projectile.EntityProjectileBase;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemSniperRifle;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;

public class EntityProjectileSimple
extends EntityProjectileBase {
    float damage = -1.0f;
    boolean impact = false;

    public EntityProjectileSimple(World world) {
        super(world);
        this.func_70105_a(0.3f, 0.3f);
    }

    @Override
    public void initProjectile(EntityLivingBase shooter, EnumHand hand, ItemStack weapon) {
        super.initProjectile(shooter, hand, weapon);
        this.func_70105_a(0.3f, 0.3f);
        if (this.usedWeapon.func_77978_p().func_74767_n("ArrowLit")) {
            this.usedWeaponOrig.func_77978_p().func_74757_a("ArrowLit", false);
            this.func_70015_d(1000);
        }
        if (ItemFromData.getData(this.usedWeapon).getString(PropertyType.PROJECTILE).equals("repairclaw")) {
            this.setType(0);
        } else if (ItemFromData.getData(this.usedWeapon).getString(PropertyType.PROJECTILE).equals("syringe")) {
            this.setType(1);
        } else if (ItemFromData.getData(this.usedWeapon).getString(PropertyType.PROJECTILE).equals("cleaver")) {
            this.setType(2);
        } else if (ItemFromData.getData(this.usedWeapon).getString(PropertyType.PROJECTILE).equals("arrow")) {
            this.setType(3);
        } else if (ItemFromData.getData(this.usedWeapon).getString(PropertyType.PROJECTILE).equals("hhhaxe")) {
            this.setType(8);
        }
    }

    @Override
    public void onHitGround(int x, int y, int z, RayTraceResult mop) {
        if (!this.field_70170_p.field_72995_K) {
            this.impact = true;
            if (ItemFromData.getData(this.usedWeapon).hasProperty(PropertyType.HIT_SOUND)) {
                SoundEvent event = ItemFromData.getData(this.usedWeapon).hasProperty(PropertyType.HIT_WORLD_SOUND) ? ItemFromData.getSound(this.usedWeapon, PropertyType.HIT_WORLD_SOUND) : ItemFromData.getSound(this.usedWeapon, PropertyType.HIT_SOUND);
                this.func_184185_a(event, 1.3f, 1.0f);
            }
            if (TF2Attribute.getModifier("Destroy Block", this.usedWeapon, 0.0f, this.shootingEntity) > 0.0f) {
                float damage = this.damage;
                if (damage == -1.0f) {
                    damage = TF2Util.calculateDamage((Entity)TF2weapons.dummyEnt, this.field_70170_p, this.shootingEntity, this.usedWeapon, this.getCritical(), (float)this.shootingEntity.func_174791_d().func_72438_d(mop.field_72307_f));
                    if (this.usedWeapon.func_77973_b() instanceof ItemSniperRifle) {
                        damage *= 2.52f;
                    }
                    damage *= TF2Attribute.getModifier("Destroy Block", this.usedWeapon, 0.0f, this.shootingEntity);
                }
                this.damage = TF2Util.damageBlock(mop.func_178782_a(), this.shootingEntity, this.field_70170_p, this.usedWeapon, this.getCritical(), damage, null, null);
                if (this.damage <= 0.0f) {
                    this.func_70106_y();
                }
            } else {
                this.func_70106_y();
            }
        }
    }

    @Override
    public void onHitMob(Entity entityHit, RayTraceResult mop) {
        this.attackDirect(entityHit, 1.0, mop.hitInfo instanceof Boolean ? (Boolean)mop.hitInfo : false, mop.field_72307_f);
    }

    @Override
    public void spawnParticles(double x, double y, double z) {
    }

    @Override
    public boolean isPushable() {
        return this.getType() != 1;
    }
}

