/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.projectile;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.entity.projectile.EntityProjectileSimple;
import rafradek.TF2weapons.util.TF2Util;

public class EntityProjectileEnergy
extends EntityProjectileSimple {
    double struck;

    public EntityProjectileEnergy(World world) {
        super(world);
    }

    @Override
    public void initProjectile(EntityLivingBase shooter, EnumHand hand, ItemStack weapon) {
        super.initProjectile(shooter, hand, weapon);
        this.setType(4);
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    public boolean canPenetrate() {
        return true;
    }

    @Override
    public double getGravity() {
        return 0.0;
    }

    @Override
    public void onHitMob(Entity entityHit, RayTraceResult mop) {
        super.onHitMob(entityHit, mop);
        if (this.struck == 0.0) {
            this.struck = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72433_c();
            this.field_70159_w = this.field_70159_w / this.struck * 0.9;
            this.field_70181_x = this.field_70181_x / this.struck * 0.9;
            this.field_70179_y = this.field_70179_y / this.struck * 0.9;
        }
    }

    @Override
    public void onHitGround(int x, int y, int z, RayTraceResult mop) {
        if (this.struck == 0.0) {
            super.onHitGround(x, y, z, mop);
        }
    }

    @Override
    public void spawnParticles(double x, double y, double z) {
        ClientProxy.spawnBisonParticle(this.field_70170_p, x, y, z, TF2Util.getTeamColor((Entity)this.shootingEntity));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.hitEntities.size() > 0) {
            this.hitEntities.clear();
        } else if (this.struck != 0.0) {
            this.field_70159_w = this.field_70159_w * this.struck / 0.9;
            this.field_70181_x = this.field_70181_x * this.struck / 0.9;
            this.field_70179_y = this.field_70179_y * this.struck / 0.9;
            this.struck = 0.0;
        }
    }
}

