/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.projectile;

import atomicstryker.dynamiclights.client.DynamicLights;
import atomicstryker.dynamiclights.client.IDynamicLightSource;
import com.google.common.collect.Iterables;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ReportedException;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2DamageSource;
import rafradek.TF2weapons.util.TF2Util;

@Optional.Interface(iface="atomicstryker.dynamiclights.client.IDynamicLightSource", modid="dynamiclights", striprefs=true)
public abstract class EntityProjectileBase
extends Entity
implements IProjectile,
IThrowableEntity,
IDynamicLightSource,
IEntityAdditionalSpawnData {
    public HashSet<Entity> hitEntities = new HashSet();
    public EntityLivingBase shootingEntity;
    public ItemStack usedWeapon = ItemStack.field_190927_a;
    public ItemStack usedWeaponOrig = ItemStack.field_190927_a;
    public double gravity = 0.05;
    public float health = 4.0f;
    public float distanceTravelled;
    public BlockPos stickedBlock;
    public EntitySentry sentry;
    public boolean reflected;
    public boolean infinite;
    public double cachedGravity = -1.0;
    public float damageModifier = 1.0f;
    public float chargeLevel;
    private static final DataParameter<Byte> CRITICAL = EntityDataManager.func_187226_a(EntityProjectileBase.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final DataParameter<Byte> TYPE = EntityDataManager.func_187226_a(EntityProjectileBase.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> STICK = EntityDataManager.func_187226_a(EntityProjectileBase.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> STICK_X = EntityDataManager.func_187226_a(EntityProjectileBase.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> STICK_Y = EntityDataManager.func_187226_a(EntityProjectileBase.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> STICK_Z = EntityDataManager.func_187226_a(EntityProjectileBase.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> GRAVITY = EntityDataManager.func_187226_a(EntityProjectileBase.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> PENETRATE = EntityDataManager.func_187226_a(EntityProjectileBase.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityProjectileBase(World p_i1753_1_) {
        super(p_i1753_1_);
        this.func_70105_a(0.5f, 0.5f);
    }

    public void initProjectile(EntityLivingBase shooter, EnumHand hand, ItemStack weapon) {
        Vec3d trace;
        this.shootingEntity = shooter;
        this.usedWeapon = weapon.func_77946_l();
        this.usedWeaponOrig = weapon;
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70759_as, shooter.field_70125_A + this.getPitchAddition());
        Vec3d look = Vec3d.func_189986_a((float)shooter.field_70125_A, (float)shooter.field_70759_as).func_186678_a(80.0).func_178787_e(shooter.func_174824_e(1.0f));
        if (shooter instanceof EntityPlayer) {
            RayTraceResult ray = (RayTraceResult)Iterables.getFirst(TF2Util.pierce(this.field_70170_p, (Entity)shooter, this.field_70165_t, this.field_70163_u, this.field_70161_v, look.field_72450_a, look.field_72448_b, look.field_72449_c, false, 0.0f, false), null);
            trace = ray.field_72307_f;
        } else {
            trace = look;
        }
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f * (float)(hand == EnumHand.MAIN_HAND ? 1 : -1));
        this.field_70163_u -= shooter instanceof EntitySentry ? -0.1 : (shooter instanceof EntityPlayer ? 0.1 : 0.0);
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f * (float)(hand == EnumHand.MAIN_HAND ? 1 : -1));
        if (trace.func_189985_c() < 2.0) {
            trace = look;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        boolean nospread = false;
        if (TF2Attribute.getModifier("Onyx Projectile", this.usedWeapon, 0.0f, shooter) != 0.0f) {
            this.damageModifier = TF2Attribute.getModifier("Onyx Projectile", this.usedWeapon, 0.0f, shooter);
            nospread = true;
        }
        this.func_70186_c(trace.field_72450_a - this.field_70165_t, trace.field_72448_b - this.field_70163_u, trace.field_72449_c - this.field_70161_v, ((ItemWeapon)this.usedWeapon.func_77973_b()).getProjectileSpeed(this.usedWeapon, shooter), nospread ? 0.0f : ((ItemWeapon)this.usedWeapon.func_77973_b()).getWeaponSpread(this.usedWeapon, shooter) * 133.33333f);
        if (((ItemWeapon)this.usedWeapon.func_77973_b()).canPenetrate(this.usedWeapon, this.shootingEntity)) {
            this.setPenetrate();
        }
        if (((ItemWeapon)this.usedWeapon.func_77973_b()).holdingMode(this.usedWeapon, shooter) != 0) {
            this.chargeLevel = ((ItemWeapon)this.usedWeapon.func_77973_b()).getCharge(shooter, this.usedWeapon);
        }
        this.getGravityOverride();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CRITICAL, (Object)0);
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
        this.field_70180_af.func_187214_a(STICK, (Object)false);
        this.field_70180_af.func_187214_a(STICK_X, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(STICK_Y, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(STICK_Z, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PENETRATE, (Object)false);
        this.field_70180_af.func_187214_a(GRAVITY, (Object)Float.valueOf(-1.0f));
    }

    public float getPitchAddition() {
        return 0.0f;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public void func_70186_c(double x, double y, double z, float speed, float spread) {
        if (spread > 0.0f) {
            float xzlen = MathHelper.func_76133_a((double)(x * x + z * z));
            float yaw = (float)MathHelper.func_181159_b((double)x, (double)z);
            float pitch = (float)MathHelper.func_181159_b((double)y, (double)xzlen);
            Vec3d rand = TF2Util.radiusRandom2D(spread * 0.0075f, this.field_70170_p.field_73012_v, yaw, pitch, speed);
            x = rand.field_72450_a;
            y = rand.field_72448_b;
            z = rand.field_72449_c;
        } else {
            double len = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            x = x / len * (double)speed;
            y = y / len * (double)speed;
            z = z / len * (double)speed;
        }
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f3) * 180.0 / Math.PI);
    }

    public void face(double x, double y, double z, float speedmult) {
        float speed = (float)Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
        this.func_70186_c(x -= this.field_70165_t, y -= this.field_70163_u, z -= this.field_70161_v, speed * speedmult, 0.0f);
    }

    public void face(EntityLivingBase target, float speedmult) {
        float speed = (float)Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
        double x = target.field_70165_t;
        double y = target.field_70163_u + (double)target.func_70047_e();
        double z = target.field_70161_v;
        double dist = target.func_70032_d((Entity)this);
        float gravity = (float)this.getGravityOverride();
        int ticksToReach = MathHelper.func_76143_f((double)(dist / (double)(speed *= speedmult)));
        if (ticksToReach != 0) {
            x += target.field_70159_w * (double)ticksToReach * 1.0;
            z += target.field_70179_y * (double)ticksToReach * 1.0;
            if (!target.func_70090_H()) {
                int ticksGrav = ticksToReach - 1;
                int i = (ticksGrav * ticksGrav + ticksGrav) / 2;
                y += (double)(gravity * (float)i);
            }
        }
        this.face(x, y, z, speedmult);
    }

    public void func_70016_h(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
        this.field_70159_w = p_70016_1_;
        this.field_70181_x = p_70016_3_;
        this.field_70179_y = p_70016_5_;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(p_70016_1_ * p_70016_1_ + p_70016_5_ * p_70016_5_));
            this.field_70126_B = this.field_70177_z = (float)(MathHelper.func_181159_b((double)p_70016_1_, (double)p_70016_5_) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(MathHelper.func_181159_b((double)p_70016_3_, (double)f) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    public void explode(double x, double y, double z, Entity direct, float damageMult) {
        if (this.field_70170_p.field_72995_K || this.shootingEntity == null) {
            return;
        }
        this.func_70106_y();
        float size = this.getExplosionSize() * TF2Attribute.getModifier("Explosion Radius", this.usedWeapon, 1.0f, this.shootingEntity);
        if (TF2Attribute.getModifier("Airborne Bonus", this.usedWeapon, 0.0f, this.shootingEntity) != 0.0f) {
            size *= 0.8f;
        }
        TF2Util.explosion(this.field_70170_p, this.shootingEntity, this.usedWeapon, this, direct, x, y, z, size, damageMult * this.damageModifier, this.getCritical(), this.getDistanceToTarget(null, x, y, z));
    }

    public SoundEvent getExplosionSound() {
        return ItemFromData.getSound(this.usedWeapon, PropertyType.EXPLOSION_SOUND);
    }

    public void addDamageTypes(DamageSource source) {
    }

    public boolean attackDirect(Entity target, double pushForce, boolean headshot, Vec3d hitPos) {
        if (!this.field_70170_p.field_72995_K && !this.hitEntities.contains(target)) {
            boolean proceed;
            this.hitEntities.add(target);
            float distance = this.getDistanceToTarget(target, hitPos.field_72450_a, hitPos.field_72448_b, hitPos.field_72449_c);
            int critical = TF2Util.calculateCritPost(target, this.shootingEntity, headshot ? ((ItemWeapon)this.usedWeapon.func_77973_b()).getHeadshotCrit(this.shootingEntity, this.usedWeapon) : this.getCritical(), this.usedWeapon);
            float dmg = TF2Util.calculateDamage(target, this.field_70170_p, this.shootingEntity, this.usedWeapon, critical, distance) * this.damageModifier;
            DamageSource src = TF2Util.causeBulletDamage(this.usedWeapon, (Entity)this.shootingEntity, critical, this);
            this.addDamageTypes(src);
            if (headshot) {
                ((TF2DamageSource)src).addAttackFlag(2);
            }
            if (!(proceed = ((ItemWeapon)this.usedWeapon.func_77973_b()).onHit(this.usedWeapon, this.shootingEntity, target, dmg, critical, false)) || TF2Util.dealDamage(target, this.field_70170_p, this.shootingEntity, this.usedWeapon, critical, dmg, src)) {
                if (!this.canPenetrate()) {
                    this.func_70106_y();
                }
                if (proceed) {
                    Vec3d pushvec = new Vec3d(target.field_70165_t - hitPos.field_72450_a, target.field_70163_u + (double)(target.field_70131_O / 2.0f) - hitPos.field_72448_b, target.field_70161_v - hitPos.field_72449_c).func_72432_b();
                    pushvec = pushvec.func_186678_a(((ItemWeapon)this.usedWeapon.func_77973_b()).getKnockbackForDamage(this.usedWeapon, this.shootingEntity, dmg, src));
                    if (target instanceof EntityLivingBase) {
                        pushvec = pushvec.func_186678_a(1.0 - ((EntityLivingBase)target).func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111266_c).func_111126_e());
                    }
                    target.func_70024_g(pushvec.field_72450_a, pushvec.field_72448_b, pushvec.field_72449_c);
                    boolean bl = target.field_70160_al = target.field_70160_al || -pushvec.field_72448_b > 0.02;
                    if (target instanceof EntityPlayerMP) {
                        TF2weapons.network.sendTo(new TF2Message.VelocityAddMessage(pushvec, target.field_70160_al), (EntityPlayerMP)target);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public float getDistanceToTarget(Entity target, double x, double y, double z) {
        if (target == null) {
            return (float)new Vec3d(this.shootingEntity.field_70165_t, this.shootingEntity.field_70163_u, this.shootingEntity.field_70161_v).func_72438_d(new Vec3d(x, y, z));
        }
        return (float)TF2Util.getDistanceBox((Entity)this.shootingEntity, target.field_70165_t, target.field_70163_u, target.field_70161_v, (double)target.field_70130_N + 0.1, (double)target.field_70131_O + 0.1);
    }

    public Entity func_184204_a(int dimensionId) {
        return null;
    }

    public float getExplosionSize() {
        return 2.8f;
    }

    public void trace() {
        boolean flag = this.shootingEntity.hasCapability(TF2weapons.WEAPONS_CAP, null);
        if (flag) {
            WeaponsCapability.get((Entity)this.shootingEntity).lastHitCharge = this.chargeLevel;
        }
        boolean headshot = this.usedWeapon.func_190926_b() || !flag ? false : ((ItemWeapon)this.usedWeapon.func_77973_b()).canHeadshot(this.shootingEntity, this.usedWeapon);
        for (RayTraceResult target : TF2Util.pierce(this.field_70170_p, (Entity)this.shootingEntity, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y, headshot, this.getCollisionSize(), this.canPenetrate())) {
            int attr;
            if (target.field_72308_g != null && target.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)target.field_72308_g;
                if (entityplayer.field_71075_bZ.field_75102_a) continue;
            }
            if (!(target.field_72308_g == null || ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)target) || TF2Util.isOnSameTeam((Entity)this.shootingEntity, target.field_72308_g) && this.field_70173_aa < 3 && !this.field_70170_p.field_72995_K && ((ItemWeapon)this.usedWeapon.func_77973_b()).onHit(this.usedWeapon, this.shootingEntity, target.field_72308_g, 1.0f, 0, true))) {
                this.onHitMob(target.field_72308_g, target);
                continue;
            }
            if (target.field_72313_a != RayTraceResult.Type.BLOCK || this.useCollisionBox()) continue;
            if (TF2Attribute.getModifier("Detonate", this.usedWeapon, 0.0f, this.shootingEntity) != 0.0f) {
                TF2Attribute.setAttribute(this.usedWeapon, TF2Attribute.attributes[0], 0.0f);
                this.explode(target.field_72307_f.field_72450_a + (double)target.field_178784_b.func_82601_c() * 0.05, target.field_72307_f.field_72448_b + (double)target.field_178784_b.func_96559_d() * 0.05, target.field_72307_f.field_72449_c + (double)target.field_178784_b.func_82599_e() * 0.05, null, 1.0f);
                return;
            }
            int n = attr = this.field_70170_p.field_72995_K ? 0 : (int)TF2Attribute.getModifier("Coll Remove", this.usedWeapon, 0.0f, this.shootingEntity);
            if (attr == 0 && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)target)) {
                BlockPos blpos = target.func_178782_a();
                this.onHitGround(blpos.func_177958_n(), blpos.func_177956_o(), blpos.func_177952_p(), target);
                continue;
            }
            if (attr == 2) {
                this.explode(target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, null, 1.0f);
                continue;
            }
            this.func_70106_y();
        }
        if (flag) {
            WeaponsCapability.get((Entity)this.shootingEntity).lastHitCharge = 0.0f;
            if (!this.field_70128_L && (WeaponsCapability.get((Entity)this.shootingEntity).state & 2) == 2 && TF2Attribute.getModifier("Detonate", this.usedWeapon, 0.0f, this.shootingEntity) != 0.0f) {
                this.explode(this.field_70165_t + this.field_70159_w * 0.5, this.field_70163_u + this.field_70181_x * 0.5, this.field_70161_v + this.field_70179_y * 0.5, null, 1.0f);
                return;
            }
        }
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > this.getMaxTime()) {
            this.func_70106_y();
            return;
        }
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
        if (this.shootingEntity != null) {
            this.trace();
        }
        if (this.isSticked()) {
            this.func_70107_b(((Float)this.field_70180_af.func_187225_a(STICK_X)).floatValue(), ((Float)this.field_70180_af.func_187225_a(STICK_Y)).floatValue(), ((Float)this.field_70180_af.func_187225_a(STICK_Z)).floatValue());
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0 && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.1f, (double)0.1f, (double)0.1f)).isEmpty()) {
                this.setSticked(false);
            }
        }
        if (this.moveable()) {
            if (!this.useCollisionBox()) {
                this.field_70165_t += this.field_70159_w;
                this.field_70163_u += this.field_70181_x;
                this.field_70161_v += this.field_70179_y;
            } else {
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            float f3 = (float)(1.0 - this.getGravityOverride() / 5.0);
            this.field_70159_w *= (double)f3;
            this.field_70181_x *= (double)f3;
            this.field_70179_y *= (double)f3;
            this.field_70181_x -= this.getGravityOverride();
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            if ((double)f2 > 0.1 || Math.abs(this.field_70181_x) > this.getGravityOverride() * 3.0) {
                this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
                this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI);
                while (this.field_70125_A - this.field_70127_C < -180.0f) {
                    this.field_70127_C -= 360.0f;
                }
                while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                    this.field_70127_C += 360.0f;
                }
                while (this.field_70177_z - this.field_70126_B < -180.0f) {
                    this.field_70126_B -= 360.0f;
                }
                while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                    this.field_70126_B += 360.0f;
                }
                this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
                this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            }
        }
        if (this.field_70170_p.field_72995_K) {
            int j = 0;
            while ((float)j < this.getSpeed()) {
                double pX = this.field_70165_t - this.field_70159_w * (double)j / (double)this.getSpeed() - this.field_70159_w;
                double pY = this.field_70163_u + (double)(this.useCollisionBox() ? this.field_70131_O / 2.0f : 0.0f) - this.field_70181_x * (double)j / (double)this.getSpeed() - this.field_70181_x;
                double pZ = this.field_70161_v - this.field_70179_y * (double)j / (double)this.getSpeed() - this.field_70179_y;
                if (this.getCritical() == 2) {
                    ClientProxy.spawnCritParticle(this.field_70170_p, pX, pY, pZ, TF2Util.getTeamColor((Entity)this.shootingEntity));
                }
                this.spawnParticles(pX, pY, pZ);
                ++j;
            }
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        if (!this.useCollisionBox()) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    public void func_180426_a(double p_180426_1_, double p_180426_3_, double p_180426_5_, float p_180426_7_, float p_180426_8_, int p_180426_9_, boolean p_180426_10_) {
        if (this.moveable()) {
            super.func_180426_a(p_180426_1_, p_180426_3_, p_180426_5_, p_180426_7_, p_180426_8_, p_180426_9_, p_180426_10_);
        }
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.field_70145_X) {
            this.func_174826_a(this.func_174813_aQ().func_72317_d(x, y, z));
            this.func_174829_m();
        } else {
            BlockPos blockpos1;
            IBlockState iblockstate1;
            Block block1;
            int i5;
            int l4;
            BlockPos blockpos;
            IBlockState iblockstate;
            int j4;
            this.field_70170_p.field_72984_F.func_76320_a("move");
            if (this.field_70134_J) {
                this.field_70134_J = false;
                x *= 0.25;
                y *= (double)0.05f;
                z *= 0.25;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            double d3 = x;
            double d4 = y;
            double d5 = z;
            List list1 = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72321_a(x, y, z));
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            int j = list1.size();
            for (int i = 0; i < j; ++i) {
                y = ((AxisAlignedBB)list1.get(i)).func_72323_b(this.func_174813_aQ(), y);
            }
            double limit = y / d4;
            if (!this.isSticky()) {
                this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, y, 0.0));
            }
            boolean i_ = this.field_70122_E || d4 != y && d4 < 0.0;
            int k = list1.size();
            for (j4 = 0; j4 < k; ++j4) {
                x = ((AxisAlignedBB)list1.get(j4)).func_72316_a(this.func_174813_aQ(), x);
            }
            if (this.isSticky()) {
                if (x / d3 < limit) {
                    limit = x / d3;
                }
            } else {
                this.func_174826_a(this.func_174813_aQ().func_72317_d(x, 0.0, 0.0));
            }
            int k4 = list1.size();
            for (j4 = 0; j4 < k4; ++j4) {
                z = ((AxisAlignedBB)list1.get(j4)).func_72322_c(this.func_174813_aQ(), z);
            }
            if (this.isSticky()) {
                if (z / d5 < limit) {
                    limit = z / d5;
                }
                this.func_174826_a(this.func_174813_aQ().func_72317_d(d3 * limit, d4 * limit, d5 * limit));
            } else {
                this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, 0.0, z));
            }
            if (this.field_70138_W > 0.0f && i_ && (d3 != x || d5 != z)) {
                double d11 = x;
                double d7 = y;
                double d8 = z;
                AxisAlignedBB axisalignedbb1 = this.func_174813_aQ();
                this.func_174826_a(axisalignedbb);
                y = this.field_70138_W;
                List list = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72321_a(d3, y, d5));
                AxisAlignedBB axisalignedbb2 = this.func_174813_aQ();
                AxisAlignedBB axisalignedbb3 = axisalignedbb2.func_72321_a(d3, 0.0, d5);
                double d9 = y;
                int i1 = list.size();
                for (int l = 0; l < i1; ++l) {
                    d9 = ((AxisAlignedBB)list.get(l)).func_72323_b(axisalignedbb3, d9);
                }
                axisalignedbb2 = axisalignedbb2.func_72317_d(0.0, d9, 0.0);
                double d15 = d3;
                int k1 = list.size();
                for (int j1 = 0; j1 < k1; ++j1) {
                    d15 = ((AxisAlignedBB)list.get(j1)).func_72316_a(axisalignedbb2, d15);
                }
                axisalignedbb2 = axisalignedbb2.func_72317_d(d15, 0.0, 0.0);
                double d16 = d5;
                int i2 = list.size();
                for (int l1 = 0; l1 < i2; ++l1) {
                    d16 = ((AxisAlignedBB)list.get(l1)).func_72322_c(axisalignedbb2, d16);
                }
                axisalignedbb2 = axisalignedbb2.func_72317_d(0.0, 0.0, d16);
                AxisAlignedBB axisalignedbb4 = this.func_174813_aQ();
                double d17 = y;
                int k2 = list.size();
                for (int j2 = 0; j2 < k2; ++j2) {
                    d17 = ((AxisAlignedBB)list.get(j2)).func_72323_b(axisalignedbb4, d17);
                }
                axisalignedbb4 = axisalignedbb4.func_72317_d(0.0, d17, 0.0);
                double d18 = d3;
                int i3 = list.size();
                for (int l2 = 0; l2 < i3; ++l2) {
                    d18 = ((AxisAlignedBB)list.get(l2)).func_72316_a(axisalignedbb4, d18);
                }
                axisalignedbb4 = axisalignedbb4.func_72317_d(d18, 0.0, 0.0);
                double d19 = d5;
                int k3 = list.size();
                for (int j3 = 0; j3 < k3; ++j3) {
                    d19 = ((AxisAlignedBB)list.get(j3)).func_72322_c(axisalignedbb4, d19);
                }
                axisalignedbb4 = axisalignedbb4.func_72317_d(0.0, 0.0, d19);
                double d20 = d15 * d15 + d16 * d16;
                double d10 = d18 * d18 + d19 * d19;
                if (d20 > d10) {
                    x = d15;
                    z = d16;
                    y = -d9;
                    this.func_174826_a(axisalignedbb2);
                } else {
                    x = d18;
                    z = d19;
                    y = -d17;
                    this.func_174826_a(axisalignedbb4);
                }
                int i4 = list.size();
                for (int l3 = 0; l3 < i4; ++l3) {
                    y = ((AxisAlignedBB)list.get(l3)).func_72323_b(this.func_174813_aQ(), y);
                }
                this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, y, 0.0));
                if (d11 * d11 + d8 * d8 >= x * x + z * z) {
                    x = d11;
                    y = d7;
                    z = d8;
                    this.func_174826_a(axisalignedbb1);
                }
            }
            this.field_70170_p.field_72984_F.func_76319_b();
            this.field_70170_p.field_72984_F.func_76320_a("rest");
            this.func_174829_m();
            this.field_70123_F = d3 != x || d5 != z;
            this.field_70124_G = d4 != y;
            this.field_70122_E = this.field_70124_G && d4 < 0.0;
            boolean bl = this.field_70132_H = this.field_70123_F || this.field_70124_G;
            if (this.isSticky() && !this.field_70170_p.field_72995_K && this.field_70132_H) {
                this.setSticked(true);
            }
            if ((iblockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(j4 = MathHelper.func_76128_c((double)this.field_70165_t), l4 = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), i5 = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() == Material.field_151579_a && ((block1 = (iblockstate1 = this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_177230_c()) instanceof BlockFence || block1 instanceof BlockWall || block1 instanceof BlockFenceGate)) {
                iblockstate = iblockstate1;
                blockpos = blockpos1;
            }
            this.stickedBlock = blockpos;
            this.func_184231_a(y, this.field_70122_E, iblockstate, blockpos);
            if (d3 != x) {
                this.onHitBlockX();
            }
            if (d5 != z) {
                this.onHitBlockZ();
            }
            Block block = iblockstate.func_177230_c();
            if (d4 != y) {
                this.onHitBlockY(block);
            }
            if (this.func_70041_e_() && this.func_184187_bx() == null && block != null && this.field_70122_E) {
                block.func_180634_a(this.field_70170_p, blockpos, iblockstate, (Entity)this);
            }
            try {
                this.func_145775_I();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Checking entity block collision");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
                this.func_85029_a(crashreportcategory);
                throw new ReportedException(crashreport);
            }
            this.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    public void func_70014_b(NBTTagCompound p_70014_1_) {
    }

    public void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    public abstract void onHitGround(int var1, int var2, int var3, RayTraceResult var4);

    public abstract void onHitMob(Entity var1, RayTraceResult var2);

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean moveable() {
        return !this.isSticked();
    }

    public void setCritical(int critical) {
        this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)critical));
    }

    public void setSticked(boolean stick) {
        this.field_70180_af.func_187227_b(STICK, (Object)stick);
        this.field_70180_af.func_187227_b(STICK_X, (Object)Float.valueOf((float)this.field_70165_t));
        this.field_70180_af.func_187227_b(STICK_Y, (Object)Float.valueOf((float)this.field_70163_u));
        this.field_70180_af.func_187227_b(STICK_Z, (Object)Float.valueOf((float)this.field_70161_v));
    }

    public int getCritical() {
        return ((Byte)this.field_70180_af.func_187225_a(CRITICAL)).byteValue();
    }

    public int getType() {
        return ((Byte)this.field_70180_af.func_187225_a(TYPE)).byteValue();
    }

    public boolean isSticked() {
        return (Boolean)this.field_70180_af.func_187225_a(STICK);
    }

    public boolean canPenetrate() {
        return (Boolean)this.field_70180_af.func_187225_a(PENETRATE);
    }

    protected float getSpeed() {
        return 3.0f;
    }

    public double getGravity() {
        return 0.0381f;
    }

    public double getGravityOverride() {
        if (((Float)this.field_70180_af.func_187225_a(GRAVITY)).floatValue() == -1.0f && !this.usedWeapon.func_190926_b()) {
            this.field_70180_af.func_187227_b(GRAVITY, (Object)Float.valueOf(((ItemWeapon)this.usedWeapon.func_77973_b()).getAdditionalGravity(this.shootingEntity, this.usedWeapon, this.getGravity())));
        }
        return ((Float)this.field_70180_af.func_187225_a(GRAVITY)).floatValue();
    }

    public Entity getThrower() {
        return this.shootingEntity;
    }

    public void setThrower(Entity entity) {
        this.shootingEntity = (EntityLivingBase)entity;
    }

    public void setType(int type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)((byte)type));
    }

    public void setPenetrate() {
        this.field_70180_af.func_187227_b(PENETRATE, (Object)true);
    }

    public boolean isSticky() {
        return false;
    }

    public void onHitBlockX() {
        this.field_70159_w = 0.0;
    }

    public void onHitBlockY(Block block) {
        block.func_176216_a(this.field_70170_p, (Entity)this);
    }

    public void onHitBlockZ() {
        this.field_70179_y = 0.0;
    }

    public abstract void spawnParticles(double var1, double var3, double var5);

    public int getMaxTime() {
        return 1000;
    }

    public boolean func_70039_c(NBTTagCompound tagCompund) {
        return false;
    }

    public boolean useCollisionBox() {
        return false;
    }

    public float getCollisionSize() {
        return 0.3f;
    }

    public boolean isPushable() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase && !TF2Util.isOnSameTeam(source.func_76346_g(), (Entity)this.shootingEntity) && !source.func_94541_c() && !source.func_76347_k()) {
            if (source instanceof TF2DamageSource) {
                damage *= Math.max(1.0f, TF2Attribute.getModifier("Destroy Projectiles", ((TF2DamageSource)source).getWeapon(), 0.0f, (EntityLivingBase)source.func_76346_g()));
            }
            this.health -= damage;
            if (this.health <= 0.0f) {
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 512.0 * EntityProjectileBase.func_184183_bd()) * d0;
    }

    @Optional.Method(modid="dynamiclights")
    public void makeLit() {
        if (TF2ConfigVars.dynamicLightsProj) {
            DynamicLights.addLightSource((IDynamicLightSource)this);
        }
    }

    @Optional.Method(modid="dynamiclights")
    public Entity getAttachmentEntity() {
        return this;
    }

    @Optional.Method(modid="dynamiclights")
    public int getLightLevel() {
        return 9;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt((int)(this.field_70159_w * 8000.0));
        buffer.writeInt((int)(this.field_70181_x * 8000.0));
        buffer.writeInt((int)(this.field_70179_y * 8000.0));
    }

    public void readSpawnData(ByteBuf buffer) {
        this.field_70159_w = (double)buffer.readInt() / 8000.0;
        this.field_70181_x = (double)buffer.readInt() / 8000.0;
        this.field_70179_y = (double)buffer.readInt() / 8000.0;
    }
}

