/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.projectile;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.entity.projectile.EntityProjectileBase;
import rafradek.TF2weapons.item.ItemWeapon;

public class EntityGrenade
extends EntityProjectileBase {
    public boolean hitGround;
    public int fuse = 46;
    private static final DataParameter<Byte> BOMB = EntityDataManager.func_187226_a(EntityGrenade.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> BURST = EntityDataManager.func_187226_a(EntityGrenade.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityGrenade(World p_i1756_1_) {
        super(p_i1756_1_);
        this.func_70105_a(0.3f, 0.3f);
    }

    @Override
    public void initProjectile(EntityLivingBase shooter, EnumHand hand, ItemStack weapon) {
        super.initProjectile(shooter, hand, weapon);
        this.func_70105_a(0.3f, 0.3f);
        int weaponmode = (int)TF2Attribute.getModifier("Weapon Mode", this.usedWeapon, 0.0f, shooter);
        if (weaponmode == 1) {
            this.setBomb(1);
            this.func_70105_a(0.7f, 0.7f);
            this.fuse = 26 + this.field_70146_Z.nextInt(20);
            double motion = (double)0.8f + this.field_70146_Z.nextDouble() * 0.55;
            this.field_70159_w *= motion;
            this.field_70181_x *= motion;
            this.field_70179_y *= motion;
        } else if (weaponmode == 2) {
            this.setBomb(2);
            this.fuse = (int)(20.0f - ((ItemWeapon)weapon.func_77973_b()).getCharge(shooter, weapon) * 20.0f);
        } else {
            this.fuse = (int)(TF2Attribute.getModifier("Fuse Time", weapon, 2.3f, shooter) * 20.0f);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BOMB, (Object)0);
        this.field_70180_af.func_187214_a(BURST, (Object)false);
    }

    public void setBomb(int val) {
        this.field_70180_af.func_187227_b(BOMB, (Object)((byte)val));
    }

    public int getBomb() {
        return ((Byte)this.field_70180_af.func_187225_a(BOMB)).byteValue();
    }

    public void setBurst(boolean burst) {
        this.field_70180_af.func_187227_b(BURST, (Object)burst);
    }

    public boolean isBurst() {
        return (Boolean)this.field_70180_af.func_187225_a(BURST);
    }

    @Override
    public float getPitchAddition() {
        return -3.0f;
    }

    @Override
    public float getExplosionSize() {
        return 3.05f;
    }

    @Override
    public void onHitGround(int x, int y, int z, RayTraceResult mop) {
    }

    @Override
    public SoundEvent getExplosionSound() {
        return this.isBurst() ? TF2Sounds.GRENADE_EXPLODESPECIAL : super.getExplosionSound();
    }

    @Override
    public void explode(double x, double y, double z, Entity direct, float damageMult) {
        super.explode(x, y, z, direct, damageMult);
        if (this.field_70170_p.field_72995_K || this.shootingEntity == null) {
            return;
        }
        if (!this.isBurst()) {
            int grenadeSpecialist = (int)TF2Attribute.getModifier("Grenade Specialist", this.usedWeapon, 0.0f, this.shootingEntity);
            int grenadeMult = (int)(2.0f * (direct == null ? 1.5f : 1.0f));
            double rndSpread = direct == null ? (double)0.4f : (double)0.1f;
            for (int i = 0; i < grenadeSpecialist * grenadeMult; ++i) {
                EntityGrenade burst = new EntityGrenade(this.field_70170_p);
                burst.initProjectile(this.shootingEntity, EnumHand.MAIN_HAND, this.usedWeaponOrig);
                burst.func_70107_b(x, y, z);
                double motionmult = 1.0 + this.field_70146_Z.nextDouble() * 0.3 * (double)grenadeSpecialist - 0.15 * (double)grenadeSpecialist;
                if (direct == null) {
                    motionmult += 0.25 + this.field_70146_Z.nextDouble() * 0.1 * (double)grenadeSpecialist;
                }
                burst.func_70186_c(-this.field_70159_w * motionmult * 0.07 + this.field_70146_Z.nextDouble() * rndSpread * 2.0 - rndSpread, 0.2, -this.field_70179_y * motionmult * 0.07 + this.field_70146_Z.nextDouble() * rndSpread * 2.0 - rndSpread, (float)motionmult * 0.3f, 0.0f);
                burst.setBurst(true);
                burst.damageModifier = this.damageModifier * 0.5f;
                this.field_70170_p.func_72838_d((Entity)burst);
            }
        }
    }

    @Override
    public void onHitMob(Entity entityHit, RayTraceResult mop) {
        if (!this.hitGround && !this.isBurst()) {
            if (this.getBomb() == 0) {
                this.explode(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, mop.field_72308_g, 1.0f);
            } else if (!this.hitEntities.contains(entityHit)) {
                if (this.attackDirect(entityHit, 1.0, mop.hitInfo instanceof Boolean ? (Boolean)mop.hitInfo : false, mop.field_72307_f) && entityHit instanceof EntityLivingBase) {
                    ((EntityLivingBase)entityHit).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20, 3));
                }
                this.field_70159_w *= 0.6;
                this.field_70181_x *= 0.65;
                this.field_70179_y *= 0.6;
            }
        }
    }

    public double maxMotion() {
        return Math.max(this.field_70159_w, Math.max(this.field_70181_x, this.field_70179_y));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        --this.fuse;
        if (this.fuse <= 0) {
            this.explode(this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, null, this.getBomb() > 0 ? 1.0f : 0.64f);
        }
        if (this.field_70132_H && !this.hitGround) {
            this.hitGround = true;
            if (!this.field_70170_p.field_72995_K) {
                int attr = (int)TF2Attribute.getModifier("Coll Remove", this.usedWeapon, 0.0f, this.shootingEntity);
                if (attr == 2 || this.isBurst()) {
                    this.explode(this.field_70165_t, this.field_70163_u, this.field_70161_v, null, this.getBomb() > 0 ? 1.0f : 0.64f);
                }
                if (attr == 1) {
                    this.func_70106_y();
                }
            }
        }
    }

    @Override
    public void spawnParticles(double x, double y, double z) {
    }

    @Override
    protected float getSpeed() {
        return 1.16205f;
    }

    @Override
    public double getGravity() {
        return 0.0381f;
    }

    @Override
    public boolean useCollisionBox() {
        return true;
    }

    @Override
    public void onHitBlockX() {
        this.field_70159_w = -this.field_70159_w * 0.18;
        this.field_70181_x *= 0.8;
        this.field_70179_y *= 0.8;
    }

    @Override
    public void onHitBlockY(Block block) {
        this.field_70159_w *= 0.8;
        this.field_70181_x = -this.field_70181_x * 0.18;
        this.field_70179_y *= 0.8;
    }

    @Override
    public void onHitBlockZ() {
        this.field_70159_w *= 0.8;
        this.field_70181_x *= 0.8;
        this.field_70179_y = -this.field_70179_y * 0.18;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (BOMB.equals(key) && this.getBomb() == 1) {
            this.func_70105_a(0.7f, 0.7f);
        }
    }
}

