/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.projectile;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.entity.projectile.EntityProjectileBase;
import rafradek.TF2weapons.util.TF2Util;

public class EntityFlame
extends EntityProjectileBase {
    public EntityFlame(World world) {
        super(world);
    }

    @Override
    public void initProjectile(EntityLivingBase shooter, EnumHand hand, ItemStack weapon) {
        super.initProjectile(shooter, hand, weapon);
        this.func_70024_g(shooter.field_70159_w, shooter.field_70181_x, shooter.field_70179_y);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return false;
    }

    @Override
    public void onHitGround(int x, int y, int z, RayTraceResult mop) {
        if (!this.field_70170_p.field_72995_K && TF2ConfigVars.destTerrain == 2 && this.field_70170_p.func_180495_p(mop.func_178782_a()).func_185904_a().func_76217_h() && this.field_70170_p.func_180495_p(mop.func_178782_a().func_177972_a(mop.field_178784_b)).func_185904_a() != Material.field_151581_o && this.field_70170_p.func_180495_p(mop.func_178782_a().func_177972_a(mop.field_178784_b)).func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, this.func_180425_c().func_177972_a(mop.field_178784_b))) {
            this.field_70170_p.func_175656_a(mop.func_178782_a().func_177972_a(mop.field_178784_b), Blocks.field_150480_ab.func_176223_P());
        }
        this.func_70106_y();
    }

    @Override
    public void onHitMob(Entity entityHit, RayTraceResult mop) {
        if (!this.field_70170_p.field_72995_K && !this.hitEntities.contains(entityHit)) {
            this.hitEntities.add(entityHit);
            int critical = TF2Util.calculateCritPost(entityHit, this.shootingEntity, this.getCritical(), this.usedWeapon);
            float dmg = TF2Util.calculateDamage(entityHit, this.field_70170_p, this.shootingEntity, this.usedWeapon, critical, 1.0f + (float)(this.field_70173_aa - 1) / (float)(this.getMaxTime() - 1));
            if (TF2Util.dealDamage(entityHit, this.field_70170_p, this.shootingEntity, this.usedWeapon, critical, dmg, TF2Util.causeBulletDamage(this.usedWeapon, (Entity)this.shootingEntity, critical, this).func_76361_j()) && (entityHit.field_70173_aa - entityHit.getEntityData().func_74762_e("LastHitBurn") > 1 || entityHit.getEntityData().func_74762_e("LastHitBurn") > entityHit.field_70173_aa)) {
                entityHit.getEntityData().func_74768_a("LastHitBurn", entityHit.field_70173_aa);
                TF2Util.igniteAndAchievement(entityHit, this.shootingEntity, 1, TF2Attribute.getModifier("Burn Time", this.usedWeapon, 1.0f, this.shootingEntity));
            }
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.func_70055_a(Material.field_151586_h)) {
            this.func_70106_y();
            return;
        }
        super.func_70071_h_();
    }

    @Override
    public void spawnParticles(double x, double y, double z) {
    }

    @Override
    public int getMaxTime() {
        return Math.round(3.0f + TF2Attribute.getModifier("Flame Range", this.usedWeapon, 2.0f, this.shootingEntity));
    }

    @Override
    protected float getSpeed() {
        return 1.257f;
    }

    @Override
    public double getGravity() {
        return 0.0;
    }

    @Override
    public float getCollisionSize() {
        return 0.2f + (float)this.field_70173_aa * 0.18f;
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    public boolean canPenetrate() {
        return true;
    }
}

