/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.mercenary;

import com.google.common.base.Charsets;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.util.WeaponData;

public class Squad {
    public int minCount;
    public String name;
    public ArrayList<Unit> units = new ArrayList();
    public int cost;

    public Squad(Type type) {
    }

    public static Multimap<Type, Squad> parseFile(File file) {
        HashMultimap map = HashMultimap.create();
        try {
            String s = Files.toString((File)file, (Charset)Charsets.UTF_8);
            JsonObject tree = new JsonParser().parse(s).getAsJsonObject();
            for (Map.Entry entry : tree.entrySet()) {
                Type type;
                switch ((String)entry.getKey()) {
                    case "giant": {
                        type = Type.GIANT;
                        break;
                    }
                    case "final": {
                        type = Type.FINAL;
                        break;
                    }
                    case "support": {
                        type = Type.SUPPORT;
                        break;
                    }
                    default: {
                        type = Type.NORMAL;
                    }
                }
                for (JsonElement squadEl : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    Squad squad = new Squad(type);
                    JsonObject squadObj = squadEl.getAsJsonObject();
                    squad.name = JsonUtils.func_151219_a((JsonObject)squadObj, (String)"Name", (String)"");
                    squad.minCount = JsonUtils.func_151208_a((JsonObject)squadObj, (String)"Min count", (int)1);
                    squad.cost = JsonUtils.func_151208_a((JsonObject)squadObj, (String)"Cost", (int)1);
                    for (JsonElement unitEl : squadObj.getAsJsonArray("Unit")) {
                        JsonObject unitObj = unitEl.getAsJsonObject();
                        Unit unit = new Unit();
                        if (unitObj.has("Health")) {
                            unit.health = unitObj.get("Health").getAsInt();
                        }
                        unit.entity = new ResourceLocation("rafradek_tf2_weapons", unitObj.get("Class").getAsString());
                        if (unitObj.has("Weapon")) {
                            unit.weapon = MapList.nameToData.get(unitObj.get("Weapon").getAsString());
                        }
                        if (!unitObj.has("Attributes")) continue;
                        for (Map.Entry attribute : unitObj.getAsJsonObject("Attributes").entrySet()) {
                            String attributeName = (String)attribute.getKey();
                            float attributeValue = ((JsonElement)attribute.getValue()).getAsFloat();
                            Iterator<String> iterator2 = MapList.nameToAttribute.keySet().iterator();
                            boolean has = false;
                            while (iterator2.hasNext()) {
                                if (!iterator2.next().equals(attributeName)) continue;
                                unit.attributes.put(MapList.nameToAttribute.get(attributeName), Float.valueOf(attributeValue));
                                has = true;
                            }
                            if (has) continue;
                            unit.attributes.put(TF2Attribute.attributes[Integer.parseInt(attributeName)], Float.valueOf(attributeValue));
                        }
                    }
                    map.put((Object)type, (Object)squad);
                }
            }
        }
        catch (Exception e) {
            TF2weapons.LOGGER.error("Skipped reading squad data from file: %0", (Object)file.getName());
            e.printStackTrace();
        }
        return map;
    }

    public static class Unit {
        HashMap<TF2Attribute, Float> attributes = new HashMap();
        ResourceLocation entity;
        WeaponData weapon;
        int health;
    }

    public static enum Type {
        NORMAL,
        GIANT,
        FINAL,
        SUPPORT;

    }
}

