/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.mercenary;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2EventsCommon;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.entity.mercenary.EntityDemoman;
import rafradek.TF2weapons.entity.mercenary.EntityEngineer;
import rafradek.TF2weapons.entity.mercenary.EntityHeavy;
import rafradek.TF2weapons.entity.mercenary.EntityPyro;
import rafradek.TF2weapons.entity.mercenary.EntityScout;
import rafradek.TF2weapons.entity.mercenary.EntitySniper;
import rafradek.TF2weapons.entity.mercenary.EntitySoldier;
import rafradek.TF2weapons.entity.mercenary.EntitySpy;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.entity.mercenary.Squad;
import rafradek.TF2weapons.entity.mercenary.TF2CharacterAdditionalData;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;
import rafradek.TF2weapons.util.WeaponData;

public class InvasionEvent
implements INBTSerializable<NBTTagCompound> {
    protected final BossInfoServer bossInfo = new BossInfoServer((ITextComponent)new TextComponentTranslation("gui.robotinvasion", new Object[]{1, 1}), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);
    public static final float[] DIFFICULTY = new float[]{1.0f, 1.5f, 2.0f, 2.75f, 4.0f};
    public static Multimap<Squad.Type, Squad> squads;
    public World world;
    public BlockPos target;
    public long startTime;
    public float difficulty;
    public int diffTour;
    public int wave;
    public int progress;
    public List<UUID> playersTotal = new ArrayList<UUID>();
    public Set<EntityPlayer> playersArea = new HashSet<EntityPlayer>();
    public Set<BlockPos> notSpawnArea = new HashSet<BlockPos>();
    public int robotKilledWave;
    public int robotKilledTotal;
    public int robotsWave;
    public int pauseTicks;
    public long endTime;
    public Map<UUID, Float> sentryDamage = new HashMap<UUID, Float>();
    private Set<ChunkPos> eligibleChunksForSpawning = new HashSet<ChunkPos>();
    private HashMap<EntityTF2Character, Integer> entityList = new HashMap();
    public float direction = 0.0f;
    private int robotKilledEnv;
    private int robotCountWeighted;
    private int lowestInvasionBeaten = 100;
    public static List<Biome.SpawnListEntry> spawnList;
    public boolean finished;
    public int waves;

    public InvasionEvent(World world, NBTTagCompound tag) {
        this.world = world;
        this.deserializeNBT(tag);
    }

    public InvasionEvent(World world, BlockPos targetPos, int diff) {
        this.world = world;
        this.startTime = world.func_72820_D();
        this.target = targetPos;
        this.direction = (float)((double)world.field_73012_v.nextFloat() * Math.PI * 2.0 - Math.PI);
        List players = this.world.func_175661_b(EntityPlayerMP.class, player -> this.isInRange(player.func_180425_c()));
        for (EntityPlayerMP player2 : players) {
            float killed = player2.func_147099_x().func_77444_a(TF2weapons.robotsKilled);
            this.difficulty = (float)((double)this.difficulty + (1.0 + Math.min(0.5 + (double)diff * 0.1, (double)(killed / (500.0f * (float)(diff + 1))))));
            this.onPlayerEnter((EntityPlayer)player2);
            this.lowestInvasionBeaten = Math.min(this.lowestInvasionBeaten, TF2PlayerCapability.get((EntityPlayer)player2).maxInvasionBeaten);
            player2.func_145747_a((ITextComponent)new TextComponentTranslation("gui.robotinvasion.message", new Object[0]));
        }
        this.diffTour = diff;
        this.difficulty *= DIFFICULTY[diff] * (3.0f / (float)(players.size() + 2));
        this.waves = TF2ConfigVars.invasionMaxWaves - TF2ConfigVars.invasionMaxWaves / 3 + world.field_73012_v.nextInt(TF2ConfigVars.invasionMaxWaves / 3 + 1);
        this.calculateWave();
    }

    public void onPlayerEnter(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            this.bossInfo.func_186760_a((EntityPlayerMP)player);
        }
        this.playersTotal.add(player.func_110124_au());
        this.playersArea.add(player);
    }

    public void onPlayerLeave(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            this.bossInfo.func_186761_b((EntityPlayerMP)player);
        }
        TF2PlayerCapability.get(player).setInvasionDir(Float.MIN_VALUE);
        TF2PlayerCapability.get((EntityPlayer)player).lastDayInvasion = (int)(this.world.func_72820_D() / 24000L);
    }

    public void addRobotToList(EntityTF2Character entity) {
        if (this.entityList.put(entity, -1) == null) {
            this.robotCountWeighted += entity.isGiant() ? 3 : 1;
        }
    }

    public void removeRobotFromList(EntityTF2Character entity) {
        if (this.entityList.remove(entity) != null) {
            this.robotCountWeighted -= entity.isGiant() ? 3 : 1;
        }
    }

    public void removeRobotCount(EntityTF2Character entity) {
        this.robotCountWeighted -= entity.isGiant() ? 3 : 1;
    }

    public float getWaveDifficulty() {
        return this.difficulty * (1.0f + (float)(this.wave - 1) / 4.0f);
    }

    public int getMaxActiveRobots() {
        return (int)(this.getWaveDifficulty() * 4.2f);
    }

    public void onUpdate() {
        Iterator<EntityPlayer> players = this.playersArea.iterator();
        while (players.hasNext()) {
            EntityPlayer player2 = players.next();
            if (this.isInRange(player2.func_180425_c())) continue;
            this.onPlayerLeave(player2);
            players.remove();
        }
        for (EntityPlayer player3 : this.world.func_175661_b(EntityPlayer.class, player -> !this.playersArea.contains(player) && this.isInRange(player.func_180425_c()))) {
            this.onPlayerEnter(player3);
        }
        if ((this.world.func_82737_E() & 0x6FL) == 0L) {
            for (EntityTF2Character ent : this.world.func_175647_a(EntityTF2Character.class, new AxisAlignedBB(this.target).func_186662_g(256.0), entity -> entity.func_70089_S() && entity.func_184753_b() == null && entity.isRobot())) {
                this.addRobotToList(ent);
            }
        }
        boolean giantslook = false;
        boolean reduce = this.robotCountWeighted > this.getMaxActiveRobots();
        Iterator<Map.Entry<EntityTF2Character, Integer>> it = this.entityList.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<EntityTF2Character, Integer> entry = it.next();
            EntityTF2Character ent = entry.getKey();
            if (ent.field_70128_L) {
                if (ent.func_94060_bK() != null && TF2Util.getOwnerIfOwnable(ent.func_94060_bK()) instanceof EntityPlayer && (ent.func_94060_bK().func_96124_cp() != null || !TF2ConfigVars.canJoin)) {
                    this.onKill((Entity)TF2Util.getOwnerIfOwnable(ent.func_94060_bK()), ent.func_189748_bU(), ent);
                }
                it.remove();
                this.removeRobotCount(ent);
                continue;
            }
            if (ent.func_70638_az() instanceof EntityPlayer && ent.isGiant()) {
                giantslook = true;
            }
            if (ent.field_70173_aa == entry.getValue()) {
                it.remove();
                this.removeRobotCount(ent);
                continue;
            }
            if (ent.func_70654_ax() > (reduce ? 400 : 750)) {
                it.remove();
                ent.func_70106_y();
                this.removeRobotCount(ent);
                continue;
            }
            entry.setValue(ent.field_70173_aa);
        }
        if (this.robotKilledWave >= this.robotsWave && !giantslook) {
            if (this.wave < this.waves) {
                this.calculateWave();
            } else {
                this.finish();
            }
        }
        if (this.pauseTicks <= 0 && this.robotKilledWave < this.robotsWave) {
            this.eligibleChunksForSpawning.clear();
            if (this.robotCountWeighted < this.getMaxActiveRobots()) {
                for (EntityPlayer entityplayer : this.playersArea) {
                    if (entityplayer.func_175149_v()) continue;
                    int j = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
                    int k = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
                    for (int i1 = -7; i1 <= 7; ++i1) {
                        for (int j1 = -7; j1 <= 7; ++j1) {
                            PlayerChunkMapEntry playerchunkmapentry;
                            boolean flag = i1 == -7 || i1 == 7 || j1 == -7 || j1 == 7;
                            ChunkPos chunkpos = new ChunkPos(i1 + j, j1 + k);
                            float distance = i1 * i1 + j1 * j1;
                            float angle = (float)MathHelper.func_181159_b((double)i1, (double)j1);
                            if (this.eligibleChunksForSpawning.contains(chunkpos) || !(Math.PI - Math.abs((double)Math.abs(angle - this.direction) - Math.PI) < 1.2566370614359172) || !(distance / 60.0f < this.world.field_73012_v.nextFloat() + 0.1f) || flag || !this.world.func_175723_af().func_177730_a(chunkpos) || (playerchunkmapentry = ((WorldServer)this.world).func_184164_w().func_187301_b(chunkpos.field_77276_a, chunkpos.field_77275_b)) == null || !playerchunkmapentry.func_187274_e()) continue;
                            this.eligibleChunksForSpawning.add(chunkpos);
                        }
                    }
                }
                BlockPos spawnPoint = this.world.func_175694_M();
                ArrayList shuffled = Lists.newArrayList(this.eligibleChunksForSpawning);
                Collections.shuffle(shuffled);
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                block9: for (ChunkPos chunkpos1 : shuffled) {
                    BlockPos blockpos = InvasionEvent.getRandomChunkPosition(this.world, chunkpos1.field_77276_a, chunkpos1.field_77275_b);
                    int k1 = blockpos.func_177958_n();
                    int l1 = blockpos.func_177956_o();
                    int i2 = blockpos.func_177952_p();
                    IBlockState iblockstate = this.world.func_180495_p(blockpos);
                    if (iblockstate.func_185915_l()) continue;
                    for (int k2 = 0; k2 < 3; ++k2) {
                        int l2 = k1;
                        int i3 = l1;
                        int j3 = i2;
                        Biome.SpawnListEntry spawnEntry = (Biome.SpawnListEntry)WeightedRandom.func_76271_a((Random)this.world.field_73012_v, spawnList);
                        TF2CharacterAdditionalData livingdata = new TF2CharacterAdditionalData();
                        livingdata.natural = true;
                        livingdata.team = 2;
                        int l3 = MathHelper.func_76143_f((double)(Math.random() * 4.0));
                        for (int i4 = 0; i4 < l3; ++i4) {
                            blockpos$mutableblockpos.func_181079_c(l2 += this.world.field_73012_v.nextInt(6) - this.world.field_73012_v.nextInt(6), i3 += this.world.field_73012_v.nextInt(1) - this.world.field_73012_v.nextInt(1), j3 += this.world.field_73012_v.nextInt(6) - this.world.field_73012_v.nextInt(6));
                            float f = (float)l2 + 0.5f;
                            float f1 = (float)j3 + 0.5f;
                            if (this.world.func_175636_b((double)f, (double)i3, (double)f1, 24.0) || !this.checkInArea((int)f, i3, (int)f1) || !(spawnPoint.func_177954_c((double)f, (double)i3, (double)f1) >= 576.0) || !WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntitySpawnPlacementRegistry.func_180109_a(EntityTF2Character.class), (World)this.world, (BlockPos)blockpos$mutableblockpos)) continue;
                            EntityTF2Character entityliving = null;
                            try {
                                entityliving = (EntityTF2Character)spawnEntry.newInstance(this.world);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            entityliving.func_70012_b(f, i3, f1, this.world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                            entityliving.setRobot(1);
                            Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)this.world, (float)f, (float)i3, (float)f1, (boolean)false);
                            if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !entityliving.func_70601_bi() || !entityliving.func_70058_J())) continue;
                            livingdata.isGiant = entityliving.canBecomeGiant() && (double)this.world.field_73012_v.nextFloat() < 0.025 * (double)this.getWaveDifficulty();
                            entityliving.robotStrength = this.difficulty;
                            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityliving, (World)this.world, (float)f, (float)i3, (float)f1)) {
                                livingdata = (TF2CharacterAdditionalData)entityliving.func_180482_a(this.world.func_175649_E(new BlockPos((Entity)entityliving)), livingdata);
                            }
                            if (entityliving.func_70058_J()) {
                                this.world.func_72838_d((Entity)entityliving);
                                this.addRobotToList(entityliving);
                                continue block9;
                            }
                            entityliving.func_70106_y();
                            continue block9;
                        }
                    }
                }
            }
        } else {
            --this.pauseTicks;
            if (this.pauseTicks == 120) {
                for (EntityPlayer player4 : this.playersArea) {
                    TF2Util.playSoundToPlayer(player4, TF2Sounds.MVM_WAVE_START, SoundCategory.VOICE, player4.field_70165_t, player4.field_70163_u, player4.field_70161_v, 6.0f, 1.0f);
                }
            } else if (this.pauseTicks == 0) {
                for (EntityPlayer player4 : this.playersArea) {
                    TF2PlayerCapability.get(player4).setInvasionDir(Float.MIN_VALUE);
                }
            }
        }
        if (this.world.func_72820_D() >= this.endTime) {
            this.finish();
        }
    }

    public void calculateWave() {
        if (this.wave != 0) {
            this.giveRobotAwards();
            this.direction = (float)((double)this.world.field_73012_v.nextFloat() * Math.PI * 2.0 - Math.PI);
            for (EntityPlayer player : this.playersArea) {
                TF2Util.playSoundToPlayer(player, TF2Sounds.MVM_WAVE_END, SoundCategory.VOICE, player.field_70165_t, player.field_70163_u, player.field_70161_v, 6.0f, 1.0f);
            }
        }
        ++this.wave;
        for (EntityPlayer player : this.playersArea) {
            TF2PlayerCapability.get(player).setInvasionDir(this.direction);
        }
        this.pauseTicks = 300;
        this.robotsWave = (int)(11.2f * this.getWaveDifficulty());
        this.robotKilledWave = 0;
        this.endTime = this.world.func_72820_D() + (long)((this.wave + 1) * 12000);
        this.bossInfo.func_186739_a((ITextComponent)new TextComponentTranslation("gui.robotinvasion", new Object[]{this.wave, this.waves}));
        this.bossInfo.func_186735_a(1.0f - (float)this.robotKilledWave / (float)this.robotsWave);
        this.entityList.keySet().removeIf(ent -> {
            ent.func_70097_a(DamageSource.field_76377_j, 99999.0f);
            this.robotCountWeighted -= ent.isGiant() ? 3 : 1;
            return true;
        });
    }

    public void onKill(Entity player, DamageSource source, EntityTF2Character robot) {
        if (player instanceof EntityPlayer) {
            this.playersTotal.add(player.func_110124_au());
        }
        if (robot.damagedByEnv) {
            ++this.robotKilledEnv;
            this.addNotSpawnArea(robot.spawnPos);
            this.addNotSpawnArea(robot.func_180425_c());
        }
        int robotSize = robot.getRobotSize();
        this.robotKilledTotal += robotSize * robotSize * robotSize;
        this.robotKilledWave += robotSize * robotSize * robotSize;
        this.bossInfo.func_186735_a(1.0f - (float)this.robotKilledWave / (float)this.robotsWave);
    }

    public void addNotSpawnArea(BlockPos pos) {
        for (BlockPos pos2 : this.notSpawnArea) {
            if (!(pos.func_177951_i((Vec3i)pos2) < 400.0)) continue;
            return;
        }
        this.notSpawnArea.add(pos);
    }

    public boolean checkInArea(int x, int y, int z) {
        for (BlockPos pos : this.notSpawnArea) {
            if (!(pos.func_177954_c((double)x, (double)y, (double)z) < 400.0)) continue;
            return false;
        }
        return true;
    }

    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.giveRobotAwards();
        for (EntityPlayer player : this.playersArea) {
            TF2Util.playSoundToPlayer(player, TF2Sounds.MVM_WAVE_END, SoundCategory.VOICE, player.field_70165_t, player.field_70163_u, player.field_70161_v, 6.0f, 1.0f);
            if (player instanceof EntityPlayerMP) {
                this.onPlayerLeave((EntityPlayer)((EntityPlayerMP)player));
            }
            if (this.wave != this.waves) continue;
            TF2PlayerCapability.get((EntityPlayer)player).maxInvasionBeaten = Math.max(TF2PlayerCapability.get((EntityPlayer)player).maxInvasionBeaten, this.diffTour + 1);
        }
        for (EntityTF2Character ent : this.entityList.keySet()) {
            ent.func_70097_a(DamageSource.field_76380_i, 9999.0f);
        }
    }

    public void giveRobotAwards() {
        if (this.playersTotal.isEmpty()) {
            return;
        }
        TF2EventsCommon.TF2WorldStorage cap = (TF2EventsCommon.TF2WorldStorage)this.world.getCapability(TF2weapons.WORLD_CAP, null);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        float chance = this.difficulty;
        chance = Math.min(46.0f, (float)Math.pow(this.robotKilledWave, 0.7)) * (this.world.field_73012_v.nextFloat() * 0.8f + 1.05f);
        if (this.wave == this.waves) {
            if (this.lowestInvasionBeaten <= this.diffTour || this.diffTour == DIFFICULTY.length - 1) {
                items.add(new ItemStack(TF2weapons.blockRobotDeploy, this.diffTour - this.lowestInvasionBeaten + 1));
            }
            chance *= 2.0f;
        }
        int itemtype = 2;
        while (chance > 0.0f) {
            boolean australium;
            float chl;
            float cost = 0.0f;
            ItemStack item = ItemStack.field_190927_a;
            if (itemtype == 0 && chance >= 4.5f && !(item = ItemFromData.getRandomWeapon(this.world.field_73012_v, (Predicate<WeaponData>)Predicates.and(arg_0 -> InvasionEvent.lambda$giveRobotAwards$4(chl = chance, australium = chance > 18.0f && this.world.field_73012_v.nextInt(6) == 0, arg_0), ItemFromData.VISIBLE_WEAPON))).func_190926_b()) {
                cost = 0.5f * (float)ItemFromData.getData(item).getInt(PropertyType.COST);
                if (australium) {
                    cost *= 4.0f;
                    item.func_77978_p().func_74757_a("Australium", true);
                    item.func_77978_p().func_74757_a("Strange", true);
                }
                float upgradecost = (chance - cost) * this.world.field_73012_v.nextFloat() * 0.5f;
                TF2Attribute.upgradeItemStack(item, (int)upgradecost * 20, this.world.field_73012_v);
                cost += upgradecost;
            }
            if (cost == 0.0f && itemtype == 1 && chance >= 3.0f) {
                ArrayList<TF2Attribute> list = new ArrayList<TF2Attribute>(Arrays.asList(TF2Attribute.attributes));
                list.removeIf(attr -> attr == null || attr.perKill == 0.0f);
                int level = 0;
                cost = 3.0f;
                float rand = this.world.field_73012_v.nextFloat();
                if (rand < 0.2f && chance >= 27.0f) {
                    level = 2;
                    cost = 27.0f;
                } else if (rand < 0.4f && chance >= 9.0f) {
                    level = 1;
                    cost = 9.0f;
                }
                item = new ItemStack(TF2weapons.itemKillstreakFabricator, 1, list.get((int)this.world.field_73012_v.nextInt((int)list.size())).id + (level << 9));
            }
            if (itemtype == 2) {
                cost = Math.min(chance, 2.0f + this.world.field_73012_v.nextFloat() * 2.0f);
                item = new ItemStack(TF2weapons.itemMoney, Math.round(cost * 3.2f), 1);
            }
            if (item.func_190926_b()) break;
            chance -= cost;
            items.add(item);
            itemtype = this.world.field_73012_v.nextInt(3);
        }
        for (int i = 0; i < items.size(); ++i) {
            cap.getPlayerStorage((UUID)this.playersTotal.get((int)(i % this.playersTotal.size()))).itemsToGive.add(items.get(i));
        }
    }

    public boolean isInRange(BlockPos pos) {
        return pos.func_177951_i((Vec3i)this.target) <= 65536.0;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("start", this.startTime);
        tag.func_74772_a("end", this.endTime);
        tag.func_74776_a("diff", this.difficulty);
        tag.func_74783_a("pos", new int[]{this.target.func_177958_n(), this.target.func_177952_p()});
        tag.func_74774_a("wave", (byte)this.wave);
        tag.func_74777_a("rkwave", (short)this.robotKilledWave);
        tag.func_74777_a("rktotal", (short)this.robotKilledTotal);
        tag.func_74777_a("rwave", (short)this.robotsWave);
        tag.func_74777_a("rkenv", (short)this.robotKilledEnv);
        NBTTagList list = new NBTTagList();
        for (UUID uuid : this.playersTotal) {
            list.func_74742_a((NBTBase)NBTUtil.func_186862_a((UUID)uuid));
        }
        tag.func_74774_a("difftour", (byte)this.diffTour);
        tag.func_74782_a("players", (NBTBase)list);
        tag.func_74774_a("waves", (byte)this.waves);
        tag.func_74776_a("direction", this.direction);
        tag.func_74774_a("lowinvasion", (byte)this.lowestInvasionBeaten);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.startTime = nbt.func_74763_f("start");
        this.difficulty = nbt.func_74760_g("diff");
        int[] coord = nbt.func_74759_k("pos");
        this.target = new BlockPos(coord[0], 0, coord[1]);
        this.wave = nbt.func_74771_c("wave");
        this.waves = nbt.func_74771_c("waves");
        this.endTime = nbt.func_74763_f("end");
        this.bossInfo.func_186739_a((ITextComponent)new TextComponentTranslation("gui.robotinvasion", new Object[]{this.wave, this.waves}));
        this.robotKilledTotal = nbt.func_74765_d("rkwave");
        this.robotKilledWave = nbt.func_74765_d("rktotal");
        this.robotsWave = nbt.func_74765_d("rwave");
        this.robotKilledEnv = nbt.func_74765_d("rkenv");
        this.diffTour = nbt.func_74771_c("difftour");
        this.bossInfo.func_186735_a(1.0f - (float)this.robotKilledWave / (float)this.robotsWave);
        this.direction = nbt.func_74760_g("direction");
        NBTTagList list = nbt.func_150295_c("players", 11);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.playersTotal.add(NBTUtil.func_186860_b((NBTTagCompound)list.func_150305_b(i)));
        }
        this.lowestInvasionBeaten = nbt.func_74771_c("lowinvasion");
    }

    private static BlockPos getRandomChunkPosition(World worldIn, int x, int z) {
        Chunk chunk = worldIn.func_72964_e(x, z);
        int i = x * 16 + worldIn.field_73012_v.nextInt(16);
        int j = z * 16 + worldIn.field_73012_v.nextInt(16);
        int k = MathHelper.func_154354_b((int)(chunk.func_177433_f(new BlockPos(i, 0, j)) + 1), (int)16);
        int l = worldIn.field_73012_v.nextInt(k > 0 ? k : chunk.func_76625_h() + 16 - 1);
        return new BlockPos(i, l, j);
    }

    public void onDamageSentry(EntityTF2Character entity, EntitySentry sentry, DamageSource source, float amount) {
        this.sentryDamage.compute(sentry.func_110124_au(), (uuid, dmg) -> Float.valueOf(dmg == null ? 0.0f : dmg.floatValue() + amount));
    }

    public void onDamageEnv(EntityTF2Character entity, DamageSource source, float amount) {
    }

    private static /* synthetic */ boolean lambda$giveRobotAwards$4(float chl, boolean australium, WeaponData data) {
        return chl > (australium ? 2.0f : 0.5f) * (float)data.getInt(PropertyType.COST);
    }

    static {
        spawnList = new ArrayList<Biome.SpawnListEntry>();
        spawnList.add(new Biome.SpawnListEntry(EntitySoldier.class, 4, 2, 4));
        spawnList.add(new Biome.SpawnListEntry(EntityScout.class, 3, 2, 4));
        spawnList.add(new Biome.SpawnListEntry(EntityPyro.class, 3, 2, 4));
        spawnList.add(new Biome.SpawnListEntry(EntityDemoman.class, 3, 2, 4));
        spawnList.add(new Biome.SpawnListEntry(EntityHeavy.class, 3, 2, 4));
        spawnList.add(new Biome.SpawnListEntry(EntityEngineer.class, 1, 1, 1));
        spawnList.add(new Biome.SpawnListEntry(EntitySniper.class, 1, 1, 1));
        spawnList.add(new Biome.SpawnListEntry(EntitySpy.class, 1, 1, 1));
    }
}

