/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.mercenary;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.items.ItemStackHandler;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2EventsCommon;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.common.TF2Achievements;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.IEntityTF2;
import rafradek.TF2weapons.entity.ai.EntityAIFindDispenser;
import rafradek.TF2weapons.entity.ai.EntityAIFollowTrader;
import rafradek.TF2weapons.entity.ai.EntityAIMoveAttack;
import rafradek.TF2weapons.entity.ai.EntityAIMoveTowardsRestriction2;
import rafradek.TF2weapons.entity.ai.EntityAINearestChecked;
import rafradek.TF2weapons.entity.ai.EntityAIOwnerHurt;
import rafradek.TF2weapons.entity.ai.EntityAISeek;
import rafradek.TF2weapons.entity.ai.EntityAIUseRangedWeapon;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.entity.mercenary.EntityEngineer;
import rafradek.TF2weapons.entity.mercenary.EntityMedic;
import rafradek.TF2weapons.entity.mercenary.EntityScout;
import rafradek.TF2weapons.entity.mercenary.InvasionEvent;
import rafradek.TF2weapons.entity.mercenary.TF2CharacterAdditionalData;
import rafradek.TF2weapons.entity.projectile.EntityProjectileBase;
import rafradek.TF2weapons.inventory.InventoryLoadout;
import rafradek.TF2weapons.item.ItemAmmo;
import rafradek.TF2weapons.item.ItemBackpack;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemHuntsman;
import rafradek.TF2weapons.item.ItemMeleeWeapon;
import rafradek.TF2weapons.item.ItemMoney;
import rafradek.TF2weapons.item.ItemMonsterPlacerPlus;
import rafradek.TF2weapons.item.ItemProjectileWeapon;
import rafradek.TF2weapons.item.ItemToken;
import rafradek.TF2weapons.item.ItemUsable;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.item.ItemWearable;
import rafradek.TF2weapons.util.PlayerPersistStorage;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;
import rafradek.TF2weapons.util.WeaponData;

public class EntityTF2Character
extends EntityCreature
implements IMob,
IMerchant,
IEntityTF2,
IEntityOwnable {
    public static final UUID SPEED_MULT_UUID = UUID.fromString("8ca1776e-72e8-4394-9d0f-0564fdec0b44");
    public static final UUID SPEED_GIANT_MULT_UUID = UUID.fromString("8ca1776e-72e8-4394-9d0f-0564fdec0b41");
    public static final UUID HEALTH_MULT_UUID = UUID.fromString("8ca1776e-72e8-4394-9d0f-0564fdec0b32");
    public static final UUID KNOCKBACK_MULT_UUID = UUID.fromString("8ca1776e-72e8-4394-9d0f-0564fdec0b35");
    public static final UUID FOLLOW_MULT_UUID = UUID.fromString("8ca1776e-72e8-4394-9d0f-0564fdec0b51");
    public static final UUID ARMOR_MULT_UUID = UUID.fromString("8ca1776e-72e8-4452-9d0f-0564fdec0b51");
    public float[] lastRotation;
    public boolean jump;
    public boolean friendly;
    public boolean ranged;
    public EntityAIUseRangedWeapon attack;
    public EntityAIMoveAttack moveAttack;
    public EntityAINearestChecked findplayer = new EntityAINearestChecked(this, EntityLivingBase.class, true, false, this::isValidTarget, true, false);
    protected EntityAIAttackMelee attackMeele = new EntityAIAttackMelee((EntityCreature)this, (double)1.1f, false);
    public EntityAIWander wander;
    public boolean unlimitedAmmo;
    public boolean natural;
    private boolean noAmmo;
    public boolean alert;
    public static int nextEntTeam = -1;
    public EntityPlayer trader;
    public EntityPlayer lastTrader;
    public Map<EntityPlayer, Integer> tradeCount;
    public InventoryLoadout loadout;
    public ItemStackHandler loadoutHeld;
    public ItemStackHandler refill;
    public int followTicks;
    public MerchantRecipeList tradeOffers;
    public double[] targetPrevPos = new double[9];
    private static final DataParameter<Byte> VIS_TEAM = EntityDataManager.func_187226_a(EntityTF2Character.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> DIFFICULTY = EntityDataManager.func_187226_a(EntityTF2Character.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<UUID>> OWNER_UUID = EntityDataManager.func_187226_a(EntityTF2Character.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Byte> ORDER = EntityDataManager.func_187226_a(EntityTF2Character.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> MAIN_WEAPON = EntityDataManager.func_187226_a(EntityTF2Character.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> ACTIVE_SLOT = EntityDataManager.func_187226_a(EntityTF2Character.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> SHARE = EntityDataManager.func_187226_a(EntityTF2Character.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> ROBOT = EntityDataManager.func_187226_a(EntityTF2Character.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> FRONT = EntityDataManager.func_187226_a(EntityTF2Character.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> SIDE = EntityDataManager.func_187226_a(EntityTF2Character.class, (DataSerializer)DataSerializers.field_187191_a);
    public float rotation;
    public int traderFollowTicks;
    public int usedSlot = 0;
    public int bannerTeam = -1;
    private UUID followID;
    public int tradeLevel;
    public String ownerName;
    private int[] ammoCount;
    public int preferredSlot = 0;
    public float eating = 0.0f;
    public EntityAIAvoidEntity<EntitySentry> avoidSentry;
    private int alertTime;
    private EntityLivingBase alertTarget;
    public int difficulty = 0;
    public ArrayList<AttributeModifier> playerAttributes = new ArrayList();
    public boolean[] isEmpty;
    protected boolean noEquipment;
    public boolean spawnMedic;
    private int robotSizeEnsured;
    public float robotStrength = 1.0f;
    public BlockPos spawnPos = BlockPos.field_177992_a;
    public InvasionEvent event;
    public boolean damagedByEnv;
    private WeaponsCapability weaponCap;
    private int moneyDrop;

    public EntityTF2Character(World p_i1738_1_) {
        super(p_i1738_1_);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsRestriction2(this, 1.25));
        this.avoidSentry = new EntityAIAvoidEntity<EntitySentry>((EntityCreature)this, EntitySentry.class, sentry -> {
            double range = sentry.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e() + 1.0;
            range *= range;
            return !TF2Util.isOnSameTeam((Entity)this, (Entity)sentry) && !sentry.isDisabled() && sentry.func_70068_e((Entity)this) < range;
        }, 25.0f, 1.0, 1.0){

            public boolean func_75253_b() {
                double range = ((EntitySentry)this.field_75376_d).func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e() + 1.0;
                range *= range;
                return super.func_75253_b() && this.field_75376_d != null && !(((EntitySentry)this.field_75376_d).func_70068_e((Entity)EntityTF2Character.this) > range);
            }
        };
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.avoidSentry);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowTrader(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFindDispenser(this, 20.0f));
        this.wander = new EntityAIWander((EntityCreature)this, 1.0);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.wander);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityTF2Character.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAISeek((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)this.findplayer);
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIOwnerHurt(this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestChecked(this, EntityLiving.class, true, false, target -> target instanceof IMob && target.func_70068_e(this.func_70902_q()) < 400.0 || target.func_70638_az() == this.func_70902_q(), true, false){

            @Override
            public boolean func_75250_a() {
                return ((EntityTF2Character)this.field_75299_d).func_70902_q() != null && super.func_75250_a();
            }
        });
        this.rotation = 17.0f;
        this.lastRotation = new float[20];
        this.loadout = new InventoryLoadout(5, (EntityLivingBase)this);
        this.loadoutHeld = new ItemStackHandler(8);
        this.refill = new ItemStackHandler(1);
        this.ammoCount = new int[4];
        this.isEmpty = new boolean[4];
        this.field_82174_bp[0] = 0.0f;
        this.field_184655_bs[0] = 0.25f;
        if (p_i1738_1_ != null) {
            this.attack = new EntityAIUseRangedWeapon(this, 1.0f, 19.9f);
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.attack);
            this.moveAttack = new EntityAIMoveAttack(this, 1.0f, 20.0f);
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.moveAttack);
        }
        this.tradeCount = new HashMap<EntityPlayer, Integer>();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack stack = new ItemStack(TF2weapons.itemPlacer, 1, this.getClassIndex() + 9 * this.getEntTeam());
        return stack;
    }

    public float getWidth() {
        return 0.6f;
    }

    public float getHeight() {
        return 1.8f;
    }

    protected void addWeapons() {
        String className = ItemToken.CLASS_NAMES[this.getClassIndex()];
        this.loadout.setStackInSlot(0, ItemFromData.getRandomWeaponOfSlotMob(className, 0, this.field_70146_Z, false, this.getStockWeight(0), this.noEquipment));
        this.loadout.setStackInSlot(1, ItemFromData.getRandomWeaponOfSlotMob(className, 1, this.field_70146_Z, false, this.getStockWeight(1), this.noEquipment));
        this.loadout.setStackInSlot(2, ItemFromData.getRandomWeaponOfSlotMob(className, 2, this.field_70146_Z, false, this.getStockWeight(2), this.noEquipment));
        this.loadout.setStackInSlot(3, ItemFromData.getRandomWeaponOfSlotMob(className, 3, this.field_70146_Z, false, this.getStockWeight(3), this.noEquipment));
        if (!this.noEquipment && !this.isRobot()) {
            if (this.field_70146_Z.nextInt(Math.max(1, (int)((float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 3) / TF2ConfigVars.hatMercenaryMult))) == 0) {
                int i;
                this.tradeLevel = 1;
                this.difficulty = 1;
                this.field_70728_aV *= 2;
                ItemStack hat = ItemFromData.getRandomWeaponOfSlotMob(className, 9, this.field_70146_Z, false, this.getStockWeight(9), false);
                if (!hat.func_190926_b() && this.field_70146_Z.nextInt(9) == 0) {
                    hat.func_77978_p().func_74774_a("UEffect", (byte)this.field_70146_Z.nextInt(10));
                    this.field_184655_bs[0] = 0.35f;
                    this.tradeLevel = 2;
                    this.difficulty = 2;
                    this.field_70728_aV = (int)((double)this.field_70728_aV * 1.5);
                    for (i = 0; i < this.loadout.getSlots(); ++i) {
                        TF2Attribute.upgradeItemStack(this.loadout.getStackInSlot(i), Math.min(1600, 640 + (int)(this.field_70170_p.func_72820_D() / 2000L)), this.field_70146_Z);
                    }
                }
                this.func_184201_a(EntityEquipmentSlot.HEAD, hat);
                if (this.field_70170_p.func_72820_D() > 48000L) {
                    for (i = 0; i < this.loadout.getSlots(); ++i) {
                        TF2Attribute.upgradeItemStack(this.loadout.getStackInSlot(i), Math.min(800, 232 + (int)(this.field_70170_p.func_72820_D() / 4000L)), this.field_70146_Z);
                    }
                }
            } else if (this.field_70146_Z.nextInt(2 + Math.min(5, (int)(this.field_70170_p.func_72820_D() / 160000L))) == 0) {
                ItemStack hat = ItemFromData.getRandomWeapon(this.field_70146_Z, (Predicate<WeaponData>)((Predicate)data -> data.getBoolean(PropertyType.F2P)));
                this.func_184201_a(EntityEquipmentSlot.HEAD, hat);
                this.field_184655_bs[0] = 0.35f;
                this.difficulty = -1;
                this.tradeLevel = -1;
            }
        }
    }

    public float getStockWeight(int slot) {
        return this.isRobot() ? 4.5f - Math.min(2.5f, this.robotStrength / 2.0f) : 2.0f;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        if (this.noEquipment || this.isRobot()) {
            return;
        }
        float chance = 1.0f + 3.0f * (float)this.tradeLevel + (float)(this.tradeLevel * this.tradeLevel) * 2.0f;
        if (this.field_70146_Z.nextFloat() < TF2ConfigVars.armorMult * chance * difficulty.func_180168_b() * 0.3f) {
            int i = this.field_70146_Z.nextInt(2);
            float f = (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.1f : 0.25f) / chance;
            if (this.field_70146_Z.nextFloat() < 0.095f * chance) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f * chance) {
                ++i;
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier("hatarmor", 1.0, 0));
            }
            if (this.field_70146_Z.nextFloat() < 0.095f * chance) {
                ++i;
                this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111121_a(new AttributeModifier("hatarmort", 1.0, 0));
            }
            boolean flag = true;
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                Item item;
                if (entityequipmentslot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
                ItemStack itemstack = this.func_184582_a(entityequipmentslot);
                if (!flag && this.field_70146_Z.nextFloat() < f) break;
                flag = false;
                if (!itemstack.func_190926_b() || entityequipmentslot == EntityEquipmentSlot.HEAD || (item = EntityTF2Character.func_184636_a((EntityEquipmentSlot)entityequipmentslot, (int)i)) == null) continue;
                this.func_184201_a(entityequipmentslot, new ItemStack(item));
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VIS_TEAM, (Object)((byte)this.field_70146_Z.nextInt(2)));
        this.field_70180_af.func_187214_a(DIFFICULTY, (Object)0);
        this.field_70180_af.func_187214_a(OWNER_UUID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(ORDER, (Object)0);
        this.field_70180_af.func_187214_a(SHARE, (Object)false);
        this.field_70180_af.func_187214_a(ROBOT, (Object)0);
        this.field_70180_af.func_187214_a(FRONT, (Object)0);
        this.field_70180_af.func_187214_a(SIDE, (Object)0);
        this.field_70180_af.func_187214_a(MAIN_WEAPON, (Object)-1);
        this.weaponCap = new WeaponsCapability((EntityLivingBase)this);
    }

    public int getEntTeam() {
        return this.isRobot() ? 2 : (int)((Byte)this.field_70180_af.func_187225_a(VIS_TEAM)).byteValue();
    }

    public int getDiff() {
        return Math.max(0, (Byte)this.field_70180_af.func_187225_a(DIFFICULTY) + this.difficulty + (this.isGiant() ? 2 : 0));
    }

    public void setEntTeam(int team) {
        this.field_70180_af.func_187227_b(VIS_TEAM, (Object)((byte)team));
    }

    public void setDiff(int diff) {
        this.field_70180_af.func_187227_b(DIFFICULTY, (Object)((byte)diff));
    }

    public Order getOrder() {
        return Order.values()[(Byte)this.field_70180_af.func_187225_a(ORDER)];
    }

    public void setOrder(Order order) {
        this.field_70180_af.func_187227_b(ORDER, (Object)((byte)order.ordinal()));
    }

    public int getMainWeapon() {
        return ((Byte)this.field_70180_af.func_187225_a(MAIN_WEAPON)).byteValue();
    }

    public void setMainWeapon(int slot) {
        this.field_70180_af.func_187227_b(MAIN_WEAPON, (Object)((byte)slot));
    }

    public boolean isSharing() {
        return (Boolean)this.field_70180_af.func_187225_a(SHARE);
    }

    public boolean isRobot() {
        return (Byte)this.field_70180_af.func_187225_a(ROBOT) != 0;
    }

    public int getRobotSize() {
        return ((Byte)this.field_70180_af.func_187225_a(ROBOT)).byteValue();
    }

    public boolean isGiant() {
        return (Byte)this.field_70180_af.func_187225_a(ROBOT) > 1;
    }

    public void setRobot(int robot) {
        this.field_70180_af.func_187227_b(ROBOT, (Object)((byte)robot));
        if (robot > 0) {
            if (this.func_184753_b() != null) {
                TF2Util.addModifierSafe((EntityLivingBase)this, SharedMonsterAttributes.field_111265_b, new AttributeModifier(FOLLOW_MULT_UUID, "GiantRange", 0.4, 2), true);
            }
            if (robot > 1) {
                this.field_70138_W = 1.0f;
                this.field_70714_bg.func_85156_a(this.avoidSentry);
                TF2Util.addModifierSafe((EntityLivingBase)this, SharedMonsterAttributes.field_188791_g, new AttributeModifier(ARMOR_MULT_UUID, "GiantArmor", -0.5, 2), true);
                TF2Util.addModifierSafe((EntityLivingBase)this, SharedMonsterAttributes.field_111267_a, new AttributeModifier(HEALTH_MULT_UUID, "GiantHealth", (0.25 + (double)this.robotStrength) * 2.5, 1), true);
                TF2Util.addModifierSafe((EntityLivingBase)this, SharedMonsterAttributes.field_111266_c, new AttributeModifier(KNOCKBACK_MULT_UUID, "GiantKnockback", 0.6, 0), true);
                TF2Util.addModifierSafe((EntityLivingBase)this, SharedMonsterAttributes.field_111265_b, new AttributeModifier(FOLLOW_MULT_UUID, "GiantRange", 0.8, 2), true);
                this.func_70606_j(this.func_110138_aP());
                if (!(this instanceof EntityScout) && !(this instanceof EntityMedic)) {
                    TF2Util.addModifierSafe((EntityLivingBase)this, SharedMonsterAttributes.field_111263_d, new AttributeModifier(SPEED_GIANT_MULT_UUID, "GiantSpeed", -0.43, 2), true);
                }
            }
        }
    }

    public void setSharing(boolean share) {
        this.field_70180_af.func_187227_b(SHARE, (Object)share);
    }

    public int getAmmo() {
        return this.getAmmo(this.usedSlot);
    }

    public void func_70659_e(float speedIn) {
        if (this.isGiant()) {
            speedIn = Math.max(speedIn, (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() * (this.getRobotSize() == 2 ? 0.4f : 0.5f));
        }
        super.func_70659_e(speedIn);
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return !this.isGiant() || potioneffectIn.func_188419_a() != TF2weapons.stun;
    }

    public void func_70624_b(EntityLivingBase target) {
        super.func_70624_b(target);
        if (this.isTrading() && target != null && this.func_70931_l_() != this.func_70902_q()) {
            this.func_70932_a_(null);
        }
        if (!this.alert) {
            for (EntityTF2Character ent : this.field_70170_p.func_72872_a(EntityTF2Character.class, new AxisAlignedBB(this.field_70165_t - 15.0, this.field_70163_u - 6.0, this.field_70161_v - 15.0, this.field_70165_t + 15.0, this.field_70163_u + 6.0, this.field_70161_v + 15.0))) {
                if (!TF2Util.isOnSameTeam((Entity)this, (Entity)ent) || TF2Util.isOnSameTeam((Entity)this, (Entity)target) || ent.func_70638_az() != null && !ent.func_70638_az().field_70128_L) continue;
                ent.alert = true;
                ent.alertTarget = target;
                ent.alertTime = ent.field_70173_aa + 8 + this.func_70681_au().nextInt(14);
            }
        }
    }

    public void useAmmo(int amount) {
        if (!this.unlimitedAmmo) {
            int n = this.usedSlot;
            this.ammoCount[n] = this.ammoCount[n] - amount;
        }
    }

    public boolean shouldScaleAttributes() {
        return this.func_70638_az() != null && TF2ConfigVars.scaleAttributes && (this.func_70638_az() instanceof EntityPlayer || this.func_70638_az() instanceof IEntityOwnable && ((IEntityOwnable)this.func_70638_az()).func_184753_b() != null) && this.func_184753_b() == null;
    }

    public float getAttributeModifier(String attribute) {
        float base = 1.0f;
        if (this.func_70660_b(TF2weapons.sapped) != null) {
            base *= 2.0f;
        }
        if (this.shouldScaleAttributes()) {
            if (attribute.equals("Knockback")) {
                base *= this.scaleWithDifficulty(0.4f, 1.0f);
            } else if (attribute.equals("Fire Rate")) {
                base *= this.scaleWithDifficulty(1.9f, 1.0f);
            } else if (attribute.equals("Spread")) {
                base *= this.scaleWithDifficulty(1.9f, 1.0f);
            } else if (attribute.equals("Damage") && this.func_184614_ca().func_77973_b() instanceof ItemMeleeWeapon) {
                base *= 1.25f;
            }
        }
        if (attribute.equals("Auto Fire")) {
            return 0.0f;
        }
        return base;
    }

    public boolean hasHeldInventory() {
        return !this.isRobot() || this.func_184753_b() == null;
    }

    public void func_70636_d() {
        ItemStack backpack;
        if (this.field_70170_p.field_72995_K && !Minecraft.func_71410_x().func_71387_A()) {
            this.field_191988_bg = (float)((Byte)this.field_70180_af.func_187225_a(FRONT)).byteValue() / 128.0f;
            this.field_70702_br = (float)((Byte)this.field_70180_af.func_187225_a(SIDE)).byteValue() / 128.0f;
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(FRONT, (Object)((byte)MathHelper.func_76125_a((int)Math.round(this.field_191988_bg * 128.0f), (int)-128, (int)127)));
            this.field_70180_af.func_187227_b(SIDE, (Object)((byte)MathHelper.func_76125_a((int)Math.round(this.field_70702_br * 128.0f), (int)-128, (int)127)));
        }
        this.func_82168_bl();
        ItemStack hat = this.func_184582_a(EntityEquipmentSlot.HEAD);
        if (!hat.func_190926_b() && hat.func_77973_b() instanceof ItemWearable) {
            ((ItemWearable)hat.func_77973_b()).onUpdateWearing(hat, this.field_70170_p, (EntityLivingBase)this);
        }
        if (!(backpack = ItemBackpack.getBackpack((EntityLivingBase)this)).func_190926_b() && backpack.func_77973_b() instanceof ItemBackpack) {
            ((ItemBackpack)backpack.func_77973_b()).onArmorTickAny(this.field_70170_p, (EntityLivingBase)this, backpack);
        }
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
        if (!this.friendly && this.func_70638_az() instanceof EntityTF2Character && TF2Util.isOnSameTeam((Entity)this, (Entity)this.func_70638_az())) {
            this.func_70624_b(null);
        }
        if (this.jump && this.field_70122_E) {
            this.func_70664_aZ();
        }
        if (this.spawnMedic) {
            TF2CharacterAdditionalData data = new TF2CharacterAdditionalData();
            data.team = this.getEntTeam();
            data.natural = true;
            data.allowGiant = this.isGiant();
            EntityMedic medic = new EntityMedic(this.field_70170_p);
            medic.func_70012_b(this.field_70165_t + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70163_u, this.field_70161_v + this.field_70146_Z.nextDouble() * 0.5 - 0.25, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            medic.func_180482_a(this.field_70170_p.func_175649_E(this.func_190671_u_()), data);
            this.field_70170_p.func_72838_d((Entity)medic);
            this.spawnMedic = false;
        }
        if ((this.getCapability(TF2weapons.WEAPONS_CAP, null).state & 4) == 0) {
            this.getCapability(TF2weapons.WEAPONS_CAP, null).state += 4;
        }
        if (!this.noAmmo && this.func_70638_az() != null && Math.abs(this.field_70177_z - this.field_70759_as) > 60.0f) {
            this.field_70177_z = this.field_70759_as - this.field_70177_z > 60.0f ? this.field_70759_as + 60.0f : this.field_70759_as - 60.0f;
        }
        if (this.field_70148_d) {
            this.spawnPos = this.func_180425_c();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 2 == 0) {
                this.loadout.updateSlots();
            }
            if (this.isRobot()) {
                if (this.func_70638_az() == null || this.friendly && this.func_70638_az().func_94060_bK() == null) {
                    ++this.field_70708_bq;
                    if (this.field_70708_bq > 800 + this.getRobotSize() * 500) {
                        this.func_70106_y();
                    }
                }
                if (this.func_70660_b(TF2weapons.sapped) != null) {
                    this.field_70125_A = 40.0f;
                }
            }
            if (this.getOrder() == Order.HOLD && !this.func_110175_bO()) {
                this.func_175449_a(this.func_190671_u_(), 12);
            } else if (this.getOrder() == Order.FOLLOW && this.func_110175_bO()) {
                this.func_110177_bN();
            }
            this.setDiff(this.field_70170_p.func_175659_aa().func_151525_a());
            if (this.isTrading() && (this.trader.func_70068_e((Entity)this.trader) > 100.0 || !this.func_70089_S())) {
                this.func_70932_a_(null);
            }
            if (this.func_184614_ca().func_77973_b() instanceof ItemUsable && !((ItemUsable)this.func_184614_ca().func_77973_b()).isAmmoSufficient(this.func_184614_ca(), (EntityLivingBase)this, true) && !this.refill(this.usedSlot)) {
                this.switchSlot(this.getFirstSlotWithAmmo(), true, false);
            }
            if (this.preferredSlot != this.usedSlot) {
                this.switchSlot(this.preferredSlot);
            }
            if (this.traderFollowTicks > 0) {
                --this.traderFollowTicks;
                if (this.followID != null && this.lastTrader == null) {
                    this.lastTrader = this.field_70170_p.func_152378_a(this.followID);
                }
            }
            if (this.refill.getStackInSlot(0).func_77973_b() instanceof ItemAmmo || this.refill.getStackInSlot(0).func_77973_b() instanceof ItemArrow) {
                ItemStack ammoStack = this.refill.getStackInSlot(0);
                int ammoType = ammoStack.func_77973_b() instanceof ItemAmmo ? ((ItemAmmo)ammoStack.func_77973_b()).getTypeInt(ammoStack) : 1000;
                for (int i = 0; i < this.ammoCount.length; ++i) {
                    if (this.getAmmo(i) >= this.getMaxAmmo(i) || ammoType != ItemFromData.getData(this.loadout.getStackInSlot(i)).getInt(PropertyType.AMMO_TYPE)) continue;
                    if (ammoStack.func_77984_f()) {
                        int oldAmmo = this.getMaxAmmo(i) - this.ammoCount[i];
                        int n = i;
                        this.ammoCount[n] = this.ammoCount[n] + Math.min((ammoStack.func_77958_k() - ammoStack.func_77952_i()) * 2, this.getMaxAmmo(i) - this.ammoCount[i]);
                        ammoStack.func_77964_b(ammoStack.func_77952_i() + oldAmmo);
                        if (ammoStack.func_77952_i() <= ammoStack.func_77958_k()) continue;
                        this.refill.setStackInSlot(0, ItemStack.field_190927_a);
                        continue;
                    }
                    int n = i;
                    this.ammoCount[n] = this.ammoCount[n] + this.refill.extractItem(0, (this.getMaxAmmo(i) - this.ammoCount[i]) / 2, false).func_190916_E() * 2;
                }
            } else if (this.func_184607_cu().func_190926_b() && this.func_70638_az() == null && this.func_110143_aJ() / this.func_110138_aP() < 0.7f && this.refill.getStackInSlot(0).func_77973_b() instanceof ItemFood) {
                this.func_184611_a(EnumHand.OFF_HAND, this.refill.getStackInSlot(0));
                this.func_184598_c(EnumHand.OFF_HAND);
            }
            if (this.alert && this.alertTarget != null && this.alertTime == this.field_70173_aa) {
                this.func_70624_b(this.alertTarget);
                this.alert = false;
            }
        }
        for (int i = 19; i > 0; --i) {
            this.lastRotation[i] = this.lastRotation[i - 1];
        }
        this.lastRotation[0] = (float)Math.sqrt((this.field_70759_as - this.field_70758_at) * (this.field_70759_as - this.field_70758_at) + (this.field_70125_A - this.field_70127_C) * (this.field_70125_A - this.field_70127_C));
    }

    protected float func_189749_co() {
        return this.func_184753_b() != null ? 1.0f : 0.9f;
    }

    public void func_191986_a(float m1, float m2, float m3) {
        float move = this.func_70689_ay();
        super.func_191986_a(m1 / move, m2, m3 / move);
        if (!this.func_70613_aW() && !Minecraft.func_71410_x().func_71387_A()) {
            if (!this.func_70090_H()) {
                if (!this.func_180799_ab()) {
                    if (this.func_184613_cA()) {
                        double d11;
                        double d3;
                        float f5;
                        if (this.field_70181_x > -0.5) {
                            this.field_70143_R = 1.0f;
                        }
                        Vec3d vec3d = this.func_70040_Z();
                        float f = this.field_70125_A * ((float)Math.PI / 180);
                        double d6 = Math.sqrt(vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c);
                        double d8 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                        double d1 = vec3d.func_72433_c();
                        float f4 = MathHelper.func_76134_b((float)f);
                        f4 = (float)((double)f4 * (double)f4 * Math.min(1.0, d1 / 0.4));
                        this.field_70181_x += -0.08 + (double)f4 * 0.06;
                        if (this.field_70181_x < 0.0 && d6 > 0.0) {
                            double d2 = this.field_70181_x * -0.1 * (double)f4;
                            this.field_70181_x += d2;
                            this.field_70159_w += vec3d.field_72450_a * d2 / d6;
                            this.field_70179_y += vec3d.field_72449_c * d2 / d6;
                        }
                        if (f < 0.0f) {
                            double d10 = d8 * (double)(-MathHelper.func_76126_a((float)f)) * 0.04;
                            this.field_70181_x += d10 * 3.2;
                            this.field_70159_w -= vec3d.field_72450_a * d10 / d6;
                            this.field_70179_y -= vec3d.field_72449_c * d10 / d6;
                        }
                        if (d6 > 0.0) {
                            this.field_70159_w += (vec3d.field_72450_a / d6 * d8 - this.field_70159_w) * 0.1;
                            this.field_70179_y += (vec3d.field_72449_c / d6 * d8 - this.field_70179_y) * 0.1;
                        }
                        this.field_70159_w *= (double)0.99f;
                        this.field_70181_x *= (double)0.98f;
                        this.field_70179_y *= (double)0.99f;
                        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                        if (this.field_70123_F && !this.field_70170_p.field_72995_K && (f5 = (float)((d3 = d8 - (d11 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) * 10.0 - 3.0)) > 0.0f) {
                            this.func_184185_a(this.func_184588_d((int)f5), 1.0f, 1.0f);
                            this.func_70097_a(DamageSource.field_188406_j, f5);
                        }
                        if (this.field_70122_E && !this.field_70170_p.field_72995_K) {
                            this.func_70052_a(7, false);
                        }
                    } else {
                        float f6 = 0.91f;
                        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185345_c((double)this.field_70165_t, (double)(this.func_174813_aQ().field_72338_b - 1.0), (double)this.field_70161_v);
                        if (this.field_70122_E) {
                            IBlockState underState = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                            f6 = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos, (Entity)this) * 0.91f;
                        }
                        float f7 = 0.16277136f / (f6 * f6 * f6);
                        float f8 = this.field_70122_E ? f7 : this.field_70747_aH;
                        this.moveRelativeLook(m1, m2, m3, f8);
                        f6 = 0.91f;
                        if (this.field_70122_E) {
                            IBlockState underState = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_189532_c(this.field_70165_t, this.func_174813_aQ().field_72338_b - 1.0, this.field_70161_v));
                            f6 = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos, (Entity)this) * 0.91f;
                        }
                        if (this.func_70617_f_()) {
                            float f9 = 0.15f;
                            this.field_70159_w = MathHelper.func_151237_a((double)this.field_70159_w, (double)-0.15f, (double)0.15f);
                            this.field_70179_y = MathHelper.func_151237_a((double)this.field_70179_y, (double)-0.15f, (double)0.15f);
                            this.field_70143_R = 0.0f;
                            if (this.field_70181_x < -0.15) {
                                this.field_70181_x = -0.15;
                            }
                        }
                        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                        if (this.field_70123_F && this.func_70617_f_()) {
                            this.field_70181_x = 0.2;
                        }
                        if (this.func_70644_a(MobEffects.field_188424_y)) {
                            this.field_70181_x += (0.05 * (double)(this.func_70660_b(MobEffects.field_188424_y).func_76458_c() + 1) - this.field_70181_x) * 0.2;
                        } else {
                            blockpos$pooledmutableblockpos.func_189532_c(this.field_70165_t, 0.0, this.field_70161_v);
                            if (!this.field_70170_p.field_72995_K || this.field_70170_p.func_175667_e((BlockPos)blockpos$pooledmutableblockpos) && this.field_70170_p.func_175726_f((BlockPos)blockpos$pooledmutableblockpos).func_177410_o()) {
                                if (!this.func_189652_ae()) {
                                    this.field_70181_x -= 0.08;
                                }
                            } else {
                                this.field_70181_x = this.field_70163_u > 0.0 ? -0.1 : 0.0;
                            }
                        }
                        this.field_70181_x *= (double)0.98f;
                        this.field_70159_w *= (double)f6;
                        this.field_70179_y *= (double)f6;
                        blockpos$pooledmutableblockpos.func_185344_t();
                    }
                } else {
                    double d4 = this.field_70163_u;
                    this.func_191958_b(m1, m2, m3, 0.02f);
                    this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                    if (!this.func_189652_ae()) {
                        this.field_70181_x -= 0.02;
                    }
                    if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + d4, this.field_70179_y)) {
                        this.field_70181_x = 0.3f;
                    }
                }
            } else {
                double d0 = this.field_70163_u;
                float f1 = this.func_189749_co();
                float f2 = 0.02f;
                float f3 = EnchantmentHelper.func_185294_d((EntityLivingBase)this);
                if (f3 > 3.0f) {
                    f3 = 3.0f;
                }
                if (!this.field_70122_E) {
                    f3 *= 0.5f;
                }
                if (f3 > 0.0f) {
                    f1 += (0.54600006f - f1) * f3 / 3.0f;
                    f2 += (this.func_70689_ay() - f2) * f3 / 3.0f;
                }
                this.func_191958_b(m1, m2, m3, f2);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f1;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)f1;
                if (!this.func_189652_ae()) {
                    this.field_70181_x -= 0.02;
                }
                if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + d0, this.field_70179_y)) {
                    this.field_70181_x = 0.3f;
                }
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d5 = this.field_70165_t - this.field_70169_q;
            double d7 = this.field_70161_v - this.field_70166_s;
            double d9 = this instanceof EntityFlying ? this.field_70163_u - this.field_70167_r : 0.0;
            float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d9 * d9 + d7 * d7)) * 4.0f;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            this.field_70721_aZ += (f10 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        }
    }

    private void moveRelativeLook(float strafe, float up, float forward, float friction) {
        float f = strafe * strafe + up * up + forward * forward;
        if (f >= 1.0E-4f) {
            if ((f = MathHelper.func_76129_c((float)f)) < 1.0f) {
                f = 1.0f;
            }
            f = friction / f;
            strafe *= f;
            up *= f;
            forward *= f;
            if (this.func_70090_H() || this.func_180799_ab()) {
                strafe *= (float)this.func_110148_a(SWIM_SPEED).func_111126_e();
                up *= (float)this.func_110148_a(SWIM_SPEED).func_111126_e();
                forward *= (float)this.func_110148_a(SWIM_SPEED).func_111126_e();
            }
            float f1 = MathHelper.func_76126_a((float)(this.field_70759_as * ((float)Math.PI / 180)));
            float f2 = MathHelper.func_76134_b((float)(this.field_70759_as * ((float)Math.PI / 180)));
            this.field_70159_w += (double)(strafe * f2 - forward * f1);
            this.field_70181_x += (double)up;
            this.field_70179_y += (double)(forward * f2 + strafe * f1);
        }
    }

    protected void func_71036_o() {
        if (!this.field_184627_bm.func_190926_b() && this.func_184587_cr() && this.field_184627_bm.func_77975_n() == EnumAction.EAT) {
            this.func_70691_i(((ItemFood)this.field_184627_bm.func_77973_b()).func_150905_g(this.field_184627_bm));
        }
        super.func_71036_o();
        this.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
    }

    public boolean canBecomeGiant() {
        return true;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance p_180482_1_, IEntityLivingData entityLivingData) {
        TF2CharacterAdditionalData data;
        super.func_180482_a(p_180482_1_, entityLivingData);
        if (!(entityLivingData instanceof TF2CharacterAdditionalData)) {
            data = new TF2CharacterAdditionalData();
            data.natural = true;
            if (nextEntTeam >= 0) {
                data.team = nextEntTeam;
                nextEntTeam = -1;
            }
            if (this.bannerTeam != -1) {
                data.team = this.bannerTeam;
            } else {
                List list = this.field_70170_p.func_175647_a(EntityTF2Character.class, this.func_174813_aQ().func_72314_b(40.0, 4.0, 40.0), null);
                boolean found = false;
                for (EntityTF2Character ent : list) {
                    if (ent.func_184753_b() != null) continue;
                    found = true;
                    data.team = ((EntityTF2Character)list.get(0)).getEntTeam();
                    break;
                }
                if (!found) {
                    data.team = this.field_70146_Z.nextInt(2);
                }
            }
        } else {
            data = (TF2CharacterAdditionalData)entityLivingData;
        }
        if (entityLivingData instanceof TF2CharacterAdditionalData) {
            this.natural = data.natural;
            this.setEntTeam(data.team);
            this.noEquipment = data.noEquipment;
        }
        if (this.natural) {
            // empty if block
        }
        if (data.team == 2) {
            this.setRobot(1);
            this.setMoneyDrop(7);
            if (data.isGiant) {
                this.setRobot(2);
                this.setMoneyDrop(14 + this.difficulty * 10);
            }
        }
        this.addWeapons();
        this.func_180481_a(p_180482_1_);
        this.switchSlot(this.getDefaultSlot(), false, true);
        int i = 3;
        for (ItemStack stack : this.func_184193_aE()) {
            this.isEmpty[i] = stack.func_190926_b();
            --i;
        }
        if (!this.field_70170_p.func_82736_K().func_82766_b("doTF2AI")) {
            this.field_70714_bg.field_75782_a.clear();
            this.field_70715_bh.field_75782_a.clear();
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("damageModifier", (double)(TF2ConfigVars.damageMultiplier - 1.0f), 2));
        this.applySpeed();
        this.func_70606_j(this.func_110138_aP());
        for (int j = 0; j < this.ammoCount.length; ++j) {
            this.ammoCount[j] = this.getMaxAmmo(j);
            if (!this.isRobot()) continue;
            int n = j;
            this.ammoCount[n] = this.ammoCount[n] * 20;
        }
        return data;
    }

    public void applySpeed() {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(SPEED_MULT_UUID);
        if (this.func_184753_b() == null && this.getRobotSize() < 2) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(SPEED_MULT_UUID, "speedModifier", (double)(TF2ConfigVars.speedMult - 1.0f), 2));
        }
    }

    public int getDefaultSlot() {
        return 0;
    }

    protected float func_175134_bD() {
        return 0.5f;
    }

    public void func_70645_a(DamageSource s) {
        if (s.func_76346_g() != null && s.func_76346_g() instanceof EntityPlayerMP && !TF2Util.isOnSameTeam((Entity)this, s.func_76346_g())) {
            EntityPlayerMP player = (EntityPlayerMP)s.func_76346_g();
            if (s.func_76346_g().func_96124_cp() != null || TF2ConfigVars.neutralAttack) {
                if (!this.isRobot()) {
                    player.func_71029_a(TF2Achievements.KILLED_MERC);
                    if (player.func_147099_x().func_77444_a(TF2Achievements.KILLED_MERC) >= 5 && player.func_147099_x().func_77444_a(TF2Achievements.CONTRACT_DAY) == 0) {
                        player.func_71064_a(TF2Achievements.CONTRACT_DAY, (int)(this.field_70170_p.func_72820_D() / 24000L + 1L));
                    }
                } else {
                    player.func_71029_a(TF2weapons.robotsKilled);
                    TF2PlayerCapability.get((EntityPlayer)player).robotsKilledInvasion += 1.0f;
                }
            }
        }
        if (this.field_70717_bb != null && TF2Util.isOnSameTeam((Entity)this, (Entity)this.field_70717_bb)) {
            this.field_70728_aV = 0;
        }
        super.func_70645_a(s);
    }

    public boolean isValidTarget(EntityLivingBase living) {
        boolean hostilemob = false;
        if (TF2ConfigVars.attackMobs && !this.isRobot() && TF2Util.isHostile(living)) {
            double rangesq = living.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e() + 1.0;
            rangesq *= rangesq;
            boolean bl = hostilemob = living.func_70068_e((Entity)this) < rangesq;
        }
        if (living.func_96124_cp() != null || TF2ConfigVars.neutralAttack && living instanceof EntityPlayer || hostilemob) {
            return !TF2Util.isOnSameTeam((Entity)this, (Entity)living) && (!(living instanceof EntityTF2Character) || !TF2ConfigVars.naturalCheck.equals("Never") || !((EntityTF2Character)living).natural || !this.natural);
        }
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!(player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ItemMonsterPlacerPlus || this.func_70902_q() != player && this.func_70638_az() != null && !this.friendly || !this.func_70089_S() || this.isTrading() || this.func_70631_g_() || player.func_70093_af())) {
            if (this.field_70170_p.field_72995_K && !this.isRobot() && player.func_96124_cp() == null && ((this.getCapability(TF2weapons.WEAPONS_CAP, null).state & 1) == 0 || this.friendly) && !player.func_184812_l_()) {
                ClientProxy.displayScreenConfirm("Choose a team to interact", "Visit the Mann Co. Store located in a village");
            }
            if (!this.field_70170_p.field_72995_K && (TF2Util.isOnSameTeam((Entity)this, (Entity)player) || player.func_184812_l_())) {
                this.func_70932_a_(player);
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)TF2weapons.instance, (int)4, (World)this.field_70170_p, (int)this.func_145782_y(), (int)0, (int)0);
            }
            player.func_71029_a(StatList.field_188074_H);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean isTrading() {
        return this.trader != null;
    }

    public void func_70037_a(NBTTagCompound tag) {
        int i;
        super.func_70037_a(tag);
        if (tag.func_74775_l("ForgeCaps").func_74764_b("rafradek_tf2_weapons:weaponscap")) {
            tag.func_74782_a("WeaponsCap", (NBTBase)tag.func_74775_l("ForgeCaps").func_74775_l("rafradek_tf2_weapons:weaponscap"));
            tag.func_74775_l("ForgeCaps").func_82580_o("rafradek_tf2_weapons:weaponscap");
        }
        this.weaponCap.deserializeNBT(tag.func_74775_l("WeaponsCap"));
        if (tag.func_74764_b("AmmoC")) {
            this.ammoCount = tag.func_74759_k("AmmoC");
        }
        if (this.ammoCount.length == 0) {
            this.ammoCount = new int[3];
        }
        this.unlimitedAmmo = tag.func_74767_n("UnlimitedAmmo");
        this.setEntTeam(tag.func_74771_c("Team"));
        this.natural = tag.func_74767_n("Natural");
        this.robotStrength = tag.func_74760_g("RobotStrength");
        this.setRobot(tag.func_74771_c("Robot"));
        this.setMoneyDrop(tag.func_74762_e("MoneyDrop"));
        if (tag.func_74781_a("Loadout") instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)tag.func_74781_a("Loadout");
            if (list != null) {
                for (i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = list.func_150305_b(i);
                    byte j = nbttagcompound.func_74771_c("Slot");
                    this.loadout.setStackInSlot(j, new ItemStack(nbttagcompound));
                }
            }
        } else {
            this.loadout.deserializeNBT(tag.func_74775_l("Loadout"));
        }
        this.loadoutHeld.deserializeNBT(tag.func_74775_l("LoadoutHeld"));
        if (this.loadoutHeld.getSlots() < 8) {
            this.loadoutHeld.setSize(8);
            this.loadoutHeld.setStackInSlot(7, this.loadoutHeld.getStackInSlot(6));
            this.loadoutHeld.setStackInSlot(6, this.loadoutHeld.getStackInSlot(5));
            this.loadoutHeld.setStackInSlot(5, this.loadoutHeld.getStackInSlot(4));
            this.loadoutHeld.setStackInSlot(4, this.loadoutHeld.getStackInSlot(3));
        }
        this.refill.setStackInSlot(0, new ItemStack(tag.func_74775_l("Refill")));
        if (tag.func_74764_b("Offers")) {
            this.tradeOffers = new MerchantRecipeList();
            this.tradeOffers.func_77201_a(tag.func_74775_l("Offers"));
        }
        this.preferredSlot = tag.func_74771_c("PSlot");
        this.switchSlot(tag.func_74771_c("Slot"), true, true);
        this.setMainWeapon(tag.func_74771_c("MainWeapon"));
        if (tag.func_74764_b("FollowTrader")) {
            this.followID = tag.func_186857_a("FollowTrader");
            this.traderFollowTicks = tag.func_74762_e("FollowTraderTicks");
        }
        if (!this.field_70170_p.func_82736_K().func_82766_b("doTF2AI")) {
            this.field_70714_bg.field_75782_a.clear();
            this.field_70715_bh.field_75782_a.clear();
        }
        if (tag.func_186855_b("Owner")) {
            UUID ownerID = tag.func_186857_a("Owner");
            this.field_70180_af.func_187227_b(OWNER_UUID, (Object)Optional.of((Object)ownerID));
            this.ownerName = tag.func_74779_i("OwnerName");
            this.func_70902_q();
            this.func_110163_bv();
            this.setOrder(Order.values()[tag.func_74771_c("Order")]);
            PlayerPersistStorage.get((World)this.field_70170_p, (UUID)this.func_184753_b()).medicMercPos.remove(this.func_190671_u_());
            PlayerPersistStorage.get((World)this.field_70170_p, (UUID)this.func_184753_b()).restMercPos.remove(this.func_190671_u_());
        }
        this.tradeLevel = tag.func_74771_c("TradeLevel");
        this.difficulty = tag.func_74771_c("Difficulty");
        byte[] empty = tag.func_74770_j("Empty");
        for (i = 0; i < empty.length; ++i) {
            this.isEmpty[i] = empty[i] != 0;
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        IAttributeInstance speed = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        for (AttributeModifier modifier : this.playerAttributes) {
            speed.func_111124_b(modifier);
        }
        super.func_70014_b(tag);
        tag.func_74782_a("WeaponsCap", (NBTBase)this.weaponCap.serializeNBT());
        tag.func_74783_a("AmmoC", this.ammoCount);
        tag.func_74757_a("UnlimitedAmmo", this.unlimitedAmmo);
        tag.func_74774_a("Team", (byte)this.getEntTeam());
        tag.func_74757_a("Natural", this.natural);
        tag.func_74774_a("Robot", (byte)this.getRobotSize());
        tag.func_74782_a("Loadout", (NBTBase)this.loadout.serializeNBT());
        tag.func_74782_a("LoadoutHeld", (NBTBase)this.loadoutHeld.serializeNBT());
        tag.func_74782_a("Refill", (NBTBase)this.refill.getStackInSlot(0).serializeNBT());
        if (this.tradeOffers != null) {
            tag.func_74782_a("Offers", (NBTBase)this.tradeOffers.func_77202_a());
        }
        if (this.usedSlot == -1) {
            this.usedSlot = this.getDefaultSlot();
        }
        tag.func_74774_a("Slot", (byte)this.usedSlot);
        tag.func_74774_a("PSlot", (byte)this.preferredSlot);
        if (this.lastTrader != null) {
            tag.func_186854_a("TraderFollow", this.lastTrader.func_110124_au());
            tag.func_74768_a("TraderFollowTicks", this.traderFollowTicks);
        }
        if (this.func_184753_b() != null) {
            tag.func_186854_a("Owner", this.func_184753_b());
            tag.func_74778_a("OwnerName", this.ownerName);
            tag.func_74774_a("Order", (byte)this.getOrder().ordinal());
            if (this.getOrder() == Order.FOLLOW) {
                ((TF2EventsCommon.TF2WorldStorage)this.field_70170_p.getCapability(TF2weapons.WORLD_CAP, null)).getPlayerStorage((UUID)this.func_184753_b()).lostMercPos.add(this.func_190671_u_());
                ((TF2EventsCommon.TF2WorldStorage)this.field_70170_p.getCapability(TF2weapons.WORLD_CAP, null)).getPlayerStorage(this.func_184753_b()).setSave();
            } else if (this.getOrder() == Order.HOLD && this instanceof EntityMedic) {
                ((TF2EventsCommon.TF2WorldStorage)this.field_70170_p.getCapability(TF2weapons.WORLD_CAP, null)).getPlayerStorage((UUID)this.func_184753_b()).medicMercPos.add(this.func_190671_u_());
                ((TF2EventsCommon.TF2WorldStorage)this.field_70170_p.getCapability(TF2weapons.WORLD_CAP, null)).getPlayerStorage(this.func_184753_b()).setSave();
            } else if (this.getOrder() == Order.HOLD && !(this instanceof EntityEngineer)) {
                ((TF2EventsCommon.TF2WorldStorage)this.field_70170_p.getCapability(TF2weapons.WORLD_CAP, null)).getPlayerStorage((UUID)this.func_184753_b()).restMercPos.add(this.func_190671_u_());
                ((TF2EventsCommon.TF2WorldStorage)this.field_70170_p.getCapability(TF2weapons.WORLD_CAP, null)).getPlayerStorage(this.func_184753_b()).setSave();
            }
        }
        tag.func_74774_a("MainWeapon", (byte)this.getMainWeapon());
        tag.func_74774_a("TradeLevel", (byte)this.tradeLevel);
        tag.func_74773_a("Empty", new byte[]{(byte)(this.isEmpty[0] ? 1 : 0), (byte)(this.isEmpty[1] ? 1 : 0), (byte)(this.isEmpty[2] ? 1 : 0), (byte)(this.isEmpty[3] ? 1 : 0)});
        tag.func_74774_a("Difficulty", (byte)this.difficulty);
        tag.func_74776_a("RobotStrength", (float)((short)this.robotStrength));
        tag.func_74768_a("MoneyDrop", this.moneyDrop);
    }

    public boolean func_70601_bi() {
        if (this.detectBanner()) {
            return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && super.func_70601_bi();
        }
        if (this.field_70128_L || TF2ConfigVars.overworldOnly && this.field_71093_bK != 0) {
            return false;
        }
        boolean naturalGround = TF2Util.isNaturalBlock(this.field_70170_p, this.func_180425_c().func_177977_b(), this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()));
        boolean validLight = this.isValidLightLevel(naturalGround, this.isRobot());
        if (!validLight) {
            return false;
        }
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && super.func_70601_bi();
    }

    public boolean detectBanner() {
        Iterator<BlockPos> iterator = ((TF2EventsCommon.TF2WorldStorage)this.field_70170_p.getCapability(TF2weapons.WORLD_CAP, null)).banners.iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            if (!(pos.func_177951_i((Vec3i)this.func_180425_c()) < 1200.0)) continue;
            TileEntity banner = this.field_70170_p.func_175625_s(pos);
            if (banner != null && banner instanceof TileEntityBanner) {
                boolean fast = false;
                for (BannerPattern pattern : TF2EventsCommon.getPatterns((TileEntityBanner)banner)) {
                    if (pattern == TF2weapons.redPattern) {
                        this.bannerTeam = 0;
                        continue;
                    }
                    if (pattern == TF2weapons.bluPattern) {
                        this.bannerTeam = 1;
                        continue;
                    }
                    if (pattern == TF2weapons.neutralPattern) {
                        this.func_70106_y();
                        return false;
                    }
                    if (pattern != TF2weapons.fastSpawn) continue;
                    fast = true;
                }
                return fast && pos.func_177951_i((Vec3i)this.func_180425_c()) < 800.0;
            }
            iterator.remove();
            return false;
        }
        return false;
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        if (!this.func_180431_b(damageSrc)) {
            if ((damageAmount = ForgeHooks.onLivingHurt((EntityLivingBase)this, (DamageSource)damageSrc, (float)damageAmount)) <= 0.0f) {
                return;
            }
            damageAmount = ISpecialArmor.ArmorProperties.applyArmor((EntityLivingBase)this, (NonNullList)((NonNullList)this.func_184193_aE()), (DamageSource)damageSrc, (double)damageAmount);
            if (damageAmount <= 0.0f) {
                return;
            }
            float f = damageAmount = this.func_70672_c(damageSrc, damageAmount);
            damageAmount = Math.max(damageAmount - this.func_110139_bj(), 0.0f);
            this.func_110149_m(this.func_110139_bj() - (f - damageAmount));
            damageAmount = ForgeHooks.onLivingDamage((EntityLivingBase)this, (DamageSource)damageSrc, (float)damageAmount);
            if (damageAmount != 0.0f) {
                float f1 = this.func_110143_aJ();
                this.func_70606_j(this.func_110143_aJ() - damageAmount);
                this.func_110142_aN().func_94547_a(damageSrc, f1, damageAmount);
            }
        }
    }

    protected boolean isValidLightLevel(boolean isNaturalBlock, boolean event) {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        int skylight = this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos);
        if (16 + skylight < this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int lightbl = this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, blockpos);
        if (!isNaturalBlock && skylight < 13 || lightbl > 1 && !event) {
            return false;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        Chunk chunk = this.field_70170_p.func_175726_f(blockpos);
        boolean spawnDay = event || this.field_70146_Z.nextInt(32) == 0 && chunk.func_76617_a(987234911L).nextInt(10) == 0;
        return spawnDay || i <= 4 + this.field_70146_Z.nextInt(4);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_184753_b() == null && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public Team func_96124_cp() {
        if (this.func_70902_q() != null) {
            return this.func_70902_q().func_96124_cp();
        }
        if (this.ownerName != null && !this.ownerName.isEmpty()) {
            return this.field_70170_p.func_96441_U().func_96509_i(this.ownerName);
        }
        return this.getEntTeam() == 0 ? this.field_70170_p.func_96441_U().func_96508_e("RED") : (this.getEntTeam() == 1 ? this.field_70170_p.func_96441_U().func_96508_e("BLU") : this.field_70170_p.func_96441_U().func_96508_e("Robots"));
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187939_hm, 0.15f, 1.0f);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70718_bc > 0 && source == DamageSource.field_76376_m) {
            this.field_70718_bc = Math.max(20, this.field_70718_bc);
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (super.func_70097_a(source, amount)) {
            if (!(this.event == null || source.func_76346_g() instanceof EntityLivingBase && source.func_76346_g() != TF2weapons.dummyEnt)) {
                this.event.onDamageEnv(this, source, amount);
                this.damagedByEnv = true;
            }
            if (this.event != null && source.func_76364_f() instanceof EntitySentry) {
                this.event.onDamageSentry(this, (EntitySentry)source.func_76364_f(), source, amount);
            }
            Entity entity = source.func_76346_g();
            return this.func_184187_bx() != entity && this.func_184187_bx() != entity ? true : true;
        }
        return false;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187741_cz;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187738_cy;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
                if (!itemstack.func_190926_b() && itemstack1 != null && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    protected boolean func_146066_aG() {
        return true;
    }

    public int func_70627_aG() {
        return this.func_184753_b() != null ? 1000 : 320;
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.08f + 1.5f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.08f + 1.0f;
    }

    protected float func_70599_aP() {
        return TF2ConfigVars.mercenaryVolume;
    }

    public float getMotionSensitivity() {
        return this.scaleWithDifficulty(0.18f, 0.03f);
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        if (!this.field_70170_p.field_72995_K && slotIn == EntityEquipmentSlot.MAINHAND) {
            return this.loadout.getStackInSlot(this.usedSlot);
        }
        return super.func_184582_a(slotIn);
    }

    public void onShot() {
    }

    protected boolean func_70692_ba() {
        return this.natural && this.func_184753_b() == null;
    }

    public void func_70932_a_(EntityPlayer player) {
        this.trader = player;
    }

    public EntityPlayer func_70931_l_() {
        return this.trader;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.tradeOffers == null) {
            this.makeOffers();
        }
        return this.tradeOffers;
    }

    public void makeOffers() {
        this.tradeOffers = new MerchantRecipeList();
        if (this.isRobot() || this.tradeLevel == -1) {
            return;
        }
        int weaponCount = 1 + this.field_70146_Z.nextInt(2 + this.tradeLevel);
        for (int i = 0; i < weaponCount; ++i) {
            int costmult;
            int cost;
            boolean buyItem = this.field_70146_Z.nextBoolean();
            int slot = this.getValidSlots()[this.field_70146_Z.nextInt(this.getValidSlots().length)];
            String className = ItemToken.CLASS_NAMES[this.getClassIndex()];
            ItemStack item = ItemFromData.getRandomWeaponOfSlotMob(className, slot, this.func_70681_au(), false, 1.0f, false);
            if (item.func_190926_b()) continue;
            int basecost = cost = ItemFromData.getData(item).getInt(PropertyType.COST);
            if (!buyItem) {
                int upgrade;
                if (this.tradeLevel == 1 && this.field_70146_Z.nextFloat() < 0.6f) {
                    upgrade = Math.min(800, 232 + (int)(this.field_70170_p.func_72820_D() / 4000L));
                    TF2Attribute.upgradeItemStack(this.loadout.getStackInSlot(0), upgrade, this.field_70146_Z);
                    cost += upgrade / cost > 13 ? 5 : 10;
                    if (this.field_70146_Z.nextFloat() < 0.25f) {
                        item.func_77978_p().func_74757_a("Strange", true);
                        cost = (int)((float)cost + ((float)(basecost * 8) + (float)cost * 0.12f));
                    }
                } else if (this.tradeLevel == 2) {
                    upgrade = Math.min(800, 232 + (int)(this.field_70170_p.func_72820_D() / 4000L));
                    TF2Attribute.upgradeItemStack(this.loadout.getStackInSlot(0), Math.min(3000, 1000 + (int)(this.field_70170_p.func_72820_D() / 2000L)), this.field_70146_Z);
                    cost += upgrade / cost > 13 ? 5 : 10;
                    if (this.field_70146_Z.nextFloat() < 0.6f) {
                        item.func_77978_p().func_74757_a("Strange", true);
                        cost = (int)((float)cost + ((float)(basecost * 8) + (float)cost * 0.12f));
                    }
                    if (this.field_70146_Z.nextFloat() < 0.25f) {
                        item.func_77978_p().func_74757_a("Australium", true);
                        cost = (int)((float)cost + ((float)(basecost * 16) + (float)cost * 0.06f));
                    }
                    if (this.field_70146_Z.nextFloat() < 0.3f) {
                        ArrayList<TF2Attribute> list = new ArrayList<TF2Attribute>(Arrays.asList(TF2Attribute.attributes));
                        list.removeIf(attr -> attr == null || attr.perKill == 0.0f);
                        item.func_77978_p().func_74777_a("StreakAttrib", (short)list.get((int)this.field_70146_Z.nextInt((int)list.size())).id);
                        float rand = this.field_70146_Z.nextFloat();
                        int level = (double)rand < 0.15 ? 3 : ((double)rand < 0.5 ? 2 : 1);
                        item.func_77978_p().func_74774_a("StreakLevel", (byte)level);
                        cost = (int)((float)cost + ((float)(basecost * 8 * level) + (float)cost * 0.08f));
                    }
                }
            }
            int n = cost < 27 || buyItem ? 0 : (costmult = cost < 81 ? 1 : 2);
            ItemStack metal = new ItemStack(TF2weapons.itemTF2, Math.max(1, cost / (costmult == 0 ? 9 : (costmult == 1 ? 27 : 81))), 3 + costmult);
            ItemStack metal2 = new ItemStack(TF2weapons.itemTF2, Math.max(1, cost / (costmult == 1 ? 9 : 27) % 3), 2 + costmult);
            this.tradeOffers.add((Object)new MerchantRecipe(buyItem ? item : metal, !buyItem && costmult > 0 ? metal2 : ItemStack.field_190927_a, buyItem ? metal : item, 0, 1));
        }
        int hatCount = this.field_70146_Z.nextInt(2 + this.tradeLevel);
        for (int i = 0; i < hatCount; ++i) {
            boolean buyItem = this.field_70146_Z.nextBoolean();
            ItemStack item = ItemFromData.getRandomWeaponOfClass("cosmetic", this.field_70146_Z, false);
            int cost = Math.max(1, ItemFromData.getData(item).getInt(PropertyType.COST));
            if (i == 0 && this.tradeLevel == 2) {
                ((ItemWearable)item.func_77973_b()).applyRandomEffect(item, this.field_70146_Z);
                cost *= 6 + this.field_70146_Z.nextInt(6);
                buyItem = false;
            }
            ItemStack metal = new ItemStack(TF2weapons.itemTF2, cost / 18, 5);
            ItemStack metal2 = new ItemStack(TF2weapons.itemTF2, this.field_70146_Z.nextInt(3), 4);
            if (metal2.func_190916_E() == 0) {
                metal2 = ItemStack.field_190927_a;
            }
            this.tradeOffers.add((Object)new MerchantRecipe(buyItem ? item : metal, buyItem ? ItemStack.field_190927_a : metal2, buyItem ? metal : item, 0, 1));
        }
        if (this.tradeLevel >= 1) {
            boolean buyKey = this.field_70146_Z.nextBoolean();
            ItemStack item = new ItemStack(TF2weapons.itemTF2, 1, 7);
            ItemStack metal = new ItemStack(TF2weapons.itemTF2, 4, 5);
            ItemStack metal2 = new ItemStack(TF2weapons.itemTF2, this.field_70146_Z.nextInt(3), 4);
            if (metal2.func_190916_E() == 0) {
                metal2 = ItemStack.field_190927_a;
            }
            this.tradeOffers.add((Object)new MerchantRecipe(buyKey ? item : metal, buyKey ? ItemStack.field_190927_a : metal2, buyKey ? metal : item, 0, 1));
            ArrayList<TF2Attribute> list = new ArrayList<TF2Attribute>(Arrays.asList(TF2Attribute.attributes));
            list.removeIf(attr -> attr == null || attr.perKill == 0.0f);
            int killstreakCount = this.field_70146_Z.nextInt(3 * this.tradeLevel);
            for (int i = 0; i < killstreakCount; ++i) {
                int level = 0;
                int cost = 18;
                float rand = this.field_70146_Z.nextFloat();
                if (this.tradeLevel == 2 && rand < 0.05f) {
                    level = 2;
                    cost = 72;
                } else if (rand < 0.2f * (float)this.tradeLevel) {
                    level = 1;
                }
                cost = 39;
                item = new ItemStack(TF2weapons.itemKillstreak, 1, list.get((int)this.field_70146_Z.nextInt((int)list.size())).id + (level << 9));
                if (i != 0 || this.tradeLevel > 1) {
                    // empty if block
                }
                this.addTradeOffer(item, cost, this.field_70146_Z.nextBoolean());
            }
        }
    }

    private void addTradeOffer(ItemStack toBuy, int cost, boolean buy) {
        boolean refined = cost >= 9;
        ItemStack ingot = new ItemStack(TF2weapons.itemTF2, cost / (refined ? 9 : 3), refined ? 5 : 4);
        ItemStack nugget = new ItemStack(TF2weapons.itemTF2, cost % (refined ? 9 : 3), 3);
        if (buy) {
            this.tradeOffers.add((Object)new MerchantRecipe(ingot.func_190916_E() > 0 ? ingot : nugget, nugget.func_190916_E() > 0 ? nugget : ItemStack.field_190927_a, toBuy, 0, 100));
        } else {
            this.tradeOffers.add((Object)new MerchantRecipe(toBuy, ItemStack.field_190927_a, ingot.func_190916_E() > 0 ? ingot : nugget, 0, 100));
        }
    }

    public void func_70930_a(MerchantRecipeList recipeList) {
        this.tradeOffers = recipeList;
    }

    public float func_70047_e() {
        return 1.62f * (this.getRobotSize() > 1 ? 1.68f : (this.getRobotSize() > 2 ? 1.9f : 1.0f));
    }

    public int[] getValidSlots() {
        return new int[]{0, 1, 2};
    }

    public float[] getDropChance() {
        return new float[]{0.08f, 0.15f, 0.15f};
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        if (this.func_184753_b() != null) {
            if (recipe.func_77394_a().func_77973_b() instanceof ItemWeapon) {
                this.loadout.setStackInSlot(ItemFromData.getSlotForClass(ItemFromData.getData(recipe.func_77394_a()), this), recipe.func_77394_a());
                this.switchSlot(0);
            } else if (recipe.func_77394_a().func_77973_b() instanceof ItemWearable) {
                this.func_184201_a(EntityEquipmentSlot.HEAD, recipe.func_77394_a());
                this.field_184655_bs[0] = 0.0f;
            }
        }
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        int i = 3 + this.field_70146_Z.nextInt(4);
        this.lastTrader = this.trader;
        this.tradeCount.put(this.trader, this.tradeCount.containsKey(this.trader) ? this.tradeCount.get(this.trader) + 1 : 1);
        this.traderFollowTicks = Math.min(4800, this.tradeCount.get(this.trader) * 250 + 350);
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    public void switchSlot(int slot) {
        this.switchSlot(slot, false, false);
    }

    public void switchSlot(int slot, boolean noAmmoSwitch, boolean forceRefresh) {
        boolean itemChange;
        ItemStack stack = this.loadout.getStackInSlot(slot);
        if (this.getMainWeapon() != -1 && this.getMainWeapon() != slot && !forceRefresh && !noAmmoSwitch) {
            return;
        }
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.func_77973_b() instanceof ItemFromData && !((ItemFromData)stack.func_77973_b()).canSwitchTo(stack)) {
            return;
        }
        if (!noAmmoSwitch) {
            this.preferredSlot = slot;
        }
        boolean bl = itemChange = !(stack.func_77973_b() instanceof ItemUsable);
        if ((slot != this.usedSlot || forceRefresh) && stack.func_77973_b() instanceof ItemUsable) {
            if (!((ItemUsable)stack.func_77973_b()).isAmmoSufficient(stack, (EntityLivingBase)this, true) && !this.refill(this.usedSlot)) {
                this.switchSlot(this.getFirstSlotWithAmmo(), true, forceRefresh);
                return;
            }
            itemChange = true;
        }
        if (itemChange) {
            if (this.func_184614_ca().func_77973_b() instanceof ItemUsable && slot != this.usedSlot) {
                ((ItemUsable)this.func_184614_ca().func_77973_b()).holster(this.getWepCapability(), stack, (EntityLivingBase)this, this.field_70170_p);
            }
            this.func_184611_a(EnumHand.MAIN_HAND, stack);
            if (stack.func_77973_b() instanceof ItemUsable) {
                this.onEquipItem(slot, stack);
            }
            if (slot != this.usedSlot) {
                this.getCapability(TF2weapons.WEAPONS_CAP, null).setPrimaryCooldown(400);
            }
            this.usedSlot = slot;
        }
    }

    public void switchSlotActual(int slot) {
        this.switchSlot(slot, false, false);
    }

    public void onEquipItem(int slot, ItemStack stack) {
        WeaponData data = ItemFromData.getData(stack);
        this.attack.explosive = TF2Attribute.EXPLOSIVE.apply((Object)stack);
        this.attack.projSpeed = TF2Attribute.getModifier("Proj Speed", stack, data.getFloat(PropertyType.PROJECTILE_SPEED), (EntityLivingBase)this);
        this.attack.fireAtFeet = 0.0;
        if (stack.func_77973_b() instanceof ItemHuntsman) {
            this.attack.fireAtFeet = -1.0;
            this.getWepCapability().chargeTicks = ((ItemWeapon)stack.func_77973_b()).holdingMode(stack, (EntityLivingBase)this);
        }
        if (this.isGiant()) {
            this.attack.setRange(data.getFloat(PropertyType.EFFICIENT_RANGE) * 1.75f);
        } else {
            this.attack.setRange(data.getFloat(PropertyType.EFFICIENT_RANGE));
        }
        this.moveAttack.setRange(data.getFloat(PropertyType.EFFICIENT_RANGE), data.get(PropertyType.MINIMAL_RANGE, Float.valueOf(3.0f)).floatValue());
        ((ItemUsable)stack.func_77973_b()).draw(this.getWepCapability(), stack, (EntityLivingBase)this, this.field_70170_p);
        if (stack.func_77973_b() instanceof ItemProjectileWeapon) {
            String projName = data.getString(PropertyType.PROJECTILE);
            try {
                EntityProjectileBase proj = MapList.projectileClasses.get(projName).getConstructor(World.class).newInstance(this.field_70170_p);
                proj.initProjectile((EntityLivingBase)this, EnumHand.MAIN_HAND, stack);
                this.attack.gravity = (float)proj.getGravityOverride();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.getWepCapability().chargeTicks = 0;
    }

    public void func_110297_a_(ItemStack stack) {
    }

    public int func_70641_bl() {
        return 4;
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        int i;
        boolean isPlayerAttacker;
        int i2;
        for (i2 = 0; i2 < 4; ++i2) {
            if (this.loadoutHeld.getStackInSlot(i2).func_190926_b() && this.hasHeldInventory()) continue;
            if (!this.loadout.getStackInSlot(i2).func_190926_b()) {
                this.func_70099_a(this.loadout.getStackInSlot(i2), 0.0f).func_145799_b(this.ownerName);
            }
            this.loadout.setStackInSlot(i2, this.loadoutHeld.getStackInSlot(i2));
        }
        for (i2 = 0; i2 < 4; ++i2) {
            if (this.loadoutHeld.getStackInSlot(i2 + 4).func_190926_b() && this.hasHeldInventory()) continue;
            if (!this.func_184582_a(EntityEquipmentSlot.values()[5 - i2]).func_190926_b()) {
                this.func_70099_a(this.func_184582_a(EntityEquipmentSlot.values()[5 - i2]), 0.0f).func_145799_b(this.ownerName);
            }
            this.func_184201_a(EntityEquipmentSlot.values()[5 - i2], this.loadoutHeld.getStackInSlot(i2 + 4));
            this.func_184642_a(EntityEquipmentSlot.values()[5 - i2], i2 == 0 ? 0.25f : 0.0f);
        }
        if (!this.isRobot() && this.func_184753_b() != null) {
            ItemStack stack = new ItemStack(TF2weapons.itemTF2, this.isSharing() ? 2 : 1, 2);
            if (this.func_70902_q() != null && this.func_70068_e(this.func_70902_q()) < 100.0) {
                this.func_70099_a(stack, 0.0f);
            } else {
                HashMap<String, MerchantRecipeList> map = ((TF2EventsCommon.TF2WorldStorage)this.func_190670_t_().getCapability(TF2weapons.WORLD_CAP, null)).lostItems;
                if (!map.containsKey(this.ownerName)) {
                    map.put(this.ownerName, new MerchantRecipeList());
                }
                ((MerchantRecipeList)map.get(this.ownerName)).add((Object)new MerchantRecipe(ItemStack.field_190927_a, ItemStack.field_190927_a, stack, 0, 1));
            }
        }
        EntityLivingBase attacker = this.func_94060_bK();
        if (!(this.refill.getStackInSlot(0).func_190926_b() || attacker != this.func_70902_q() && TF2Util.isOnSameTeam((Entity)attacker, (Entity)this))) {
            this.func_70099_a(this.refill.getStackInSlot(0), 0.0f);
        }
        boolean bl = isPlayerAttacker = (attacker instanceof EntityPlayer || attacker instanceof IEntityOwnable && ((IEntityOwnable)attacker).func_184753_b() != null) && (attacker.func_96124_cp() != null || TF2ConfigVars.neutralAttack) && TF2Util.isEnemy(attacker, (EntityLivingBase)this);
        if (!this.isRobot() && isPlayerAttacker) {
            for (i = 0; i < this.loadout.getSlots(); ++i) {
                ItemStack stack = this.loadout.getStackInSlot(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemFromData) || !(this.field_70146_Z.nextFloat() <= this.getDropChance()[i] * (1.0f + (float)lootingModifier * 0.4f))) continue;
                stack.func_190920_e(1);
                if (stack.func_77973_b() instanceof ItemFromData) {
                    TF2Attribute.upgradeItemStack(stack, (int)(Math.min(320L, this.field_70170_p.func_72820_D() / 4000L) + (long)this.field_70146_Z.nextInt((int)Math.min(720L, this.field_70170_p.func_72820_D() / 2000L))), this.field_70146_Z);
                }
                this.func_70099_a(stack, 0.0f);
            }
        } else if (this.field_184655_bs[0] < 1.0f) {
            this.field_184655_bs[0] = 0.0f;
        }
        if (this.getMoneyDrop() > 0 && (isPlayerAttacker || this.func_184753_b() != null)) {
            for (i = 0; i < this.getMoneyDrop() / 64; ++i) {
                this.func_70099_a(new ItemStack(TF2weapons.itemMoney, 64, 0), 0.0f);
            }
            this.func_70099_a(new ItemStack(TF2weapons.itemMoney, this.getMoneyDrop() % 64, 0), 0.0f);
            this.setMoneyDrop(0);
        }
        if (this.isRobot() && this.func_184753_b() != null) {
            this.func_70099_a(new ItemStack(TF2weapons.itemTF2, 1, this.isGiant() ? 13 : 12), 0.0f);
        }
        super.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return this.func_180425_c();
    }

    public WeaponsCapability getWepCapability() {
        return this.getCapability(TF2weapons.WEAPONS_CAP, null);
    }

    protected int func_70693_a(EntityPlayer player) {
        if (TF2Util.isOnSameTeam((Entity)player, (Entity)this)) {
            return 0;
        }
        if (this.isRobot() && !this.isGiant()) {
            return super.func_70693_a(player) / 2;
        }
        return super.func_70693_a(player);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (ROBOT.equals(key) && this.robotSizeEnsured != this.getRobotSize()) {
            this.robotSizeEnsured = this.getRobotSize();
            float scale = 1.0f;
            if (this.getRobotSize() == 2) {
                scale = 1.65f;
            } else if (this.getRobotSize() > 2) {
                scale = 1.88f;
            }
            this.func_70105_a(Math.min(0.98f, this.getWidth() * scale), this.getHeight() * scale);
        }
    }

    public UUID func_184753_b() {
        return (UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER_UUID)).orNull();
    }

    public Entity func_70902_q() {
        if (this.func_184753_b() != null) {
            return this.field_70170_p.func_152378_a((UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER_UUID)).orNull());
        }
        return null;
    }

    public void setOwner(EntityLivingBase owner) {
        if (owner == null) {
            this.ownerName = null;
            this.field_70180_af.func_187227_b(OWNER_UUID, (Object)Optional.absent());
        } else if (owner instanceof EntityPlayer) {
            this.ownerName = owner.func_70005_c_();
            this.field_70180_af.func_187227_b(OWNER_UUID, (Object)Optional.of((Object)owner.func_110124_au()));
            this.func_110163_bv();
        }
    }

    public void setOwnerID(String name, UUID owner) {
        this.ownerName = name;
        this.field_70180_af.func_187227_b(OWNER_UUID, (Object)Optional.of((Object)owner));
        this.func_110163_bv();
    }

    public int getMaxAmmo(int slot) {
        int ammo = ItemFromData.getData(this.loadout.getStackInSlot(slot == -1 ? this.usedSlot : slot)).getInt(PropertyType.MAX_AMMO);
        return (int)(this.func_184753_b() != null ? (float)ammo : this.scaleWithDifficulty(0.5f, 1.0f) * (float)ammo);
    }

    public int getAmmo(int slot) {
        if (slot == 1000 || slot == -1 || slot >= this.ammoCount.length) {
            slot = 0;
        }
        if (this.unlimitedAmmo) {
            return this.getMaxAmmo(slot);
        }
        return this.ammoCount[slot];
    }

    public boolean isAmmoFull() {
        if (this.unlimitedAmmo) {
            return true;
        }
        for (int i = 0; i < this.ammoCount.length; ++i) {
            ItemStack stack = this.loadout.getStackInSlot(i);
            if (!(stack.func_77973_b() instanceof ItemUsable) || this.ammoCount[i] >= this.getMaxAmmo(i)) continue;
            return false;
        }
        return true;
    }

    public int getFirstSlotWithAmmo() {
        if (this.unlimitedAmmo) {
            return this.getMainWeapon() == -1 ? this.getDefaultSlot() : this.getMainWeapon();
        }
        for (int i = 0; i < this.loadout.getSlots(); ++i) {
            ItemStack stack = this.loadout.getStackInSlot(i);
            if (!(stack.func_77973_b() instanceof ItemUsable)) continue;
            if (((ItemUsable)stack.func_77973_b()).isAmmoSufficient(stack, (EntityLivingBase)this, true)) {
                return i;
            }
            if (!this.refill(i)) continue;
            return i;
        }
        return 2;
    }

    public boolean refill(int slot) {
        if (!this.refill.getStackInSlot(0).func_190926_b() && TF2Util.isOre("ingotLead", this.refill.getStackInSlot(0))) {
            this.refill.extractItem(0, 1, false);
            this.ammoCount[slot] = (int)((float)this.getMaxAmmo(slot) * 0.4f);
            return true;
        }
        if (this.isRobot() && this.refill.getStackInSlot(0).func_77973_b() instanceof ItemMoney) {
            ItemStack stack = this.refill.extractItem(0, 1, false);
            this.ammoCount[slot] = this.getMaxAmmo(slot) * ((ItemMoney)stack.func_77973_b()).getValue(stack);
            return true;
        }
        return false;
    }

    public boolean restoreAmmo(float p) {
        for (int i = 0; i < this.ammoCount.length; ++i) {
            if (!(this.loadout.getStackInSlot(i).func_77973_b() instanceof ItemUsable)) continue;
            int maxAmmo = this.getMaxAmmo(i);
            this.ammoCount[i] = Math.min(this.ammoCount[i] + (int)((float)maxAmmo * p), maxAmmo);
        }
        return true;
    }

    public int getState(boolean onTarget) {
        return onTarget ? 1 : 0;
    }

    public int getClassIndex() {
        return 0;
    }

    public float scaleWithDifficulty(float min, float max) {
        int diff = this.getDiff();
        float div = 1 << diff - 1;
        if (this.isRobot()) {
            div = Math.max(div * 0.67f, 1.0f);
        }
        if (diff < 3 && !this.shouldScaleAttributes()) {
            diff = 3;
        }
        return TF2Util.lerp(min, max, 1.0f - 1.0f / div);
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        return forSpawnCount && this.isRobot() ? false : super.isCreatureType(type, forSpawnCount);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == TF2weapons.WEAPONS_CAP) {
            return (T)this.weaponCap;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == TF2weapons.WEAPONS_CAP || super.hasCapability(capability, facing);
    }

    @Override
    public boolean hasHead() {
        return true;
    }

    @Override
    public AxisAlignedBB getHeadBox() {
        return null;
    }

    @Override
    public boolean hasDamageFalloff() {
        return true;
    }

    @Override
    public boolean isBuilding() {
        return false;
    }

    @Override
    public boolean isBackStabbable(EntityLivingBase attacker, ItemStack knife) {
        return true;
    }

    public boolean isTargetEnemy() {
        return !this.friendly;
    }

    public int getMoneyDrop() {
        return this.moneyDrop;
    }

    public void setMoneyDrop(int moneyDrop) {
        this.moneyDrop = moneyDrop;
    }

    @Override
    public float getBackstabDamageReduction(EntityLivingBase attacker, ItemStack knife, float mult) {
        if (this.isGiant()) {
            mult *= 0.6f;
            if (this.getEntityData().func_74764_b("TF2BD")) {
                mult /= this.getEntityData().func_74760_g("TF2BD");
            }
        }
        return mult;
    }

    public static enum Order {
        FOLLOW,
        HOLD;

    }
}

