/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.mercenary;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.entity.ai.EntityAIAmbush;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemCloak;
import rafradek.TF2weapons.item.ItemDisguiseKit;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemMeleeWeapon;
import rafradek.TF2weapons.util.TF2Util;

public class EntitySpy
extends EntityTF2Character {
    public int weaponCounter;
    public int cloakCounter;
    public float prevHealth;
    public boolean isAmbushing;

    public EntitySpy(World p_i1738_1_) {
        super(p_i1738_1_);
        this.field_70728_aV = 15;
        this.rotation = 20.0f;
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityLivingBase.class, entity -> entity == this.func_70638_az() && TF2Util.lookingAtFast(entity, 105.0, this.field_70165_t, this.field_70163_u, this.field_70161_v), 4.0f, 1.0, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAmbush(this));
        this.field_70714_bg.func_85156_a((EntityAIBase)this.avoidSentry);
        if (this.attack != null) {
            this.attack.setRange(30.0f);
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.attack);
        }
        this.getCapability(TF2weapons.WEAPONS_CAP, null).invisTicks = 20;
        if (!this.field_70170_p.field_72995_K) {
            this.getWepCapability().setDisguised(true);
            this.getWepCapability().setDisguiseType("M:" + TF2weapons.animalsDisguise.get(this.func_70681_au().nextInt(TF2weapons.animalsDisguise.size())));
        }
    }

    @Override
    public float[] getDropChance() {
        return new float[]{0.1f, 0.7f, 0.08f, 0.05f};
    }

    protected ResourceLocation func_184647_J() {
        return TF2weapons.lootSpy;
    }

    @Override
    public int func_70627_aG() {
        return 80;
    }

    public boolean hasWatch() {
        return this.loadout.getStackInSlot(3).func_77973_b() instanceof ItemCloak;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void func_70636_d() {
        block7: {
            super.func_70636_d();
            if (this.field_70170_p.field_72995_K) break block7;
            if (this.field_70173_aa == 0 && this.isRobot() && this.hasWatch()) {
                ((ItemCloak)this.loadout.getStackInSlot(3).func_77973_b()).setCloak(true, this.loadout.getStackInSlot(3), (EntityLivingBase)this, this.field_70170_p);
                this.getWepCapability().setInvisible(this.hasWatch());
            }
            this.prevHealth = this.func_110143_aJ();
            --this.cloakCounter;
            target = this.func_70638_az();
            if (target == null && !this.getWepCapability().isDisguised()) {
                ItemDisguiseKit.startDisguise((EntityLivingBase)this, this.field_70170_p, "M:" + TF2weapons.animalsDisguise.get(this.func_70681_au().nextInt(TF2weapons.animalsDisguise.size())));
            }
            if (this.hasWatch()) {
                this.loadout.getStackInSlot(3).func_77973_b().func_77663_a(this.loadout.getStackInSlot(3), this.field_70170_p, (Entity)this, 0, true);
            }
            --this.weaponCounter;
            if (this.weaponCounter > 0 || this.func_70638_az() == null) ** GOTO lbl-1000
            if (this.isAmbushing) ** GOTO lbl-1000
            v0 = this.func_70068_e((Entity)this.func_70638_az());
            v1 = TF2Util.lookingAtFast(target, 105.0, this.field_70165_t, this.field_70163_u, this.field_70161_v) != false ? 4 : 600;
            if (v0 < (double)v1) lbl-1000:
            // 2 sources

            {
                this.setCombatTask(false);
                this.weaponCounter = 8;
            } else if (this.weaponCounter <= 0 && this.func_184614_ca() == this.loadout.getStackInSlot(2)) {
                this.setCombatTask(true);
                this.weaponCounter = 3;
            }
            if (this.func_70638_az() != null && this.func_70638_az() instanceof EntityBuilding && ((EntityBuilding)this.func_70638_az()).isSapped() && ((EntityBuilding)this.func_70638_az()).getOwner() != null) {
                this.func_70624_b(((EntityBuilding)this.func_70638_az()).getOwner());
            }
        }
    }

    @Override
    public int[] getValidSlots() {
        return new int[]{0, 1, 2, 3};
    }

    @Override
    protected void addWeapons() {
        super.addWeapons();
        this.loadout.setStackInSlot(1, ItemFromData.getRandomWeaponOfSlotMob("spy", 1, this.field_70146_Z, true, this.getStockWeight(1), this.noEquipment));
        this.loadout.getStackInSlot(1).func_190920_e(64);
    }

    public String func_70005_c_() {
        if (this.field_70170_p.field_72995_K && ClientProxy.getLocalPlayer() != null && this.getWepCapability().isDisguised()) {
            String username = this.getWepCapability().getDisguiseType().substring(2);
            if (TF2Util.isOnSameTeam((Entity)ClientProxy.getLocalPlayer(), (Entity)this)) {
                return super.func_70005_c_() + " [" + username + "]";
            }
            if (this.getWepCapability().getDisguiseType().startsWith("M:")) {
                return TextFormatting.RESET + I18n.func_135052_a((String)EntityList.func_191302_a((ResourceLocation)new ResourceLocation(username)), (Object[])new Object[0]);
            }
            return ScorePlayerTeam.func_96667_a((Team)Minecraft.func_71410_x().field_71441_e.func_96441_U().func_96509_i(username), (String)username);
        }
        return super.func_70005_c_();
    }

    protected SoundEvent func_184639_G() {
        return TF2Sounds.MOB_SPY_SAY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return TF2Sounds.MOB_SPY_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return TF2Sounds.MOB_SPY_DEATH;
    }

    public void setCombatTask(boolean ranged) {
        this.ranged = ranged;
        if (ranged) {
            this.switchSlot(0);
        } else if (this.func_70638_az() instanceof EntityBuilding) {
            this.switchSlot(1);
        } else {
            this.switchSlot(2);
        }
    }

    @Override
    public float getAttributeModifier(String attribute) {
        float base = super.getAttributeModifier(attribute);
        if (attribute.equals("Damage") && this.func_184614_ca().func_77973_b() instanceof ItemMeleeWeapon) {
            base *= 0.9f;
        }
        return base;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.field_70146_Z.nextFloat() < 0.085f + (float)p_70628_2_ * 0.05f) {
            this.func_70099_a(ItemFromData.getNewStack("revolver"), 0.0f);
        }
        if (this.field_70146_Z.nextFloat() < 0.06f + (float)p_70628_2_ * 0.025f) {
            this.func_70099_a(ItemFromData.getNewStack("butterflyknife"), 0.0f);
        }
        if (this.field_70146_Z.nextFloat() < 0.05f + (float)p_70628_2_ * 0.025f) {
            this.func_70099_a(ItemFromData.getNewStack("cloak"), 0.0f);
        }
        if (this.field_70146_Z.nextFloat() < 0.05f + (float)p_70628_2_ * 0.025f) {
            this.func_70099_a(new ItemStack(TF2weapons.itemDisguiseKit), 0.0f);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.5);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.1);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.14111);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    public int getClassIndex() {
        return 8;
    }

    @Override
    public boolean canBecomeGiant() {
        return false;
    }

    @Override
    public boolean isValidTarget(EntityLivingBase living) {
        return super.isValidTarget(living) && (!(living instanceof EntityBuilding) || !((EntityBuilding)living).isSapped());
    }
}

