/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.mercenary;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemBackpack;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemHorn;
import rafradek.TF2weapons.item.ItemParachute;
import rafradek.TF2weapons.item.ItemSoldierBackpack;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;

public class EntitySoldier
extends EntityTF2Character {
    public boolean rocketJump;
    public boolean rocketJumper;
    public boolean airborne;
    private boolean activateBackpack;

    public EntitySoldier(World par1World) {
        super(par1World);
        if (this.attack != null) {
            this.attack.setRange(35.0f);
            this.attack.fireAtFeet = 1.0;
            this.attack.projSpeed = 1.04f;
            this.attack.explosive = true;
            this.moveAttack.setDodge(true, this.rocketJumper);
        }
        this.field_70728_aV = 15;
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new UseBackpack());
    }

    @Override
    protected void addWeapons() {
        super.addWeapons();
        if (this.loadout.getStackInSlot(1).func_77973_b() instanceof ItemBackpack) {
            this.getWepCapability().setRage(WeaponsCapability.RageType.BANNER, 1.0f);
            if (this.isGiant()) {
                TF2Attribute.setAttribute(this.loadout.getStackInSlot(1), MapList.nameToAttribute.get("EffectDurationBonus"), 999.0f);
            }
        }
        if (this.isGiant()) {
            TF2Attribute.setAttribute(this.loadout.getStackInSlot(0), MapList.nameToAttribute.get("FireRateBonus"), 0.5f);
            TF2Attribute.setAttribute(this.loadout.getStackInSlot(0), MapList.nameToAttribute.get("ClipSizeBonus"), 3.0f);
            TF2Attribute.setAttribute(this.loadout.getStackInSlot(0), MapList.nameToAttribute.get("ReloadRateBonus"), 0.3f);
        }
    }

    protected ResourceLocation func_184647_J() {
        return TF2weapons.lootSoldier;
    }

    @Override
    public float[] getDropChance() {
        return new float[]{0.05f, 0.12f, 0.11f};
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.10583);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    @Override
    public void setRobot(int robot) {
        super.setRobot(robot);
    }

    @Override
    public float getStockWeight(int slot) {
        if (slot != 1) {
            super.getStockWeight(slot);
        }
        return this.isRobot() ? 5.5f - Math.min(3.5f, this.robotStrength / 2.0f) : 2.0f;
    }

    @Override
    public void func_70636_d() {
        ItemStack backpack;
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
            if (this.loadout.getStackInSlot(0).func_77973_b() instanceof ItemWeapon && this.usedSlot == 0 && (this.rocketJumper || this.hasBaseJumper()) && this.func_110143_aJ() > 7.0f && !this.airborne && this.field_70122_E && ItemWeapon.getWeapon(this.func_184614_ca()).getClip(this.func_184614_ca()) == 0) {
                this.rocketJump = true;
            }
            if (!this.isRobot() && this.getDiff() > 1 && this.loadout.getStackInSlot(1).func_77973_b() instanceof ItemWeapon) {
                if (this.usedSlot == 0 && ItemWeapon.getWeapon(this.func_184614_ca()).getClip(this.func_184614_ca()) == 0 && ItemWeapon.getWeapon(this.loadout.getStackInSlot(1)).getClip(this.loadout.getStackInSlot(1)) > 0 && this.func_70068_e((Entity)this.func_70638_az()) < 36.0) {
                    this.switchSlot(1);
                } else if (this.usedSlot == 1 && (ItemWeapon.getWeapon(this.func_184614_ca()).getClip(this.func_184614_ca()) == 0 || this.func_70068_e((Entity)this.func_70638_az()) > 40.0)) {
                    this.switchSlot(0);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_184607_cu().func_77973_b() instanceof ItemHorn && (backpack = ItemBackpack.getBackpack((EntityLivingBase)this)).func_77973_b() instanceof ItemSoldierBackpack && 72000 - this.func_184605_cv() > ItemFromData.getData(backpack).getInt(PropertyType.FIRE_SPEED)) {
            this.func_184597_cx();
            this.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70122_E && (this.field_70143_R > 2.0f || this.getWepCapability().isExpJump() && this.field_70181_x < 0.0) && this.hasBaseJumper()) {
            ItemBackpack.getBackpack((EntityLivingBase)this).func_77978_p().func_74757_a("Deployed", true);
        }
        if (this.airborne) {
            this.jump = false;
        }
        super.func_70636_d();
    }

    public boolean hasBaseJumper() {
        return ItemBackpack.getBackpack((EntityLivingBase)this).func_77973_b() instanceof ItemParachute;
    }

    public void activateBackpack() {
        ItemStack backpack = ItemBackpack.getBackpack((EntityLivingBase)this);
        if (this.getWepCapability().getRage(WeaponsCapability.RageType.BANNER) >= 1.0f) {
            this.func_184611_a(EnumHand.OFF_HAND, new ItemStack(TF2weapons.itemHorn));
            this.func_184598_c(EnumHand.OFF_HAND);
            if (TF2Util.getTeamForDisplay((Entity)this) == 1) {
                this.func_184185_a(ItemFromData.getSound(backpack, PropertyType.HORN_BLU_SOUND), 0.8f, 1.0f);
            } else {
                this.func_184185_a(ItemFromData.getSound(backpack, PropertyType.HORN_RED_SOUND), 0.8f, 1.0f);
            }
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, this.airborne ? damageMultiplier * 0.35f : damageMultiplier);
        this.airborne = false;
    }

    @Override
    public void onShot() {
        if (this.rocketJump) {
            this.jump = true;
            this.field_70759_as += 180.0f;
            this.field_70125_A = 50.0f;
            this.rocketJump = false;
            this.airborne = true;
        }
    }

    @Override
    public void onEquipItem(int slot, ItemStack stack) {
        super.onEquipItem(slot, stack);
        this.attack.fireAtFeet = slot == 0 ? (double)TF2Attribute.getModifier("Explosion Radius", stack, 1.0f, (EntityLivingBase)this) : 0.0;
        this.rocketJumper = !this.isRobot() && (TF2Attribute.getModifier("Airborne Bonus", stack, 0.0f, (EntityLivingBase)this) != 0.0f || this.field_70146_Z.nextBoolean());
    }

    protected SoundEvent func_184639_G() {
        return TF2Sounds.MOB_SOLDIER_SAY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return TF2Sounds.MOB_SOLDIER_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return TF2Sounds.MOB_SOLDIER_DEATH;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.field_70146_Z.nextFloat() < 0.15f + (float)p_70628_2_ * 0.075f) {
            this.func_70099_a(ItemFromData.getNewStack("shotgun"), 0.0f);
        }
        if (this.field_70146_Z.nextFloat() < 0.05f + (float)p_70628_2_ * 0.025f) {
            this.func_70099_a(ItemFromData.getNewStack("rocketlauncher"), 0.0f);
        }
    }

    @Override
    public int getClassIndex() {
        return 1;
    }

    public class UseBackpack
    extends EntityAIBase {
        public boolean func_75250_a() {
            if (EntitySoldier.this.func_70902_q() == null && EntitySoldier.this.getDiff() > 1 && (EntitySoldier.this.func_70638_az() != null || EntitySoldier.this.isGiant()) && EntitySoldier.this.field_184627_bm.func_190926_b()) {
                ItemStack backpack = ItemBackpack.getBackpack((EntityLivingBase)EntitySoldier.this);
                return backpack.func_77973_b() instanceof ItemSoldierBackpack && EntitySoldier.this.getWepCapability().getRage(WeaponsCapability.RageType.BANNER) >= 1.0f;
            }
            return false;
        }

        public void func_75246_d() {
            EntitySoldier.this.activateBackpack();
        }
    }
}

