/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.mercenary;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemCleaver;
import rafradek.TF2weapons.item.ItemFromData;

public class EntityScout
extends EntityTF2Character {
    public boolean doubleJumped;
    private int jumpDelay;
    public int ballCooldown;

    public EntityScout(World par1World) {
        super(par1World);
        if (this.attack != null) {
            this.moveAttack.setDodge(true, true);
            this.attack.jump = true;
            this.attack.jumprange = 40;
            this.attack.dodgeSpeed = 1.25f;
        }
        this.field_70728_aV = 15;
    }

    @Override
    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        if (ItemFromData.getData(this.loadout.getStackInSlot(2)).getName().equals("sandmanball")) {
            this.loadout.setStackInSlot(2, ItemFromData.getNewStack("sandman"));
        }
        super.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    @Override
    protected void addWeapons() {
        super.addWeapons();
        if (TF2Attribute.getModifier("Crit Stun", this.loadout.getStackInSlot(1), 0.0f, (EntityLivingBase)this) != 0.0f) {
            this.loadout.setStackInSlot(2, ItemFromData.getNewStack("sandman"));
        }
    }

    protected ResourceLocation func_184647_J() {
        return TF2weapons.lootScout;
    }

    @Override
    public float[] getDropChance() {
        return new float[]{0.1f, 0.12f, 0.11f};
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.5);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.17638);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.jumpDelay > 0 && --this.jumpDelay == 0 && (this.field_70122_E || !this.doubleJumped)) {
            this.func_70664_aZ();
        }
        if (this.field_70122_E) {
            this.doubleJumped = false;
        }
        if (!this.field_70170_p.field_72995_K && TF2Attribute.getModifier("Crit Stun", this.loadout.getStackInSlot(1), 0.0f, (EntityLivingBase)this) != 0.0f) {
            --this.ballCooldown;
            if (this.func_70638_az() == null || this.func_70638_az().func_70660_b(TF2weapons.stun) == null) {
                this.switchSlot(2);
            } else if (!this.isRobot()) {
                this.switchSlot(1);
                this.func_184614_ca().func_190920_e(16);
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.switchSlot(0);
        }
    }

    protected void func_70664_aZ() {
        super.func_70664_aZ();
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI));
        float f2 = (float)((double)MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
        this.field_70159_w *= (double)f2;
        this.field_70179_y *= (double)f2;
        this.field_70143_R = -3.0f;
        if (!this.doubleJumped && this.jump) {
            this.doubleJumped = true;
            this.jumpDelay = 8;
        }
    }

    @Override
    public float getAttributeModifier(String attribute) {
        if (this.loadout.getStackInSlot(1).func_77973_b() instanceof ItemCleaver && this.shouldScaleAttributes() && attribute.equals("Fire Rate")) {
            return this.scaleWithDifficulty(1.8f, 1.0f);
        }
        return super.getAttributeModifier(attribute);
    }

    protected SoundEvent func_184639_G() {
        return TF2Sounds.MOB_SCOUT_SAY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return TF2Sounds.MOB_SCOUT_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return TF2Sounds.MOB_SCOUT_DEATH;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.field_70146_Z.nextFloat() < 0.6f + (float)p_70628_2_ * 0.3f) {
            this.func_70099_a(ItemFromData.getNewStack("bonk"), 0.0f);
        }
        if (this.field_70146_Z.nextFloat() < 0.12f + (float)p_70628_2_ * 0.075f) {
            this.func_70099_a(ItemFromData.getNewStack("scattergun"), 0.0f);
        }
        if (this.field_70146_Z.nextFloat() < 0.15f + (float)p_70628_2_ * 0.075f) {
            this.func_70099_a(ItemFromData.getNewStack("pistol"), 0.0f);
        }
    }

    @Override
    public float getMotionSensitivity() {
        return this.scaleWithDifficulty(0.12f, 0.02f);
    }

    @Override
    public void onShot() {
        if (ItemFromData.getData(this.loadout.getStackInSlot(2)).getName().equals("sandmanball")) {
            this.ballCooldown = this.getDiff() == 1 ? 340 : (this.getDiff() == 3 ? 160 : 240);
        }
    }

    @Override
    public int getClassIndex() {
        return 0;
    }

    @Override
    public int getState(boolean onTarget) {
        if (onTarget && this.usedSlot == 2) {
            return 3;
        }
        return super.getState(onTarget);
    }
}

