/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.mercenary;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.entity.ai.EntityAINearestChecked;
import rafradek.TF2weapons.entity.ai.EntityAISeek;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.entity.mercenary.InvasionEvent;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemKnife;
import rafradek.TF2weapons.item.ItemMonsterPlacerPlus;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2DamageSource;
import rafradek.TF2weapons.util.TF2Util;

public class EntitySaxtonHale
extends EntityCreature
implements INpc,
IMerchant {
    public EntityPlayer trader;
    public MerchantRecipeList tradeOffers;
    public static List<MerchantRecipe> addRecipes = new ArrayList<MerchantRecipe>();
    public static List<MerchantRecipe> removeRecipes = new ArrayList<MerchantRecipe>();
    public float rage;
    public boolean hostile;
    public boolean superJump;
    public int jumpCooldown;
    public boolean endangered;
    public int lastWeekCheck;
    private int noPathTime = 0;
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS);

    public EntitySaxtonHale(World worldIn) {
        super(worldIn);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, (double)1.1f, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityTF2Character.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAISeek((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70728_aV = 1500;
        this.field_70138_W = 1.0f;
    }

    public void func_70932_a_(EntityPlayer player) {
        this.trader = player;
    }

    public EntityPlayer func_70931_l_() {
        return this.trader;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.tradeOffers == null || this.field_70170_p.func_82737_E() / 96000L != (long)this.lastWeekCheck) {
            this.makeOffers();
        }
        MerchantRecipeList list = new MerchantRecipeList();
        list.addAll((Collection)this.tradeOffers);
        if (!TF2ConfigVars.disableInvasionItems) {
            for (int i = 0; i <= TF2PlayerCapability.get((EntityPlayer)player).maxInvasionBeaten; ++i) {
                if (i == 4 && ((EntityPlayerMP)player).func_147099_x().func_77444_a(TF2weapons.robotsKilled) < 2000 || i == InvasionEvent.DIFFICULTY.length) continue;
                this.addTradeOffer(new ItemStack(TF2weapons.itemEventMaker, 1, i), 27 + i * 9, list, i + 1);
            }
        }
        return list;
    }

    protected ResourceLocation func_184647_J() {
        return TF2weapons.lootHale;
    }

    public void makeOffers() {
        this.lastWeekCheck = (int)(this.field_70170_p.func_82737_E() / 96000L);
        this.tradeOffers = new MerchantRecipeList();
        this.tradeOffers.addAll(addRecipes);
        this.tradeOffers.add((Object)new MerchantRecipe(new ItemStack(TF2weapons.itemTF2, 5, 2), ItemStack.field_190927_a, new ItemStack(TF2weapons.itemTF2, 1, 7), 0, 100));
        int weaponCount = 13 + this.field_70146_Z.nextInt(2);
        List<ItemStack> weapons = ItemFromData.getRandomWeapons(this.field_70146_Z, ItemFromData.VISIBLE_WEAPON, weaponCount);
        for (int i = 0; i < weaponCount; ++i) {
            ItemStack item = weapons.get(i);
            int cost = ItemFromData.getData(item).getInt(PropertyType.COST);
            this.addTradeOffer(item, cost);
        }
        int hatCount = 2 + this.field_70146_Z.nextInt(3);
        for (int i = 0; i < hatCount; ++i) {
            ItemStack item = ItemFromData.getRandomWeaponOfClass("cosmetic", this.field_70146_Z, false);
            int cost = ItemFromData.getData(item).getInt(PropertyType.COST);
            this.addTradeOffer(item, cost);
        }
        for (MerchantRecipe toRemove : removeRecipes) {
            this.tradeOffers.removeIf(recipe -> recipe.func_77394_a().func_77969_a(toRemove.func_77394_a()));
        }
    }

    private void addTradeOffer(ItemStack toBuy, int cost) {
        cost = (int)((float)cost * TF2ConfigVars.costMult);
        ItemStack ingot = new ItemStack(TF2weapons.itemTF2, cost / 9, 2);
        ItemStack nugget = new ItemStack(TF2weapons.itemTF2, cost % 9, 6);
        this.tradeOffers.add((Object)new MerchantRecipe(ingot.func_190916_E() > 0 ? ingot : nugget, nugget.func_190916_E() > 0 ? nugget : ItemStack.field_190927_a, toBuy, 0, 100));
    }

    private void addTradeOffer(ItemStack toBuy, int cost, MerchantRecipeList list, int index) {
        cost = (int)((float)cost * TF2ConfigVars.costMult);
        ItemStack ingot = new ItemStack(TF2weapons.itemTF2, cost / 9, 2);
        ItemStack nugget = new ItemStack(TF2weapons.itemTF2, cost % 9, 6);
        list.add(index, (Object)new MerchantRecipe(ingot.func_190916_E() > 0 ? ingot : nugget, nugget.func_190916_E() > 0 ? nugget : ItemStack.field_190927_a, toBuy, 0, 100));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (super.func_70097_a(source, amount)) {
            Entity entity;
            if (source == DamageSource.field_76369_e || source == DamageSource.field_76371_c) {
                this.superJump = true;
                this.func_70664_aZ();
            }
            if ((entity = source.func_76346_g()) instanceof EntityPlayerMP) {
                this.bossInfo.func_186760_a((EntityPlayerMP)entity);
            }
            this.rage += amount / 100.0f;
            if (source instanceof TF2DamageSource && ((TF2DamageSource)source).getCritical() == 2 && !((TF2DamageSource)source).getWeapon().func_190926_b() && ((TF2DamageSource)source).getWeapon().func_77973_b() instanceof ItemKnife) {
                this.func_184185_a(TF2Sounds.MOB_SAXTON_STAB, 2.5f, 1.0f);
            }
            return this.func_184187_bx() != entity && this.func_184187_bx() != entity ? true : true;
        }
        return false;
    }

    public void setHostile() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestChecked(this, EntityLivingBase.class, true, false, new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase input) {
                return input instanceof EntityPlayer || input instanceof EntityTF2Character;
            }
        }, true, false));
        this.hostile = true;
    }

    public void func_70930_a(MerchantRecipeList recipeList) {
        this.tradeOffers = recipeList;
    }

    public void func_70933_a(MerchantRecipe recipe) {
    }

    public void func_110297_a_(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77942_o()) {
            stack.func_77978_p().func_74757_a("Bought", true);
        }
    }

    public void func_191986_a(float m1, float m2, float m3) {
        float move = this.func_70689_ay();
        super.func_191986_a(m1 / move, m2, m3 / move);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            List list;
            --this.jumpCooldown;
            if (this.func_70638_az() == null) {
                this.func_70691_i(0.35f);
            }
            if (this.field_70146_Z.nextInt(20) == 0) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.12 * (double)TF2Util.lerp(1.5f, 1.0f, this.func_110143_aJ() / this.func_110138_aP()));
            }
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
            List boxes = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0));
            boolean obscuredView = false;
            for (AxisAlignedBB box : boxes) {
                if (box.func_72327_a(this.func_174791_d().func_72441_c(0.0, (double)this.func_70047_e(), 0.0), this.func_174791_d().func_178787_e(this.func_174806_f(0.0f, this.field_70759_as).func_72441_c(0.0, (double)this.func_70047_e(), 0.0))) == null) continue;
                obscuredView = true;
                break;
            }
            if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && obscuredView) {
                this.superJump = true;
                this.func_70664_aZ();
            }
            if (this.field_70173_aa % 3 == 0) {
                if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_70661_as().func_75494_a((Entity)this.func_70638_az()) == null) {
                    ++this.noPathTime;
                    Vec3d forward = this.func_174806_f(0.0f, this.field_70759_as);
                    if (this.noPathTime > 2) {
                        int x = (int)this.field_70165_t;
                        while ((double)x <= this.field_70165_t + forward.field_72450_a) {
                            int y = (int)Math.max(this.func_70638_az().field_70163_u, this.field_70163_u - 1.0);
                            while ((double)y <= this.field_70163_u + 2.0) {
                                int z = (int)this.field_70161_v;
                                while ((double)z <= this.field_70161_v + forward.field_72449_c) {
                                    BlockPos pos = new BlockPos(x, y, z);
                                    if (this.field_70170_p.func_180495_p(pos).func_185887_b(this.field_70170_p, pos) != -1.0f) {
                                        this.field_70170_p.func_175655_b(pos, true);
                                    }
                                    ++z;
                                }
                                ++y;
                            }
                            ++x;
                        }
                        this.noPathTime = 1;
                    }
                } else {
                    this.noPathTime = 0;
                }
            }
            if (this.rage > 1.0f && !(list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(12.0, 12.0, 12.0), (Predicate)new Predicate<EntityLivingBase>(){

                public boolean apply(EntityLivingBase input) {
                    return !(input instanceof EntitySaxtonHale) && (!(input instanceof EntityPlayer) || !((EntityPlayer)input).func_184812_l_()) && input.func_70068_e((Entity)EntitySaxtonHale.this) < 144.0;
                }
            })).isEmpty()) {
                this.rage = 0.0f;
                this.func_184185_a(TF2Sounds.MOB_SAXTON_RAGE, 2.5f, 1.0f);
                for (EntityLivingBase living : list) {
                    TF2Util.stun(living, 160, false);
                }
                this.superJump = true;
                this.func_70664_aZ();
            }
        }
    }

    public void func_70624_b(EntityLivingBase living) {
        super.func_70624_b(living);
        if (!this.endangered) {
            this.endangered = true;
            this.func_184185_a(TF2Sounds.MOB_SAXTON_START, 2.0f, 1.0f);
        }
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187741_cz;
    }

    protected SoundEvent func_184615_bR() {
        return TF2Sounds.MOB_SAXTON_DEATH;
    }

    public boolean func_184222_aU() {
        return !this.hostile;
    }

    public Team func_96124_cp() {
        return this.hostile ? this.field_70170_p.func_96441_U().func_96508_e("TF2Bosses") : null;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, 0.0f);
    }

    protected float func_175134_bD() {
        if (this.superJump && this.jumpCooldown <= 0) {
            return 2.7f;
        }
        return 0.7f;
    }

    public void func_70664_aZ() {
        if (this.superJump && this.jumpCooldown <= 0) {
            this.func_184185_a(TF2Sounds.MOB_SAXTON_JUMP, 2.0f, 1.0f);
        }
        if (this.field_70122_E || this.jumpCooldown <= 0) {
            this.field_70181_x = 0.0;
            super.func_70664_aZ();
        }
        if (this.superJump) {
            this.superJump = false;
        }
        this.jumpCooldown = 20;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1000.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.8);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.12);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(20.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
                if (!itemstack.func_190926_b() && itemstack1 != null && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
            if (entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_110143_aJ() <= 0.0f) {
                if (entityIn instanceof EntityBuilding) {
                    this.func_184185_a(TF2Sounds.MOB_SAXTON_DESTROY, 2.2f, 1.0f);
                } else {
                    this.func_184185_a(TF2Sounds.MOB_SAXTON_KILL, 2.2f, 1.0f);
                }
            }
        }
        return flag;
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74767_n("Hostile")) {
            this.setHostile();
        }
        if (par1NBTTagCompound.func_74764_b("Offers")) {
            this.tradeOffers = new MerchantRecipeList();
            this.tradeOffers.func_77201_a(par1NBTTagCompound.func_74775_l("Offers"));
        }
        this.endangered = par1NBTTagCompound.func_74767_n("Endangered");
        this.lastWeekCheck = par1NBTTagCompound.func_74762_e("LastWeek");
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        if (this.tradeOffers != null) {
            par1NBTTagCompound.func_74782_a("Offers", (NBTBase)this.tradeOffers.func_77202_a());
        }
        par1NBTTagCompound.func_74757_a("Hostile", this.hostile);
        par1NBTTagCompound.func_74757_a("Endangered", this.endangered);
        par1NBTTagCompound.func_74768_a("LastWeek", (int)((short)this.lastWeekCheck));
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!(player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ItemMonsterPlacerPlus || this.func_70638_az() != null || !this.func_70089_S() || this.isTrading() || this.func_70631_g_() || player.func_70093_af())) {
            boolean canTrade;
            boolean bl = canTrade = player.func_96124_cp() != null || player.field_71075_bZ.field_75098_d || !TF2ConfigVars.canJoin;
            if (this.field_70170_p.field_72995_K && !canTrade) {
                ClientProxy.displayScreenJoinTeam();
            } else if (!(this.field_70170_p.field_72995_K || !canTrade || this.tradeOffers != null && this.tradeOffers.isEmpty())) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            }
            player.func_71029_a(StatList.field_188074_H);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean isTrading() {
        return this.trader != null;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        if (this.hostile) {
            this.bossInfo.func_186760_a(player);
        }
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return this.func_190671_u_();
    }
}

