/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.mercenary;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.ai.EntityAIAirblast;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemBackpack;
import rafradek.TF2weapons.item.ItemFlameThrower;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemJetpack;
import rafradek.TF2weapons.item.ItemProjectileWeapon;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;

public class EntityPyro
extends EntityTF2Character {
    public EntityPyro(World par1World) {
        super(par1World);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAirblast(this));
        if (this.attack != null) {
            this.moveAttack.setDodge(true, true);
            this.attack.dodgeSpeed = 1.2f;
            this.attack.setRange(6.2865f);
            this.attack.projSpeed = 1.257f;
        }
        this.rotation = 16.0f;
        this.field_70728_aV = 15;
    }

    protected ResourceLocation func_184647_J() {
        return TF2weapons.lootPyro;
    }

    @Override
    public float[] getDropChance() {
        return new float[]{0.062f, 0.12f, 0.11f};
    }

    @Override
    protected void addWeapons() {
        super.addWeapons();
        if (this.isGiant()) {
            TF2Attribute.setAttribute(this.loadout.getStackInSlot(1), MapList.nameToAttribute.get("FireRateBonus"), 0.42f);
        }
        if (ItemFromData.getData(this.func_184582_a(EntityEquipmentSlot.HEAD)).getName().equals("head_prize") && this.field_70146_Z.nextInt(3) == 0) {
            this.func_96094_a("Pywwo OwO");
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76370_b) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70015_d(int time) {
        super.func_70015_d(1);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
            ItemStack weapon;
            if (this.getDiff() > 1 && this.loadout.getStackInSlot(1).func_77973_b() instanceof ItemProjectileWeapon) {
                if (this.isRobot() || this.usedSlot == 0 && this.func_70068_e((Entity)this.func_70638_az()) > 64.0) {
                    this.switchSlot(1);
                } else if (this.usedSlot == 1 && this.func_70068_e((Entity)this.func_70638_az()) < 44.0) {
                    this.switchSlot(0);
                }
            }
            if ((weapon = this.func_184614_ca()).func_77973_b() instanceof ItemFlameThrower && ((ItemFromData)weapon.func_77973_b()).getMaxRage(weapon, (EntityLivingBase)this) > 0.0f && ((ItemFromData)weapon.func_77973_b()).getRage(weapon, (EntityLivingBase)this) >= ((ItemFromData)weapon.func_77973_b()).getMaxRage(weapon, (EntityLivingBase)this)) {
                this.func_70690_d(new PotionEffect(TF2weapons.stun, 40, 1));
                this.func_70690_d(new PotionEffect(TF2weapons.noKnockback, 40, 0));
                TF2Util.addAndSendEffect((EntityLivingBase)this, new PotionEffect(TF2weapons.uber, 40, 0));
                this.getWepCapability().setRageActive(WeaponsCapability.RageType.PHLOG, true, 2.0f);
                this.func_184185_a(ItemFromData.getSound(weapon, PropertyType.CHARGE_SOUND), this.func_70599_aP(), this.func_70647_i());
            }
            ItemStack backpack = ItemBackpack.getBackpack((EntityLivingBase)this);
            if (!this.field_70170_p.field_72995_K && backpack.func_77973_b() instanceof ItemJetpack && this.func_70068_e((Entity)this.func_70638_az()) > 120.0 && ((ItemJetpack)backpack.func_77973_b()).canActivate(backpack, (EntityLivingBase)this)) {
                ((ItemJetpack)backpack.func_77973_b()).activateJetpack(backpack, (EntityLivingBase)this, true);
            }
        }
        super.func_70636_d();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(17.5);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1329);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    protected SoundEvent func_184639_G() {
        return TF2Sounds.MOB_PYRO_SAY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return TF2Sounds.MOB_PYRO_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return TF2Sounds.MOB_PYRO_DEATH;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.field_70146_Z.nextFloat() < 0.15f + (float)p_70628_2_ * 0.075f) {
            this.func_70099_a(ItemFromData.getNewStack("shotgun"), 0.0f);
        }
        if (this.field_70146_Z.nextFloat() < 0.05f + (float)p_70628_2_ * 0.025f) {
            this.func_70099_a(ItemFromData.getNewStack("flamethrower"), 0.0f);
        }
    }

    @Override
    public float getAttributeModifier(String attribute) {
        if (this.shouldScaleAttributes() && attribute.equals("Damage")) {
            return 0.93f;
        }
        return super.getAttributeModifier(attribute);
    }

    @Override
    public int getClassIndex() {
        return 2;
    }
}

