/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.mercenary;

import com.google.common.base.Predicates;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.entity.ai.EntityAINearestChecked;
import rafradek.TF2weapons.entity.ai.EntityAIUseMedigun;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemMedigun;
import rafradek.TF2weapons.util.TF2Util;

public class EntityMedic
extends EntityTF2Character {
    public EntityAIUseMedigun useMedigun = new EntityAIUseMedigun(this, 1.0f, 20.0f);

    public EntityMedic(World par1World) {
        super(par1World);
        this.field_70715_bh.field_75782_a.clear();
        this.findplayer = new EntityAINearestChecked(this, EntityLivingBase.class, true, false, Predicates.and(this::isValidTarget, target -> target.func_110143_aJ() < target.func_110138_aP() || target == this.func_70902_q() && this.func_110139_bj() == 0.0f || target instanceof EntityPlayer && ((TF2PlayerCapability)target.getCapability(TF2weapons.PLAYER_CAP, null)).medicCall > 0), false, true){

            @Override
            public boolean func_75250_a() {
                return EntityMedic.this.canHeal() && super.func_75250_a();
            }
        };
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.findplayer);
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestChecked(this, EntityLivingBase.class, true, false, this::isValidTarget, true, false){

            @Override
            public boolean func_75250_a() {
                return EntityMedic.this.canHeal() && super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestChecked(this, EntityLivingBase.class, true, false, x$0 -> super.isValidTarget((EntityLivingBase)x$0), true, false));
        this.field_70728_aV = 15;
        this.rotation = 15.0f;
        this.field_70138_W = 1.0f;
        if (par1World != null) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.useMedigun);
            this.friendly = true;
        }
    }

    public boolean canHeal() {
        return this.loadout.getStackInSlot(1).func_77973_b() instanceof ItemMedigun;
    }

    @Override
    protected void addWeapons() {
        super.addWeapons();
        if (this.isGiant()) {
            if (this.func_184753_b() == null) {
                TF2Attribute.setAttribute(this.loadout.getStackInSlot(1), MapList.nameToAttribute.get("HealRateBonus"), 10000.0f);
                TF2Attribute.setAttribute(this.loadout.getStackInSlot(1), MapList.nameToAttribute.get("OverHealBonus"), 0.0f);
            } else {
                TF2Attribute.setAttribute(this.loadout.getStackInSlot(1), MapList.nameToAttribute.get("HealRateBonus"), 2.25f);
                TF2Attribute.setAttribute(this.loadout.getStackInSlot(1), MapList.nameToAttribute.get("OverHealBonus"), 0.0f);
            }
        }
    }

    protected ResourceLocation func_184647_J() {
        return TF2weapons.lootMedic;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.1);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.14111);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.field_70158_ak = this.getCapability(TF2weapons.WEAPONS_CAP, null).getHealTarget() > 0;
        if (!this.field_70170_p.field_72995_K) {
            IAttributeInstance speed = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (this.field_70173_aa % 4 == 0) {
                for (AttributeModifier modifier : this.playerAttributes) {
                    speed.func_111124_b(modifier);
                }
                this.playerAttributes.clear();
                if (this.func_70638_az() != null && this.friendly && this.func_70638_az() instanceof EntityPlayer) {
                    for (AttributeModifier modifier : this.func_70638_az().func_110148_a(SharedMonsterAttributes.field_111263_d).func_111122_c()) {
                        if (!(modifier.func_111164_d() > 0.0)) continue;
                        TF2Util.addModifierSafe((EntityLivingBase)this, SharedMonsterAttributes.field_111263_d, modifier, true);
                        this.playerAttributes.add(modifier);
                    }
                }
            }
        }
    }

    @Override
    public void func_70624_b(EntityLivingBase entity) {
        this.alert = true;
        if (TF2Util.isOnSameTeam((Entity)this, (Entity)entity)) {
            if (!this.friendly) {
                this.friendly = true;
            }
        } else if (entity != null && this.friendly) {
            this.friendly = false;
        }
        this.switchSlot(this.getDefaultSlot());
        super.func_70624_b(entity);
    }

    protected SoundEvent func_184639_G() {
        return TF2Sounds.MOB_MEDIC_SAY;
    }

    @Override
    public int getDefaultSlot() {
        return this.friendly ? 1 : 0;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return TF2Sounds.MOB_MEDIC_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return TF2Sounds.MOB_MEDIC_DEATH;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.field_70146_Z.nextFloat() < 0.15f + (float)p_70628_2_ * 0.075f) {
            this.func_70099_a(ItemFromData.getNewStack("syringegun"), 0.0f);
        }
        if (this.field_70146_Z.nextFloat() < 0.08f + (float)p_70628_2_ * 0.03f) {
            this.func_70099_a(ItemFromData.getNewStack("medigun"), 0.0f);
        }
    }

    @Override
    public float getAttributeModifier(String attribute) {
        if (!(!TF2ConfigVars.scaleAttributes || this.func_70638_az() instanceof EntityPlayer || this.func_70638_az() instanceof IEntityOwnable && ((IEntityOwnable)this.func_70638_az()).func_184753_b() != null)) {
            if (attribute.equals("Heal")) {
                return this.scaleWithDifficulty(0.75f, 1.0f);
            }
            if (attribute.equals("Overheal")) {
                return this.scaleWithDifficulty(0.55f, 1.0f);
            }
        }
        return super.getAttributeModifier(attribute);
    }

    @Override
    public float getMotionSensitivity() {
        return 0.0f;
    }

    @Override
    public boolean isValidTarget(EntityLivingBase target) {
        return (!(target instanceof EntityMedic) || !((EntityTF2Character)target).isRobot() && !(target.func_110143_aJ() >= target.func_110138_aP())) && !(target instanceof EntityBuilding) && TF2Util.isOnSameTeam((Entity)this, (Entity)target);
    }

    @Override
    public int getClassIndex() {
        return 6;
    }
}

