/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.mercenary;

import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemFromData;

public class EntityHeavy
extends EntityTF2Character {
    public EntityHeavy(World par1World) {
        super(par1World);
        if (this.attack != null) {
            this.moveAttack.setDodge(true, true);
            this.attack.dodgeSpeed = 1.25f;
        }
        this.rotation = 10.0f;
        this.field_70728_aV = 15;
        this.func_70105_a(0.6f, 1.99f);
    }

    @Override
    public float getWidth() {
        return 0.6f;
    }

    @Override
    public float getHeight() {
        return 1.99f;
    }

    @Override
    protected void addWeapons() {
        super.addWeapons();
        if (!this.noEquipment && !this.isRobot()) {
            float chance = this.field_70146_Z.nextFloat();
            if (chance < 0.2f) {
                this.refill.setStackInSlot(0, new ItemStack(TF2weapons.itemSandvich));
            } else if (chance < 0.3f) {
                this.refill.setStackInSlot(0, new ItemStack(TF2weapons.itemChocolate));
            }
        }
        if (this.isGiant()) {
            TF2Attribute.setAttribute(this.loadout.getStackInSlot(0), MapList.nameToAttribute.get("DamageBonus"), 1.35f);
        }
    }

    protected ResourceLocation func_184647_J() {
        return TF2weapons.lootHeavy;
    }

    @Override
    public float[] getDropChance() {
        return new float[]{0.045f, 0.12f, 0.11f};
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getAmmo() > 0 && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) <= 350.0 && (this.getCapability(TF2weapons.WEAPONS_CAP, null).state & 2) == 0) {
            this.getCapability(TF2weapons.WEAPONS_CAP, null).state += 2;
        }
    }

    protected SoundEvent func_184639_G() {
        return TF2Sounds.MOB_HEAVY_SAY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return TF2Sounds.MOB_HEAVY_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return TF2Sounds.MOB_HEAVY_DEATH;
    }

    @Override
    public float func_70047_e() {
        return 1.78f * (this.getRobotSize() > 1 ? 1.75f : (this.getRobotSize() > 2 ? 2.0f : 1.0f));
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.field_70146_Z.nextFloat() < 0.15f + (float)p_70628_2_ * 0.075f) {
            this.func_70099_a(ItemFromData.getNewStack("shotgun"), 0.0f);
        }
        if (this.field_70146_Z.nextFloat() < 0.05f + (float)p_70628_2_ * 0.025f) {
            this.func_70099_a(ItemFromData.getNewStack("minigun"), 0.0f);
        }
    }

    @Override
    public float getAttributeModifier(String attribute) {
        if (this.shouldScaleAttributes()) {
            if (attribute.equals("Minigun Spinup")) {
                return this.scaleWithDifficulty(2.0f, 1.0f);
            }
            if (attribute.equals("Damage")) {
                return 0.9f;
            }
        }
        return super.getAttributeModifier(attribute);
    }

    @Override
    public int getClassIndex() {
        return 4;
    }

    @Override
    public int getState(boolean onTarget) {
        return onTarget ? 1 : 2;
    }
}

