/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.mercenary;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.entity.ai.EntityAIRepair;
import rafradek.TF2weapons.entity.ai.EntityAISetup;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.building.EntityDispenser;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemFromData;

public class EntityEngineer
extends EntityTF2Character {
    public EntitySentry sentry;
    public EntityDispenser dispenser;
    public int buildCount;
    public NBTTagCompound grabbed;
    public int grabbedid;

    public EntityEngineer(World p_i1738_1_) {
        super(p_i1738_1_);
        this.field_70728_aV = 15;
        this.rotation = 15.0f;
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRepair(this, 1.0f, 2.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISetup(this));
        this.field_70714_bg.func_85156_a((EntityAIBase)this.wander);
        this.getCapability(TF2weapons.WEAPONS_CAP, null).setMetal(TF2ConfigVars.maxMetalEngineer);
        if (this.attack != null) {
            this.attack.setRange(20.0f);
        }
    }

    protected ResourceLocation func_184647_J() {
        return TF2weapons.lootEngineer;
    }

    @Override
    protected void addWeapons() {
        super.addWeapons();
    }

    @Override
    public float[] getDropChance() {
        return new float[]{0.12f, 0.12f, 0.08f, 0.02f};
    }

    @Override
    public int[] getValidSlots() {
        return new int[]{0, 1, 2, 3};
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.5);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1329);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    protected SoundEvent func_184639_G() {
        return TF2Sounds.MOB_ENGINEER_SAY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return TF2Sounds.MOB_ENGINEER_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return TF2Sounds.MOB_ENGINEER_DEATH;
    }

    @Override
    public void switchSlot(int slot, boolean noAmmoSwitch, boolean forceRefresh) {
        super.switchSlot(slot, noAmmoSwitch, forceRefresh);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 2) {
            for (EntityBuilding building2 : this.field_70170_p.func_175647_a(EntityBuilding.class, this.func_174813_aQ().func_186662_g(32.0), building -> building.func_184753_b() == null && building.getOwner() == null && this.func_110124_au().equals(building.ownerEntityID))) {
                if (building2 instanceof EntitySentry && this.sentry == null) {
                    this.sentry = (EntitySentry)building2;
                    building2.setOwner((EntityLivingBase)this);
                    continue;
                }
                if (!(building2 instanceof EntityDispenser) || this.dispenser != null) continue;
                this.dispenser = (EntityDispenser)building2;
                building2.setOwner((EntityLivingBase)this);
            }
        }
        if (this.func_110174_bM() == 0.0f && this.func_174818_b(this.func_180486_cf()) < 1.0) {
            this.func_175449_a(this.func_180486_cf(), 8);
        }
        if (this.func_70902_q() != null && this.getOrder() == EntityTF2Character.Order.FOLLOW && this.grabbed == null) {
            if (this.sentry != null && this.sentry.func_70089_S() && !this.sentry.isMini() && this.func_70068_e((Entity)this.sentry) < 16.0) {
                this.sentry.grab();
            } else if (this.dispenser != null && this.dispenser.func_70089_S() && this.func_70068_e((Entity)this.dispenser) < 16.0) {
                this.dispenser.grab();
            }
        }
        super.func_70636_d();
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.field_70146_Z.nextFloat() < 0.1f + (float)p_70628_2_ * 0.05f) {
            this.func_70099_a(ItemFromData.getNewStack("pistol"), 0.0f);
        }
        if (this.field_70146_Z.nextFloat() < 0.1f + (float)p_70628_2_ * 0.05f) {
            this.func_70099_a(ItemFromData.getNewStack("shotgun"), 0.0f);
        }
        if (this.field_70146_Z.nextFloat() < 0.1f + (float)p_70628_2_ * 0.05f) {
            this.func_70099_a(ItemFromData.getNewStack("wrench"), 0.0f);
        }
        this.func_70099_a(new ItemStack(TF2weapons.itemBuildingBox, 1, 18 + this.field_70146_Z.nextInt(3) * 2 + this.getEntTeam()), 0.0f);
    }

    @Override
    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("BuildCount", (short)this.buildCount);
        par1NBTTagCompound.func_74774_a("GrabbedID", (byte)this.grabbedid);
        if (this.grabbed != null) {
            par1NBTTagCompound.func_74782_a("Grabbed", (NBTBase)this.grabbed);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        if (par1NBTTagCompound.func_74764_b("Grabbed")) {
            this.grabbed = par1NBTTagCompound.func_74775_l("Grabbed");
        }
        super.func_70037_a(par1NBTTagCompound);
        this.buildCount = par1NBTTagCompound.func_74765_d("BuildCount");
        this.grabbedid = par1NBTTagCompound.func_74771_c("GrabbedID");
    }

    @Override
    public int getClassIndex() {
        return 5;
    }

    @Override
    public boolean isAmmoFull() {
        return this.getWepCapability().getMetal() >= (this.hasSentryAndDispenser() ? 40 : Math.min(TF2ConfigVars.maxMetalEngineer, 200)) && super.isAmmoFull();
    }

    public boolean hasSentryAndDispenser() {
        return this.sentry != null && this.sentry.func_70089_S() && this.dispenser != null && this.dispenser.func_70089_S();
    }

    @Override
    public boolean canBecomeGiant() {
        return false;
    }
}

