/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.mercenary;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.entity.ai.EntityAIStickybomb;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.entity.projectile.EntityStickybomb;
import rafradek.TF2weapons.item.ItemChargingTarge;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemStickyLauncher;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.WeaponData;

public class EntityDemoman
extends EntityTF2Character {
    private static final DataParameter<Boolean> SENTRY_BUSTER = EntityDataManager.func_187226_a(EntityDemoman.class, (DataSerializer)DataSerializers.field_187198_h);
    public int chargeCool = 0;
    public EntityLivingBase target;
    public BlockPos targetpos;

    public EntityDemoman(World par1World) {
        super(par1World);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIStickybomb(this, 1.0f, 10.0f));
        if (this.attack != null) {
            this.attack.setRange(20.0f);
            this.attack.projSpeed = 1.16205f;
            this.attack.gravity = 0.0381f;
            this.attack.releaseAt = 0.03f;
            this.moveAttack.setDodge(true, false);
        }
        this.rotation = 10.0f;
        this.field_70728_aV = 15;
    }

    @Override
    protected void addWeapons() {
        ItemStack sword;
        super.addWeapons();
        if (this.field_70146_Z.nextFloat() > 0.18f && !this.loadout.getStackInSlot(1).func_190926_b() && this.loadout.getStackInSlot(1).func_77973_b() instanceof ItemChargingTarge && !(sword = ItemFromData.getRandomWeapon(this.field_70146_Z, (Predicate<WeaponData>)Predicates.and(ItemFromData.VISIBLE_WEAPON, (Predicate)new Predicate<WeaponData>(){

            public boolean apply(WeaponData input) {
                return !input.getBoolean(PropertyType.STOCK) && ItemFromData.isItemOfClassSlot(input, 2, "demoman");
            }
        }))).func_190926_b()) {
            this.loadout.setStackInSlot(2, sword);
        }
        if (this.isGiant()) {
            TF2Attribute.setAttribute(this.loadout.getStackInSlot(0), MapList.nameToAttribute.get("FireRateBonus"), 0.5f);
            TF2Attribute.setAttribute(this.loadout.getStackInSlot(0), MapList.nameToAttribute.get("ClipSizeBonus"), 4.0f);
            TF2Attribute.setAttribute(this.loadout.getStackInSlot(0), MapList.nameToAttribute.get("ReloadRateBonus"), 0.25f);
            TF2Attribute.setAttribute(this.loadout.getStackInSlot(0), MapList.nameToAttribute.get("SpreadAdd"), 0.1f);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SENTRY_BUSTER, (Object)false);
    }

    private void setBusterInternal() {
        this.field_70180_af.func_187227_b(SENTRY_BUSTER, (Object)true);
        this.field_70715_bh.field_75782_a.clear();
        this.field_70714_bg.func_85156_a((EntityAIBase)this.attack);
    }

    public void setBuster(EntityLivingBase target) {
        this.setBusterInternal();
        this.target = target;
    }

    public void setBuster(BlockPos target) {
        this.setBusterInternal();
        this.targetpos = target;
    }

    @Override
    public float[] getDropChance() {
        return new float[]{0.065f, 0.065f, 0.11f};
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(17.5);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.12347);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance p_180482_1_, IEntityLivingData data) {
        data = super.func_180482_a(p_180482_1_, data);
        if (!this.loadout.getStackInSlot(1).func_190926_b() && this.loadout.getStackInSlot(1).func_77973_b() instanceof ItemChargingTarge) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("ShieldHP", 3.0, 0));
            this.func_70691_i(3.0f);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier("ShieldMove", 0.02, 2));
        }
        return data;
    }

    @Override
    public int getDefaultSlot() {
        return this.loadout.getStackInSlot(1).func_77973_b() instanceof ItemChargingTarge ? 2 : 0;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        --this.chargeCool;
        if (!this.field_70170_p.field_72995_K) {
            boolean chargetick;
            if (!this.getWepCapability().activeBomb.isEmpty() && this.loadout.getStackInSlot(1).func_77973_b() instanceof ItemStickyLauncher) {
                EntityStickybomb bomb = this.getWepCapability().activeBomb.get(this.field_70146_Z.nextInt(this.getWepCapability().activeBomb.size()));
                for (EntityLivingBase target : this.field_70170_p.func_72872_a(EntityLivingBase.class, bomb.func_174813_aQ().func_186662_g(5.0))) {
                    if (!this.isValidTarget(target) || !(target.func_70068_e((Entity)bomb) < 7.0) || !this.func_70635_at().func_75522_a((Entity)target) || !target.func_70685_l((Entity)bomb)) continue;
                    ((ItemWeapon)this.loadout.getStackInSlot(1).func_77973_b()).altFireTick(this.loadout.getStackInSlot(1), (EntityLivingBase)this, this.field_70170_p);
                    break;
                }
            }
            boolean bl = chargetick = this.field_70173_aa % 4 == 0;
            if (chargetick && this.loadout.getStackInSlot(1).func_77973_b() instanceof ItemChargingTarge) {
                this.func_184611_a(EnumHand.OFF_HAND, this.loadout.getStackInSlot(1));
                this.switchSlot(2);
                if (this.func_70638_az() != null && this.func_70635_at().func_75522_a((Entity)this.func_70638_az()) && this.chargeCool < 0) {
                    this.moveAttack.setDodge(false, false);
                    this.chargeCool = 300;
                    this.func_184185_a(TF2Sounds.WEAPON_SHIELD_CHARGE, 2.0f, 1.0f);
                    this.func_70690_d(new PotionEffect(TF2weapons.charging, 40));
                }
            } else if (chargetick && this.func_184586_b(EnumHand.OFF_HAND).func_77973_b() instanceof ItemChargingTarge) {
                this.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
                this.switchSlot(this.getDefaultSlot());
            }
        }
    }

    protected void func_70688_c(PotionEffect effect) {
        super.func_70688_c(effect);
        if (effect.func_188419_a() == TF2weapons.charging) {
            this.moveAttack.setDodge(true, false);
        }
    }

    @Override
    public void onEquipItem(int slot, ItemStack stack) {
        super.onEquipItem(slot, stack);
        this.attack.fireAtFeet = slot == 1 ? (double)TF2Attribute.getModifier("Explosion Radius", stack, 1.0f, (EntityLivingBase)this) : 0.0;
    }

    protected SoundEvent func_184639_G() {
        return TF2Sounds.MOB_DEMOMAN_SAY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return TF2Sounds.MOB_DEMOMAN_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return TF2Sounds.MOB_DEMOMAN_DEATH;
    }

    protected ResourceLocation func_184647_J() {
        return TF2weapons.lootDemoman;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        if (this.field_70146_Z.nextFloat() < 0.075f + (float)p_70628_2_ * 0.0375f) {
            this.func_70099_a(ItemFromData.getNewStack("grenadelauncher"), 0.0f);
        }
        if (this.field_70146_Z.nextFloat() < 0.06f + (float)p_70628_2_ * 0.03f) {
            this.func_70099_a(ItemFromData.getNewStack("stickybomblauncher"), 0.0f);
        }
    }

    @Override
    public float getAttributeModifier(String attribute) {
        if (attribute.equals("Spread") && this.func_184614_ca() != null && this.func_184614_ca().func_77973_b() instanceof ItemStickyLauncher) {
            return 3.0f;
        }
        return super.getAttributeModifier(attribute);
    }

    @Override
    public int getClassIndex() {
        return 3;
    }

    public void explode() {
    }
}

