/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.building;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemDye;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import org.lwjgl.opengl.GL11;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.TF2Achievements;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.util.TF2Util;

public class EntityTeleporter
extends EntityBuilding {
    public static final int TP_PER_PLAYER = 128;
    public static int tpCount = 0;
    public static HashMap<UUID, TeleporterData[]> teleporters = new HashMap();
    public int tpID = -1;
    public int ticksToTeleport;
    public EntityTeleporter linkedTp;
    public float spin;
    public float spinRender;
    public long timestamp;
    private static final DataParameter<Integer> TELEPORTS = EntityDataManager.func_187226_a(EntityTeleporter.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TPPROGRESS = EntityDataManager.func_187226_a(EntityTeleporter.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> CHANNEL = EntityDataManager.func_187226_a(EntityTeleporter.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> EXIT = EntityDataManager.func_187226_a(EntityTeleporter.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> COLOR = EntityDataManager.func_187226_a(EntityTeleporter.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityTeleporter(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 0.2f);
    }

    @Override
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K && !this.isExit() && this.getTPprogress() <= 0 && entityIn != null && entityIn instanceof EntityLivingBase && !(entityIn instanceof EntityBuilding) && (this.getOwner() != null && (WeaponsCapability.get((Entity)this.getOwner()).teleporterEntity && !(entityIn instanceof EntityPlayer) || WeaponsCapability.get((Entity)this.getOwner()).teleporterPlayer && entityIn instanceof EntityPlayer && entityIn.func_96124_cp() == null) || TF2Util.isOnSameTeam((Entity)this, entityIn)) && entityIn.func_174813_aQ().func_72326_a(this.func_174813_aQ().func_72314_b(0.0, 0.5, 0.0).func_72317_d(0.0, 0.5, 0.0)) && this.ticksToTeleport <= 0) {
            if (this.ticksToTeleport < 0) {
                this.ticksToTeleport = 10;
            } else {
                TeleporterData exit = this.getTeleportExit();
                if (exit != null && this.consumeEnergy(this.getMinEnergy())) {
                    if (exit.dimension != this.field_71093_bK) {
                        if (entityIn instanceof EntityPlayerMP && ForgeHooks.onTravelToDimension((Entity)this, (int)exit.dimension)) {
                            this.field_70170_p.func_73046_m().func_184103_al().transferPlayerToDimension((EntityPlayerMP)entityIn, exit.dimension, (Teleporter)new TeleporterDim((WorldServer)this.field_70170_p, exit));
                        } else {
                            WorldServer destworld = this.field_70170_p.func_73046_m().func_71218_a(exit.dimension);
                            Entity newent = EntityList.func_191304_a(entityIn.getClass(), (World)destworld);
                            if (newent != null) {
                                NBTTagCompound data = entityIn.func_189511_e(new NBTTagCompound());
                                data.func_82580_o("Dimension");
                                newent.func_70020_e(data);
                                entityIn.func_70106_y();
                                newent.field_98038_p = true;
                                entityIn.func_174828_a((BlockPos)exit, entityIn.field_70177_z, entityIn.field_70125_A);
                                destworld.func_72838_d(newent);
                                entityIn = newent;
                            }
                        }
                    }
                    entityIn.func_70634_a((double)exit.func_177958_n() + 0.5, (double)exit.func_177956_o() + 0.23, (double)exit.func_177952_p() + 0.5);
                    this.setTeleports(this.getTeleports() + 1);
                    this.setTPprogress(this.getLevel() == 1 ? 200 : (this.getLevel() == 2 ? 100 : 60));
                    this.func_184185_a(TF2Sounds.MOB_TELEPORTER_SEND, 1.5f, 1.0f);
                    entityIn.func_184185_a(TF2Sounds.MOB_TELEPORTER_RECEIVE, 0.75f, 1.0f);
                    if (this.getOwner() instanceof EntityPlayerMP) {
                        ((EntityPlayer)this.getOwner()).func_71029_a(TF2Achievements.TELEPORTED);
                    }
                }
            }
        }
        return super.func_70114_g(entityIn);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.tpID == -1) {
                this.tpID = ++tpCount;
            }
            if (!this.isExit()) {
                --this.ticksToTeleport;
                if (this.getTPprogress() > 0) {
                    this.setTPprogress(this.getTPprogress() - 1);
                }
                if (this.getSoundState() == 1 && (this.getTPprogress() > 0 || this.getTeleportExit() == null)) {
                    this.setSoundState(0);
                    if (this.linkedTp != null) {
                        this.linkedTp.setSoundState(0);
                    }
                }
                if (this.getSoundState() == 0 && this.getTPprogress() <= 0 && this.getTeleportExit() != null) {
                    this.setSoundState(1);
                    if (this.linkedTp != null) {
                        this.linkedTp.setSoundState(1);
                    }
                }
                if (this.linkedTp != null && this.getColor() != this.linkedTp.getColor()) {
                    this.func_184212_Q().func_187227_b(COLOR, (Object)((byte)this.linkedTp.getColor()));
                }
            } else if (teleporters.get(this.func_184753_b())[this.getID()] == null || EntityTeleporter.teleporters.get((Object)this.func_184753_b())[this.getID()].id != this.tpID) {
                this.setExit(false);
                this.updateTeleportersData(true);
            } else if (EntityTeleporter.teleporters.get((Object)this.func_184753_b())[this.getID()].id == this.tpID && !this.func_180425_c().equals((Object)teleporters.get(this.func_184753_b())[this.getID()])) {
                this.updateTeleportersData(false);
            }
        } else {
            this.spin = this.getSoundState() == 1 ? (this.spin += (float)Math.PI * (this.getLevel() == 1 ? 0.25f : (this.getLevel() == 2 ? 0.325f : 0.4f))) : 0.0f;
        }
    }

    public TeleporterData getTeleportExit() {
        UUID uuid = this.func_184753_b();
        if (this.func_184753_b() != null && teleporters.get(uuid) != null) {
            final TeleporterData data = teleporters.get(uuid)[this.getID()];
            List list = this.field_70170_p.func_175644_a(EntityTeleporter.class, (Predicate)new Predicate<EntityTeleporter>(){

                public boolean apply(EntityTeleporter input) {
                    return data != null && data.id == input.tpID;
                }
            });
            if (!list.isEmpty()) {
                this.linkedTp = (EntityTeleporter)list.get(0);
            }
            return data;
        }
        return null;
    }

    @Override
    public SoundEvent getSoundNameForState(int state) {
        switch (state) {
            case 0: {
                return null;
            }
            case 1: {
                return this.getLevel() == 1 ? TF2Sounds.MOB_TELEPORTER_SPIN_1 : (this.getLevel() == 2 ? TF2Sounds.MOB_TELEPORTER_SPIN_2 : TF2Sounds.MOB_TELEPORTER_SPIN_3);
            }
        }
        return super.getSoundNameForState(state);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player == this.getOwner() && player.func_184586_b(hand).func_77973_b() instanceof ItemDye) {
            if (!this.field_70170_p.field_72995_K) {
                this.setColor(player.func_184586_b(hand).func_77960_j());
            }
            return true;
        }
        if (player == this.getOwner() && hand == EnumHand.MAIN_HAND) {
            if (!this.field_70170_p.field_72995_K) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)TF2weapons.instance, (int)5, (World)this.field_70170_p, (int)this.func_145782_y(), (int)0, (int)0);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TELEPORTS, (Object)0);
        this.field_70180_af.func_187214_a(TPPROGRESS, (Object)0);
        this.field_70180_af.func_187214_a(EXIT, (Object)false);
        this.field_70180_af.func_187214_a(CHANNEL, (Object)0);
        this.field_70180_af.func_187214_a(COLOR, (Object)-1);
    }

    public boolean isExit() {
        return (Boolean)this.field_70180_af.func_187225_a(EXIT);
    }

    public void setExit(boolean exit) {
        if (this.tpID == -1) {
            this.tpID = ++tpCount;
        }
        this.field_70180_af.func_187227_b(EXIT, (Object)exit);
        if (this.func_184753_b() != null) {
            this.updateTeleportersData(false);
        }
    }

    public int getID() {
        return ((Byte)this.field_70180_af.func_187225_a(CHANNEL)).byteValue();
    }

    public void setID(int id) {
        if (id >= 128 || id < 0) {
            return;
        }
        if (this.func_184753_b() != null) {
            this.updateTeleportersData(true);
        }
        this.field_70180_af.func_187227_b(CHANNEL, (Object)((byte)id));
        if (this.func_184753_b() != null) {
            this.updateTeleportersData(false);
        }
    }

    public int getTPprogress() {
        return this.isDisabled() ? 20 : (Integer)this.field_70180_af.func_187225_a(TPPROGRESS);
    }

    public void setTPprogress(int progress) {
        this.field_70180_af.func_187227_b(TPPROGRESS, (Object)progress);
    }

    public void setTeleports(int amount) {
        this.field_70180_af.func_187227_b(TELEPORTS, (Object)amount);
    }

    public int getTeleports() {
        return (Integer)this.field_70180_af.func_187225_a(TELEPORTS);
    }

    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)((byte)color));
        if (this.linkedTp != null && !this.isExit()) {
            this.linkedTp.setColor(color);
        }
    }

    public int getColor() {
        return ((Byte)this.field_70180_af.func_187225_a(COLOR)).byteValue();
    }

    @Override
    public void upgrade() {
        super.upgrade();
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            this.updateTeleportersData(true);
        }
        super.func_70106_y();
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        UUID id;
        super.func_184206_a(key);
        if (!this.field_70170_p.field_72995_K && OWNER_UUID.equals(key) && !teleporters.containsKey(id = this.func_184753_b())) {
            teleporters.put(id, new TeleporterData[128]);
        }
    }

    public void updateTeleportersData(boolean forceremove) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        UUID id = this.func_184753_b();
        if (!forceremove && this.isExit()) {
            EntityTeleporter.teleporters.get((Object)id)[this.getID()] = new TeleporterData(this.func_180425_c(), this.tpID, this.field_71093_bK);
        } else if (teleporters.get(id)[this.getID()] != null && EntityTeleporter.teleporters.get((Object)id)[this.getID()].id == this.tpID) {
            EntityTeleporter.teleporters.get((Object)id)[this.getID()] = null;
        }
    }

    protected SoundEvent func_184615_bR() {
        return TF2Sounds.MOB_TELEPORTER_DEATH;
    }

    @Override
    public float getCollHeight() {
        return 0.2f;
    }

    @Override
    public float getCollWidth() {
        return 1.0f;
    }

    @Override
    public int getIronDrop() {
        return 1 + this.getLevel() / 2;
    }

    @Override
    public boolean shouldUseBlocks() {
        return TF2ConfigVars.teleporterUseEnergy >= 0 && super.shouldUseBlocks();
    }

    @Override
    public int getMinEnergy() {
        return this.func_184753_b() != null ? TF2ConfigVars.teleporterUseEnergy : 0;
    }

    @Override
    public int getBuildingID() {
        return 2 + (this.isExit() ? 1 : 0);
    }

    @Override
    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74774_a("TeleExitID", (byte)this.getID());
        par1NBTTagCompound.func_74757_a("TeleExit", this.isExit());
        par1NBTTagCompound.func_74768_a("TeleID", this.tpID);
        par1NBTTagCompound.func_74777_a("Teleports", (short)this.getTeleports());
        par1NBTTagCompound.func_74774_a("Color", (byte)this.getColor());
    }

    @Override
    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.tpID = par1NBTTagCompound.func_74762_e("TeleID");
        this.setTeleports(par1NBTTagCompound.func_74765_d("Teleports"));
        this.func_184212_Q().func_187227_b(CHANNEL, (Object)par1NBTTagCompound.func_74771_c("TeleExitID"));
        if (!(this.field_70170_p.field_72995_K || teleporters.get(this.func_184753_b())[this.getID()] != null && EntityTeleporter.teleporters.get((Object)this.func_184753_b())[this.getID()].id != this.tpID)) {
            this.setExit(par1NBTTagCompound.func_74767_n("TeleExit"));
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(EXIT, (Object)par1NBTTagCompound.func_74767_n("TeleExit"));
        }
        this.func_184212_Q().func_187227_b(COLOR, (Object)par1NBTTagCompound.func_74771_c("Color"));
    }

    @Override
    public void renderGUI(BufferBuilder renderer, Tessellator tessellator, EntityPlayer player, int width, int height, GuiIngame gui) {
        float health;
        ClientProxy.setColor(TF2Util.getTeamColor((Entity)this), 0.7f, 0.0f, 0.25f, 0.8f);
        gui.func_73729_b(20, 2, 0, 112, 124, 44);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
        gui.func_73729_b(0, 0, 0, 0, 144, 48);
        double imagePos = this.isExit() ? 0.1875 : 0.0;
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(19.0, 48.0, 0.0).func_187315_a(0.5625 + imagePos, 0.9375).func_181675_d();
        renderer.func_181662_b(69.0, 48.0, 0.0).func_187315_a(0.75 + imagePos, 0.9375).func_181675_d();
        renderer.func_181662_b(69.0, 0.0, 0.0).func_187315_a(0.75 + imagePos, 0.75).func_181675_d();
        renderer.func_181662_b(19.0, 0.0, 0.0).func_187315_a(0.5625 + imagePos, 0.75).func_181675_d();
        tessellator.func_78381_a();
        if (!this.func_70089_S()) {
            return;
        }
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(67.0, 22.0, 0.0).func_187315_a(0.9375, 0.1875).func_181675_d();
        renderer.func_181662_b(83.0, 22.0, 0.0).func_187315_a(1.0, 0.1875).func_181675_d();
        renderer.func_181662_b(83.0, 6.0, 0.0).func_187315_a(1.0, 0.125).func_181675_d();
        renderer.func_181662_b(67.0, 6.0, 0.0).func_187315_a(0.9375, 0.125).func_181675_d();
        tessellator.func_78381_a();
        imagePos = this.getLevel() == 1 ? 0.3125 : (this.getLevel() == 2 ? 0.375 : 0.4375);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(50.0, 18.0, 0.0).func_187315_a(0.9375, 0.0625 + imagePos).func_181675_d();
        renderer.func_181662_b(66.0, 18.0, 0.0).func_187315_a(1.0, 0.0625 + imagePos).func_181675_d();
        renderer.func_181662_b(66.0, 2.0, 0.0).func_187315_a(1.0, imagePos).func_181675_d();
        renderer.func_181662_b(50.0, 2.0, 0.0).func_187315_a(0.9375, imagePos).func_181675_d();
        tessellator.func_78381_a();
        if (this.getLevel() < 3) {
            renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            renderer.func_181662_b(67.0, 42.0, 0.0).func_187315_a(0.9375, 0.125).func_181675_d();
            renderer.func_181662_b(83.0, 42.0, 0.0).func_187315_a(1.0, 0.125).func_181675_d();
            renderer.func_181662_b(83.0, 26.0, 0.0).func_187315_a(1.0, 0.0625).func_181675_d();
            renderer.func_181662_b(67.0, 26.0, 0.0).func_187315_a(0.9375, 0.0625).func_181675_d();
            tessellator.func_78381_a();
        }
        if (this.getTPprogress() <= 0) {
            gui.func_73731_b(gui.func_175179_f(), this.getTeleports() + " (ID: " + (this.getID() + 1) + ")", 85, 10, 0xFFFFFF);
        }
        if ((health = this.func_110143_aJ() / this.func_110138_aP()) > 0.33f) {
            GlStateManager.func_179131_c((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)0.85f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glDisable((int)3553);
        int i = 0;
        while ((float)i < health * 8.0f) {
            renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            renderer.func_181662_b(19.0, (double)(39 - i * 5), 0.0).func_181675_d();
            renderer.func_181662_b(9.0, (double)(39 - i * 5), 0.0).func_181675_d();
            renderer.func_181662_b(9.0, (double)(43 - i * 5), 0.0).func_181675_d();
            renderer.func_181662_b(19.0, (double)(43 - i * 5), 0.0).func_181675_d();
            tessellator.func_78381_a();
            ++i;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.33f);
        if (this.getTPprogress() > 0) {
            renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            renderer.func_181662_b(85.0, 21.0, 0.0).func_181675_d();
            renderer.func_181662_b(140.0, 21.0, 0.0).func_181675_d();
            renderer.func_181662_b(140.0, 7.0, 0.0).func_181675_d();
            renderer.func_181662_b(85.0, 7.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
        }
        if (this.getLevel() < 3) {
            renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            renderer.func_181662_b(85.0, 41.0, 0.0).func_181675_d();
            renderer.func_181662_b(140.0, 41.0, 0.0).func_181675_d();
            renderer.func_181662_b(140.0, 27.0, 0.0).func_181675_d();
            renderer.func_181662_b(85.0, 27.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
        if (this.getTPprogress() > 0) {
            double tpProgress = (1.0 - (double)this.getTPprogress() / (double)(this.getLevel() == 1 ? 200 : (this.getLevel() == 2 ? 100 : 60))) * 55.0;
            renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            renderer.func_181662_b(85.0, 21.0, 0.0).func_181675_d();
            renderer.func_181662_b(85.0 + tpProgress, 21.0, 0.0).func_181675_d();
            renderer.func_181662_b(85.0 + tpProgress, 7.0, 0.0).func_181675_d();
            renderer.func_181662_b(85.0, 7.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
        }
        if (this.getLevel() < 3) {
            renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            renderer.func_181662_b(85.0, 41.0, 0.0).func_181675_d();
            renderer.func_181662_b(85.0 + (double)this.getProgress() * 0.275, 41.0, 0.0).func_181675_d();
            renderer.func_181662_b(85.0 + (double)this.getProgress() * 0.275, 27.0, 0.0).func_181675_d();
            renderer.func_181662_b(85.0, 27.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
        }
        GL11.glEnable((int)3553);
    }

    public static class TeleporterDim
    extends Teleporter {
        public BlockPos target;

        public TeleporterDim(WorldServer worldIn, BlockPos targetPos) {
            super(worldIn);
            this.target = targetPos;
        }

        public boolean func_85188_a(Entity entityIn) {
            return true;
        }

        public boolean func_180620_b(Entity entityIn, float rotationYaw) {
            if (entityIn instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entityIn).field_71135_a.func_147364_a((double)this.target.func_177958_n(), (double)this.target.func_177956_o(), (double)this.target.func_177952_p(), entityIn.field_70177_z, entityIn.field_70125_A);
            } else {
                entityIn.func_70012_b((double)this.target.func_177958_n(), (double)this.target.func_177956_o(), (double)this.target.func_177952_p(), entityIn.field_70177_z, entityIn.field_70125_A);
            }
            return true;
        }
    }

    public static class TeleporterData
    extends BlockPos {
        public final int dimension;
        public final int id;

        public TeleporterData(BlockPos blockPos, int id, int dimension) {
            super((Vec3i)blockPos);
            this.id = id;
            this.dimension = dimension;
        }
    }
}

