/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.building;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2EventsCommon;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.client.particle.EnumTF2Particles;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.ai.EntityAISentryAttack;
import rafradek.TF2weapons.entity.ai.EntityAISentryIdle;
import rafradek.TF2weapons.entity.ai.EntityAISpotTarget;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.building.SentryLookHelper;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.entity.projectile.EntityProjectileBase;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemPDA;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.util.Contract;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.ReflectionAccess;
import rafradek.TF2weapons.util.TF2DamageSource;
import rafradek.TF2weapons.util.TF2Util;

public class EntitySentry
extends EntityBuilding {
    public ItemStack sentryBullet = ItemFromData.getNewStack("sentrybullet");
    public ItemStack sentryHeat = ItemFromData.getNewStack("sentrybullet");
    public ItemStack sentryRocket = ItemFromData.getNewStack("sentryrocket");
    public float rotationDefault = 0.0f;
    public float attackDelay;
    public int attackDelayRocket;
    public boolean shootRocket;
    public boolean shootBullet;
    public int mercsKilled;
    public float attackRateMult = 1.0f;
    private static final DataParameter<Integer> AMMO = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ROCKET = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> KILLS = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CONTROLLED = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> TARGET = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> MINI = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> HEAT = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final AttributeModifier MINI_HEALTH_MODIFIER = new AttributeModifier(UUID.fromString("1184831d-b1dc-40c8-86e6-34fa8f5abada"), "minisentry", -6.0, 0);

    public EntitySentry(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 0.8f);
        try {
            ReflectionAccess.entityLookHelper.set(this, (Object)new SentryLookHelper(this));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void adjustSize() {
        if (this.getLevel() == 1) {
            this.field_70130_N = 0.8f;
            this.field_70131_O = 0.8f;
        } else if (this.getLevel() == 2) {
            this.field_70130_N = 1.0f;
            this.field_70131_O = 1.0f;
        } else if (this.getLevel() == 3) {
            this.field_70130_N = 1.0f;
            this.field_70131_O = 1.2f;
        }
        if (this.isMini()) {
            this.field_70130_N *= 0.65f;
            this.field_70131_O *= 0.65f;
        }
        this.field_70131_O -= 0.1f;
        this.func_70105_a(this.field_70130_N, this.field_70131_O + 0.1f);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.isControlled()) {
            amount *= 0.5f;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public SoundEvent getSoundNameForState(int state) {
        switch (state) {
            case 0: {
                return this.getLevel() == 1 ? TF2Sounds.MOB_SENTRY_SCAN_1 : (this.getLevel() == 2 ? TF2Sounds.MOB_SENTRY_SCAN_2 : TF2Sounds.MOB_SENTRY_SCAN_3);
            }
            case 3: {
                return TF2Sounds.MOB_SENTRY_EMPTY;
            }
        }
        return super.getSoundNameForState(state);
    }

    public void func_70624_b(EntityLivingBase target) {
        if (TF2Util.isOnSameTeam((Entity)this, (Entity)target)) {
            return;
        }
        if (target != this.func_70638_az() && target != null) {
            this.func_184185_a(TF2Sounds.MOB_SENTRY_SPOT, 1.5f, 1.0f);
        }
        super.func_70624_b(target);
    }

    @Override
    public void applyTasks() {
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAISpotTarget(this, EntityLivingBase.class, true, true, new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase target) {
                return ((EntitySentry.this.getAttackFlags() & 2) == 2 && EntitySentry.this.func_184753_b() != null && target instanceof EntityPlayer || target.func_96124_cp() != null || (EntitySentry.this.getAttackFlags() & 1) == 1 && (EntitySentry.this.func_70643_av() == target || EntitySentry.this.getOwner() != null && (EntitySentry.this.getOwner().func_70643_av() == target || EntitySentry.this.getOwner().func_110144_aD() == target)) || (EntitySentry.this.getAttackFlags() & 4) == 4 && TF2Util.isHostile(target) && EntitySentry.this.func_184753_b() != null || (EntitySentry.this.getAttackFlags() & 4) == 4 && target instanceof EntityLiving && TF2Util.isOnSameTeam((Entity)EntitySentry.this, (Entity)((EntityLiving)target).func_70638_az()) || (EntitySentry.this.getAttackFlags() & 8) == 8 && !(target instanceof EntityPlayer) && !TF2Util.isHostile(target) && EntitySentry.this.func_184753_b() != null) && !TF2Util.isOnSameTeam((Entity)EntitySentry.this, (Entity)target) && (!(target instanceof EntityTF2Character) || !TF2ConfigVars.naturalCheck.equals("Never") || !((EntityTF2Character)target).natural);
            }
        }, false, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISentryAttack(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISentryIdle(this));
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.getAttackFlags();
        }
        if (this.rotationDefault == 0.0f) {
            this.rotationDefault = this.field_70759_as;
        }
        if (this.attackDelay > 0.0f) {
            this.attackDelay -= 1.0f;
        }
        if (this.attackDelayRocket > 0) {
            --this.attackDelayRocket;
        }
        this.field_70158_ak = this.isControlled();
        if (this.isControlled() && !this.field_70170_p.field_72995_K) {
            Vec3d lookVec = this.getOwner().func_70040_Z().func_186678_a(200.0);
            List<RayTraceResult> trace = TF2Util.pierce(this.field_70170_p, (Entity)this.getOwner(), this.getOwner().field_70165_t, this.getOwner().field_70163_u + (double)this.getOwner().func_70047_e(), this.getOwner().field_70161_v, this.getOwner().field_70165_t + lookVec.field_72450_a, this.getOwner().field_70163_u + (double)this.getOwner().func_70047_e() + lookVec.field_72448_b, this.getOwner().field_70161_v + lookVec.field_72449_c, false, 0.02f, false);
            this.func_70671_ap().func_75650_a(trace.get((int)0).field_72307_f.field_72450_a, trace.get((int)0).field_72307_f.field_72448_b, trace.get((int)0).field_72307_f.field_72449_c, 30.0f, 75.0f);
        }
        if (!(this.func_70638_az() == null || this.func_70638_az().func_70089_S() && this.func_70685_l((Entity)this.func_70638_az()))) {
            this.func_70624_b(null);
        }
        super.func_70636_d();
    }

    public ItemStack func_184586_b(EnumHand hand) {
        return hand == EnumHand.MAIN_HAND ? this.sentryRocket : (this.isHeat() ? this.sentryHeat : this.sentryBullet);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AMMO, (Object)150);
        this.field_70180_af.func_187214_a(ROCKET, (Object)20);
        this.field_70180_af.func_187214_a(KILLS, (Object)0);
        this.field_70180_af.func_187214_a(TARGET, (Object)-1);
        this.field_70180_af.func_187214_a(CONTROLLED, (Object)false);
        this.field_70180_af.func_187214_a(MINI, (Object)false);
        this.field_70180_af.func_187214_a(HEAT, (Object)0);
    }

    public void shootRocket(EntityLivingBase owner) {
        while (this.getLevel() == 3 && this.getRocketAmmo() > 0 && this.attackDelayRocket <= 0 && this.consumeEnergy(this.getMinEnergy() * 10)) {
            this.attackDelayRocket += 60;
            if (this.isControlled()) {
                this.attackDelayRocket = (int)((float)this.attackDelayRocket * 0.75f);
            }
            try {
                this.func_184185_a(TF2Sounds.MOB_SENTRY_ROCKET, 1.5f, 1.0f);
                EntityProjectileBase proj = MapList.projectileClasses.get(ItemFromData.getData(this.sentryRocket).getString(PropertyType.PROJECTILE)).getConstructor(World.class).newInstance(this.field_70170_p);
                proj.initProjectile((EntityLivingBase)this, EnumHand.MAIN_HAND, this.sentryRocket);
                proj.shootingEntity = owner;
                proj.usedWeapon = this.sentryRocket;
                proj.sentry = this;
                this.field_70170_p.func_72838_d((Entity)proj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setRocketAmmo(this.getRocketAmmo() - 1);
        }
    }

    public void shootBullet(EntityLivingBase owner) {
        Vec3d attackPos;
        this.setSoundState(this.getAmmo() > 0 && this.energy.getEnergyStored() >= this.getMinEnergy() ? 2 : 3);
        Vec3d vec3d = attackPos = this.isControlled() ? new Vec3d(this.func_70671_ap().func_180423_e(), this.func_70671_ap().func_180422_f(), this.func_70671_ap().func_180421_g()) : this.func_70638_az().func_174824_e(1.0f).func_178788_d(this.func_174824_e(1.0f)).func_72432_b().func_186678_a(30.0).func_178787_e(this.func_174791_d());
        while (this.attackDelay <= 0.0f && this.getAmmo() > 0 && this.consumeEnergy(this.getMinEnergy())) {
            float cooldown;
            if (this.func_184753_b() != null && this.field_70173_aa % 10 == 0) {
                TF2Util.attractMobs((EntityLivingBase)this, this.field_70170_p);
            }
            float f = cooldown = this.getLevel() > 1 ? 2.5f : 5.0f;
            if (this.isMini()) {
                cooldown /= 1.5f;
            }
            if (this.isHeat()) {
                cooldown *= this.getLevel() > 1 ? 5.0f : 4.0f;
            }
            if (this.isControlled()) {
                cooldown /= 2.0f;
            }
            this.attackDelay += (cooldown *= this.attackRateMult);
            if (this.isHeat()) {
                this.func_184185_a(TF2Sounds.WEAPON_MACHINA, 2.0f, 1.0f);
            } else {
                this.func_184185_a(this.getLevel() == 1 ? TF2Sounds.MOB_SENTRY_SHOOT_1 : TF2Sounds.MOB_SENTRY_SHOOT_2, 1.5f, 1.0f);
            }
            float damage = 1.6f;
            if (this.isHeat()) {
                damage = 4.25f + (float)this.getHeat() * 1.25f;
                if (this.getLevel() > 1) {
                    damage *= 1.25f;
                }
            }
            if (this.isMini()) {
                damage *= 0.5f;
            }
            List<RayTraceResult> list = TF2Util.pierce(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, attackPos.field_72450_a, attackPos.field_72448_b, attackPos.field_72449_c, false, this.isHeat() ? 0.25f + (float)this.getHeat() * 0.2f : 0.01f, this.isHeat());
            for (RayTraceResult bullet : list) {
                float range;
                if (bullet == list.get(0)) {
                    if (!this.isHeat()) {
                        TF2Util.sendParticle(EnumTF2Particles.BULLET_TRACER, (Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, bullet.field_72307_f.field_72450_a, bullet.field_72307_f.field_72448_b, bullet.field_72307_f.field_72449_c, 1, 13, 0, 64);
                    } else {
                        TF2Util.sendParticle(EnumTF2Particles.BULLET_TRACER, (Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, bullet.field_72307_f.field_72450_a, bullet.field_72307_f.field_72448_b, bullet.field_72307_f.field_72449_c, 1, 0, TF2Util.getTeamColor((Entity)this), 1280);
                    }
                }
                if (bullet.field_72308_g == null) continue;
                DamageSource src = TF2Util.causeBulletDamage(this.func_184586_b(EnumHand.OFF_HAND), (Entity)owner, 0, (Entity)this).func_76349_b();
                if (this.fromPDA) {
                    ((TF2DamageSource)src).addAttackFlag(4);
                }
                range = (range = bullet.field_72308_g.func_70032_d((Entity)this)) >= (float)this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e() ? Math.max(0.5f, (float)this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e() / range) : 1.0f;
                if (!TF2Util.dealDamage(bullet.field_72308_g, this.field_70170_p, owner, this.func_184586_b(EnumHand.OFF_HAND), TF2Util.calculateCritPost(bullet.field_72308_g, null, 0, ItemStack.field_190927_a), range * damage, src)) continue;
                Vec3d dist = new Vec3d(bullet.field_72308_g.field_70165_t - this.field_70165_t, bullet.field_72308_g.field_70163_u - this.field_70163_u, bullet.field_72308_g.field_70161_v - this.field_70161_v).func_72432_b();
                dist = dist.func_186678_a(0.25 * (this.getLevel() > 1 ? 0.7 : 1.0));
                if (this.isMini()) {
                    dist = dist.func_186678_a(0.55);
                }
                if (this.isControlled()) {
                    dist = dist.func_186678_a(0.35);
                }
                if (this.isHeat()) {
                    dist = dist.func_186678_a((double)(1.5f + 1.5f * (float)this.getHeat()));
                }
                if (bullet.field_72308_g instanceof EntityTF2Character && ((EntityTF2Character)bullet.field_72308_g).isGiant()) {
                    dist = dist.func_186678_a(0.35);
                }
                if (bullet.field_72308_g instanceof EntityLivingBase) {
                    dist = dist.func_186678_a(1.0 - ((EntityLivingBase)bullet.field_72308_g).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e());
                }
                if (!(dist.func_189985_c() > 0.0)) continue;
                bullet.field_72308_g.func_70024_g(dist.field_72450_a, dist.field_72448_b, dist.field_72449_c);
                boolean bl = bullet.field_72308_g.field_70160_al = bullet.field_72308_g.field_70181_x > 0.05;
                if (bullet.field_72308_g instanceof EntityPlayerMP) {
                    TF2weapons.network.sendTo(new TF2Message.VelocityAddMessage(dist, bullet.field_72308_g.field_70160_al), (EntityPlayerMP)bullet.field_72308_g);
                }
                if (!(bullet.field_72308_g instanceof EntityLivingBase)) continue;
                ((EntityLivingBase)bullet.field_72308_g).func_130011_c((Entity)this);
                ((EntityLivingBase)bullet.field_72308_g).func_70604_c((EntityLivingBase)this);
                if (bullet.field_72308_g.func_70089_S()) continue;
                this.scoreKill((EntityLivingBase)bullet.field_72308_g);
            }
            this.setAmmo(this.getAmmo() - 1);
        }
    }

    public void scoreKill(EntityLivingBase target) {
        ItemStack stack;
        this.setKills(this.getKills() + 1);
        if (this.getOwner() instanceof EntityPlayer && target instanceof EntityTF2Character && !((EntityTF2Character)target).isRobot()) {
            if (++this.mercsKilled % 5 == 0) {
                ((TF2PlayerCapability)this.getOwner().getCapability(TF2weapons.PLAYER_CAP, null)).completeObjective(Contract.Objective.KILLS_SENTRY, this.func_184592_cb());
            }
            ((TF2PlayerCapability)this.getOwner().getCapability(TF2weapons.PLAYER_CAP, null)).completeObjective(Contract.Objective.KILL_W_SENTRY, this.func_184592_cb());
        }
        if (this.getOwner() instanceof EntityPlayer && TF2Util.isEnemy(this.getOwner(), target) && !(stack = TF2Util.getFirstItem((IInventory)((EntityPlayer)this.getOwner()).field_71071_by, (Predicate<ItemStack>)((Predicate)stackl -> stackl.func_77973_b() instanceof ItemPDA))).func_190926_b()) {
            if (!(target instanceof EntityPlayer)) {
                stack.func_77978_p().func_74768_a("Kills", stack.func_77978_p().func_74762_e("Kills") + 1);
            } else {
                stack.func_77978_p().func_74768_a("PlayerKills", stack.func_77978_p().func_74762_e("PlayerKills") + 1);
            }
            TF2EventsCommon.onStrangeUpdate(stack, this.getOwner());
        }
    }

    public boolean func_70685_l(Entity entityIn) {
        return this.field_70170_p.func_147447_a(new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v), new Vec3d(entityIn.field_70165_t, entityIn.field_70163_u + (double)entityIn.func_70047_e(), entityIn.field_70161_v), false, true, false) == null;
    }

    public int getMaxAmmo() {
        return this.getLevel() == 1 ? 150 : 200;
    }

    public int getAmmo() {
        return (Integer)this.field_70180_af.func_187225_a(AMMO);
    }

    public int getKills() {
        return (Integer)this.field_70180_af.func_187225_a(KILLS);
    }

    public int getRocketAmmo() {
        return (Integer)this.field_70180_af.func_187225_a(ROCKET);
    }

    public int getTargetInfo() {
        return ((Byte)this.field_70180_af.func_187225_a(TARGET)).byteValue();
    }

    public boolean isMini() {
        return (Boolean)this.field_70180_af.func_187225_a(MINI);
    }

    public boolean isHeat() {
        return this.getHeat() > 0;
    }

    public int getHeat() {
        return (Integer)this.field_70180_af.func_187225_a(HEAT);
    }

    public void setAmmo(int ammo) {
        this.field_70180_af.func_187227_b(AMMO, (Object)ammo);
    }

    public void setRocketAmmo(int ammo) {
        this.field_70180_af.func_187227_b(ROCKET, (Object)ammo);
    }

    public void setKills(int kills) {
        this.field_70180_af.func_187227_b(KILLS, (Object)kills);
    }

    public void setControlled(boolean control) {
        this.field_70180_af.func_187227_b(CONTROLLED, (Object)control);
    }

    public void setTargetInfo(int target) {
        this.field_70180_af.func_187227_b(TARGET, (Object)((byte)target));
    }

    public void setHeat(int heat) {
        this.field_70180_af.func_187227_b(HEAT, (Object)heat);
    }

    public void setMini(boolean mini) {
        this.field_70180_af.func_187227_b(MINI, (Object)mini);
        if (mini) {
            TF2Util.addModifierSafe((EntityLivingBase)this, SharedMonsterAttributes.field_111267_a, MINI_HEALTH_MODIFIER, true);
            this.adjustSize();
        }
        if (mini && this.isConstructing()) {
            this.func_70606_j(Math.max(this.func_110143_aJ(), this.func_110138_aP() * 0.5f));
        }
    }

    @Override
    public int getMaxLevel() {
        return this.isMini() ? 1 : 3;
    }

    public int getAttackFlags() {
        if (this.getTargetInfo() == -1) {
            this.setTargetInfo(this.getOwner() != null && this.getOwner() instanceof EntityPlayer ? WeaponsCapability.get((Entity)this.getOwner()).sentryTargets : 5);
        }
        return this.getTargetInfo();
    }

    @Override
    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("Ammo", (short)this.getAmmo());
        par1NBTTagCompound.func_74777_a("RocketAmmo", (short)this.getRocketAmmo());
        par1NBTTagCompound.func_74777_a("Kills", (short)this.getKills());
        par1NBTTagCompound.func_74777_a("MercKills", (short)this.mercsKilled);
        par1NBTTagCompound.func_74777_a("AttackFlags", (short)this.getTargetInfo());
        par1NBTTagCompound.func_74757_a("Mini", this.isMini());
        par1NBTTagCompound.func_74776_a("AttackRateMult", this.attackRateMult);
    }

    @Override
    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setMini(par1NBTTagCompound.func_74767_n("Mini"));
        this.setAmmo(par1NBTTagCompound.func_74765_d("Ammo"));
        this.setRocketAmmo(par1NBTTagCompound.func_74765_d("RocketAmmo"));
        this.setKills(par1NBTTagCompound.func_74765_d("Kills"));
        this.mercsKilled = par1NBTTagCompound.func_74765_d("MercKills");
        this.setTargetInfo(par1NBTTagCompound.func_74765_d("AttackFlags"));
        this.attackRateMult = par1NBTTagCompound.func_74760_g("AttackRateMult");
    }

    @Override
    public float getCollHeight() {
        return 1.2f;
    }

    @Override
    public float getCollWidth() {
        return 1.12f;
    }

    public float func_70047_e() {
        return this.field_70131_O / 2.0f + 0.2f;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return this.isSapped() ? null : TF2Sounds.MOB_SENTRY_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TF2Sounds.MOB_SENTRY_DEATH;
    }

    @Override
    public boolean canUseWrench() {
        return super.canUseWrench() || this.getAmmo() < this.getMaxAmmo() || this.getRocketAmmo() < 20;
    }

    @Override
    public void upgrade() {
        super.upgrade();
        this.setAmmo(200);
    }

    @Override
    public int getMinEnergy() {
        return this.func_184753_b() != null ? TF2ConfigVars.sentryUseEnergy : 0;
    }

    @Override
    public boolean shouldUseBlocks() {
        return TF2ConfigVars.sentryUseEnergy >= 0 && super.shouldUseBlocks();
    }

    public boolean isControlled() {
        return this.func_70089_S() && (Boolean)this.field_70180_af.func_187225_a(CONTROLLED) != false;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player == this.getOwner() && hand == EnumHand.MAIN_HAND) {
            if (!this.field_70170_p.field_72995_K) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)TF2weapons.instance, (int)5, (World)this.field_70170_p, (int)this.func_145782_y(), (int)0, (int)0);
            }
            return true;
        }
        return true;
    }

    @Override
    public int getBuildingID() {
        return 0;
    }

    @Override
    public void func_70645_a(DamageSource s) {
        super.func_70645_a(s);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderGUI(BufferBuilder renderer, Tessellator tessellator, EntityPlayer player, int width, int height, GuiIngame gui) {
        ClientProxy.setColor(TF2Util.getTeamColor((Entity)this), 0.7f, 0.0f, 0.25f, 0.8f);
        gui.func_73729_b(20, 2, 0, 112, 124, 60);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
        gui.func_73729_b(0, 0, 0, 48, 144, 64);
        double imagePos = this.getLevel() == 1 ? 0.375 : (this.getLevel() == 2 ? 0.1875 : 0.0);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(19.0, 56.0, 0.0).func_187315_a(0.75, imagePos + 0.1875).func_181675_d();
        renderer.func_181662_b(67.0, 56.0, 0.0).func_187315_a(0.9375, imagePos + 0.1875).func_181675_d();
        renderer.func_181662_b(67.0, 8.0, 0.0).func_187315_a(0.9375, imagePos).func_181675_d();
        renderer.func_181662_b(19.0, 8.0, 0.0).func_187315_a(0.75, imagePos).func_181675_d();
        tessellator.func_78381_a();
        if (!this.func_70089_S()) {
            return;
        }
        imagePos = this.getLevel() == 3 ? 0.0 : 0.0625;
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(67.0, 57.0, 0.0).func_187315_a(0.9375, 0.0625 + imagePos).func_181675_d();
        renderer.func_181662_b(83.0, 57.0, 0.0).func_187315_a(1.0, 0.0625 + imagePos).func_181675_d();
        renderer.func_181662_b(83.0, 41.0, 0.0).func_187315_a(1.0, imagePos).func_181675_d();
        renderer.func_181662_b(67.0, 41.0, 0.0).func_187315_a(0.9375, imagePos).func_181675_d();
        tessellator.func_78381_a();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(67.0, 21.0, 0.0).func_187315_a(0.9375, 0.25).func_181675_d();
        renderer.func_181662_b(83.0, 21.0, 0.0).func_187315_a(1.0, 0.25).func_181675_d();
        renderer.func_181662_b(83.0, 5.0, 0.0).func_187315_a(1.0, 0.1875).func_181675_d();
        renderer.func_181662_b(67.0, 5.0, 0.0).func_187315_a(0.9375, 0.1875).func_181675_d();
        tessellator.func_78381_a();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(67.0, 39.0, 0.0).func_187315_a(0.9375, 0.1875).func_181675_d();
        renderer.func_181662_b(83.0, 39.0, 0.0).func_187315_a(1.0, 0.1875).func_181675_d();
        renderer.func_181662_b(83.0, 23.0, 0.0).func_187315_a(1.0, 0.125).func_181675_d();
        renderer.func_181662_b(67.0, 23.0, 0.0).func_187315_a(0.9375, 0.125).func_181675_d();
        tessellator.func_78381_a();
        imagePos = this.getLevel() == 1 ? 0.3125 : (this.getLevel() == 2 ? 0.375 : 0.4375);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(50.0, 18.0, 0.0).func_187315_a(0.9375, 0.0625 + imagePos).func_181675_d();
        renderer.func_181662_b(66.0, 18.0, 0.0).func_187315_a(1.0, 0.0625 + imagePos).func_181675_d();
        renderer.func_181662_b(66.0, 2.0, 0.0).func_187315_a(1.0, imagePos).func_181675_d();
        renderer.func_181662_b(50.0, 2.0, 0.0).func_187315_a(0.9375, imagePos).func_181675_d();
        tessellator.func_78381_a();
        gui.func_73731_b(gui.func_175179_f(), Integer.toString(this.getKills()), 85, 9, 0xFFFFFF);
        float health = this.func_110143_aJ() / this.func_110138_aP();
        if (health > 0.33f) {
            GlStateManager.func_179131_c((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)0.85f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glDisable((int)3553);
        int i = 0;
        while ((float)i < health * 11.0f) {
            renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            renderer.func_181662_b(19.0, (double)(55 - i * 5), 0.0).func_181675_d();
            renderer.func_181662_b(9.0, (double)(55 - i * 5), 0.0).func_181675_d();
            renderer.func_181662_b(9.0, (double)(59 - i * 5), 0.0).func_181675_d();
            renderer.func_181662_b(19.0, (double)(59 - i * 5), 0.0).func_181675_d();
            tessellator.func_78381_a();
            ++i;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.33f);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        renderer.func_181662_b(85.0, 38.0, 0.0).func_181675_d();
        renderer.func_181662_b(140.0, 38.0, 0.0).func_181675_d();
        renderer.func_181662_b(140.0, 24.0, 0.0).func_181675_d();
        renderer.func_181662_b(85.0, 24.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        renderer.func_181662_b(85.0, 56.0, 0.0).func_181675_d();
        renderer.func_181662_b(140.0, 56.0, 0.0).func_181675_d();
        renderer.func_181662_b(140.0, 42.0, 0.0).func_181675_d();
        renderer.func_181662_b(85.0, 42.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        renderer.func_181662_b(85.0, 38.0, 0.0).func_181675_d();
        renderer.func_181662_b(85.0 + (double)this.getAmmo() / (double)this.getMaxAmmo() * 55.0, 38.0, 0.0).func_181675_d();
        renderer.func_181662_b(85.0 + (double)this.getAmmo() / (double)this.getMaxAmmo() * 55.0, 24.0, 0.0).func_181675_d();
        renderer.func_181662_b(85.0, 24.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        double xOffset = this.getLevel() < 3 ? (double)this.getProgress() * 0.275 : (double)this.getRocketAmmo() * 2.75;
        renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        renderer.func_181662_b(85.0, 56.0, 0.0).func_181675_d();
        renderer.func_181662_b(85.0 + xOffset, 56.0, 0.0).func_181675_d();
        renderer.func_181662_b(85.0 + xOffset, 42.0, 0.0).func_181675_d();
        renderer.func_181662_b(85.0, 42.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
    }

    @Override
    public int getGuiHeight() {
        return 64;
    }

    @Override
    public int getConstructionTime() {
        return this.isMini() ? 4200 : 10500;
    }
}

