/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.building;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.FoodStats;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.lwjgl.opengl.GL11;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.mercenary.EntityEngineer;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemCloak;
import rafradek.TF2weapons.item.ItemDisguiseKit;
import rafradek.TF2weapons.util.TF2Util;

public class EntityDispenser
extends EntityBuilding {
    public int reloadTimer;
    public int giveAmmoTimer;
    public List<EntityLivingBase> dispenserTarget = new ArrayList<EntityLivingBase>();
    private static final DataParameter<Integer> METAL = EntityDataManager.func_187226_a(EntityDispenser.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> RANGE = EntityDataManager.func_187226_a(EntityDispenser.class, (DataSerializer)DataSerializers.field_187193_c);
    public ItemStackHandler items = new ItemStackHandler(9);
    public HashMap<ItemStack, Float> fillMeter = new HashMap();
    public int food;
    private ItemStack currRepairItem;
    public static final int MAX_METAL = 400;

    public EntityDispenser(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.1f);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isDisabled()) {
            this.dispenserTarget.clear();
            return;
        }
        List targetList = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b((double)(2.0f * this.getRange()), 1.5 * (double)this.getRange(), (double)(2.0f * this.getRange())), (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase input) {
                return !(input instanceof EntityBuilding) && EntityDispenser.this != input && (EntityDispenser.this.getOwner() != null && WeaponsCapability.get((Entity)EntityDispenser.this.getOwner()).dispenserPlayer && input instanceof EntityPlayer && input.func_96124_cp() == null || TF2Util.isOnSameTeam((Entity)EntityDispenser.this, (Entity)input));
            }
        });
        if (!this.field_70170_p.field_72995_K) {
            ItemStack foodItem;
            --this.reloadTimer;
            if (this.reloadTimer <= 0 && this.getMetal() < 400) {
                int metalAmount = TF2ConfigVars.fastMetalProduction ? 30 : 21;
                metalAmount = Math.min(400 - this.getMetal(), metalAmount + this.getLevel() * (metalAmount / 3));
                if (this.consumeEnergy(metalAmount * this.getMinEnergy())) {
                    this.setMetal(this.getMetal() + metalAmount);
                    this.func_184185_a(TF2Sounds.MOB_DISPENSER_GENERATE_METAL, 1.55f, 1.0f);
                    this.reloadTimer = TF2ConfigVars.fastMetalProduction ? 100 : 200;
                }
            }
            --this.giveAmmoTimer;
            if (this.food <= 8 && this.giveAmmoTimer == 0 && !(foodItem = TF2Util.getFirstItem((IItemHandler)this.items, (Predicate<ItemStack>)((Predicate)stack -> stack.func_77973_b() instanceof ItemFood))).func_190926_b()) {
                this.food += ((ItemFood)foodItem.func_77973_b()).func_150905_g(foodItem);
                foodItem.func_190918_g(1);
            }
            for (EntityLivingBase living : targetList) {
                Tuple cloak;
                int level = this.getLevel();
                if (living.func_110143_aJ() < living.func_110138_aP() && this.consumeEnergy(this.getMinEnergy())) {
                    living.func_70691_i(0.025f + 0.025f * (float)level);
                }
                if (this.giveAmmoTimer == 0) {
                    Predicate test;
                    ItemStack heldItem;
                    if (living instanceof EntityPlayer) {
                        FoodStats stats = ((EntityPlayer)living).func_71024_bL();
                        if (stats.func_75116_a() >= 20) {
                            stats.func_75122_a(1, living.func_110143_aJ() >= living.func_110138_aP() ? 8.0f : 1.0f);
                        } else {
                            int foodAmount = (int)(living.func_110143_aJ() / living.func_110138_aP() * 8.0f);
                            if (this.food > 0) {
                                stats.func_75122_a(Math.min(foodAmount, this.food), 1.0f);
                                this.food -= Math.min(foodAmount, this.food);
                            }
                        }
                    }
                    if (living instanceof EntityEngineer || living instanceof EntityPlayer) {
                        int metal = ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).getMetal();
                        int metalUse = Math.min(30 + this.getLevel() * 10, Math.min(WeaponsCapability.get((Entity)living).getMaxMetal() - metal, this.getMetal()));
                        this.setMetal(this.getMetal() - metalUse);
                        ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).setMetal(metal + metalUse);
                    }
                    if (living instanceof EntityTF2Character) {
                        ((EntityTF2Character)living).restoreAmmo(0.1f + (float)this.getLevel() * 0.1f);
                    }
                    if ((heldItem = TF2Util.getFirstItem((IItemHandler)this.items, (Predicate<ItemStack>)(test = stack -> !stack.func_190926_b() && (stack.func_77973_b().isRepairable() || stack.func_77984_f() && !TF2ConfigVars.oldDispenser) && stack.func_77952_i() != 0 && !TF2ConfigVars.repairBlacklist.contains(stack.func_77973_b().getRegistryName())))).func_190926_b() && test.apply((Object)living.func_184614_ca())) {
                        heldItem = living.func_184614_ca();
                    }
                    if (!heldItem.func_190926_b()) {
                        float repairMult = TF2ConfigVars.dispenserRepair;
                        NBTTagList list = heldItem.func_77986_q();
                        float enchantCost = 1.0f;
                        if (list != null) {
                            for (int i = 0; i < list.func_74745_c(); ++i) {
                                enchantCost -= (float)list.func_150305_b(i).func_74765_d("lvl") / 15.0f;
                            }
                            if (enchantCost <= 0.33333334f) {
                                enchantCost = 0.33333334f;
                            }
                        }
                        int metalUse = Math.min(15 + this.getLevel() * 10, Math.min((int)((float)heldItem.func_77952_i() / (repairMult *= enchantCost)) + 1, this.getMetal()));
                        int repairUses = this.getRepairMaterialUses(heldItem, Math.min(heldItem.func_77952_i(), (int)((float)metalUse * repairMult)), 1.0f / enchantCost);
                        if (repairUses != 0 && this.consumeEnergy(metalUse * this.getMinEnergy())) {
                            this.setMetal(this.getMetal() - metalUse);
                            heldItem.func_77964_b(heldItem.func_77952_i() - repairUses);
                            if (living instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)living).func_71113_k();
                            }
                        }
                    }
                }
                if (!((ItemStack)(cloak = ItemCloak.searchForWatches(living)).func_76340_b()).func_190926_b() || !living.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && living.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemCloak) {
                    if (((ItemStack)cloak.func_76340_b()).func_190926_b()) {
                        cloak = new Tuple((Object)-1, (Object)living.func_184614_ca());
                    }
                    if (TF2Attribute.getModifier("No External Cloak", (ItemStack)cloak.func_76340_b(), 0.0f, living) == 0.0f) {
                        ((ItemStack)cloak.func_76340_b()).func_77964_b(Math.max(((ItemStack)cloak.func_76340_b()).func_77952_i() - (2 + this.getLevel()), 0));
                        if (living instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)living).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(-2, ((Integer)cloak.func_76341_a()).intValue(), (ItemStack)cloak.func_76340_b()));
                        }
                    }
                }
                if (this.dispenserTarget == null || this.dispenserTarget.contains(living)) continue;
                this.func_184185_a(TF2Sounds.MOB_DISPENSER_HEAL, 0.75f, 1.0f);
            }
            if (this.giveAmmoTimer <= 0) {
                this.giveAmmoTimer = 20;
            }
        }
        this.dispenserTarget = targetList;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player == this.getOwner() && hand == EnumHand.MAIN_HAND) {
            if (!this.field_70170_p.field_72995_K) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)TF2weapons.instance, (int)5, (World)this.field_70170_p, (int)this.func_145782_y(), (int)0, (int)0);
            }
            return true;
        }
        return true;
    }

    @Override
    public SoundEvent getSoundNameForState(int state) {
        switch (state) {
            case 0: {
                return TF2Sounds.MOB_DISPENSER_IDLE;
            }
        }
        return super.getSoundNameForState(state);
    }

    public int getRepairMaterialUses(ItemStack tool, int maxRepair, float matCostMult) {
        if (TF2ConfigVars.oldDispenser) {
            return maxRepair;
        }
        Iterator<Map.Entry<ItemStack, Float>> it = this.fillMeter.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ItemStack, Float> uses = it.next();
            if (!tool.func_77973_b().func_82789_a(tool, uses.getKey())) continue;
            this.currRepairItem = uses.getKey();
            float materialCost = this.getMaterialCost(tool) * matCostMult;
            float use = (float)maxRepair / (float)tool.func_77958_k() * materialCost;
            float maxUse = Math.min(uses.getValue().floatValue(), use);
            uses.setValue(Float.valueOf(uses.getValue().floatValue() - maxUse));
            if (uses.getValue().floatValue() == 0.0f) {
                it.remove();
            }
            return (int)(maxUse * ((float)tool.func_77958_k() / materialCost));
        }
        for (int i = 0; i < this.items.getSlots(); ++i) {
            if (!tool.func_77973_b().func_82789_a(tool, this.items.getStackInSlot(i))) continue;
            this.currRepairItem = this.items.getStackInSlot(i);
            this.items.extractItem(i, 1, false);
            float materialCost = this.getMaterialCost(tool) * matCostMult;
            float use = (float)maxRepair / (float)tool.func_77958_k() * materialCost;
            float maxUse = Math.min(1.0f, use);
            this.fillMeter.put(ItemHandlerHelper.copyStackWithSize((ItemStack)this.currRepairItem, (int)1), Float.valueOf(1.0f - maxUse));
            return (int)(maxUse * ((float)tool.func_77958_k() / materialCost));
        }
        return 0;
    }

    public float getMaterialCost(ItemStack stack) {
        float cost = 0.0f;
        for (IRecipe recipe : ForgeRegistries.RECIPES.getValues()) {
            if (!recipe.func_77571_b().func_185136_b(stack) || !TF2Util.isBaseSame(recipe.func_77571_b().func_77978_p(), stack.func_77978_p())) continue;
            for (Ingredient ing : recipe.func_192400_c()) {
                if (!ing.apply(this.currRepairItem)) continue;
                cost += 1.0f;
            }
            if (cost == 0.0f) continue;
            break;
        }
        if (cost == 0.0f) {
            if (stack.func_77973_b() instanceof ItemPickaxe || stack.func_77973_b() instanceof ItemAxe) {
                cost = 3.0f;
            } else if (stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemHoe || stack.func_77973_b() instanceof ItemShears) {
                cost = 2.0f;
            } else if (stack.func_77973_b() instanceof ItemSpade) {
                cost = 1.0f;
            } else if (stack.func_77973_b() instanceof ItemArmor) {
                switch (((ItemArmor)stack.func_77973_b()).field_77881_a) {
                    case CHEST: {
                        cost = 8.0f;
                        break;
                    }
                    case FEET: {
                        cost = 4.0f;
                        break;
                    }
                    case HEAD: {
                        cost = 5.0f;
                        break;
                    }
                    case LEGS: {
                        cost = 7.0f;
                        break;
                    }
                }
            } else {
                cost = stack.func_77973_b() instanceof ItemDisguiseKit ? 1.0f : 4.0f;
            }
        }
        cost = stack.func_77973_b() instanceof ItemArmor ? (cost /= 4.5f) : (cost /= 3.0f);
        return cost;
    }

    public static boolean isNearDispenser(World world, final EntityLivingBase living) {
        List targetList = world.func_175647_a(EntityDispenser.class, living.func_174813_aQ().func_72314_b(8.0, 6.0, 8.0), (Predicate)new Predicate<EntityDispenser>(){

            public boolean apply(EntityDispenser input) {
                return !input.isDisabled() && input.dispenserTarget != null && input.dispenserTarget.contains(living);
            }
        });
        return !targetList.isEmpty();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(METAL, (Object)0);
        this.field_70180_af.func_187214_a(RANGE, (Object)Float.valueOf(1.0f));
    }

    public int getMetal() {
        return (Integer)this.field_70180_af.func_187225_a(METAL);
    }

    public void setMetal(int amount) {
        this.field_70180_af.func_187227_b(METAL, (Object)amount);
    }

    public float getRange() {
        return ((Float)this.field_70180_af.func_187225_a(RANGE)).floatValue();
    }

    public void setRange(float range) {
        this.field_70180_af.func_187227_b(RANGE, (Object)Float.valueOf(range));
    }

    @Override
    public void upgrade() {
        super.upgrade();
        this.setMetal(this.getMetal() + 25);
    }

    @Override
    public int getMinEnergy() {
        return this.func_184753_b() != null ? TF2ConfigVars.dispenserUseEnergy : 0;
    }

    public boolean isItemStackAccepted(ItemStack stack) {
        return stack.func_77984_f();
    }

    @Override
    public void drawFromBlock(BlockPos pos, TileEntity ent, EnumFacing facing) {
        block4: {
            super.drawFromBlock(pos, ent, facing);
            EnumFacing front = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)this);
            if (!ent.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) break block4;
            IItemHandler handler = (IItemHandler)ent.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            if (front == facing || front == facing.func_176734_d()) {
                for (int i = 0; i < this.items.getSlots(); ++i) {
                    if (!this.items.getStackInSlot(i).func_77984_f() || this.items.getStackInSlot(i).func_77952_i() != 0) continue;
                    this.items.insertItem(i, ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)this.items.extractItem(i, 1, false), (boolean)false), false);
                }
            } else {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    handler.insertItem(i, ItemHandlerHelper.insertItem((IItemHandler)this.items, (ItemStack)handler.extractItem(i, 1, false), (boolean)false), false);
                }
            }
        }
    }

    @Override
    public boolean shouldUseBlocks() {
        return true;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return TF2Sounds.MOB_DISPENSER_DEATH;
    }

    @Override
    public int getIronDrop() {
        return 0 + this.getLevel();
    }

    @Override
    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)this.items.serializeNBT());
        par1NBTTagCompound.func_74777_a("Metal", (short)this.getMetal());
        par1NBTTagCompound.func_74777_a("Food", (short)this.food);
        NBTTagList fill = new NBTTagList();
        for (Map.Entry<ItemStack, Float> entry : this.fillMeter.entrySet()) {
            NBTTagCompound values = new NBTTagCompound();
            values.func_74782_a("Item", (NBTBase)entry.getKey().serializeNBT());
            values.func_74776_a("Fill", entry.getValue().floatValue());
            fill.func_74742_a((NBTBase)values);
        }
        par1NBTTagCompound.func_74782_a("Fill", (NBTBase)fill);
        par1NBTTagCompound.func_74776_a("Range", this.getRange());
    }

    @Override
    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.items.deserializeNBT(par1NBTTagCompound.func_74775_l("Items"));
        this.setMetal(par1NBTTagCompound.func_74765_d("Metal"));
        this.food = par1NBTTagCompound.func_74765_d("Food");
        this.setRange(par1NBTTagCompound.func_74765_d("Range"));
        NBTTagList fill = par1NBTTagCompound.func_150295_c("Fill", 10);
        for (int i = 0; i < fill.func_74745_c(); ++i) {
            NBTTagCompound values = (NBTTagCompound)fill.func_179238_g(i);
            this.fillMeter.put(new ItemStack(values.func_74775_l("Item")), Float.valueOf(values.func_74760_g("Fill")));
        }
    }

    @Override
    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        for (int i = 0; i < this.items.getSlots(); ++i) {
            this.func_70099_a(this.items.getStackInSlot(i), 0.0f);
        }
    }

    @Override
    public int getBuildingID() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderGUI(BufferBuilder renderer, Tessellator tessellator, EntityPlayer player, int width, int height, GuiIngame gui) {
        float health;
        ClientProxy.setColor(TF2Util.getTeamColor((Entity)this), 0.7f, 0.0f, 0.25f, 0.8f);
        gui.func_73729_b(20, 2, 0, 112, 124, 44);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
        gui.func_73729_b(0, 0, 0, 0, 144, 48);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(19.0, 48.0, 0.0).func_187315_a(0.75, 0.75).func_181675_d();
        renderer.func_181662_b(65.0, 48.0, 0.0).func_187315_a(0.9375, 0.75).func_181675_d();
        renderer.func_181662_b(65.0, 0.0, 0.0).func_187315_a(0.9375, 0.5625).func_181675_d();
        renderer.func_181662_b(19.0, 0.0, 0.0).func_187315_a(0.75, 0.5625).func_181675_d();
        tessellator.func_78381_a();
        if (!this.func_70089_S()) {
            return;
        }
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(67.0, 22.0, 0.0).func_187315_a(0.9375, 0.1875).func_181675_d();
        renderer.func_181662_b(83.0, 22.0, 0.0).func_187315_a(1.0, 0.1875).func_181675_d();
        renderer.func_181662_b(83.0, 6.0, 0.0).func_187315_a(1.0, 0.125).func_181675_d();
        renderer.func_181662_b(67.0, 6.0, 0.0).func_187315_a(0.9375, 0.125).func_181675_d();
        tessellator.func_78381_a();
        double imagePos = this.getLevel() == 1 ? 0.3125 : (this.getLevel() == 2 ? 0.375 : 0.4375);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b(50.0, 18.0, 0.0).func_187315_a(0.9375, 0.0625 + imagePos).func_181675_d();
        renderer.func_181662_b(66.0, 18.0, 0.0).func_187315_a(1.0, 0.0625 + imagePos).func_181675_d();
        renderer.func_181662_b(66.0, 2.0, 0.0).func_187315_a(1.0, imagePos).func_181675_d();
        renderer.func_181662_b(50.0, 2.0, 0.0).func_187315_a(0.9375, imagePos).func_181675_d();
        tessellator.func_78381_a();
        if (this.getLevel() < 3) {
            renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            renderer.func_181662_b(67.0, 42.0, 0.0).func_187315_a(0.9375, 0.125).func_181675_d();
            renderer.func_181662_b(83.0, 42.0, 0.0).func_187315_a(1.0, 0.125).func_181675_d();
            renderer.func_181662_b(83.0, 26.0, 0.0).func_187315_a(1.0, 0.0625).func_181675_d();
            renderer.func_181662_b(67.0, 26.0, 0.0).func_187315_a(0.9375, 0.0625).func_181675_d();
            tessellator.func_78381_a();
        }
        if ((health = this.func_110143_aJ() / this.func_110138_aP()) > 0.33f) {
            GlStateManager.func_179131_c((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)0.85f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glDisable((int)3553);
        int i = 0;
        while ((float)i < health * 8.0f) {
            renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            renderer.func_181662_b(19.0, (double)(39 - i * 5), 0.0).func_181675_d();
            renderer.func_181662_b(9.0, (double)(39 - i * 5), 0.0).func_181675_d();
            renderer.func_181662_b(9.0, (double)(43 - i * 5), 0.0).func_181675_d();
            renderer.func_181662_b(19.0, (double)(43 - i * 5), 0.0).func_181675_d();
            tessellator.func_78381_a();
            ++i;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.33f);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        renderer.func_181662_b(85.0, 21.0, 0.0).func_181675_d();
        renderer.func_181662_b(140.0, 21.0, 0.0).func_181675_d();
        renderer.func_181662_b(140.0, 7.0, 0.0).func_181675_d();
        renderer.func_181662_b(85.0, 7.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        if (this.getLevel() < 3) {
            renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            renderer.func_181662_b(85.0, 41.0, 0.0).func_181675_d();
            renderer.func_181662_b(140.0, 41.0, 0.0).func_181675_d();
            renderer.func_181662_b(140.0, 27.0, 0.0).func_181675_d();
            renderer.func_181662_b(85.0, 27.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        renderer.func_181662_b(85.0, 21.0, 0.0).func_181675_d();
        renderer.func_181662_b(85.0 + (double)this.getMetal() * 0.1375, 21.0, 0.0).func_181675_d();
        renderer.func_181662_b(85.0 + (double)this.getMetal() * 0.1375, 7.0, 0.0).func_181675_d();
        renderer.func_181662_b(85.0, 7.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        if (this.getLevel() < 3) {
            renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            renderer.func_181662_b(85.0, 41.0, 0.0).func_181675_d();
            renderer.func_181662_b(85.0 + (double)this.getProgress() * 0.275, 41.0, 0.0).func_181675_d();
            renderer.func_181662_b(85.0 + (double)this.getProgress() * 0.275, 27.0, 0.0).func_181675_d();
            renderer.func_181662_b(85.0, 27.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
        }
        GL11.glEnable((int)3553);
    }
}

