/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.building;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Team;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.client.audio.BuildingSound;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.IEntityTF2;
import rafradek.TF2weapons.entity.building.EntityDispenser;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.entity.mercenary.EntityEngineer;
import rafradek.TF2weapons.item.ItemPDA;
import rafradek.TF2weapons.item.ItemSapper;
import rafradek.TF2weapons.util.PlayerPersistStorage;
import rafradek.TF2weapons.util.TF2Util;

public class EntityBuilding
extends EntityLiving
implements IEntityOwnable,
IEntityTF2 {
    private static final DataParameter<Byte> VIS_TEAM = EntityDataManager.func_187226_a(EntityBuilding.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> LEVEL = EntityDataManager.func_187226_a(EntityBuilding.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> SOUND_STATE = EntityDataManager.func_187226_a(EntityBuilding.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> PROGRESS = EntityDataManager.func_187226_a(EntityBuilding.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CONSTRUCTING = EntityDataManager.func_187226_a(EntityBuilding.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ENERGY = EntityDataManager.func_187226_a(EntityBuilding.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> SAPPED = EntityDataManager.func_187226_a(EntityBuilding.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<UUID>> OWNER_UUID = EntityDataManager.func_187226_a(EntityBuilding.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final UUID UPGRADE_HEALTH_UUID = UUID.fromString("1184831d-b1dc-40c8-86e6-34fa8f30bada");
    public static final DamageSource DETONATE = new DamageSource("detonate").func_76348_h().func_151518_m();
    public static final int SENTRY_COST = 130;
    public static final int DISPENSER_COST = 100;
    public static final int TELEPORTER_COST = 50;
    public static final int SENTRY_MINI_COST = 100;
    public static final int SENTRY_DISPOSABLE_COST = 60;
    public EntityLivingBase owner;
    public BuildingSound buildingSound;
    public int wrenchBonusTime;
    public float wrenchBonusMult;
    public ItemStack sapper = ItemStack.field_190927_a;
    public EntityLivingBase sapperOwner;
    public boolean playerOwner;
    public boolean redeploy;
    public String ownerName;
    public EnergyStorage energy;
    public int ticksNoOwner;
    private boolean engMade;
    public ItemStackHandler charge;
    public boolean fromPDA;
    private int disposableID = -1;
    public UUID ownerEntityID;

    public EntityBuilding(World worldIn) {
        super(worldIn);
        this.applyTasks();
        this.func_70606_j(0.1f);
        this.energy = new EnergyStorage(40000);
        this.charge = new ItemStackHandler(1);
        this.adjustSize();
    }

    public void applyTasks() {
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn.func_174813_aQ().func_72326_a(this.func_70046_E())) {
            super.func_70108_f(entityIn);
        }
    }

    public int getMaxLevel() {
        return 3;
    }

    public void func_184206_a(DataParameter<?> key) {
        this.adjustSize();
        if (!this.field_70170_p.field_72995_K && CONSTRUCTING.equals(key)) {
            this.setSoundState((Integer)this.field_70180_af.func_187225_a(CONSTRUCTING) >= this.getConstructionTime() ? 0 : 25);
        }
        if (this.field_70170_p.field_72995_K && SOUND_STATE.equals(key)) {
            SoundEvent sound = this.getSoundNameForState(this.getSoundState());
            if (sound != null) {
                if (this.buildingSound != null) {
                    this.buildingSound.stopPlaying();
                }
                this.buildingSound = new BuildingSound(this, sound, this.getSoundState());
                ClientProxy.playBuildingSound(this.buildingSound);
            } else if (this.buildingSound != null) {
                this.buildingSound.stopPlaying();
            }
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && player == this.getOwner() && hand == EnumHand.MAIN_HAND) {
            this.grab();
            return true;
        }
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack stack = new ItemStack(TF2weapons.itemBuildingBox, 1, (this instanceof EntitySentry ? 18 : (this instanceof EntityDispenser ? 20 : 22)) + this.getEntTeam());
        return stack;
    }

    public void grab() {
        if (!this.isDisabled() && this.disposableID == -1) {
            if (this.owner instanceof EntityEngineer) {
                NBTTagCompound tag = new NBTTagCompound();
                this.func_70014_b(tag);
                ((EntityEngineer)this.owner).grabbed = tag;
                ((EntityEngineer)this.owner).grabbedid = this.getBuildingID();
                ((EntityEngineer)this.owner).loadout.getStackInSlot(3).func_77978_p().func_74774_a("Building", (byte)(this.getBuildingID() + 1));
                ((EntityEngineer)this.owner).switchSlot(3);
            } else if (this.fromPDA) {
                int slotpda = TF2Util.getFirstItemSlot((IInventory)((EntityPlayer)this.getOwner()).field_71071_by, (Predicate<ItemStack>)((Predicate)stack -> stack.func_77973_b() instanceof ItemPDA));
                if (slotpda != -1) {
                    NBTTagCompound tag = new NBTTagCompound();
                    this.func_70014_b(tag);
                    TF2PlayerCapability.get((EntityPlayer)((EntityPlayer)this.getOwner())).carrying = tag;
                    TF2PlayerCapability.get((EntityPlayer)((EntityPlayer)this.getOwner())).carryingType = this.getBuildingID();
                    this.clearReferences();
                }
            } else {
                ItemStack stack2 = this.getPickedResult(null);
                stack2.func_77982_d(new NBTTagCompound());
                stack2.func_77978_p().func_74782_a("SavedEntity", (NBTBase)new NBTTagCompound());
                this.func_70014_b(stack2.func_77978_p().func_74775_l("SavedEntity"));
                this.func_70099_a(stack2, 0.0f);
            }
            this.func_70106_y();
        }
    }

    public void adjustSize() {
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == TF2weapons.stun;
    }

    public SoundEvent getSoundNameForState(int state) {
        return state == 50 ? TF2Sounds.MOB_SAPPER_IDLE : null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0 * (double)TF2ConfigVars.damageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76370_b) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70015_d(int time) {
        super.func_70015_d(0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VIS_TEAM, (Object)((byte)this.field_70146_Z.nextInt(2)));
        this.field_70180_af.func_187214_a(OWNER_UUID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(LEVEL, (Object)1);
        this.field_70180_af.func_187214_a(SOUND_STATE, (Object)25);
        this.field_70180_af.func_187214_a(PROGRESS, (Object)0);
        this.field_70180_af.func_187214_a(SAPPED, (Object)0);
        this.field_70180_af.func_187214_a(CONSTRUCTING, (Object)0);
        this.field_70180_af.func_187214_a(ENERGY, (Object)0);
    }

    public int getSoundState() {
        return ((Byte)this.field_70180_af.func_187225_a(SOUND_STATE)).byteValue();
    }

    public void setSoundState(int state) {
        this.field_70180_af.func_187227_b(SOUND_STATE, (Object)((byte)state));
    }

    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).orNull();
    }

    public EntityLivingBase getOwner() {
        if (!(this.owner == null || this.owner instanceof EntityPlayer && this.owner.field_70128_L)) {
            return this.owner;
        }
        if (this.func_184753_b() != null) {
            this.owner = this.field_70170_p.func_152378_a(this.func_184753_b());
            return this.owner;
        }
        return null;
    }

    public void setOwner(EntityLivingBase owner) {
        this.owner = owner;
        if (owner instanceof EntityPlayer) {
            this.ownerName = owner.func_70005_c_();
            this.field_70180_af.func_187227_b(OWNER_UUID, (Object)Optional.of((Object)owner.func_110124_au()));
            this.func_110163_bv();
        } else if (this.func_184753_b() != null) {
            this.field_70180_af.func_187227_b(OWNER_UUID, (Object)Optional.absent());
        } else if (owner != null) {
            this.engMade = true;
        }
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        if (this.getOwner() instanceof EntityEngineer) {
            WeaponsCapability.get((Entity)this.getOwner()).giveMetal(EntityBuilding.getCost(this.getBuildingID(), ((EntityEngineer)this.getOwner()).loadout.getStackInSlot(2)) / 2);
        }
        this.clearReferences();
    }

    public void clearReferences() {
        if (this.func_184753_b() != null && this.fromPDA) {
            if (this.disposableID == -1) {
                PlayerPersistStorage.get((World)this.field_70170_p, (UUID)this.func_184753_b()).buildings[this.getBuildingID()] = null;
            } else {
                try {
                    PlayerPersistStorage.get((World)this.field_70170_p, (UUID)this.func_184753_b()).disposableBuildings.remove(this.func_110124_au());
                }
                catch (IndexOutOfBoundsException e) {
                    LOGGER.error("Disposable ID out of bounds");
                }
            }
        }
    }

    public void func_70071_h_() {
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        if (this.field_70148_d && !this.field_70170_p.field_72995_K && this.fromPDA && !PlayerPersistStorage.get(this.field_70170_p, this.func_184753_b()).allowBuilding(this)) {
            this.func_70106_y();
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.engMade && this.func_184753_b() == null && (this.owner == null || this.owner.field_70128_L) && this.ticksNoOwner++ >= 120) {
            this.func_70606_j(0.0f);
        } else {
            this.ticksNoOwner = 0;
        }
        if (this.field_70181_x > 0.0) {
            this.field_70181_x = 0.0;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 80 == 0) {
                int j1 = MathHelper.func_76141_d((float)(this.field_70177_z * 256.0f / 360.0f));
                int l1 = MathHelper.func_76141_d((float)(this.field_70125_A * 256.0f / 360.0f));
                ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a((Entity)this, (Packet)new SPacketEntity.S16PacketEntityLook(this.func_145782_y(), (byte)j1, (byte)l1, true));
            }
            if (this.fromPDA && this.field_70173_aa % 5 == 0 && this.func_70089_S()) {
                PlayerPersistStorage storage = PlayerPersistStorage.get(this.field_70170_p, this.func_184753_b());
                if (this.disposableID == -1) {
                    if (storage.buildings[this.getBuildingID()] == null || !((UUID)storage.buildings[this.getBuildingID()].func_76341_a()).equals(this.func_110124_au())) {
                        this.func_70606_j(0.0f);
                        this.func_70645_a(DETONATE);
                        return;
                    }
                    NBTTagCompound tag = (NBTTagCompound)storage.buildings[this.getBuildingID()].func_76340_b();
                    this.func_70014_b(tag);
                } else if (!storage.disposableBuildings.contains(this.func_110124_au())) {
                    this.func_70606_j(0.0f);
                    this.func_70645_a(DETONATE);
                    return;
                }
            }
            if (this.isSapped()) {
                TF2Util.dealDamage((Entity)this, this.field_70170_p, this.sapperOwner, this.sapper, 0, this.sapper.func_190926_b() ? 0.14f : ((ItemSapper)this.sapper.func_77973_b()).getWeaponDamage(this.sapper, this.sapperOwner, (Entity)this), TF2Util.causeDirectDamage(this.sapper, (Entity)this.sapperOwner, 0));
            }
            if (this.charge.getStackInSlot(0).hasCapability(CapabilityEnergy.ENERGY, null)) {
                this.energy.receiveEnergy(((IEnergyStorage)this.charge.getStackInSlot(0).getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(this.energy.receiveEnergy(this.energy.getMaxEnergyStored(), true), false), false);
            }
            this.setInfoEnergy(this.energy.getEnergyStored());
            if (this.func_184753_b() != null && this.shouldUseBlocks()) {
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    BlockPos pos = this.func_180425_c().func_177972_a(facing);
                    TileEntity ent = this.field_70170_p.func_175625_s(pos);
                    if (ent == null) continue;
                    this.drawFromBlock(pos, ent, facing);
                }
            }
        }
        super.func_70071_h_();
        if (this.isConstructing()) {
            this.updateConstruction();
        }
        --this.wrenchBonusTime;
    }

    public void detonate() {
        this.func_70606_j(0.0f);
        this.func_70645_a(DETONATE);
    }

    public void drawFromBlock(BlockPos pos, TileEntity ent, EnumFacing facing) {
        if (ent.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) {
            this.energy.receiveEnergy(((IEnergyStorage)ent.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())).extractEnergy(this.energy.receiveEnergy(this.energy.getMaxEnergyStored(), true), false), false);
        }
    }

    public boolean shouldUseBlocks() {
        return this.energy.getEnergyStored() != this.energy.getMaxEnergyStored();
    }

    public boolean consumeEnergy(int amount) {
        return this.energy.getEnergyStored() >= amount && this.energy.extractEnergy(amount, true) == amount && this.energy.extractEnergy(amount, false) == amount;
    }

    public int getMinEnergy() {
        return 0;
    }

    public void setSapped(EntityLivingBase owner, ItemStack sapper) {
        this.sapperOwner = owner;
        this.sapper = sapper;
        this.field_70180_af.func_187227_b(SAPPED, (Object)2);
        this.setSoundState(50);
    }

    public boolean func_175446_cd() {
        return super.func_175446_cd() || this.isDisabled();
    }

    public boolean isSapped() {
        return (Byte)this.field_70180_af.func_187225_a(SAPPED) > 0;
    }

    public boolean isDisabled() {
        return !this.func_70089_S() || this.isConstructing() || this.isSapped() || this.energy.getEnergyStored() < this.getMinEnergy() || this.func_70660_b(TF2weapons.stun) != null;
    }

    public void removeSapper() {
        this.field_70180_af.func_187227_b(SAPPED, (Object)((byte)((Byte)this.field_70180_af.func_187225_a(SAPPED) - 1)));
        if (!this.isSapped()) {
            this.setSoundState(0);
            this.func_184185_a(TF2Sounds.MOB_SAPPER_DEATH, 1.5f, 1.0f);
            this.func_145779_a(Items.field_151042_j, 1);
        }
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return (entityIn != null && !TF2Util.isOnSameTeam(entityIn, (Entity)this) || entityIn == this.getOwner()) && this.func_70089_S() ? entityIn.func_174813_aQ() : null;
    }

    public AxisAlignedBB func_70046_E() {
        if (!this.func_70089_S()) {
            return null;
        }
        return this.func_174813_aQ();
    }

    public Team func_96124_cp() {
        if (this.getOwner() != null) {
            return this.getOwner().func_96124_cp();
        }
        if (this.func_184753_b() != null) {
            return this.field_70170_p.func_96441_U().func_96509_i(this.ownerName);
        }
        switch (this.getEntTeam()) {
            case 0: {
                return this.field_70170_p.func_96441_U().func_96508_e("RED");
            }
            case 1: {
                this.field_70170_p.func_96441_U().func_96508_e("BLU");
            }
            case 2: {
                this.field_70170_p.func_96441_U().func_96508_e("Robots");
            }
        }
        return this.field_70170_p.func_96441_U().func_96508_e("RED");
    }

    public int getProgress() {
        if (this.isConstructing()) {
            return (int)((float)((Integer)this.field_70180_af.func_187225_a(CONSTRUCTING)).intValue() / (float)this.getConstructionTime() * 200.0f);
        }
        return (Integer)this.field_70180_af.func_187225_a(PROGRESS);
    }

    public void setProgress(int progress) {
        this.field_70180_af.func_187227_b(PROGRESS, (Object)progress);
    }

    public int getInfoEnergy() {
        return (Integer)this.field_70180_af.func_187225_a(ENERGY);
    }

    public void setInfoEnergy(int energy) {
        this.field_70180_af.func_187227_b(ENERGY, (Object)energy);
    }

    public int getLevel() {
        return ((Byte)this.field_70180_af.func_187225_a(LEVEL)).byteValue();
    }

    public void setLevel(int level) {
        this.field_70180_af.func_187227_b(LEVEL, (Object)((byte)level));
    }

    public void upgrade() {
        this.setLevel(this.getLevel() + 1);
        this.setProgress(0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() * 1.2);
        this.func_70606_j(this.func_110138_aP());
        this.adjustSize();
    }

    public int getEntTeam() {
        return ((Byte)this.field_70180_af.func_187225_a(VIS_TEAM)).byteValue();
    }

    public void setEntTeam(int team) {
        this.field_70180_af.func_187227_b(VIS_TEAM, (Object)((byte)team));
    }

    public boolean isConstructing() {
        return (Integer)this.field_70180_af.func_187225_a(CONSTRUCTING) < this.getConstructionTime();
    }

    public void setConstructing(boolean constr) {
        this.field_70180_af.func_187227_b(CONSTRUCTING, (Object)(constr ? 0 : this.getConstructionTime()));
    }

    public void updateConstruction() {
        if (!this.redeploy) {
            this.func_70691_i((float)this.getConstructionRate() * this.func_110138_aP() / (float)this.getConstructionTime());
        }
        this.field_70180_af.func_187227_b(CONSTRUCTING, (Object)((Integer)this.field_70180_af.func_187225_a(CONSTRUCTING) + this.getConstructionRate()));
        if (this.redeploy && (Integer)this.field_70180_af.func_187225_a(CONSTRUCTING) >= this.getConstructionTime()) {
            this.redeploy = false;
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74774_a("Team", (byte)this.getEntTeam());
        par1NBTTagCompound.func_74774_a("Level", (byte)this.getLevel());
        par1NBTTagCompound.func_74777_a("Progress", (short)((byte)this.getProgress()));
        par1NBTTagCompound.func_74777_a("Sapper", (short)((Byte)this.field_70180_af.func_187225_a(SAPPED)).byteValue());
        par1NBTTagCompound.func_74777_a("Construction", ((Integer)this.field_70180_af.func_187225_a(CONSTRUCTING)).shortValue());
        par1NBTTagCompound.func_74774_a("WrenchBonus", (byte)this.wrenchBonusTime);
        par1NBTTagCompound.func_74757_a("Redeploy", this.redeploy);
        par1NBTTagCompound.func_74757_a("EngMade", this.engMade);
        par1NBTTagCompound.func_74757_a("FromPDA", this.fromPDA);
        par1NBTTagCompound.func_74774_a("TicksOwnerless", (byte)this.ticksNoOwner);
        par1NBTTagCompound.func_74782_a("Charge", (NBTBase)this.charge.serializeNBT());
        par1NBTTagCompound.func_74768_a("Energy", this.energy.getEnergyStored());
        par1NBTTagCompound.func_74774_a("DisposableID", (byte)this.disposableID);
        if (this.getOwner() != null && !(this.getOwner() instanceof EntityPlayer)) {
            par1NBTTagCompound.func_186854_a("OwnerE", this.getOwner().func_110124_au());
        }
        if (this.func_184753_b() != null) {
            par1NBTTagCompound.func_186854_a("Owner", this.func_184753_b());
            par1NBTTagCompound.func_74778_a("OwnerName", this.ownerName);
        }
        if (this.isDisabled()) {
            par1NBTTagCompound.func_74757_a("NoAI", false);
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.setEntTeam(tag.func_74771_c("Team"));
        this.setLevel(tag.func_74771_c("Level"));
        this.setProgress(tag.func_74771_c("Progress"));
        this.field_70180_af.func_187227_b(CONSTRUCTING, (Object)tag.func_74765_d("Construction"));
        this.wrenchBonusTime = tag.func_74771_c("WrenchBonus");
        this.redeploy = tag.func_74767_n("Redeploy");
        this.ticksNoOwner = tag.func_74771_c("Ownerless");
        this.engMade = tag.func_74767_n("EngMade");
        this.fromPDA = tag.func_74767_n("FromPDA");
        this.charge.deserializeNBT(tag.func_74775_l("Charge"));
        this.energy.receiveEnergy(tag.func_74762_e("Energy"), false);
        this.disposableID = tag.func_74771_c("DisposableID");
        if (tag.func_74771_c("Sapper") != 0) {
            this.setSapped((EntityLivingBase)this, ItemStack.field_190927_a);
        }
        if (tag.func_186855_b("OwnerE")) {
            this.ownerEntityID = tag.func_186857_a("OwnerE");
        }
        if (tag.func_186855_b("Owner")) {
            UUID ownerID = tag.func_186857_a("Owner");
            this.field_70180_af.func_187227_b(OWNER_UUID, (Object)Optional.of((Object)ownerID));
            this.ownerName = tag.func_74779_i("OwnerName");
            this.getOwner();
            this.func_110163_bv();
        }
    }

    public int getBuildingID() {
        return 0;
    }

    public float getCollHeight() {
        return 1.0f;
    }

    public float getCollWidth() {
        return 0.95f;
    }

    public boolean canUseWrench() {
        return this.func_110138_aP() > this.func_110143_aJ() || this.getLevel() < this.getMaxLevel();
    }

    public boolean func_184603_cC() {
        return false;
    }

    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        this.field_70761_aq = this.field_70177_z;
        return p_110146_2_;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        EntityLivingBase attacker = this.func_94060_bK();
        if (this.fromPDA || TF2Util.isOnSameTeam((Entity)attacker, (Entity)this) && this.func_184753_b() == null) {
            return;
        }
        if (!(this.getOwner() instanceof EntityEngineer) || ((EntityEngineer)this.getOwner()).buildCount < 3) {
            int count = this.getOwner() instanceof EntityPlayer ? this.getIronDrop() : MathHelper.func_76123_f((float)(this.getIronDrop() / 2));
            for (int i = 0; i < count; ++i) {
                this.func_145779_a(Items.field_151042_j, 1);
            }
        }
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        this.func_70099_a(this.charge.getStackInSlot(0), 0.0f);
    }

    public int getIronDrop() {
        return 1 + this.getLevel();
    }

    protected boolean func_70692_ba() {
        return this.func_184753_b() == null;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderGUI(BufferBuilder renderer, Tessellator tessellator, EntityPlayer player, int width, int height, GuiIngame gui) {
    }

    public int getGuiHeight() {
        return 48;
    }

    public int getConstructionTime() {
        return 21000;
    }

    public int getConstructionRate() {
        int i = 50;
        if (this.wrenchBonusTime > 0) {
            i = (int)((float)i + 75.0f * this.wrenchBonusMult);
        }
        if (this.redeploy) {
            i += 100;
        }
        if (TF2ConfigVars.fastBuildEngineer && this.getOwner() != null && this.getOwner() instanceof EntityEngineer) {
            i += 125;
        }
        return i;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energy;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public static int getCost(int building, ItemStack wrench) {
        if (building == 0) {
            return TF2Attribute.getModifier("Weapon Mode", wrench, 0.0f, null) == 2.0f ? 100 : 130;
        }
        if (building == 1) {
            return 100;
        }
        if (building == 4) {
            return 60;
        }
        return (int)(50.0f / TF2Attribute.getModifier("Teleporter Cost", wrench, 1.0f, null));
    }

    @Override
    public boolean hasHead() {
        return false;
    }

    @Override
    public AxisAlignedBB getHeadBox() {
        return null;
    }

    @Override
    public boolean hasDamageFalloff() {
        return false;
    }

    @Override
    public boolean isBuilding() {
        return true;
    }

    @Override
    public boolean isBackStabbable(EntityLivingBase attacker, ItemStack knife) {
        return false;
    }

    public int getDisposableID() {
        return this.disposableID;
    }

    public void setDisposableID(int disposableID) {
        this.disposableID = disposableID;
    }
}

