/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.boss;

import com.google.common.base.Predicate;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.IEntityTF2;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemMinigun;
import rafradek.TF2weapons.util.TF2DamageSource;
import rafradek.TF2weapons.util.TF2Util;

public abstract class EntityTF2Boss
extends EntityMob
implements IEntityTF2 {
    protected final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS);
    public int level = 1;
    public int timeLeft = 2400;
    public HashSet<EntityPlayer> attackers = new HashSet();
    public HashSet<UUID> participateUUID = new HashSet();
    public int playersAttacked = 0;
    private int blockBreakCounter = 27;
    public BlockPos spawnPos;
    protected float envDamage;
    protected float healthForPlayer;
    public boolean summoned;
    public float desiredHealth = 0.0f;
    protected static final UUID BOSS_ARMOR_SPAWN = UUID.fromString("2d4ac0f2-a8f5-4a13-b04d-67d97bd71320");
    public WeaponsCapability weaponCap;

    public EntityTF2Boss(World worldIn) {
        super(worldIn);
        if (!this.field_70170_p.field_72995_K) {
            this.func_184195_f(true);
        }
        this.field_82174_bp = new float[]{0.0f, 0.0f};
        this.weaponCap = new WeaponsCapability((EntityLivingBase)this);
        this.weaponCap.setCanExpJump(false);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76369_e || source == DamageSource.field_76371_c || source == DamageSource.field_76370_b) {
            return false;
        }
        if (source instanceof TF2DamageSource) {
            if (source.func_76346_g() == this) {
                return false;
            }
            if (((TF2DamageSource)source).getCritical() > 0) {
                amount *= 0.7f;
            }
            if (!((TF2DamageSource)source).getWeapon().func_190926_b() && ((TF2DamageSource)source).getWeapon().func_77973_b() instanceof ItemMinigun) {
                amount *= 0.36f;
            }
        }
        if (source.func_76364_f() instanceof EntitySentry && !((EntitySentry)source.func_76364_f()).fromPDA) {
            amount *= 0.3f;
        }
        if (source.func_76346_g() == null || WeaponsCapability.get(source.func_76346_g()) == null) {
            amount *= 0.5f;
        }
        if (super.func_70097_a(source, amount * (this.func_110138_aP() / this.desiredHealth))) {
            if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer) {
                this.attackers.add((EntityPlayer)source.func_76346_g());
            }
            if (!(source.func_76346_g() instanceof EntityLivingBase)) {
                this.envDamage += amount;
            }
            return true;
        }
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, 0.0f);
    }

    public void func_70108_f(Entity entityIn) {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected float func_189749_co() {
        return 1.0f;
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        int count = this.playersAttacked;
        if (count > 4) {
            count = 2 + this.playersAttacked / 2;
        }
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                this.func_70628_a(wasRecentlyHit, lootingModifier);
            }
            this.func_70099_a(new ItemStack(TF2weapons.itemTF2, this.level / 2 + MathHelper.func_151239_c((int)this.level) + 2, 2), 0.0f);
            ItemStack weapon = ItemFromData.getRandomWeapon(this.field_70146_Z, ItemFromData.VISIBLE_WEAPON);
            if (this.level > 1) {
                TF2Attribute.upgradeItemStack(weapon, 40 + (this.level - 2) * 55 + MathHelper.func_151239_c((int)this.level) * 40, this.field_70146_Z);
            }
            this.func_70099_a(weapon, 0.0f);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        --this.timeLeft;
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 20 == 0) {
                for (EntityLivingBase living : this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(100.0, 28.0, 100.0), (Predicate)new Predicate<EntityLivingBase>(){

                    public boolean apply(EntityLivingBase input) {
                        return input.hasCapability(TF2weapons.WEAPONS_CAP, null) && (TF2Util.getOwnerIfOwnable(input) instanceof EntityPlayer || input.func_70068_e((Entity)EntityTF2Boss.this) < 900.0);
                    }
                })) {
                    if (this.participateUUID.contains(living.func_110124_au())) continue;
                    this.participateUUID.add(living.func_110124_au());
                    this.desiredHealth += this.healthForPlayer;
                    if (living instanceof EntityPlayer) {
                        this.desiredHealth += this.healthForPlayer * 3.0f;
                    }
                    float per = this.func_110143_aJ() / this.func_110138_aP();
                    this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.min(1000.0f, this.desiredHealth));
                    this.func_70606_j(per * this.func_110138_aP());
                }
            }
            if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
                this.func_70624_b(null);
            }
            if (this.timeLeft == 2250) {
                this.func_184195_f(false);
            }
            if (this.timeLeft == 1200) {
                this.func_184185_a(TF2Sounds.MOB_BOSS_ESCAPE_60, 4.0f, 1.0f);
            } else if (this.timeLeft == 200) {
                this.func_184185_a(TF2Sounds.MOB_BOSS_ESCAPE_10, 4.0f, 1.0f);
            } else if (this.timeLeft <= 0) {
                this.func_184185_a(TF2Sounds.MOB_BOSS_ESCAPE, 4.0f, 1.0f);
                if (this.summoned) {
                    this.returnSpawnItems();
                }
                this.func_70106_y();
            }
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
            --this.blockBreakCounter;
            if (this.blockBreakCounter <= 0 && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                this.blockBreakCounter = 27;
                this.breakBlocks();
            }
        }
    }

    public void returnSpawnItems() {
    }

    public boolean breakBlocks() {
        return this.breakBlocks(this.getBreakingBB());
    }

    public boolean breakBlocks(AxisAlignedBB box) {
        boolean flag = false;
        for (int x = MathHelper.func_76128_c((double)box.field_72340_a); x <= MathHelper.func_76128_c((double)box.field_72336_d); ++x) {
            for (int y = MathHelper.func_76128_c((double)box.field_72338_b); y <= MathHelper.func_76128_c((double)box.field_72337_e); ++y) {
                for (int z = MathHelper.func_76128_c((double)box.field_72339_c); z <= MathHelper.func_76128_c((double)box.field_72334_f); ++z) {
                    BlockPos blockpos = new BlockPos(x, y, z);
                    IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = iblockstate.func_177230_c();
                    if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || iblockstate.func_185904_a().func_76224_d() || !EntityWither.func_181033_a((Block)block) || !block.canEntityDestroy(iblockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this)) continue;
                    flag = this.field_70170_p.func_175655_b(blockpos, true) || flag;
                }
            }
        }
        if (flag) {
            this.field_70170_p.func_180498_a((EntityPlayer)null, 1022, new BlockPos((Entity)this), 0);
        }
        return flag;
    }

    public float func_70599_aP() {
        return TF2ConfigVars.bossVolume;
    }

    public AxisAlignedBB getBreakingBB() {
        return this.func_174813_aQ();
    }

    public boolean func_184222_aU() {
        return false;
    }

    public SoundEvent getAppearSound() {
        return null;
    }

    public Team func_96124_cp() {
        return this.field_70170_p.func_96441_U().func_96508_e("TF2Bosses");
    }

    public void func_70015_d(int time) {
        super.func_70015_d(1);
    }

    public void func_191986_a(float m1, float m2, float m3) {
        float move = this.func_70689_ay();
        super.func_191986_a(m1 / move, m2, m3 / move);
    }

    public boolean attemptTeleportForce(double x, double y, double z) {
        this.breakBlocks(this.func_174813_aQ().func_72317_d(x - this.field_70165_t, y - this.field_70163_u, z - this.field_70161_v));
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (world.func_184144_a(null, this.func_174813_aQ()).isEmpty() && !world.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        int i = 128;
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (this.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d4 = d1 + (this.field_70163_u - d1) * d6 + random.nextDouble() * (double)this.field_70131_O;
            double d5 = d2 + (this.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            world.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
        }
        if (this instanceof EntityCreature) {
            this.func_70661_as().func_75499_g();
        }
        return true;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance diff, IEntityLivingData p_110161_1_) {
        int players = 0;
        short highestLevel = 0;
        int statmult = 0;
        this.spawnPos = this.func_180425_c();
        for (EntityLivingBase living : this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(100.0, 28.0, 100.0), (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase input) {
                return input.hasCapability(TF2weapons.WEAPONS_CAP, null) && (TF2Util.getOwnerIfOwnable(input) instanceof EntityPlayer || input.func_70068_e((Entity)EntityTF2Boss.this) < 900.0);
            }
        })) {
            short level;
            ++statmult;
            this.participateUUID.add(living.func_110124_au());
            if (!(living instanceof EntityPlayer)) continue;
            ++players;
            statmult += 3;
            EntityPlayer player = (EntityPlayer)living;
            if (((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).highestBossLevel.get(this.getClass()) == null) {
                ((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).highestBossLevel.put(this.getClass(), (short)0);
            }
            if ((level = ((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).highestBossLevel.get(this.getClass()).shortValue()) > highestLevel) {
                highestLevel = level;
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("tf2boss.appear", new Object[]{this.func_145748_c_(), Math.min(30, highestLevel + 1)}));
        }
        this.level = Math.min(30, ++highestLevel);
        this.healthForPlayer = (float)(this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() * (double)0.1f * (double)(0.5f + (float)highestLevel * 0.5f));
        float desiredHealth = (float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() * (0.6f + (float)statmult * 0.1f) * (0.5f + (float)highestLevel * 0.5f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.min(1000.0f, desiredHealth));
        this.desiredHealth = desiredHealth;
        this.func_70606_j(this.func_110138_aP());
        TF2Attribute.setAttribute(this.func_184614_ca(), TF2Attribute.attributes[19], 1.0f * (0.7f + (float)highestLevel * 0.3f));
        this.field_70728_aV = (int)(200.0f * (0.5f + (float)players * 0.5f) * (0.35f + (float)highestLevel * 0.65f));
        this.playersAttacked = players;
        this.func_184185_a(this.getAppearSound(), 4.0f, 1.0f);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier(BOSS_ARMOR_SPAWN, "armorspawn", 20.0, 0));
        return p_110161_1_;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        for (EntityPlayer player : this.attackers) {
            int level;
            int n = level = ((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).highestBossLevel.get(this.getClass()) != null ? (int)((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).highestBossLevel.get(this.getClass()).shortValue() : 0;
            if (this.level > level) {
                ((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).highestBossLevel.put(this.getClass(), (short)this.level);
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("tf2boss.death", new Object[]{this.func_145748_c_(), this.level}));
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74777_a("Level", (short)this.level);
        nbt.func_74777_a("Players", (short)this.playersAttacked);
        nbt.func_74777_a("TimeLeft", (short)this.timeLeft);
        nbt.func_74776_a("DamageMult", this.desiredHealth);
        nbt.func_74757_a("Summoned", this.summoned);
        nbt.func_74776_a("HealthForPlayer", this.healthForPlayer);
        NBTTagList playerleast = new NBTTagList();
        NBTTagList playermost = new NBTTagList();
        for (EntityPlayer player : this.attackers) {
            playerleast.func_74742_a((NBTBase)new NBTTagLong(player.func_110124_au().getLeastSignificantBits()));
            playermost.func_74742_a((NBTBase)new NBTTagLong(player.func_110124_au().getMostSignificantBits()));
        }
        nbt.func_74782_a("PlayerLeast", (NBTBase)playerleast);
        nbt.func_74782_a("PlayerMost", (NBTBase)playermost);
        NBTTagList participateleast = new NBTTagList();
        NBTTagList participatemost = new NBTTagList();
        for (UUID participate : this.participateUUID) {
            participateleast.func_74742_a((NBTBase)new NBTTagLong(participate.getLeastSignificantBits()));
            participatemost.func_74742_a((NBTBase)new NBTTagLong(participate.getMostSignificantBits()));
        }
        nbt.func_74782_a("ParticipateLeast", (NBTBase)participateleast);
        nbt.func_74782_a("ParticipateMost", (NBTBase)participatemost);
        if (this.spawnPos != null) {
            nbt.func_74783_a("SpawnPos", new int[]{this.spawnPos.func_177958_n(), this.spawnPos.func_177956_o(), this.spawnPos.func_177952_p()});
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.level = nbt.func_74765_d("Level");
        this.playersAttacked = nbt.func_74765_d("Players");
        this.timeLeft = nbt.func_74765_d("TimeLeft");
        this.desiredHealth = nbt.func_74760_g("DamageMult");
        this.summoned = nbt.func_74767_n("Summoned");
        this.healthForPlayer = nbt.func_74760_g("HealthForPlayer");
        NBTTagList playerleast = nbt.func_150295_c("PlayerLeast", 4);
        NBTTagList playermost = nbt.func_150295_c("PlayerMost", 4);
        for (int i = 0; i < playerleast.func_74745_c(); ++i) {
            this.attackers.add(this.field_70170_p.func_152378_a(new UUID(((NBTTagLong)playermost.func_179238_g(i)).func_150291_c(), ((NBTTagLong)playerleast.func_179238_g(i)).func_150291_c())));
        }
        NBTTagList participateleast = nbt.func_150295_c("ParticipateLeast", 4);
        NBTTagList participatemost = nbt.func_150295_c("ParticipateMost", 4);
        for (int i = 0; i < participateleast.func_74745_c(); ++i) {
            this.participateUUID.add(new UUID(((NBTTagLong)participatemost.func_179238_g(i)).func_150291_c(), ((NBTTagLong)participateleast.func_179238_g(i)).func_150291_c()));
        }
        if (this.timeLeft < 2250) {
            this.func_184195_f(false);
        }
        if (nbt.func_74764_b("SpawnPos")) {
            int[] arr = nbt.func_74759_k("SpawnPos");
            this.spawnPos = new BlockPos(arr[0], arr[1], arr[2]);
        }
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == TF2weapons.stun && potioneffectIn.func_76458_c() >= 3;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == TF2weapons.WEAPONS_CAP) {
            return (T)this.weaponCap;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == TF2weapons.WEAPONS_CAP || super.hasCapability(capability, facing);
    }

    @Override
    public boolean hasHead() {
        return true;
    }

    @Override
    public AxisAlignedBB getHeadBox() {
        return null;
    }

    @Override
    public boolean hasDamageFalloff() {
        return false;
    }

    @Override
    public boolean isBuilding() {
        return false;
    }

    @Override
    public boolean isBackStabbable(EntityLivingBase attacker, ItemStack knife) {
        return true;
    }
}

