/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.boss;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.entity.boss.EntityTF2Boss;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemProjectileWeapon;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.util.TF2DamageSource;
import rafradek.TF2weapons.util.TF2Util;

public class EntityMonoculus
extends EntityTF2Boss {
    public static final int LASER_DURATION = 90;
    public static final int LASER_START = 60;
    public int teleport = 200;
    public int angryTicks = 0;
    public int begin = 30;
    public float toAngry = 0.0f;
    public int laserTime;
    public int laserCooldown = 150;
    private static final DataParameter<Boolean> ANGRY = EntityDataManager.func_187226_a(EntityMonoculus.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LASER = EntityDataManager.func_187226_a(EntityMonoculus.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityMonoculus(World worldIn) {
        super(worldIn);
        this.func_70105_a(4.0f, 4.0f);
        this.func_184611_a(EnumHand.MAIN_HAND, ItemFromData.getNewStack("mnceye"));
        this.func_184611_a(EnumHand.OFF_HAND, ItemFromData.getNewStack("mnclaser"));
        this.field_70765_h = new MonoculusMoveHelper(this);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANGRY, (Object)false);
        this.field_70180_af.func_187214_a(LASER, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AILaserAttack(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIFireballAttack(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround(this));
        this.field_70715_bh.field_75782_a.clear();
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget<EntityLivingBase>((EntityCreature)this, EntityLivingBase.class, 0, true, false, (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase input) {
                return input instanceof EntityPlayer || input instanceof EntityTF2Character;
            }
        }){

            protected double func_111175_f() {
                return super.func_111175_f() * 0.5;
            }
        });
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 5, false, false, input -> input instanceof EntityPlayer));
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean isAngry() {
        return (Boolean)this.func_184212_Q().func_187225_a(ANGRY);
    }

    public void setAngry(int ticks) {
        this.angryTicks = ticks;
        boolean angry = ticks > 0;
        this.toAngry = 0.0f;
        if (angry) {
            TF2Attribute.setAttribute(this.func_184614_ca(), TF2Attribute.attributes[19], 3.0f * (0.75f + (float)this.level * 0.25f));
        } else {
            TF2Attribute.setAttribute(this.func_184614_ca(), TF2Attribute.attributes[19], 1.0f * (0.75f + (float)this.level * 0.25f));
        }
        this.func_184212_Q().func_187227_b(ANGRY, (Object)angry);
    }

    public boolean isLaser() {
        return (Boolean)this.func_184212_Q().func_187225_a(LASER);
    }

    public void setLaser(boolean laser) {
        this.func_184212_Q().func_187227_b(LASER, (Object)laser);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            if (source instanceof TF2DamageSource) {
                if (((TF2DamageSource)source).getCritical() > 0 && !this.isAngry()) {
                    this.setAngry(160);
                }
            } else {
                this.toAngry += amount;
                if (this.toAngry >= 40.0f * (1.0f + (float)this.level * 0.08f)) {
                    this.setAngry(120);
                }
            }
            return true;
        }
        return false;
    }

    public SoundEvent func_184615_bR() {
        return TF2Sounds.MOB_MONOCULUS_DEFEAT;
    }

    @Override
    public SoundEvent getAppearSound() {
        return TF2Sounds.MOB_MONOCULUS_START;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74777_a("Begin", (short)this.begin);
        nbt.func_74777_a("Angry", (short)this.angryTicks);
        nbt.func_74777_a("Teleport", (short)this.teleport);
        nbt.func_74777_a("LaserCooldown", (short)this.laserCooldown);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.begin = nbt.func_74765_d("Begin");
        this.angryTicks = nbt.func_74765_d("Angry");
        this.setAngry(this.angryTicks);
        this.teleport = nbt.func_74765_d("Teleport");
        this.laserCooldown = nbt.func_74765_d("LaserCooldown");
    }

    @Override
    public void func_191986_a(float strafe, float forward, float par3) {
        if (this.func_70090_H()) {
            this.func_191958_b(strafe, forward, par3, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_180799_ab()) {
            this.func_191958_b(strafe, forward, par3, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            float f1 = 0.16277136f / (f * f * f);
            this.func_191958_b(strafe, forward, par3, this.field_70122_E ? 0.1f * f1 : 0.02f);
            f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)f;
            this.field_70179_y *= (double)f;
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    @Override
    public void func_70636_d() {
        if (this.func_184614_ca().func_190926_b() || !(this.func_184614_ca().func_77973_b() instanceof ItemWeapon)) {
            this.func_184611_a(EnumHand.MAIN_HAND, ItemFromData.getNewStack("mnceye"));
        }
        super.func_70636_d();
        if (this.begin-- > 20 && this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 40; ++i) {
                Vec3d pos = TF2Util.radiusRandom2D(2.7f, this.field_70146_Z);
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, pos.field_72450_a + this.field_70165_t, this.field_70163_u - 0.5, pos.field_72448_b + this.field_70161_v, 0.55, 0.12, 1.0, new int[0]);
            }
        }
        if (this.field_70173_aa == 1) {
            // empty if block
        }
        --this.laserTime;
        if (this.field_70170_p.field_72995_K) {
            this.field_70158_ak = this.isLaser();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.begin == 0) {
                this.func_94061_f(false);
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_188479_b(BOSS_ARMOR_SPAWN);
            }
            if (this.func_70638_az() == null) {
                double f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                this.field_70177_z = -((float)MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y)) * 57.295776f;
                this.field_70125_A = -((float)MathHelper.func_181159_b((double)this.field_70181_x, (double)f)) * 57.295776f;
                this.field_70761_aq = this.field_70177_z;
                this.field_70759_as = this.field_70177_z;
            } else {
                EntityLivingBase entitylivingbase = this.func_70638_az();
                double d0 = 64.0;
                if (entitylivingbase.func_70068_e((Entity)this) < 4096.0) {
                    double d1 = entitylivingbase.field_70165_t - this.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.field_70161_v;
                    double d3 = entitylivingbase.field_70163_u - (this.field_70163_u + (double)this.func_70047_e());
                    if (this.isLaser()) {
                        d3 += (double)entitylivingbase.func_70047_e();
                    }
                    double f = MathHelper.func_76133_a((double)(d1 * d1 + d2 * d2));
                    float clamp = this.isLaser() ? 1.35f : 10.0f;
                    float yaw = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                    float pitch = -((float)MathHelper.func_181159_b((double)d3, (double)f)) * 57.295776f;
                    yaw = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)(yaw - this.field_70759_as)), (float)(-clamp), (float)clamp);
                    pitch = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)(pitch - this.field_70125_A)), (float)(-clamp * 33.0f), (float)(clamp * 33.0f));
                    this.field_70177_z += yaw;
                    this.field_70761_aq = this.field_70177_z;
                    this.field_70125_A += pitch;
                    this.field_70759_as = this.field_70177_z;
                }
            }
            if (this.level > 1) {
                --this.laserCooldown;
            }
            if (this.field_70173_aa % 20 == 0 && !this.isAngry() && this.field_70146_Z.nextInt(20) == 0) {
                this.setAngry(100);
            }
            if (this.field_70173_aa % 5 == 0) {
                if (this.func_70638_az() != null && this.field_70170_p.func_72933_a(this.func_174824_e(1.0f), this.func_70638_az().func_174791_d()) != null) {
                    TF2Attribute.setAttribute(this.func_184614_ca(), TF2Attribute.attributes[39], this.isAngry() ? 0.8f : 0.45f);
                    TF2Attribute.setAttribute(this.func_184592_cb(), TF2Attribute.attributes[39], 0.0f);
                } else {
                    TF2Attribute.setAttribute(this.func_184614_ca(), TF2Attribute.attributes[39], 0.0f);
                }
            }
            this.toAngry = Math.max(0.0f, this.toAngry - 0.4f);
            if (this.isAngry() && --this.angryTicks <= 0) {
                this.setAngry(0);
            }
            if (--this.teleport <= 0 && !this.isLaser()) {
                for (int i = 0; i < 10; ++i) {
                    double x = this.field_70165_t + this.field_70146_Z.nextDouble() * 48.0 - 24.0;
                    double z = this.field_70161_v + this.field_70146_Z.nextDouble() * 48.0 - 24.0;
                    double y = this.field_70163_u + this.field_70146_Z.nextDouble() * 48.0 - 24.0;
                    if (!this.func_184595_k(x, y = Math.min(y, (double)(this.field_70170_p.func_175672_r(new BlockPos(x, y, z)).func_177956_o() + 16)), z)) continue;
                    for (int j = 0; j < 40; ++j) {
                        Vec3d pos = TF2Util.radiusRandom3D(2.7f, this.field_70146_Z);
                        this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, pos.field_72450_a + this.field_70165_t, pos.field_72448_b + this.field_70163_u, pos.field_72449_c + this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                    }
                    this.teleport += 160 + this.field_70146_Z.nextInt(80);
                    break;
                }
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(256.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(160.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.11);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance diff, IEntityLivingData p_110161_1_) {
        p_110161_1_ = super.func_180482_a(diff, p_110161_1_);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() * (0.95 + (double)this.level * 0.05));
        return p_110161_1_;
    }

    public void func_70628_a(boolean hit, int looting) {
        if (this.field_70146_Z.nextBoolean()) {
            ItemStack bomb = ItemFromData.getNewStack("bombinomicon");
            TF2Attribute.setAttribute(bomb, MapList.nameToAttribute.get("BombEnemy"), 1.45f + (float)this.level * 0.2f);
            this.func_70099_a(bomb, 0.0f);
        }
        ItemStack hat = ItemFromData.getNewStack("monoculus");
        hat.func_77978_p().func_74777_a("BossLevel", (short)this.level);
        this.func_70099_a(hat, 0.0f);
    }

    public float func_70047_e() {
        return this.field_70131_O / 2.0f;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (this.field_70170_p.field_72995_K && LASER.equals(key)) {
            this.laserTime = 100;
        }
    }

    @Override
    public void returnSpawnItems() {
        this.func_70099_a(new ItemStack(TF2weapons.itemBossSpawn, 1, 1), 0.0f);
    }

    static class MonoculusMoveHelper
    extends EntityMoveHelper {
        private final EntityMonoculus parentEntity;
        private int courseChangeCooldown;

        public MonoculusMoveHelper(EntityMonoculus ghast) {
            super((EntityLiving)ghast);
            this.parentEntity = ghast;
        }

        public void func_75641_c() {
            double speed = this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            if (this.parentEntity.isLaser()) {
                speed *= 0.2;
            }
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown = 0;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        this.parentEntity.field_70159_w += d0 / d3 * speed;
                        this.parentEntity.field_70181_x += d1 / d3 * speed;
                        this.parentEntity.field_70179_y += d2 / d3 * speed;
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private final EntityMonoculus parentEntity;
        private boolean movingToHome;

        public AIRandomFly(EntityMonoculus ghast) {
            this.parentEntity = ghast;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            if (this.parentEntity.begin > 0) {
                return false;
            }
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a() || !this.parentEntity.func_110173_bK() && !this.movingToHome) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            boolean flyToPlayer;
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            BlockPos pos = this.parentEntity.field_70170_p.func_175672_r(this.parentEntity.func_180425_c());
            double d1 = Math.min((double)(pos.func_177956_o() + 16), this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f));
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            EntityLivingBase target = this.parentEntity.func_70638_az();
            this.movingToHome = this.parentEntity.func_180486_cf().func_177954_c(d0, d1, d2) < this.parentEntity.func_174818_b(this.parentEntity.func_180486_cf());
            boolean bl = flyToPlayer = target != null && target.func_70068_e((Entity)this.parentEntity) > 680.0;
            if ((!flyToPlayer || target.func_70092_e(d0, d1, d2) < target.func_70068_e((Entity)this.parentEntity)) && (flyToPlayer || this.parentEntity.func_110173_bK() || this.movingToHome)) {
                this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 0.3);
            }
        }
    }

    static class AILookAround
    extends EntityAIBase {
        private final EntityMonoculus parentEntity;

        public AILookAround(EntityMonoculus ghast) {
            this.parentEntity = ghast;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.parentEntity.begin <= 0;
        }

        public void func_75246_d() {
        }
    }

    static class AILaserAttack
    extends EntityAIBase {
        private final EntityMonoculus parentEntity;
        public int damageCooldown;

        public AILaserAttack(EntityMonoculus ghast) {
            this.parentEntity = ghast;
            this.func_75248_a(4);
        }

        public boolean func_75250_a() {
            return this.parentEntity.begin <= 0 && this.parentEntity.laserCooldown <= 0 && this.parentEntity.func_70638_az() != null && TF2Util.lookingAt((EntityLivingBase)this.parentEntity, 13.0, (Entity)this.parentEntity.func_70638_az());
        }

        public boolean func_75253_b() {
            return this.parentEntity.begin <= 0 && this.parentEntity.laserCooldown <= 0 && (this.parentEntity.func_70638_az() != null || this.parentEntity.envDamage > 0.0f);
        }

        public void func_75249_e() {
            this.parentEntity.laserTime = 90 + this.parentEntity.level * 10;
        }

        public void func_75251_c() {
            this.parentEntity.setLaser(false);
            this.parentEntity.laserCooldown = 140;
        }

        public void func_75246_d() {
            if (this.parentEntity.laserTime <= 0) {
                this.parentEntity.laserCooldown = 260;
                this.parentEntity.setLaser(false);
            } else {
                this.parentEntity.setLaser(true);
            }
            if (this.parentEntity.laserTime < 60 + this.parentEntity.level * 10 && --this.damageCooldown <= 0) {
                ((ItemWeapon)this.parentEntity.func_184592_cb().func_77973_b()).use(this.parentEntity.func_184592_cb(), (EntityLivingBase)this.parentEntity, this.parentEntity.field_70170_p, EnumHand.OFF_HAND, null);
                this.damageCooldown = Math.max(20 - this.parentEntity.level, 10);
            }
            for (RayTraceResult trace : TF2Util.pierce(this.parentEntity.field_70170_p, (Entity)this.parentEntity, 120.0, false, 0.5f, true)) {
                ((WorldServer)this.parentEntity.field_70170_p).func_175739_a(EnumParticleTypes.CRIT, trace.field_72307_f.field_72450_a, trace.field_72307_f.field_72448_b, trace.field_72307_f.field_72449_c, 1, 0.0, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    static class AIFireballAttack
    extends EntityAIBase {
        private final EntityMonoculus parentEntity;
        private int attackTimer;
        public int triple;

        public AIFireballAttack(EntityMonoculus ghast) {
            this.parentEntity = ghast;
            this.func_75248_a(4);
        }

        public boolean func_75250_a() {
            return this.parentEntity.begin <= 0 && (this.parentEntity.func_70638_az() != null || this.parentEntity.envDamage > 0.0f);
        }

        public void func_75249_e() {
        }

        public void func_75246_d() {
            Object entitylivingbase = this.parentEntity.func_70638_az();
            if (entitylivingbase == null) {
                entitylivingbase = this.parentEntity;
            }
            double d0 = 64.0;
            if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                World world = this.parentEntity.field_70170_p;
                --this.attackTimer;
                if (this.attackTimer <= 0) {
                    if (this.parentEntity.envDamage > 0.0f) {
                        this.parentEntity.envDamage -= 5.0f;
                    }
                    double d1 = 4.0;
                    if (this.parentEntity.isAngry()) {
                        this.parentEntity.func_184185_a(TF2Sounds.MOB_MONOCULUS_SHOOT_MAD, 3.0f, 1.0f);
                    } else {
                        this.parentEntity.func_184185_a(TF2Sounds.MOB_MONOCULUS_SHOOT, 3.0f, 1.0f);
                    }
                    ((ItemProjectileWeapon)this.parentEntity.func_184614_ca().func_77973_b()).shoot(this.parentEntity.func_184614_ca(), (EntityLivingBase)this.parentEntity, world, 2, EnumHand.MAIN_HAND);
                    if (this.triple > 0) {
                        --this.triple;
                        this.attackTimer = Math.max(4, 6 - this.parentEntity.level / 3);
                    } else {
                        this.attackTimer = Math.max(11, 30 - this.parentEntity.level * 2);
                        if (this.parentEntity.isAngry()) {
                            this.triple = 2;
                        }
                    }
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
        }
    }
}

