/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.boss;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.block.BlockProp;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.client.particle.EnumTF2Particles;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.boss.EntityTF2Boss;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemProjectileWeapon;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.util.TF2Util;

public class EntityMerasmus
extends EntityTF2Boss {
    private int begin = 30;
    private int teleportCooldown = 240;
    private int bombCooldown = 160;
    private int bombDuration;
    public boolean hidden;
    public int topBlock;
    public BlockPos hiddenBlock;
    private int hideCount;
    public ArrayList<BlockPos> usedPos = new ArrayList();
    private static final DataParameter<Boolean> SPELL_BOMB = EntityDataManager.func_187226_a(EntityMerasmus.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityMerasmus(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.15f, 3.5f);
        this.field_70138_W = 1.05f;
        this.func_94061_f(true);
        this.func_184611_a(EnumHand.MAIN_HAND, ItemFromData.getNewStack("mrsbomb"));
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPELL_BOMB, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIAttack(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget<EntityLivingBase>((EntityCreature)this, EntityLivingBase.class, 3, false, false, (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase input) {
                return input instanceof EntityTF2Character || input instanceof EntityPlayer;
            }
        }){

            protected double func_111175_f() {
                return super.func_111175_f() * 0.35;
            }

            public boolean func_75250_a() {
                return super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, 5, false, false, input -> input instanceof EntityPlayer){

            public boolean func_75250_a() {
                boolean ex = super.func_75250_a();
                return ex;
            }
        });
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(256.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.098);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
    }

    protected PathNavigate getNewNavigator(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    public float func_70047_e() {
        return 2.1f;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        float prevHP = this.func_110143_aJ();
        if (super.func_70097_a(source, amount)) {
            float newHP = this.func_110143_aJ();
            if (this.func_70089_S() && !this.isBombSpell()) {
                if (this.hideCount == 0 && newHP / this.func_110138_aP() <= 0.55f) {
                    this.hide(true);
                    this.hideCount = 1;
                } else if (this.hideCount == 1 && newHP / this.func_110138_aP() <= 0.1f) {
                    this.hide(true);
                    this.hideCount = 2;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        if (this.func_184614_ca().func_190926_b() || !(this.func_184614_ca().func_77973_b() instanceof ItemWeapon)) {
            this.func_184611_a(EnumHand.MAIN_HAND, ItemFromData.getNewStack("mrsbomb"));
        }
        super.func_70636_d();
        if (this.func_70660_b(TF2weapons.stun) != null) {
            this.field_70125_A = 90.0f;
        }
        if (this.begin-- > 20 && this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 40; ++i) {
                Vec3d pos = TF2Util.radiusRandom2D(2.2f, this.field_70146_Z);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, pos.field_72450_a + this.field_70165_t, this.field_70163_u - 0.5, pos.field_72448_b + this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.begin == 0) {
                this.func_94061_f(false);
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_188479_b(BOSS_ARMOR_SPAWN);
            }
            --this.bombDuration;
            for (EntityLivingBase living : this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(1.5, 1.0, 1.5), (Predicate)new Predicate<EntityLivingBase>(){

                public boolean apply(EntityLivingBase input) {
                    return input.func_70660_b(TF2weapons.bombmrs) != null;
                }
            })) {
                living.func_184589_d(TF2weapons.bombmrs);
                living.func_184589_d(TF2weapons.stun);
                living.func_184589_d(MobEffects.field_76431_k);
                this.func_184185_a(TF2Sounds.MOB_MERASMUS_STUN, 1.0f, 1.0f);
                this.func_70097_a(new EntityDamageSource("magicb", (Entity)living).func_82726_p(), 15.0f);
                this.func_70690_d(new PotionEffect(TF2weapons.stun, 120, 3));
                this.teleportCooldown = 120;
            }
            if (!this.hidden) {
                if (this.field_70173_aa % 5 == 0) {
                    if (this.func_70638_az() != null && !this.func_70635_at().func_75522_a((Entity)this.func_70638_az())) {
                        TF2Attribute.setAttribute(this.func_184614_ca(), TF2Attribute.attributes[39], 0.35f);
                    } else {
                        TF2Attribute.setAttribute(this.func_184614_ca(), TF2Attribute.attributes[39], 0.0f);
                    }
                }
                if (this.bombCooldown-- <= 0) {
                    List list = this.field_70170_p.func_175647_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(30.0, 15.0, 30.0), (Predicate)new Predicate<EntityPlayer>(){

                        public boolean apply(EntityPlayer input) {
                            return EntityMerasmus.this.func_70068_e((Entity)input) < 900.0 && !TF2Util.isOnSameTeam((Entity)EntityMerasmus.this, (Entity)input) && EntityAITarget.func_179445_a((EntityLiving)EntityMerasmus.this, (EntityLivingBase)input, (boolean)false, (boolean)false);
                        }
                    });
                    if (!list.isEmpty()) {
                        EntityLivingBase living;
                        living = (EntityPlayer)list.get(this.field_70146_Z.nextInt(list.size()));
                        living.func_70690_d(new PotionEffect(TF2weapons.bombmrs, 300));
                        TF2Util.stun(living, 300, false);
                        ((EntityPlayerMP)living).field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(TF2Sounds.MOB_MERASMUS_HEADBOMB, this.func_184176_by(), living.field_70165_t, living.field_70163_u, living.field_70161_v, 4.0f, 1.0f));
                    }
                    this.bombCooldown = Math.max(680 - this.playersAttacked * 60, 480);
                }
                if (this.teleportCooldown-- <= 0 && !this.isBombSpell()) {
                    this.teleport();
                }
                if (this.isBombSpell()) {
                    float prevPitch = this.field_70125_A;
                    float prevYaw = this.field_70759_as;
                    if (this.field_70173_aa % 8 == 0) {
                        for (int i = 0; i < 16; ++i) {
                            this.field_70125_A = -70.0f + this.field_70146_Z.nextFloat() * 120.0f;
                            this.field_70759_as = (float)i * 22.5f + this.field_70146_Z.nextFloat() * 22.5f;
                            ((ItemProjectileWeapon)this.func_184614_ca().func_77973_b()).shoot(this.func_184614_ca(), (EntityLivingBase)this, this.field_70170_p, 0, EnumHand.MAIN_HAND);
                        }
                    }
                    this.field_70181_x = this.field_70163_u < (double)this.topBlock ? (double)0.15f : 0.0;
                    if (this.bombDuration == 200 || !this.func_70605_aq().func_75640_a()) {
                        Random random = this.func_70681_au();
                        BlockPos pos = this.field_70170_p.func_175672_r(this.func_180425_c());
                        double d0 = this.field_70165_t;
                        double d2 = this.field_70161_v;
                        if ((double)(pos.func_177956_o() + 7) < this.field_70163_u) {
                            d0 += (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                            d2 += (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                        }
                        double d1 = pos.func_177956_o() + 7 + random.nextInt(3);
                        this.func_70605_aq().func_75642_a(d0, (double)this.topBlock, d2, 1.0);
                    }
                    this.field_70125_A = prevPitch;
                    this.field_70759_as = prevYaw;
                    if (this.bombDuration < 40) {
                        this.setBombSpell(false);
                    }
                }
            }
            if (this.hidden) {
                if (this.field_70173_aa % 5 == 0) {
                    this.func_70691_i(this.func_110138_aP() * 0.001f);
                }
                if (this.field_70170_p.func_180495_p(this.hiddenBlock).func_177230_c() != TF2weapons.blockProp) {
                    this.hide(false);
                }
            }
        }
    }

    public void teleport() {
        this.teleportCooldown = 240;
        this.func_184185_a(TF2Sounds.MOB_MERASMUS_DISAPPEAR, 1.0f, 1.0f);
        for (int i = 0; i < 10; ++i) {
            double z;
            double x;
            if (this.func_70638_az() != null) {
                x = this.func_70638_az().field_70165_t + this.field_70146_Z.nextDouble() * 40.0 - 20.0;
                z = this.func_70638_az().field_70161_v + this.field_70146_Z.nextDouble() * 40.0 - 20.0;
            } else {
                x = this.field_70165_t + this.field_70146_Z.nextDouble() * 40.0 - 20.0;
                z = this.field_70161_v + this.field_70146_Z.nextDouble() * 40.0 - 20.0;
            }
            double y = this.field_70170_p.func_175672_r(new BlockPos(x, 0.0, z)).func_177956_o() + 3;
            if (!this.func_184595_k(x, y, z)) continue;
            this.func_184185_a(TF2Sounds.MOB_MERASMUS_APPEAR, 1.0f, 1.0f);
            for (int j = 0; j < 40; ++j) {
                Vec3d pos = TF2Util.radiusRandom3D(2.7f, this.field_70146_Z);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, pos.field_72450_a + this.field_70165_t, pos.field_72448_b + this.field_70163_u, pos.field_72449_c + this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            }
            this.teleportCooldown += 200 + this.field_70146_Z.nextInt(80);
            break;
        }
    }

    public boolean isBombSpell() {
        return (Boolean)this.func_184212_Q().func_187225_a(SPELL_BOMB);
    }

    public void setBombSpell(boolean bomb) {
        this.func_184212_Q().func_187227_b(SPELL_BOMB, (Object)bomb);
        this.func_70661_as().func_75499_g();
        if (bomb) {
            this.field_70765_h = new FloatingMoveHelper(this);
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemFromData.getNewStack("bombinomicon"));
            this.func_184185_a(TF2Sounds.MOB_MERASMUS_BOMBINOMICON, 3.3f, 1.0f);
        } else {
            this.field_70765_h = new EntityMoveHelper((EntityLiving)this);
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
        }
        TF2Attribute.setAttribute(this.func_184614_ca(), TF2Attribute.attributes[19], bomb ? 0.65f : 1.0f);
        TF2Attribute.setAttribute(this.func_184614_ca(), TF2Attribute.attributes[39], bomb ? 0.0f : 0.3f);
    }

    public void func_70628_a(boolean hit, int looting) {
        ItemStack hat = ItemFromData.getNewStack("merasmushat");
        hat.func_77978_p().func_74777_a("BossLevel", (short)this.level);
        this.func_70099_a(hat, 0.0f);
    }

    public SoundEvent func_184615_bR() {
        return TF2Sounds.MOB_MERASMUS_DEFEAT;
    }

    @Override
    public SoundEvent getAppearSound() {
        return TF2Sounds.MOB_MERASMUS_START;
    }

    public void func_70106_y() {
        super.func_70106_y();
        for (BlockPos pos : this.usedPos) {
            if (this.field_70170_p.func_180495_p(pos).func_177230_c() != TF2weapons.blockProp) continue;
            this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("Hidden", this.hidden);
        if (this.hidden) {
            nbt.func_74783_a("HiddenPos", new int[]{this.hiddenBlock.func_177958_n(), this.hiddenBlock.func_177956_o(), this.hiddenBlock.func_177952_p()});
            NBTTagList list = new NBTTagList();
            nbt.func_74782_a("Props", (NBTBase)list);
            for (BlockPos pos : this.usedPos) {
                list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
            }
        }
        nbt.func_74777_a("Begin", (short)this.begin);
        nbt.func_74777_a("Teleport", (short)this.teleportCooldown);
        nbt.func_74777_a("BombCooldown", (short)this.bombCooldown);
        nbt.func_74777_a("BombDuration", (short)this.bombDuration);
        nbt.func_74777_a("TopBlock", (short)this.topBlock);
        nbt.func_74774_a("HideCount", (byte)this.hideCount);
        nbt.func_74757_a("Bomb", this.isBombSpell());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.begin = nbt.func_74765_d("Begin");
        this.setBombSpell(nbt.func_74767_n("Bomb"));
        this.bombCooldown = nbt.func_74765_d("BombCooldown");
        this.bombDuration = nbt.func_74765_d("BombDuration");
        this.topBlock = nbt.func_74765_d("TopBlock");
        this.teleportCooldown = nbt.func_74765_d("Teleport");
        this.hidden = nbt.func_74767_n("Hidden");
        this.hideCount = nbt.func_74771_c("HideCount");
        if (this.hidden) {
            this.func_94061_f(true);
            int[] pos = nbt.func_74759_k("HiddenPos");
            this.hiddenBlock = new BlockPos(pos[0], pos[1], pos[2]);
            NBTTagList list = nbt.func_150295_c("Props", 11);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                int[] arr = list.func_150306_c(i);
                this.usedPos.add(new BlockPos(arr[0], arr[1], arr[2]));
            }
        }
    }

    public void hide(boolean hide) {
        this.hidden = hide;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        if (hide) {
            this.field_70699_by.func_75499_g();
            this.func_184185_a(TF2Sounds.MOB_MERASMUS_HIDE, this.func_70599_aP(), 1.0f);
            this.func_82142_c(true);
            int blockCount = (int)Math.min(100.0f, 10.0f * (0.7f + 0.3f * (float)this.playersAttacked) * (0.9f + 0.1f * (float)this.level));
            BlockPos initial = this.func_180425_c();
            for (int i = 0; i < blockCount; ++i) {
                BlockPos pos = initial.func_177982_a(this.field_70146_Z.nextInt((int)(40.0f + (float)blockCount * 0.3f)) - 20 - (int)((float)blockCount * 0.15f), 0, this.field_70146_Z.nextInt((int)(40.0f + (float)blockCount * 0.3f)) - 20 - (int)((float)blockCount * 0.15f));
                if (this.field_70170_p.func_180495_p(pos = this.field_70170_p.func_175672_r(pos)).func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, pos)) {
                    this.field_70170_p.func_175656_a(pos, TF2weapons.blockProp.func_176203_a(this.field_70146_Z.nextInt(BlockProp.EnumBlockType.values().length)));
                }
                if (i == 0) {
                    this.hiddenBlock = pos;
                }
                this.func_70634_a(pos.func_177958_n(), -20.0, pos.func_177952_p());
                this.usedPos.add(pos);
            }
        } else {
            this.func_82142_c(false);
            for (BlockPos pos : this.usedPos) {
                if (this.field_70170_p.func_180495_p(pos).func_177230_c() != TF2weapons.blockProp) continue;
                this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
            this.usedPos.clear();
            this.func_70634_a((double)this.hiddenBlock.func_177958_n() + 0.5, this.hiddenBlock.func_177956_o(), (double)this.hiddenBlock.func_177952_p() + 0.5);
            this.teleportCooldown = 20;
        }
        this.func_94061_f(hide);
    }

    @Override
    public void func_191986_a(float strafe, float forward, float par3) {
        if (!this.isBombSpell() && !this.hidden) {
            super.func_191986_a(strafe, forward, par3);
            return;
        }
        if (this.func_70090_H()) {
            this.func_191958_b(strafe, forward, par3, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_180799_ab()) {
            this.func_191958_b(strafe, forward, par3, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            float f1 = 0.16277136f / (f * f * f);
            this.func_191958_b(strafe, forward, par3, this.field_70122_E ? 0.1f * f1 : 0.02f);
            f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)f;
            this.field_70179_y *= (double)f;
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public void func_70624_b(EntityLivingBase ent) {
        if (this.func_70638_az() != null && ent instanceof EntityBuilding) {
            return;
        }
        super.func_70624_b(ent);
    }

    @Override
    public void returnSpawnItems() {
        if (!this.usedPos.isEmpty()) {
            this.func_70107_b(this.hiddenBlock.func_177958_n(), this.hiddenBlock.func_177956_o(), this.hiddenBlock.func_177952_p());
        }
        this.func_70099_a(new ItemStack(TF2weapons.itemBossSpawn, 1, 1), 0.0f);
    }

    static class FloatingMoveHelper
    extends EntityMoveHelper {
        private final EntityMerasmus parentEntity;
        private int courseChangeCooldown;

        public FloatingMoveHelper(EntityMerasmus ghast) {
            super((EntityLiving)ghast);
            this.parentEntity = ghast;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        this.parentEntity.field_70159_w += d0 / d3 * 0.05;
                        this.parentEntity.field_70179_y += d2 / d3 * 0.05;
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public static class AIAttack
    extends EntityAIBase {
        public EntityMerasmus host;
        public int attacksMade;
        public int attackDuration;
        public boolean lastAttackMagic;
        public boolean liftup;

        public AIAttack(EntityMerasmus host) {
            this.host = host;
        }

        public boolean func_75250_a() {
            return this.host.func_70638_az() != null && this.host.func_70660_b(TF2weapons.stun) == null || this.host.envDamage > 0.0f;
        }

        public void func_75246_d() {
            Object target = this.host.func_70638_az();
            if (target == null) {
                target = this.host;
            }
            World world = this.host.field_70170_p;
            this.host.func_70671_ap().func_75651_a((Entity)target, 30.0f, 90.0f);
            if (this.attackDuration < 20) {
                this.host.func_70661_as().func_75497_a((Entity)target, 1.0);
            }
            if (--this.attackDuration <= 0) {
                boolean sup;
                if (this.host.envDamage > 0.0f) {
                    this.host.envDamage -= 6.0f;
                }
                this.host.func_184609_a(EnumHand.MAIN_HAND);
                boolean bl = sup = this.host.level > 1 && (this.attacksMade % 7 == 0 || (this.attacksMade - 1) % 7 == 0);
                if (this.attacksMade > 0 && this.attacksMade % 13 == 0) {
                    this.host.setBombSpell(true);
                    this.host.bombDuration = 200;
                    this.host.teleport();
                    BlockPos pos = this.host.field_70170_p.func_175672_r(this.host.func_180425_c());
                    this.host.topBlock = pos.func_177956_o() + 7 + this.host.field_70146_Z.nextInt(3);
                    this.attackDuration = 200;
                } else if (this.attacksMade % 2 == 0) {
                    this.attackDuration = 20 - this.host.level / 4;
                    if (target != this.host && this.host.func_70068_e((Entity)target) < 6.0) {
                        if (this.host.func_70652_k((Entity)target)) {
                            target.func_70653_a((Entity)this.host, 1.5f, (double)MathHelper.func_76126_a((float)(this.host.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.host.field_70177_z * ((float)Math.PI / 180)))));
                        }
                    } else {
                        this.host.func_70625_a((Entity)target, 180.0f, 90.0f);
                        ((ItemProjectileWeapon)this.host.func_184614_ca().func_77973_b()).shoot(this.host.func_184614_ca(), (EntityLivingBase)this.host, world, 0, EnumHand.MAIN_HAND);
                        if (sup) {
                            Vec3d right = this.host.func_174806_f(0.0f, this.host.field_70759_as + 90.0f);
                            this.host.field_70759_as -= 24.0f;
                            for (int i = -2; i <= 2; ++i) {
                                this.host.field_70165_t += right.field_72450_a * (double)i;
                                this.host.field_70161_v += right.field_72449_c * (double)i;
                                this.host.field_70759_as += 12.0f;
                                ((ItemProjectileWeapon)this.host.func_184614_ca().func_77973_b()).shoot(this.host.func_184614_ca(), (EntityLivingBase)this.host, world, 0, EnumHand.MAIN_HAND);
                            }
                            this.host.field_70759_as -= 24.0f;
                        }
                    }
                } else {
                    this.attackDuration = (int)(55.0 / (0.91 + (double)((float)this.host.level * 0.09f)));
                    this.host.func_70661_as().func_75499_g();
                    this.host.func_184185_a(TF2Sounds.MOB_MERASMUS_SPELL, 2.0f, 1.0f);
                    boolean attacked = false;
                    final double range = 10.0 + (double)this.host.level * 0.8;
                    for (EntityLivingBase living : world.func_175647_a(EntityLivingBase.class, this.host.func_174813_aQ().func_72314_b(range, range * 0.4, range), (Predicate)new Predicate<EntityLivingBase>(){

                        public boolean apply(EntityLivingBase input) {
                            return input.func_70068_e((Entity)host) < range * range && !TF2Util.isOnSameTeam((Entity)host, (Entity)input) && EntityAITarget.func_179445_a((EntityLiving)host, (EntityLivingBase)input, (boolean)false, (boolean)false);
                        }
                    })) {
                        TF2Util.sendParticle(EnumTF2Particles.BULLET_TRACER, (Entity)this.host, this.host.field_70165_t, this.host.field_70163_u + (double)(this.host.field_70131_O / 2.0f), this.host.field_70161_v, living.field_70165_t, living.field_70163_u + (double)(living.field_70131_O / 2.0f), living.field_70161_v, 1, 0, 0x60FF60, 10000);
                        living.func_70097_a(new EntityDamageSource("magicm", (Entity)this.host).func_82726_p().func_76351_m(), 4.4f + (float)this.host.level * 0.7f);
                        living.func_70024_g(0.0, 0.7, 0.0);
                        living.field_70122_E = false;
                        if (living instanceof EntityPlayerMP) {
                            TF2Util.sendTracking(new TF2Message.VelocityAddMessage(new Vec3d(0.0, 0.7, 0.0), true), (Entity)living);
                        }
                        if (living.hasCapability(TF2weapons.WEAPONS_CAP, null)) {
                            WeaponsCapability.get((Entity)living).setExpJump(true);
                        } else {
                            living.field_70143_R = -10.0f;
                        }
                        attacked = true;
                    }
                    if (!attacked) {
                        EntityMerasmus entityMerasmus = this.host;
                        entityMerasmus.teleportCooldown = entityMerasmus.teleportCooldown - 20;
                    }
                }
                if (sup) {
                    this.attackDuration = (int)((float)this.attackDuration * 0.35f);
                }
                ++this.attacksMade;
            }
        }
    }
}

