/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.boss;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.boss.EntityTF2Boss;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.entity.projectile.EntityProjectileBase;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;

public class EntityHHH
extends EntityTF2Boss {
    public int targetTime;
    private int attackTick;
    private int scareTick;
    private int teleportTime;
    private int toTeleportTime;
    public int begin = 30;
    private float damageTakenNoPath;
    private int aboveGroundTicks;
    private int dashCool;
    private int dashTick;
    private int targetInAir;
    private Vec3d dashMotion;
    private List<EntityLivingBase> possibleTargets = new ArrayList<EntityLivingBase>();
    private static UUID slowDash = UUID.fromString("03edb08b-0a2f-4040-9c9c-062d0c2e2a85");
    private static UUID fasterSpeed = UUID.fromString("03edb08b-0a2f-4040-9c9c-062d0c2e2b85");
    private Vec3d lastPos = Vec3d.field_186680_a;

    public EntityHHH(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 2.85f);
        this.field_70138_W = 1.05f;
        this.func_94061_f(true);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184611_a(EnumHand.MAIN_HAND, ItemFromData.getNewStack("headtaker"));
        this.func_184614_ca().func_77966_a(Enchantments.field_180313_o, 10);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAirAttack());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySentry.class, 2, false, false, null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(105.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(13.0);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance diff, IEntityLivingData p_110161_1_) {
        p_110161_1_ = super.func_180482_a(diff, p_110161_1_);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() * (0.88 + (double)this.level * 0.12));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b() * (0.9 + (double)this.level * 0.1));
        return p_110161_1_;
    }

    public void func_70628_a(boolean hit, int looting) {
        if (this.field_70146_Z.nextBoolean() || this.level == 1) {
            this.func_70099_a(ItemFromData.getNewStack("headtaker"), 0.0f);
        }
    }

    @Override
    public void func_70636_d() {
        if (this.func_184614_ca().func_190926_b() || !(this.func_184614_ca().func_77973_b() instanceof ItemWeapon)) {
            this.func_184611_a(EnumHand.MAIN_HAND, ItemFromData.getNewStack("headtaker"));
        }
        super.func_70636_d();
        if (this.begin-- > 20 && this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 40; ++i) {
                Vec3d pos = TF2Util.radiusRandom2D(2.2f, this.field_70146_Z);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, pos.field_72450_a + this.field_70165_t, this.field_70163_u - 0.5, pos.field_72448_b + this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.begin <= 0) {
            List ents;
            if (this.field_70146_Z.nextInt(20) == 0) {
                TF2Util.addModifierSafe((EntityLivingBase)this, SharedMonsterAttributes.field_111263_d, new AttributeModifier(fasterSpeed, "fastspeed", (double)TF2Util.lerp(0.2f, 0.0f, this.func_110143_aJ() / this.func_110138_aP()), 2), false);
            }
            if (this.begin == 0) {
                this.func_94061_f(false);
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_188479_b(BOSS_ARMOR_SPAWN);
            }
            if (this.func_70638_az() != null && !(this.func_70638_az() instanceof EntitySentry) && this.func_70638_az().func_70660_b(TF2weapons.it) == null) {
                EntityLivingBase lastTarget = this.func_70638_az().func_110144_aD();
                this.func_70624_b(null);
                if (lastTarget != null && lastTarget.func_70660_b(TF2weapons.it) != null) {
                    this.func_70624_b(lastTarget);
                }
            }
            --this.scareTick;
            if (this.func_70638_az() == null && this.field_70173_aa % 5 == 0) {
                List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(20.0, 10.0, 20.0), (Predicate)new Predicate<EntityLivingBase>(){

                    public boolean apply(EntityLivingBase input) {
                        return (input instanceof EntityTF2Character || input instanceof EntityPlayer || input == EntityHHH.this.func_70643_av()) && EntityHHH.this.func_70068_e((Entity)input) < 600.0 && EntityAITarget.func_179445_a((EntityLiving)EntityHHH.this, (EntityLivingBase)input, (boolean)false, (boolean)false);
                    }
                });
                Collections.sort(list, new EntityAINearestAttackableTarget.Sorter((Entity)this));
                if (list.size() > 0) {
                    this.func_70624_b((EntityLivingBase)list.get(0));
                } else if (this.func_70643_av() != null) {
                    this.func_70624_b(this.func_70643_av());
                }
                if (this.scareTick <= 0) {
                    boolean one = false;
                    List lists = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0), (Predicate)new Predicate<EntityLivingBase>(){

                        public boolean apply(EntityLivingBase input) {
                            return EntityHHH.this.func_70068_e((Entity)input) < 100.0 && !TF2Util.isOnSameTeam((Entity)EntityHHH.this, (Entity)input) && (!input.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() || input.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() != Item.func_150898_a((Block)Blocks.field_150423_aK));
                        }
                    });
                    if (lists.size() > 1) {
                        for (EntityLivingBase living : lists) {
                            one = true;
                            TF2Util.stun(living, 80, false);
                        }
                    }
                    if (one) {
                        this.func_184185_a(TF2Sounds.MOB_HHH_ALERT, 1.75f, 1.0f);
                    }
                    this.scareTick = 200;
                }
            }
            if (this.func_70638_az() != null) {
                if (!this.func_70638_az().field_70122_E) {
                    ++this.targetInAir;
                }
                if (this.level > 1) {
                    if (this.dashCool-- <= 0) {
                        this.dashCool = 300;
                        this.dashTick = 35;
                        this.dashMotion = this.func_174806_f(0.0f, this.field_70759_as).func_186678_a(0.45);
                        TF2Util.addModifierSafe((EntityLivingBase)this, SharedMonsterAttributes.field_111263_d, new AttributeModifier(slowDash, "dash", -0.5, 2), false);
                    }
                    if (this.dashTick-- > 0) {
                        if (this.dashTick < 20) {
                            this.field_70159_w += this.dashMotion.field_72450_a;
                            this.field_70181_x += this.dashMotion.field_72448_b;
                            this.field_70179_y += this.dashMotion.field_72449_c;
                        }
                        if (this.dashTick < 12 && this.func_70068_e((Entity)this.func_70638_az()) < this.func_70638_az().func_70092_e(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y)) {
                            this.dashTick = 0;
                        }
                    } else {
                        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(slowDash);
                    }
                }
            }
            if (--this.teleportTime <= 0 && this.func_70638_az() != null && this.field_70173_aa % 5 == 0) {
                Path path = this.func_70661_as().func_75494_a((Entity)this.func_70638_az());
                boolean shouldTeleport = false;
                if (path == null) {
                    shouldTeleport = this.func_70068_e((Entity)this.func_70638_az()) > 1.5 && this.func_70092_e(this.func_70638_az().field_70165_t, this.field_70163_u, this.func_70638_az().field_70161_v) < 1.0;
                } else {
                    if (this.field_70173_aa % 20 == 0) {
                        if (this.lastPos.func_72436_e(this.func_174791_d()) < 2.0) {
                            shouldTeleport = true;
                        }
                        this.lastPos = this.func_174791_d();
                    }
                    if (!shouldTeleport) {
                        boolean bl = shouldTeleport = Math.abs((double)path.func_75870_c().field_75837_b - this.func_70638_az().field_70163_u) > 1.5 && this.func_70638_az().field_70122_E;
                    }
                }
                if (shouldTeleport) {
                    this.toTeleportTime = 40;
                    this.teleportTime = 250;
                    this.func_94061_f(true);
                    this.func_70095_a(true);
                }
            }
            if (this.toTeleportTime > 0) {
                if (this.field_70170_p instanceof WorldServer) {
                    WorldServer world = (WorldServer)this.field_70170_p;
                    world.func_175739_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u - 0.5, this.field_70161_v, 8, 2.7, 0.0, 2.7, 0.0, new int[0]);
                }
                if (--this.toTeleportTime == 0) {
                    this.func_70095_a(false);
                    this.func_94061_f(false);
                    Vec3d pos = null;
                    if (this.func_70638_az() != null) {
                        pos = new Vec3d(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v);
                    }
                    if (pos != null && this.attemptTeleportForce(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c)) {
                        this.func_70690_d(new PotionEffect(TF2weapons.stun, 30, 3));
                        for (int i = 0; i < 40; ++i) {
                            Vec3d partpos = TF2Util.radiusRandom2D(2.7f, this.field_70146_Z);
                            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, partpos.field_72450_a + this.field_70165_t, this.field_70163_u - 0.5, partpos.field_72448_b + this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                }
            }
            if (--this.attackTick <= 0 && !(ents = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(3.0, 1.0, 3.0), (Predicate)new Predicate<EntityLivingBase>(){

                public boolean apply(EntityLivingBase input) {
                    return EntityHHH.this.func_70068_e((Entity)input) < 4.0 && !TF2Util.isOnSameTeam((Entity)EntityHHH.this, (Entity)input) && (TF2Util.lookingAt((EntityLivingBase)EntityHHH.this, 30.0, input.field_70165_t, input.field_70163_u + (double)input.func_70047_e(), input.field_70161_v) || input.func_70046_E() != null);
                }
            })).isEmpty()) {
                this.func_184609_a(EnumHand.MAIN_HAND);
                this.attackTick = 20;
                for (EntityLivingBase living : ents) {
                    this.func_70652_k((Entity)living);
                }
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            if (this.func_70638_az() == null || this.func_70661_as().func_75500_f()) {
                this.damageTakenNoPath += amount;
                if (this.damageTakenNoPath >= 20.0f && this.teleportTime <= 50) {
                    this.damageTakenNoPath = 0.0f;
                    this.toTeleportTime = 40;
                    this.teleportTime = 250;
                    this.func_94061_f(true);
                    this.func_70095_a(true);
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            this.func_184185_a(TF2Sounds.MOB_HHH_HIT, 1.0f, 1.0f);
            if (!entityIn.func_70089_S()) {
                this.func_184185_a(TF2Sounds.MOB_HHH_ATTACK, 1.75f, 1.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public AxisAlignedBB getBreakingBB() {
        if (this.func_70638_az() != null) {
            AxisAlignedBB orig = this.func_174813_aQ();
            return new AxisAlignedBB(orig.field_72340_a - 0.5, orig.field_72338_b + 1.0, orig.field_72339_c - 0.5, orig.field_72336_d + 0.5, orig.field_72337_e, orig.field_72334_f + 0.5);
        }
        return super.getBreakingBB();
    }

    @Override
    public boolean breakBlocks() {
        boolean flag = super.breakBlocks();
        if (flag) {
            this.func_184609_a(EnumHand.MAIN_HAND);
            this.func_184185_a(TF2Sounds.MOB_HHH_MISS, 1.0f, 1.0f);
        }
        return flag;
    }

    public int func_70627_aG() {
        return 130;
    }

    public void func_70106_y() {
        if (this.func_70638_az() != null) {
            this.func_70638_az().func_184589_d(TF2weapons.it);
        }
        super.func_70106_y();
    }

    public void func_70624_b(EntityLivingBase ent) {
        if (this.func_70638_az() != null && ent instanceof EntityBuilding) {
            return;
        }
        if (ent != null && ent.hasCapability(TF2weapons.WEAPONS_CAP, null) && ((WeaponsCapability)ent.getCapability(TF2weapons.WEAPONS_CAP, null)).itProtection > 0) {
            return;
        }
        if (ent != this.func_70638_az() && this.func_70638_az() != null) {
            boolean hadeffect = this.func_70638_az().func_70660_b(TF2weapons.it) != null;
            this.func_70638_az().func_184589_d(TF2weapons.it);
            if (ent == null && hadeffect) {
                this.func_70638_az().func_70690_d(new PotionEffect(TF2weapons.it, 12));
            }
        }
        if (ent != null) {
            this.targetTime = 300;
            ent.func_70690_d(new PotionEffect(TF2weapons.it, 600));
            if (ent == this.func_70638_az() || this.field_70146_Z.nextBoolean()) {
                // empty if block
            }
        }
        super.func_70624_b(ent);
    }

    public SoundEvent func_184639_G() {
        return TF2Sounds.MOB_HHH_SAY;
    }

    public SoundEvent func_184615_bR() {
        return TF2Sounds.MOB_HHH_DEFEAT;
    }

    @Override
    public SoundEvent getAppearSound() {
        return TF2Sounds.MOB_HHH_START;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74777_a("Begin", (short)this.begin);
        nbt.func_74777_a("Scare", (short)this.scareTick);
        nbt.func_74777_a("Teleport", (short)this.teleportTime);
        nbt.func_74776_a("NoPathDamange", this.damageTakenNoPath);
        nbt.func_74777_a("DashCool", (short)this.dashCool);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.damageTakenNoPath = nbt.func_74760_g("NoPathDamage");
        this.begin = nbt.func_74765_d("Begin");
        this.scareTick = nbt.func_74765_d("Scare");
        this.teleportTime = nbt.func_74765_d("Teleport");
        this.dashCool = nbt.func_74765_d("DashCool");
    }

    @Override
    public void returnSpawnItems() {
        this.func_70099_a(new ItemStack(TF2weapons.itemBossSpawn, 1, 0), 0.0f);
    }

    public class EntityAIAirAttack
    extends EntityAIBase {
        public int ticksInAir;
        public int attackTime;
        public int attackCooldown;

        public boolean func_75250_a() {
            return EntityHHH.this.func_70638_az() != null;
        }

        public void func_75246_d() {
            if (EntityHHH.this.func_70638_az() == null) {
                return;
            }
            EntityLivingBase target = EntityHHH.this.func_70638_az();
            if (!target.field_70122_E) {
                ++this.ticksInAir;
                if (this.ticksInAir > 30) {
                    this.attackTime = 60;
                }
            } else {
                --this.ticksInAir;
            }
            if (--this.attackTime > 0) {
                this.func_75248_a(3);
                this.ticksInAir = 0;
                EntityHHH.this.func_70625_a((Entity)target, 45.0f, 90.0f);
                EntityHHH.this.func_70671_ap().func_75651_a((Entity)target, 90.0f, 90.0f);
                if (this.attackTime == 30) {
                    ItemStack stack = ItemFromData.getNewStack("hhhaxe");
                    try {
                        EntityProjectileBase proj = MapList.projectileClasses.get(ItemFromData.getData(stack).getString(PropertyType.PROJECTILE)).getConstructor(World.class).newInstance(EntityHHH.this.field_70170_p);
                        proj.initProjectile((EntityLivingBase)EntityHHH.this, EnumHand.MAIN_HAND, stack);
                        double x = target.field_70165_t;
                        double y = target.field_70163_u + (double)target.func_70047_e();
                        double z = target.field_70161_v;
                        proj.face(target, 1.0f);
                        EntityHHH.this.field_70170_p.func_72838_d((Entity)proj);
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.func_75248_a(0);
            }
        }
    }
}

