/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemUsable;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.util.TF2Util;

public class EntityAIUseRangedWeapon
extends EntityAIBase {
    protected final EntityTF2Character entityHost;
    protected EntityLivingBase attackTarget;
    public boolean reloading;
    protected int rangedAttackTime = -1;
    protected float entityMoveSpeed;
    protected int comeCloser = 0;
    private float attackRange;
    protected float attackRangeSquared;
    protected float attackRangeSSquared;
    protected boolean pressed;
    protected boolean dodging;
    public boolean jump;
    public float dodgeSpeed = 1.0f;
    public int jumprange;
    public float projSpeed;
    public double fireAtFeet;
    public double lastMotionY;
    public Vec3d velTarget;
    public Vec3d posTarget;
    public int ticksUpdatePos;
    public float gravity;
    public boolean explosive;
    public float releaseAt;

    public EntityAIUseRangedWeapon(EntityTF2Character par1IRangedAttackMob, float par2, float par5) {
        this.entityHost = par1IRangedAttackMob;
        this.entityMoveSpeed = par2;
        this.attackRange = par5;
        this.attackRangeSquared = par5 * par5;
        this.func_75248_a(2);
    }

    public void setRange(float range) {
        this.attackRange = range;
        this.attackRangeSquared = range * range;
        this.attackRangeSSquared = (range + 5.0f) * (range + 5.0f);
    }

    public boolean func_75250_a() {
        EntityLivingBase EntityLivingBase2 = this.entityHost.func_70638_az();
        if (EntityLivingBase2 == null) {
            return false;
        }
        if (this.attackTarget != EntityLivingBase2) {
            this.lastMotionY = EntityLivingBase2.field_70181_x;
        }
        this.attackTarget = EntityLivingBase2;
        return !this.entityHost.func_184614_ca().func_190926_b() && this.entityHost.eating <= 0.0f && this.entityHost.func_184614_ca().func_77973_b() instanceof ItemUsable;
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    private int getPosUpdateTime() {
        return Math.max(1, Math.round(this.entityHost.scaleWithDifficulty(18.0f, 1.0f) * TF2ConfigVars.accurracyMult));
    }

    public void func_75251_c() {
        if (this.entityHost.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemWeapon && this.entityHost.getCapability(TF2weapons.WEAPONS_CAP, null).state != 0) {
            this.pressed = false;
            ((ItemWeapon)this.entityHost.func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).endUse(this.entityHost.func_184586_b(EnumHand.MAIN_HAND), (EntityLivingBase)this.entityHost, this.entityHost.field_70170_p, this.entityHost.getCapability(TF2weapons.WEAPONS_CAP, null).state, 0);
            this.entityHost.getCapability(TF2weapons.WEAPONS_CAP, null).state = 0;
            TF2Util.sendTracking(new TF2Message.ActionMessage(0, (EntityLivingBase)this.entityHost), (Entity)this.entityHost);
        }
        if (this.jump) {
            this.entityHost.jump = false;
        }
        this.attackTarget = null;
        this.comeCloser = 0;
        this.rangedAttackTime = -1;
        this.posTarget = null;
        this.velTarget = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_75246_d() {
        boolean fire;
        boolean stay;
        ItemStack item;
        if (this.attackTarget != null && this.attackTarget.field_70725_aQ > 0 || this.entityHost.field_70725_aQ > 0) {
            this.func_75251_c();
            return;
        }
        if (this.attackTarget == null) {
            return;
        }
        int updateTime = this.getPosUpdateTime();
        if (--this.ticksUpdatePos <= 0 || this.posTarget == null) {
            this.velTarget = this.posTarget != null ? this.attackTarget.func_174791_d().func_178788_d(this.posTarget).func_186678_a(1.0 / (double)updateTime) : Vec3d.field_186680_a;
            this.posTarget = this.attackTarget.func_174791_d();
            this.ticksUpdatePos = updateTime;
        }
        if (!((item = this.entityHost.func_184586_b(EnumHand.MAIN_HAND)).func_77973_b() instanceof ItemWeapon)) {
            return;
        }
        ItemWeapon weapon = (ItemWeapon)item.func_77973_b();
        double d0 = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
        int moveTicks = updateTime - this.ticksUpdatePos;
        double lookX = this.posTarget.field_72450_a + this.velTarget.field_72450_a * (double)moveTicks;
        double lookY = this.posTarget.field_72448_b + (double)this.attackTarget.func_70047_e() + this.velTarget.field_72448_b * (double)moveTicks;
        double lookZ = this.posTarget.field_72449_c + this.velTarget.field_72449_c * (double)moveTicks;
        boolean shouldFireProj = true;
        float dist = this.entityHost.func_70032_d((Entity)this.attackTarget);
        if (this.projSpeed > 0.0f) {
            RayTraceResult mop;
            double yFall;
            int ticksToReach = MathHelper.func_76123_f((float)(dist / this.projSpeed));
            float overshoot = this.entityHost.scaleWithDifficulty(0.6f, 0.0f) * TF2ConfigVars.accurracyMult;
            ticksToReach = Math.round((float)ticksToReach * (this.entityHost.func_70681_au().nextFloat() * overshoot * 2.0f + 1.0f - overshoot));
            lookY = this.posTarget.field_72448_b + (double)(this.attackTarget.field_70131_O / 2.0f) + this.velTarget.field_72448_b * (double)moveTicks;
            if (this.fireAtFeet == -1.0 || this.entityHost.field_70170_p.func_147447_a(new Vec3d(this.entityHost.field_70165_t, this.entityHost.field_70163_u + (double)this.entityHost.func_70047_e(), this.entityHost.field_70161_v), new Vec3d(lookX += this.velTarget.field_72450_a * (double)ticksToReach * 1.0, lookY, lookZ += this.velTarget.field_72449_c * (double)ticksToReach * 1.0), false, true, false) != null) {
                lookY += (double)(this.attackTarget.func_70047_e() - this.attackTarget.field_70131_O / 2.0f);
            }
            double d = yFall = !this.attackTarget.field_70122_E ? -this.attackTarget.field_70181_x : 0.0;
            if (!this.attackTarget.func_70090_H()) {
                int ticksGrav = ticksToReach - 1;
                int i = (ticksGrav * ticksGrav + ticksGrav) / 2;
                lookY += (double)(this.gravity * (float)i);
                if (!this.attackTarget.field_70122_E && this.attackTarget.field_70181_x < 0.0) {
                    yFall += MathHelper.func_151237_a((double)(this.lastMotionY - this.attackTarget.field_70181_x), (double)0.0, (double)0.1) * (double)i;
                }
            }
            if ((mop = this.entityHost.field_70170_p.func_72933_a(this.attackTarget.func_174791_d(), this.attackTarget.func_174791_d().func_72441_c(0.0, -0.3 - yFall, 0.0))) != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                yFall = this.attackTarget.field_70163_u - mop.field_72307_f.field_72448_b;
            }
            shouldFireProj = mop != null || this.attackTarget.field_70181_x <= 0.0;
            lookY -= yFall;
            if (this.fireAtFeet > 0.0 && this.entityHost.field_70170_p.func_147447_a(new Vec3d(this.entityHost.field_70165_t, this.entityHost.field_70163_u + (double)this.entityHost.func_70047_e(), this.entityHost.field_70161_v), new Vec3d(lookX, this.attackTarget.field_70163_u, lookZ), false, true, false) == null) {
                lookY -= (double)(this.attackTarget.field_70131_O / 2.0f) * this.fireAtFeet;
            }
        }
        this.lastMotionY = this.attackTarget.field_70181_x;
        boolean charged = weapon.holdingMode(item, (EntityLivingBase)this.entityHost) > 0 && weapon.getCharge((EntityLivingBase)this.entityHost, item) >= this.releaseAt;
        boolean bl = stay = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget) || this.projSpeed > 0.0f && this.attackTarget.field_70181_x > 0.0;
        boolean bl2 = stay && this.entityHost.func_70660_b(TF2weapons.stun) == null && shouldFireProj && !charged && TF2Util.lookingAt((EntityLivingBase)this.entityHost, (double)((this.explosive && d0 < 16.0 ? 30 : 0) + 2) + Math.toDegrees(MathHelper.func_181159_b((double)(this.attackTarget.field_70130_N / 2.0f), (double)dist)), lookX, lookY, lookZ) ? true : (fire = false);
        if (!(this.reloading || this.entityHost.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && fire || weapon.getClip(item) != 0 || !weapon.hasClip(item))) {
            this.reloading = true;
        } else if (this.reloading && (weapon.getClip(item) == weapon.getWeaponClipSize(item, (EntityLivingBase)this.entityHost) || this.entityHost.getAmmo() == 0)) {
            this.reloading = false;
        }
        this.entityHost.func_70671_ap().func_75650_a(lookX, lookY, lookZ, this.entityHost.rotation, 90.0f);
        if (!this.reloading && fire) {
            float f = this.attackTarget instanceof EntityBuilding ? this.attackRangeSSquared : this.attackRangeSquared;
            if (d0 <= (double)f && ((ItemUsable)item.func_77973_b()).isAmmoSufficient(item, (EntityLivingBase)this.entityHost, true) && ((ItemUsable)item.func_77973_b()).shouldEntityFire(item, (EntityLivingBase)this.entityHost, this.attackTarget)) {
                this.reloading = false;
                if (this.pressed) return;
                this.pressed = true;
                int state = this.entityHost.getState(true);
                weapon.startUse(item, (EntityLivingBase)this.entityHost, this.entityHost.field_70170_p, this.entityHost.getCapability(TF2weapons.WEAPONS_CAP, null).state, state);
                this.entityHost.getCapability(TF2weapons.WEAPONS_CAP, null).state = state;
                TF2Util.sendTracking(new TF2Message.ActionMessage(state, (EntityLivingBase)this.entityHost), (Entity)this.entityHost);
                return;
            }
        }
        if (!(weapon.getCharge((EntityLivingBase)this.entityHost, item) >= this.releaseAt)) return;
        if (this.pressed) {
            if (this.jump) {
                this.entityHost.jump = false;
            }
            int valuedef = this.entityHost.getState(false);
            weapon.endUse(item, (EntityLivingBase)this.entityHost, this.entityHost.field_70170_p, this.entityHost.getCapability(TF2weapons.WEAPONS_CAP, null).state, valuedef);
            this.entityHost.getCapability(TF2weapons.WEAPONS_CAP, null).state = valuedef;
            TF2Util.sendTracking(new TF2Message.ActionMessage(valuedef, (EntityLivingBase)this.entityHost), (Entity)this.entityHost);
        }
        this.pressed = false;
    }
}

