/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.ai;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.Team;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.item.ItemDisguiseKit;
import rafradek.TF2weapons.util.TF2Util;

public class EntityAISpotTarget
extends EntityAIBase {
    protected final EntityBuilding taskOwner;
    protected boolean shouldCheckSight;
    private final boolean nearbyOnly;
    private int targetSearchStatus;
    private int targetSearchDelay;
    protected EntityLivingBase target;
    protected int unseenMemoryTicks;
    public int targetChoosen = 0;
    private Class<? extends EntityLivingBase> targetClass;
    private EntityAINearestAttackableTarget.Sorter theNearestAttackableTargetSorter;
    private Predicate<EntityLivingBase> targetEntitySelector;
    public EntityLivingBase targetEntity;
    private boolean targetLock;
    private int targetUnseenTicks;

    public <A extends EntityLivingBase> EntityAISpotTarget(EntityBuilding p_i1665_1_, Class<A> p_i1665_2_, boolean p_i1665_4_, boolean p_i1665_5_, final Predicate<A> p_i1665_6_, boolean targetLock, final boolean allowBehind) {
        this.nearbyOnly = p_i1665_4_;
        this.shouldCheckSight = p_i1665_5_;
        this.taskOwner = p_i1665_1_;
        this.targetClass = p_i1665_2_;
        this.theNearestAttackableTargetSorter = new EntityAINearestAttackableTarget.Sorter((Entity)p_i1665_1_);
        this.func_75248_a(1);
        this.targetLock = targetLock;
        this.targetEntitySelector = new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase target) {
                if (p_i1665_6_ != null && !p_i1665_6_.apply((Object)target)) {
                    return false;
                }
                if (target instanceof EntityLivingBase) {
                    double d0 = EntityAISpotTarget.this.getTargetDistance();
                    if (target.func_70093_af()) {
                        d0 *= (double)0.8f;
                    }
                    if (target instanceof EntityPlayer && target.func_82150_aj()) {
                        float f = ((EntityPlayer)target).func_82243_bO();
                        if (f < 0.1f) {
                            f = 0.1f;
                        }
                        d0 *= (double)(0.7f * f);
                    }
                    if (target.hasCapability(TF2weapons.WEAPONS_CAP, null) && (((WeaponsCapability)target.getCapability(TF2weapons.WEAPONS_CAP, null)).invisTicks >= 20 || ItemDisguiseKit.isDisguised(target, (EntityLivingBase)EntityAISpotTarget.this.taskOwner))) {
                        d0 = 0.0;
                    }
                    boolean fastCheck = allowBehind;
                    if ((double)target.func_70032_d((Entity)EntityAISpotTarget.this.taskOwner) > d0 || !fastCheck && !TF2Util.lookingAtFast((EntityLivingBase)EntityAISpotTarget.this.taskOwner, 86.0, target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v)) {
                        return false;
                    }
                }
                return EntityAISpotTarget.this.isSuitableTarget(target, false);
            }
        };
    }

    protected double getTargetDistance() {
        IAttributeInstance iattributeinstance = this.taskOwner.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
    }

    public void func_75251_c() {
        this.taskOwner.func_70624_b(null);
        this.target = null;
    }

    public boolean func_75250_a() {
        double d0 = this.getTargetDistance() / 2.0;
        if (this.taskOwner.func_70638_az() == null || this.taskOwner.func_70638_az().func_70068_e((Entity)this.taskOwner) > d0 * d0) {
            ++this.targetChoosen;
        }
        if (this.taskOwner.func_70638_az() == null && this.targetChoosen > 1 || this.targetChoosen > 5 || !this.targetLock) {
            this.targetChoosen = 0;
            double d1 = this.getTargetDistance();
            List list = this.taskOwner.field_70170_p.func_175647_a(this.targetClass, this.taskOwner.func_174813_aQ().func_72314_b(d1, d0, d1), this.targetEntitySelector);
            Collections.sort(list, this.theNearestAttackableTargetSorter);
            if (list.isEmpty()) {
                return false;
            }
            this.targetEntity = (EntityLivingBase)list.get(0);
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.taskOwner.func_70624_b(this.targetEntity);
        super.func_75249_e();
        this.targetSearchStatus = 0;
        this.targetSearchDelay = 0;
        this.targetUnseenTicks = 0;
    }

    public boolean func_75253_b() {
        EntityLivingBase entitylivingbase = this.taskOwner.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (!this.targetLock && this.taskOwner.field_70173_aa % 13 == 0) {
            return this.func_75250_a();
        }
        Team team = this.taskOwner.func_96124_cp();
        Team team1 = entitylivingbase.func_96124_cp();
        if (team != null && team1 == team) {
            return false;
        }
        double d0 = this.getTargetDistance();
        if (this.taskOwner.func_70068_e((Entity)entitylivingbase) > d0 * d0) {
            return false;
        }
        if (this.shouldCheckSight) {
            if (this.taskOwner.func_70635_at().func_75522_a((Entity)entitylivingbase)) {
                this.targetUnseenTicks = 0;
            } else if (++this.targetUnseenTicks > 60) {
                return false;
            }
        }
        return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a;
    }

    protected boolean isSuitableTarget(EntityLivingBase target, boolean includeInvincibles) {
        if (target == null) {
            return false;
        }
        if (target == this.taskOwner) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        if (!this.taskOwner.func_70686_a(target.getClass())) {
            return false;
        }
        Team team = this.taskOwner.func_96124_cp();
        Team team1 = target.func_96124_cp();
        if (team != null && team1 == team) {
            return false;
        }
        if (this.taskOwner instanceof IEntityOwnable && this.taskOwner.func_184753_b() != null) {
            if (target instanceof IEntityOwnable && this.taskOwner.func_184753_b().equals(((IEntityOwnable)target).func_184753_b())) {
                return false;
            }
            if (target == this.taskOwner.func_70902_q()) {
                return false;
            }
        }
        if (target instanceof EntityPlayer && !includeInvincibles && ((EntityPlayer)target).field_71075_bZ.field_75102_a) {
            return false;
        }
        return !this.shouldCheckSight || this.taskOwner.func_70635_at().func_75522_a((Entity)target);
    }
}

