/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity.ai;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.building.EntityDispenser;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.entity.mercenary.EntityEngineer;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemPDA;
import rafradek.TF2weapons.util.TF2Util;

public class EntityAISetup
extends EntityAIBase {
    public EntityEngineer engineer;
    public int buildType;
    public boolean found;
    public Vec3d target;

    public EntityAISetup(EntityEngineer engineer) {
        this.engineer = engineer;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.engineer.getMainWeapon() != -1) {
            return false;
        }
        if (this.engineer.func_70902_q() != null && this.engineer.getOrder() == EntityTF2Character.Order.FOLLOW) {
            return false;
        }
        if (this.engineer.grabbed != null) {
            this.buildType = this.engineer.grabbedid + 1;
            return true;
        }
        if (this.engineer.func_70090_H() || !(this.engineer.loadout.getStackInSlot(3).func_77973_b() instanceof ItemPDA)) {
            return false;
        }
        boolean dispensernear = TF2Util.findAmmoSource((EntityLivingBase)this.engineer, 16.0, false) != null;
        boolean sentryalive = this.engineer.sentry != null && this.engineer.sentry.func_70089_S();
        boolean dispenseralive = this.engineer.dispenser != null && this.engineer.dispenser.func_70089_S();
        boolean sentryhome = sentryalive && this.engineer.func_180485_d(this.engineer.sentry.func_180425_c());
        boolean dispenserhome = dispenseralive && this.engineer.func_180485_d(this.engineer.dispenser.func_180425_c());
        int sentryCost = EntityBuilding.getCost(0, this.engineer.loadout.getStackInSlot(2));
        if (sentryalive) {
            sentryCost /= 2;
        }
        int dispenserCost = EntityBuilding.getCost(1, this.engineer.loadout.getStackInSlot(2));
        if (dispenseralive) {
            dispenserCost /= 2;
        }
        int n = this.engineer.getWepCapability().getMetal() >= sentryCost && !sentryhome && (dispensernear || this.engineer.getWepCapability().getMetal() >= sentryCost + dispenserCost) ? 1 : (this.buildType = this.engineer.getWepCapability().getMetal() >= dispenserCost && !dispenserhome ? 2 : 0);
        if (this.buildType > 0) {
            this.engineer.loadout.getStackInSlot(3).func_77978_p().func_74774_a("Building", (byte)this.buildType);
            this.engineer.switchSlot(3);
        }
        return this.buildType > 0;
    }

    public void func_75249_e() {
    }

    public void func_75251_c() {
        this.engineer.func_70661_as().func_75499_g();
        this.engineer.switchSlot(0);
        if (this.engineer.loadout.getStackInSlot(3).func_77973_b() instanceof ItemPDA) {
            this.engineer.loadout.getStackInSlot(3).func_77978_p().func_74774_a("Building", (byte)0);
        }
    }

    public void func_75246_d() {
        if (this.buildType > 0) {
            AxisAlignedBB box;
            List list;
            int size;
            Vec3d Vec3d2;
            if (this.target != null && this.engineer.func_70092_e(this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c) < 2.0) {
                EntityBuilding building = this.spawn();
                if (this.engineer.grabbed == null) {
                    this.engineer.getWepCapability().setMetal(this.engineer.getWepCapability().getMetal() - EntityBuilding.getCost(this.buildType - 1, this.engineer.loadout.getStackInSlot(2)));
                }
                if (building instanceof EntitySentry) {
                    this.engineer.sentry = (EntitySentry)building;
                } else if (building instanceof EntityDispenser) {
                    this.engineer.dispenser = (EntityDispenser)building;
                }
                this.engineer.grabbed = null;
                this.engineer.grabbedid = 0;
                return;
            }
            if (this.engineer.func_70661_as().func_75500_f() && (Vec3d2 = RandomPositionGenerator.func_75463_a((EntityCreature)this.engineer, (int)((size = 1 + this.buildType == 1 ? 1 : 0) + 1), (int)size)) != null && (list = this.engineer.field_70170_p.func_184144_a((Entity)this.engineer, box = new AxisAlignedBB(Vec3d2.field_72450_a - 0.5, Vec3d2.field_72448_b, Vec3d2.field_72449_c - 0.5, Vec3d2.field_72450_a + 0.5, Vec3d2.field_72448_b + 1.0, Vec3d2.field_72449_c + 0.5))).isEmpty() && !this.engineer.field_70170_p.func_72875_a(box, Material.field_151586_h)) {
                this.engineer.func_70661_as().func_75492_a(Vec3d2.field_72450_a, Vec3d2.field_72448_b, Vec3d2.field_72449_c, 1.0);
                this.target = Vec3d2;
            }
        }
    }

    public EntityBuilding spawn() {
        IBlockState blockTarget;
        EntityBuilding building;
        if (this.buildType == 1) {
            if (this.engineer.sentry != null && this.engineer.sentry.func_70089_S()) {
                this.engineer.sentry.detonate();
            }
            building = new EntitySentry(this.engineer.field_70170_p);
        } else {
            if (this.engineer.dispenser != null && this.engineer.dispenser.func_70089_S()) {
                this.engineer.dispenser.detonate();
            }
            building = new EntityDispenser(this.engineer.field_70170_p);
        }
        ItemStack pda = this.engineer.loadout.getStackInSlot(3);
        if (building instanceof EntitySentry) {
            TF2Util.addModifierSafe((EntityLivingBase)building, SharedMonsterAttributes.field_111265_b, new AttributeModifier("upgraderange", (double)(TF2Attribute.getModifier("Sentry Range", pda, 1.0f, (EntityLivingBase)this.engineer) - 1.0f), 2), true);
            ((EntitySentry)building).attackRateMult = TF2Attribute.getModifier("Sentry Fire Rate", pda, 1.0f, (EntityLivingBase)this.engineer);
            ((EntitySentry)building).setHeat((int)TF2Attribute.getModifier("Piercing", pda, 0.0f, (EntityLivingBase)this.engineer));
        }
        TF2Util.addModifierSafe((EntityLivingBase)building, SharedMonsterAttributes.field_111267_a, new AttributeModifier(EntityBuilding.UPGRADE_HEALTH_UUID, "upgradehealth", (double)(TF2Attribute.getModifier("Building Health", pda, 1.0f, (EntityLivingBase)this.engineer) - 1.0f), 2), true);
        if (building instanceof EntityDispenser) {
            ((EntityDispenser)building).setRange(TF2Attribute.getModifier("Dispenser Range", pda, 1.0f, (EntityLivingBase)this.engineer));
        }
        if (this.engineer.grabbed != null) {
            building.func_70020_e(this.engineer.grabbed);
            building.setConstructing(true);
            building.redeploy = true;
        }
        if (!(blockTarget = this.engineer.field_70170_p.func_180495_p(new BlockPos(this.target))).func_177230_c().func_176205_b((IBlockAccess)this.engineer.field_70170_p, new BlockPos(this.target))) {
            building.func_70107_b(this.target.field_72450_a, this.target.field_72448_b + 1.3, this.target.field_72449_c);
        } else {
            building.func_70107_b(this.target.field_72450_a, this.target.field_72448_b + 0.3, this.target.field_72449_c);
        }
        building.setEntTeam(this.engineer.getEntTeam());
        building.setOwner((EntityLivingBase)this.engineer);
        if (building instanceof EntitySentry && TF2Attribute.getModifier("Weapon Mode", this.engineer.loadout.getStackInSlot(2), 0.0f, (EntityLivingBase)this.engineer) == 2.0f) {
            ((EntitySentry)building).setMini(true);
        }
        this.engineer.field_70170_p.func_72838_d((Entity)building);
        this.target = null;
        this.buildType = 0;
        this.func_75251_c();
        ++this.engineer.buildCount;
        return building;
    }
}

