/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.item.ItemStatue;

public class EntityStatue
extends Entity
implements IEntityAdditionalSpawnData {
    public EntityLivingBase entity;
    public NBTTagCompound data;
    public boolean isFeign;
    public float renderYawOffset;
    public boolean first;
    public boolean clientOnly;
    public int ticksLeft;
    public boolean player;
    public boolean useHand;
    public GameProfile profile;
    public float armSwing;

    public EntityStatue(World worldIn) {
        super(worldIn);
    }

    public EntityStatue(World worldIn, EntityLivingBase toCopy, boolean isFeign) {
        super(worldIn);
        this.func_70107_b(toCopy.field_70165_t, toCopy.field_70163_u, toCopy.field_70161_v);
        this.field_70130_N = toCopy.field_70130_N;
        this.field_70131_O = toCopy.field_70131_O;
        this.entity = toCopy;
        if (!this.field_70170_p.field_72995_K) {
            if (toCopy instanceof EntityPlayer) {
                this.data = toCopy.func_189511_e(new NBTTagCompound());
                this.player = true;
                this.profile = ((EntityPlayer)toCopy).func_146103_bH();
            } else {
                this.data = toCopy.serializeNBT();
            }
            this.ticksLeft = toCopy instanceof EntityPlayer || !toCopy.func_184222_aU() ? -1 : 1200;
            this.useHand = toCopy.hasCapability(TF2weapons.WEAPONS_CAP, null) && ((WeaponsCapability.get((Entity)toCopy).state & 3) != 0 || WeaponsCapability.get((Entity)toCopy).isCharging());
        } else {
            this.clientOnly = true;
        }
        this.isFeign = isFeign;
        if (!isFeign) {
            this.entity.field_70725_aQ = 0;
            this.entity.field_70737_aN = 0;
            this.renderYawOffset = toCopy.field_70761_aq;
            this.field_70126_B = this.entity.field_70126_B;
            this.field_70177_z = this.entity.field_70177_z;
        } else {
            this.field_70159_w = this.entity.field_70159_w;
            this.field_70181_x = this.entity.field_70181_x;
            this.field_70179_y = this.entity.field_70179_y;
        }
    }

    protected void func_70088_a() {
    }

    public boolean func_70067_L() {
        return !this.field_70128_L && !this.clientOnly;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.field_76373_n.equals("player")) {
            if (this.data != null) {
                this.func_70099_a(ItemStatue.getStatue(this), 0.0f);
            }
            this.func_70106_y();
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        if (this.field_70122_E) {
            this.field_70159_w *= 0.1;
            this.field_70179_y *= 0.1;
        }
        this.field_70159_w *= 0.98;
        this.field_70181_x *= 0.98;
        this.field_70179_y *= 0.98;
        this.field_70181_x -= 0.08;
        if (!this.field_70170_p.field_72995_K && this.ticksLeft >= 0 && --this.ticksLeft <= 0) {
            this.func_70106_y();
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.isFeign && this.field_70173_aa >= 20) {
            this.func_70106_y();
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        if (!TF2ConfigVars.australiumStatue) {
            this.func_70106_y();
            return;
        }
        this.data = compound.func_74775_l("Entity");
        this.ticksLeft = compound.func_74765_d("TicksLeft");
        this.player = compound.func_74767_n("Player");
        if (this.player) {
            this.profile = NBTUtil.func_152459_a((NBTTagCompound)compound.func_74775_l("Profile"));
        }
        this.useHand = compound.func_74767_n("UseArm");
    }

    public void func_70014_b(NBTTagCompound compound) {
        try {
            NBTTagCompound tag = this.data;
            if (tag != null) {
                compound.func_74782_a("Entity", (NBTBase)tag);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        compound.func_74777_a("TicksLeft", (short)this.ticksLeft);
        if (this.profile != null) {
            compound.func_74782_a("Profile", (NBTBase)NBTUtil.func_180708_a((NBTTagCompound)new NBTTagCompound(), (GameProfile)this.profile));
        }
        compound.func_74757_a("Player", this.player);
        compound.func_74757_a("UseArm", this.useHand);
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (!this.first) {
            PacketBuffer buff = new PacketBuffer(buffer);
            buffer.writeBoolean(this.player);
            if (this.profile != null) {
                buff.func_179252_a(this.profile.getId());
                buff.func_180714_a(this.profile.getName());
                buff.func_150787_b(this.profile.getProperties().size());
                for (Property property : this.profile.getProperties().values()) {
                    buff.func_180714_a(property.getName());
                    buff.func_180714_a(property.getValue());
                    if (property.hasSignature()) {
                        buff.writeBoolean(true);
                        buff.func_180714_a(property.getSignature());
                        continue;
                    }
                    buff.writeBoolean(false);
                }
            }
            int pos = buff.writerIndex();
            buff.func_150786_a(this.data);
            if (buff.writerIndex() - pos >= 0x200000) {
                buff.clear();
            }
            buff.writeBoolean(this.useHand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void readSpawnData(ByteBuf additionalData) {
        if (additionalData.readableBytes() == 0) {
            return;
        }
        try {
            PacketBuffer buff = new PacketBuffer(additionalData);
            if (buff.readBoolean()) {
                this.profile = new GameProfile(buff.func_179253_g(), buff.func_150789_c(16));
                int l = buff.func_150792_a();
                for (int i1 = 0; i1 < l; ++i1) {
                    String s = buff.func_150789_c(Short.MAX_VALUE);
                    String s1 = buff.func_150789_c(Short.MAX_VALUE);
                    if (buff.readBoolean()) {
                        this.profile.getProperties().put((Object)s, (Object)new Property(s, s1, buff.func_150789_c(Short.MAX_VALUE)));
                        continue;
                    }
                    this.profile.getProperties().put((Object)s, (Object)new Property(s, s1));
                }
                final NetworkPlayerInfo info = new NetworkPlayerInfo(this.profile);
                this.entity = new EntityOtherPlayerMP(this.field_70170_p, this.profile){

                    @Nullable
                    protected NetworkPlayerInfo func_175155_b() {
                        return info;
                    }
                };
                this.entity.func_70020_e(buff.func_150793_b());
            } else {
                this.entity = (EntityLivingBase)EntityList.func_75615_a((NBTTagCompound)buff.func_150793_b(), (World)this.field_70170_p);
            }
            if (this.entity == null) {
                this.func_70106_y();
                return;
            }
            this.entity.field_70725_aQ = 0;
            this.entity.field_70737_aN = 0;
            this.entity.field_70721_aZ = 0.5f;
            this.entity.field_70173_aa = 15;
            this.entity.field_184619_aG += this.field_70146_Z.nextFloat() * 10.0f;
            this.func_70105_a(this.entity.field_70130_N, this.entity.field_70131_O);
            this.entity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.entity.field_70759_as = this.field_70177_z;
            this.entity.field_70761_aq = this.field_70177_z;
            this.entity.field_70760_ar = this.field_70177_z;
            if (buff.readBoolean()) {
                WeaponsCapability.get((Entity)this.entity).state = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

