/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.contract;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.AdvancementTreeNode;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContractManager
extends AdvancementManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final AdvancementList ADVANCEMENT_LIST = new AdvancementList();

    public ContractManager(File advancementsDirIn) {
        super(advancementsDirIn);
    }

    public void func_192779_a() {
        ADVANCEMENT_LIST.func_192087_a();
        HashMap map = Maps.newHashMap();
        this.loadBuiltInAdvancements(map);
        ADVANCEMENT_LIST.func_192083_a((Map)map);
        for (Advancement advancement : ADVANCEMENT_LIST.func_192088_b()) {
            if (advancement.func_192068_c() == null) continue;
            AdvancementTreeNode.func_192323_a((Advancement)advancement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadBuiltInAdvancements(Map<ResourceLocation, Advancement.Builder> map) {
        Iterator iterator;
        Path path;
        FileSystem filesystem = null;
        try {
            URL url = AdvancementManager.class.getResource("/assets/.mcassetsroot");
            if (url != null) {
                URI uri = url.toURI();
                if ("file".equals(uri.getScheme())) {
                    path = Paths.get(CraftingManager.class.getResource("/assets/minecraft/advancements").toURI());
                } else {
                    if (!"jar".equals(uri.getScheme())) {
                        LOGGER.error("Unsupported scheme " + uri + " trying to list all built-in advancements (NYI?)");
                        IOUtils.closeQuietly((Closeable)filesystem);
                        return;
                    }
                    filesystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    path = filesystem.getPath("/assets/minecraft/advancements", new String[0]);
                }
            } else {
                LOGGER.error("Couldn't find .mcassetsroot");
                return;
            }
            iterator = Files.walk(path, new FileVisitOption[0]).iterator();
        }
        catch (IOException | URISyntaxException urisyntaxexception) {
            LOGGER.error("Couldn't get a list of all built-in advancement files", (Throwable)urisyntaxexception);
            return;
        }
        finally {
            IOUtils.closeQuietly(filesystem);
        }
        while (iterator.hasNext()) {
            Path path2;
            String s;
            ResourceLocation resourcelocation;
            Path path1 = (Path)iterator.next();
            if (!"json".equals(FilenameUtils.getExtension((String)path1.toString())) || map.containsKey(resourcelocation = new ResourceLocation("minecraft", s = FilenameUtils.removeExtension((String)(path2 = path.relativize(path1)).toString()).replaceAll("\\\\", "/")))) continue;
            BufferedReader bufferedreader = null;
            try {
                bufferedreader = Files.newBufferedReader(path1);
                Advancement.Builder advancement$builder = (Advancement.Builder)JsonUtils.func_193839_a((Gson)field_192783_b, (Reader)bufferedreader, Advancement.Builder.class);
                map.put(resourcelocation, advancement$builder);
            }
            catch (JsonParseException jsonparseexception) {
                LOGGER.error("Parsing error loading built-in advancement " + resourcelocation, (Throwable)jsonparseexception);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't read advancement " + resourcelocation + " from " + path1, (Throwable)ioexception);
            }
            finally {
                IOUtils.closeQuietly((Reader)bufferedreader);
            }
        }
        IOUtils.closeQuietly((Closeable)filesystem);
    }

    @Nullable
    public Advancement func_192778_a(ResourceLocation id) {
        return ADVANCEMENT_LIST.func_192084_a(id);
    }

    public Iterable<Advancement> func_192780_b() {
        return ADVANCEMENT_LIST.func_192089_c();
    }
}

