/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.common;

import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.entity.mercenary.EntityEngineer;
import rafradek.TF2weapons.entity.mercenary.EntityMedic;
import rafradek.TF2weapons.entity.mercenary.EntityScout;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.entity.projectile.EntityStickybomb;
import rafradek.TF2weapons.item.ItemChargingTarge;
import rafradek.TF2weapons.item.ItemCloak;
import rafradek.TF2weapons.item.ItemHuntsman;
import rafradek.TF2weapons.item.ItemMinigun;
import rafradek.TF2weapons.item.ItemParachute;
import rafradek.TF2weapons.item.ItemSapper;
import rafradek.TF2weapons.item.ItemSniperRifle;
import rafradek.TF2weapons.item.ItemToken;
import rafradek.TF2weapons.item.ItemUsable;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.potion.PotionTF2;
import rafradek.TF2weapons.potion.PotionTF2Item;
import rafradek.TF2weapons.util.TF2Util;
import rafradek.TF2weapons.util.WeaponData;

public class WeaponsCapability
implements ICapabilityProvider,
INBTSerializable<NBTTagCompound> {
    public static final int MAX_METAL = 200;
    public static final int MAX_METAL_ENGINEER = 500;
    public static final int PLAYER_MINCOOL = -200;
    public EntityLivingBase owner;
    public int state;
    public int minigunTicks;
    public EnumHand reloadingHand;
    public int reloadCool;
    public int lastFire;
    public boolean mainHand;
    public HashMap<String, Integer> effectsCool = new HashMap();
    public int chargeTicks;
    public int critTimeCool;
    public Deque<TF2Message.PredictionMessage>[] predictionList = new Deque[8];
    public float recoil;
    public int invisTicks;
    public int disguiseTicks;
    public boolean pressedStart;
    public int airJumps;
    public EntitySentry controlledSentry;
    public ResourceLocation skinDisguise;
    public boolean skinRetrieved;
    public String lastDisguiseValue;
    public boolean lastDisgused;
    public String skinType;
    public int ticksBash;
    public boolean bashCritical;
    public int collectedHeadsTime;
    public boolean wornEye;
    public int killsSpinning;
    public int tickAirblasted;
    public int itProtection;
    public int killsAirborne;
    public int focusShotTicks;
    public int focusShotRemaining;
    public int fanCool;
    public boolean appliedMouseSlow;
    public int hitNoMiss;
    public int sentryTargets = 5;
    public boolean dispenserPlayer;
    public boolean teleporterPlayer;
    public boolean teleporterEntity;
    public boolean forcedClass;
    public float lastHitCharge;
    public EntityDataManager dataManager;
    public EntityLivingBase entityDisguise;
    public ArrayList<EntityStickybomb> activeBomb = new ArrayList();
    public float oldFactor;
    public int expJumpGround;
    public double lastPosX;
    public double lastPosY;
    public double lastPosZ;
    public ItemStack lastWeapon = ItemStack.field_190927_a;
    public long ticksTotal;
    public boolean fireCoolReduced;
    public boolean autoFire;
    public EntityLivingBase lastAttacked;
    public boolean stabbedDisguise;
    private boolean canExpJump = true;
    public double gravity = -0.08;
    public float maxmetal = 1.0f;
    public float damageArmorMin;
    public EnumMap<EnumHand, ItemStack> stackActive = new EnumMap(EnumHand.class);
    private float[] rageDrain = new float[RageType.values().length];
    private static final DataParameter<Boolean> EXP_JUMP = new DataParameter(6, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CHARGING = new DataParameter(11, DataSerializers.field_187198_h);
    private static final DataParameter<String> DISGUISE_TYPE = new DataParameter(7, DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> DISGUISED = new DataParameter(8, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> INVIS = new DataParameter(9, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FEIGN = new DataParameter(10, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> CRIT_TIME = new DataParameter(0, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HEADS = new DataParameter(1, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HEAL_TARGET = new DataParameter(2, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> METAL = new DataParameter(3, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TOKEN_USED = new DataParameter(12, DataSerializers.field_187192_b);
    private static final DataParameter<Byte> CAN_FIRE = new DataParameter(13, DataSerializers.field_187191_a);
    private static final EnumMap<RageType, DataParameter<Float>> RAGE = new EnumMap(RageType.class);
    private static final EnumMap<RageType, DataParameter<Boolean>> RAGE_ACTIVE = new EnumMap(RageType.class);
    public static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());

    public WeaponsCapability(EntityLivingBase entity) {
        this.owner = entity;
        for (int i = 0; i < this.predictionList.length; ++i) {
            this.predictionList[i] = new ArrayDeque<TF2Message.PredictionMessage>();
        }
        this.dataManager = new EntityDataManager((Entity)entity);
        this.dataManager.func_187214_a(CRIT_TIME, (Object)0);
        this.dataManager.func_187214_a(HEADS, (Object)0);
        this.dataManager.func_187214_a(HEAL_TARGET, (Object)-1);
        this.dataManager.func_187214_a(METAL, (Object)200);
        this.dataManager.func_187214_a(FEIGN, (Object)false);
        this.dataManager.func_187214_a(INVIS, (Object)false);
        this.dataManager.func_187214_a(DISGUISED, (Object)false);
        this.dataManager.func_187214_a(DISGUISE_TYPE, (Object)"");
        this.dataManager.func_187214_a(EXP_JUMP, (Object)false);
        this.dataManager.func_187214_a(CHARGING, (Object)false);
        this.dataManager.func_187214_a(TOKEN_USED, (Object)-1);
        this.dataManager.func_187214_a(CAN_FIRE, (Object)0);
        for (RageType type : RageType.values()) {
            this.dataManager.func_187214_a(RAGE.get((Object)type), (Object)Float.valueOf(0.0f));
            this.dataManager.func_187214_a(RAGE_ACTIVE.get((Object)type), (Object)false);
        }
    }

    public int getCritTime() {
        return (Integer)this.dataManager.func_187225_a(CRIT_TIME);
    }

    public void setCritTime(int time) {
        this.dataManager.func_187227_b(CRIT_TIME, (Object)time);
    }

    public int getHealTarget() {
        return (Integer)this.dataManager.func_187225_a(HEAL_TARGET);
    }

    public void setHealTarget(int target) {
        this.dataManager.func_187227_b(HEAL_TARGET, (Object)target);
    }

    public int getHeads() {
        return (Integer)this.dataManager.func_187225_a(HEADS);
    }

    public int getMetal() {
        return (Integer)this.dataManager.func_187225_a(METAL);
    }

    public boolean hasMetal(int metal) {
        boolean hasIngot = this.owner instanceof EntityPlayer && TF2Util.hasEnoughItem((IInventory)((EntityPlayer)this.owner).field_71071_by, (Predicate<ItemStack>)((Predicate)stackL -> stackL.func_77973_b() == Items.field_151042_j), MathHelper.func_76123_f((float)((float)(metal - this.getMetal()) / 50.0f)));
        return hasIngot || this.getMetal() >= metal;
    }

    public int consumeMetal(int metal, boolean allowPartial) {
        int usedMetal = 0;
        if (this.owner instanceof EntityPlayer) {
            ItemStack ingot = new ItemStack(Items.field_151042_j);
            while ((allowPartial && this.getMetal() == 0 || !allowPartial && this.getMetal() < metal) && ((EntityPlayer)this.owner).field_71071_by.func_70431_c(ingot)) {
                ((EntityPlayer)this.owner).field_71071_by.func_174925_a(Items.field_151042_j, 0, 1, null);
                this.setMetal(this.getMetal() + 50);
            }
        }
        if (allowPartial || this.getMetal() >= metal) {
            usedMetal = Math.min(this.getMetal(), metal);
            this.setMetal(this.getMetal() - usedMetal);
        }
        return usedMetal;
    }

    public void setMetal(int metal) {
        this.dataManager.func_187227_b(METAL, (Object)MathHelper.func_76125_a((int)metal, (int)0, (int)this.getMaxMetal()));
    }

    public void giveMetal(int metal) {
        this.dataManager.func_187227_b(METAL, (Object)MathHelper.func_76125_a((int)(this.getMetal() + metal), (int)0, (int)this.getMaxMetal()));
    }

    public int getMaxMetal() {
        return (int)((float)(this.owner instanceof EntityEngineer ? TF2ConfigVars.maxMetalEngineer : 200) * this.maxmetal);
    }

    public float getRage(RageType type) {
        if (type == null) {
            return 0.0f;
        }
        return ((Float)this.dataManager.func_187225_a(RAGE.get((Object)type))).floatValue();
    }

    public void setRage(RageType type, float rage) {
        this.dataManager.func_187227_b(RAGE.get((Object)type), (Object)Float.valueOf(rage));
    }

    public boolean isRageActive(RageType type) {
        if (type == null) {
            return false;
        }
        return (Boolean)this.dataManager.func_187225_a(RAGE_ACTIVE.get((Object)type));
    }

    public void setRageActive(RageType type, boolean active, float drain) {
        this.dataManager.func_187227_b(RAGE_ACTIVE.get((Object)type), (Object)active);
        this.rageDrain[type.ordinal()] = active ? drain * 0.1f : 0.0f;
    }

    public boolean isInvisible() {
        return (Boolean)this.dataManager.func_187225_a(INVIS);
    }

    public void setInvisible(boolean invis) {
        this.dataManager.func_187227_b(INVIS, (Object)invis);
    }

    public void setDisguised(boolean val) {
        this.dataManager.func_187227_b(DISGUISED, (Object)val);
        this.disguiseTicks = 0;
        if (!val) {
            this.stabbedDisguise = false;
        }
    }

    public boolean isDisguised() {
        return (Boolean)this.dataManager.func_187225_a(DISGUISED);
    }

    public void setExpJump(boolean val) {
        this.dataManager.func_187227_b(EXP_JUMP, (Object)val);
        if (val && !this.owner.field_70170_p.field_72995_K) {
            this.expJumpGround = 2;
            TF2Util.sendTracking(new TF2Message.ActionMessage(28, this.owner), (Entity)this.owner);
        }
    }

    public boolean isExpJump() {
        return (Boolean)this.dataManager.func_187225_a(EXP_JUMP);
    }

    public void setDisguiseType(String val) {
        this.dataManager.func_187227_b(DISGUISE_TYPE, (Object)val);
    }

    public String getDisguiseType() {
        return (String)this.dataManager.func_187225_a(DISGUISE_TYPE);
    }

    public void setFeign(boolean val) {
        this.dataManager.func_187227_b(FEIGN, (Object)val);
    }

    public boolean isFeign() {
        return (Boolean)this.dataManager.func_187225_a(FEIGN);
    }

    public void setCharging(boolean val) {
        this.dataManager.func_187227_b(CHARGING, (Object)val);
        if (!val) {
            this.chargeTicks = 0;
        }
    }

    public boolean isCharging() {
        return (Boolean)this.dataManager.func_187225_a(CHARGING);
    }

    public void setUsedToken(int val) {
        this.dataManager.func_187227_b(TOKEN_USED, (Object)val);
    }

    public int getUsedToken() {
        return (Integer)this.dataManager.func_187225_a(TOKEN_USED);
    }

    public boolean canFire(EnumHand hand, boolean primary) {
        byte flags = (Byte)this.dataManager.func_187225_a(CAN_FIRE);
        return (flags & 1 << hand.ordinal()) == 1 << hand.ordinal() && ((flags & 4) == 4 && primary || (flags & 8) == 8 && !primary);
    }

    public void setCanFire(boolean fire, EnumHand hand, boolean primary) {
        int flag = 0;
        flag = hand == EnumHand.MAIN_HAND ? ++flag : (flag += 2);
        flag = primary ? (flag += 4) : (flag += 8);
        if (fire) {
            this.dataManager.func_187227_b(CAN_FIRE, (Object)((byte)((Byte)this.dataManager.func_187225_a(CAN_FIRE) | flag)));
        } else {
            this.dataManager.func_187227_b(CAN_FIRE, (Object)((byte)((Byte)this.dataManager.func_187225_a(CAN_FIRE) & ~flag)));
        }
    }

    public void addEffectCooldown(String name, int time) {
        this.effectsCool.put(name, time);
        if (this.owner instanceof EntityPlayerMP) {
            TF2weapons.network.sendTo(new TF2Message.EffectCooldownMessage(name, time), (EntityPlayerMP)this.owner);
        }
    }

    public void addHead(ItemStack weapon) {
        this.collectedHeadsTime = this.owner.field_70173_aa;
        this.dataManager.func_187227_b(HEADS, (Object)((Integer)this.dataManager.func_187225_a(HEADS) + 1));
        this.owner.func_70691_i(TF2Attribute.getModifier("Max Health Kill", weapon, 0.0f, this.owner));
    }

    public boolean focusedShot(ItemStack stack) {
        int stackLevel = (int)TF2Attribute.getModifier("Focus", stack, 0.0f, this.owner);
        return stackLevel > 0 && this.focusShotTicks > this.focusShotTime(stack);
    }

    public int focusShotTime(ItemStack stack) {
        int stackLevel = (int)TF2Attribute.getModifier("Focus", stack, 0.0f, this.owner);
        return 68 - stackLevel * 21 + ((ItemUsable)stack.func_77973_b()).getFiringSpeed(stack, this.owner) / 50;
    }

    public void onChangeValue(DataParameter<?> param, Object newValue) {
        if (param.func_187155_a() == 11 && !((Boolean)newValue).booleanValue()) {
            this.chargeTicks = 0;
        }
        if (param.func_187155_a() == 6 && ((Boolean)newValue).booleanValue()) {
            this.expJumpGround = 2;
        }
    }

    public boolean isUsingParachute() {
        ItemStack stack = this.owner.func_184582_a(EntityEquipmentSlot.CHEST);
        return stack.func_77973_b() instanceof ItemParachute && stack.func_77978_p().func_74767_n("Deployed");
    }

    public void tick() {
        Iterator<Map.Entry<String, Integer>> efiterator = this.effectsCool.entrySet().iterator();
        while (efiterator.hasNext()) {
            Map.Entry<String, Integer> entry = efiterator.next();
            entry.setValue(entry.getValue() - 1);
            if (entry.getValue() > 0) continue;
            efiterator.remove();
        }
        if (!this.owner.field_70170_p.field_72995_K && (Integer)this.dataManager.func_187225_a(HEADS) > 0 && this.collectedHeadsTime < this.owner.field_70173_aa - Math.max(100, 2000 - MathHelper.func_151239_c((int)((Integer)this.dataManager.func_187225_a(HEADS))) * 300)) {
            this.dataManager.func_187227_b(HEADS, (Object)((Integer)this.dataManager.func_187225_a(HEADS) - 1));
            this.collectedHeadsTime = this.owner.field_70173_aa;
        }
        --this.ticksBash;
        --this.itProtection;
        --this.fanCool;
        ++this.ticksTotal;
        this.lastFire -= 50;
        if (this.airJumps > 0 && this.owner.field_70122_E) {
            this.airJumps = 0;
        }
        if (this.owner.func_70051_ag() && this.getUsedToken() >= 0 && this.owner.field_70122_E) {
            this.owner.field_70159_w *= 0.82;
            this.owner.field_70179_y *= 0.82;
        }
        if (!this.owner.field_70170_p.field_72995_K && this.owner.field_70173_aa % 20 == 0 && (this.owner instanceof EntityMedic || this.getUsedToken() == 6)) {
            int lastHitTime = this.owner.field_70173_aa - this.owner.getEntityData().func_74762_e("lasthit");
            if (lastHitTime >= 120) {
                this.owner.func_70691_i(0.6f);
            } else if (lastHitTime >= 60) {
                this.owner.func_70691_i(TF2Util.lerp(0.6f, 0.3f, (float)(lastHitTime - 60) / 60.0f));
            } else {
                this.owner.func_70691_i(0.3f);
            }
        }
        if (this.owner.field_70170_p.field_72995_K && this.owner == Minecraft.func_71410_x().field_71439_g) {
            if (this.owner.func_184614_ca().func_77973_b() instanceof ItemSniperRifle && this.isCharging() && !this.appliedMouseSlow) {
                Minecraft.func_71410_x().field_71474_y.field_74341_c *= 0.4f;
                this.appliedMouseSlow = true;
            } else if (!this.isCharging() && this.appliedMouseSlow) {
                Minecraft.func_71410_x().field_71474_y.field_74341_c *= 2.5f;
                this.appliedMouseSlow = false;
            }
        }
        if (this.owner.field_70173_aa % 2 == 0) {
            for (RageType type : RageType.values()) {
                if (!this.isRageActive(type)) continue;
                this.setRage(type, Math.max(this.getRage(type) - this.rageDrain[type.ordinal()], 0.0f));
                if (!(this.getRage(type) <= 0.0f)) continue;
                this.setRageActive(type, false, 0.0f);
            }
        }
        if (this.reloadCool > 0) {
            this.reloadCool -= 50;
        }
        boolean hadItem = false;
        boolean continueReload = false;
        if (!this.owner.field_70170_p.field_72995_K && this.owner instanceof EntityPlayer && this.owner.field_70173_aa % 20 == 0) {
            this.maxmetal = TF2Attribute.getModifier("Max Metal", TF2Util.getBestItem((IInventory)((EntityPlayer)this.owner).field_71071_by, (stack1, stack2) -> (int)Math.signum(TF2Attribute.getModifier("Max Metal", stack1, 1.0f, this.owner) - TF2Attribute.getModifier("Max Metal", stack2, 1.0f, this.owner)), (Predicate<ItemStack>)((Predicate)stackl -> TF2Attribute.getModifier("Max Metal", stackl, 1.0f, this.owner) != 1.0f)), 1.0f, this.owner);
        }
        for (EnumHand hand : EnumHand.values()) {
            boolean isUseableWeapon;
            ItemStack stack = this.owner.func_184586_b(hand);
            boolean bl = isUseableWeapon = !stack.func_190926_b() && stack.func_77973_b() instanceof ItemUsable && (hand == EnumHand.MAIN_HAND || hand == EnumHand.OFF_HAND && !hadItem && ((ItemUsable)stack.func_77973_b()).getDoubleWieldBonus(stack, this.owner) != 1.0f || ItemUsable.isDoubleWielding(this.owner));
            if (isUseableWeapon) {
                EntityTF2Character shooter;
                hadItem = true;
                ItemUsable item = (ItemUsable)stack.func_77973_b();
                int state = item.getStateOverride(stack, this.owner, this.state);
                if (this.fireCoolReduced && this.owner.field_70170_p.field_72995_K) {
                    this.setPrimaryCooldown(hand, this.getPrimaryCooldown(hand) - (int)((float)item.getFiringSpeed(stack, this.owner) * (1.0f - 1.0f / TF2Attribute.getModifier("Fire Rate Hit", stack, 1.0f, this.owner))));
                    this.fireCoolReduced = false;
                }
                if (!(item instanceof ItemWeapon) || ((ItemWeapon)item).getClip(stack) == 0) {
                    this.autoFire = false;
                }
                if (!(this.owner instanceof EntityPlayer) || this.owner.field_70170_p.field_72995_K && this.owner != ClientProxy.getLocalPlayer()) {
                    item.func_77663_a(stack, this.owner.field_70170_p, (Entity)this.owner, 0, true);
                }
                WeaponData.WeaponDataCapability stackcap = (WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null);
                if (TF2Attribute.getModifier("Focus", stack, 0.0f, this.owner) != 0.0f) {
                    this.focusShotTicks += this.owner.func_70051_ag() ? 0 : 1;
                    --this.focusShotRemaining;
                }
                if (stackcap.active == 1) {
                    if (!this.lastWeapon.func_190926_b()) {
                        stackcap.fire1Cool = stackcap.fire2Cool = (int)Math.max((float)stackcap.fire1Cool, (TF2Attribute.getModifier("Holster Time", this.lastWeapon, 1.0f, this.owner) - 1.0f) * (float)item.getDeployTime(stack, this.owner));
                        this.lastWeapon = ItemStack.field_190927_a;
                    }
                    if (stackcap.fire1Cool <= 0) {
                        this.setActiveHand(hand, stack);
                    }
                }
                if (stackcap.active == 2) {
                    this.stackActive.put(hand, stack);
                }
                if (this.owner.field_70170_p.field_72995_K) {
                    stack.func_190915_d(0);
                }
                if (this.owner instanceof EntityTF2Character && (shooter = (EntityTF2Character)this.owner).func_70638_az() != null) {
                    shooter.targetPrevPos[1] = shooter.targetPrevPos[0];
                    shooter.targetPrevPos[3] = shooter.targetPrevPos[2];
                    shooter.targetPrevPos[5] = shooter.targetPrevPos[4];
                    shooter.targetPrevPos[0] = shooter.func_70638_az().field_70165_t;
                    shooter.targetPrevPos[2] = shooter.func_70638_az().field_70163_u;
                    shooter.targetPrevPos[4] = shooter.func_70638_az().field_70161_v;
                }
                this.setCanFire(item.canFireInternal(this.owner.field_70170_p, this.owner, stack, hand), hand, true);
                this.setCanFire(item.canAltFireInternal(this.owner.field_70170_p, this.owner, stack, hand), hand, false);
                this.stateDo(this.owner, stack, hand, state);
                if (!(this.owner.field_70170_p.field_72995_K && this.owner == Minecraft.func_71410_x().field_71439_g || !(stack.func_77973_b() instanceof ItemWeapon) || !((ItemWeapon)stack.func_77973_b()).hasClip(stack) || item.searchForAmmo(this.owner, stack).func_190926_b() && !this.owner.field_70170_p.field_72995_K)) {
                    boolean emptyMag;
                    ItemWeapon weapon = (ItemWeapon)item;
                    boolean bl2 = emptyMag = weapon.getClip(stack) == 0 && TF2Attribute.getModifier("Auto Fire", stack, 0.0f, this.owner) == 0.0f;
                    if (((state & 4) != 0 || emptyMag || continueReload) && stackcap.active == 2 && this.reloadingHand == null && weapon.getClip(stack) != weapon.getWeaponClipSize(stack, this.owner) && this.reloadCool <= 0 && this.getPrimaryCooldown() <= 0 && this.owner.func_70660_b(TF2weapons.stun) == null) {
                        this.reloadingHand = hand;
                        this.reloadCool = ((ItemWeapon)stack.func_77973_b()).getWeaponFirstReloadTime(stack, this.owner);
                        if (!this.owner.field_70170_p.field_72995_K && this.owner instanceof EntityPlayerMP) {
                            TF2weapons.network.sendTo(new TF2Message.UseMessage(weapon.getClip(stack), true, -1, hand), (EntityPlayerMP)this.owner);
                        }
                        if (this.owner.field_70170_p.field_72995_K && ((ItemWeapon)stack.func_77973_b()).IsReloadingFullClip(stack)) {
                            TF2weapons.proxy.playReloadSound(this.owner, stack);
                        }
                    } else if (this.getPrimaryCooldown() <= 0 || ((ItemWeapon)stack.func_77973_b()).IsReloadingFullClip(stack)) {
                        while (this.reloadingHand == hand && this.reloadCool <= 0 && weapon.getClip(stack) != weapon.getWeaponClipSize(stack, this.owner)) {
                            int maxAmmoUse = item.getAmmoAmount(this.owner, stack);
                            int consumeAmount = 0;
                            if (((ItemWeapon)stack.func_77973_b()).IsReloadingFullClip(stack)) {
                                weapon.consumeClip(stack, -(consumeAmount += Math.min(weapon.getWeaponClipSize(stack, this.owner) - weapon.getClip(stack), maxAmmoUse)), this.owner, hand);
                                maxAmmoUse -= consumeAmount;
                            } else {
                                consumeAmount = 1;
                                weapon.consumeClip(stack, -1, this.owner, hand);
                            }
                            if (!this.owner.field_70170_p.field_72995_K) {
                                item.consumeAmmoGlobal(this.owner, stack, consumeAmount);
                            }
                            if (!this.owner.field_70170_p.field_72995_K && this.owner instanceof EntityPlayerMP) {
                                TF2weapons.network.sendTo(new TF2Message.UseMessage(weapon.getClip(stack), weapon.getClip(stack) != weapon.getWeaponClipSize(stack, this.owner), -1, hand), (EntityPlayerMP)this.owner);
                            }
                            this.reloadCool += ((ItemWeapon)stack.func_77973_b()).getWeaponReloadTime(stack, this.owner);
                            if (weapon.getClip(stack) != weapon.getWeaponClipSize(stack, this.owner)) continue;
                            this.stopReload();
                            continueReload = true;
                        }
                    }
                } else if (!(this.reloadingHand != hand || this.owner.field_70170_p.field_72995_K && this.owner == Minecraft.func_71410_x().field_71439_g)) {
                    this.reloadingHand = null;
                }
            }
            if (this.stackActive.get(hand) == null) continue;
            if (this.owner.field_70170_p.field_72995_K && !(this.owner instanceof EntityPlayer) && isUseableWeapon && stack.hasCapability(TF2weapons.WEAPONS_DATA_CAP, null) && ((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).active != 2 && stack.func_77973_b().shouldCauseReequipAnimation(this.stackActive.get(hand), stack, false)) {
                ((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).active = 2;
            }
            if (isUseableWeapon && stack.hasCapability(TF2weapons.WEAPONS_DATA_CAP, null) && ((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).active == 2) continue;
            boolean revert = false;
            ItemStack activestack = this.stackActive.get(hand);
            if (activestack.func_190916_E() == 0) {
                activestack.func_190920_e(1);
                revert = true;
            }
            if (((WeaponData.WeaponDataCapability)activestack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).active == 2) {
                this.setInactiveHand(hand, activestack);
            }
            if (!revert) continue;
            activestack.func_190920_e(0);
        }
        if (!hadItem) {
            this.owner.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(ItemMinigun.slowdown);
            this.owner.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(ItemSniperRifle.slowdown);
            this.owner.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(ItemHuntsman.slowdown);
        }
        if (!this.owner.field_70170_p.field_72995_K && this.dataManager.func_187223_a()) {
            TF2Util.sendTracking(new TF2Message.CapabilityMessage((Entity)this.owner, false), (Entity)this.owner);
        }
        PotionEffect charging = this.owner.func_70660_b(TF2weapons.charging);
        if (!this.owner.field_70122_E && charging != null) {
            this.setExpJump(true);
        }
        if (this.isExpJump() && this.canExpJump()) {
            boolean enchanted;
            boolean bl = enchanted = TF2ConfigVars.enchantedExplosion && !this.owner.func_184613_cA() && !this.isUsingParachute() && (!(this.owner instanceof EntityPlayer) || !((EntityPlayer)this.owner).field_71075_bZ.field_75100_b) && !this.owner.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b().getRegistryName().toString().equals("tconstruct:slime_boots");
            if (this.owner.field_70122_E) {
                BlockPos pos = this.owner.func_180425_c().func_177977_b();
                IBlockState block = this.owner.field_70170_p.func_180495_p(pos);
                this.owner.field_70159_w *= (double)block.func_177230_c().getSlipperiness(block, (IBlockAccess)this.owner.field_70170_p, pos, (Entity)this.owner);
                this.owner.field_70179_y *= (double)block.func_177230_c().getSlipperiness(block, (IBlockAccess)this.owner.field_70170_p, pos, (Entity)this.owner);
            }
            if (this.expJumpGround > 0) {
                --this.expJumpGround;
                this.owner.field_70122_E = false;
                this.owner.field_70160_al = true;
            } else if (this.owner.field_70122_E || this.owner.func_70090_H()) {
                this.killsAirborne = 0;
                this.setExpJump(false);
                if (enchanted && this.oldFactor != 0.0f) {
                    this.owner.field_70747_aH = this.oldFactor;
                    enchanted = false;
                }
            }
            if (!enchanted && this.owner.field_70747_aH == 0.0f && this.oldFactor != 0.0f) {
                this.owner.field_70747_aH = this.oldFactor;
            }
            if (enchanted) {
                if (this.owner.field_70747_aH != 0.0f) {
                    this.oldFactor = this.owner.field_70747_aH;
                    this.owner.field_70747_aH = 0.0f;
                }
                if (this.owner.field_70170_p.field_72995_K && this.owner instanceof EntityPlayer && !this.owner.field_70170_p.func_175726_f(this.owner.func_180425_c()).func_177410_o()) {
                    this.owner.field_70159_w *= 0.99;
                    this.owner.field_70179_y *= 0.99;
                }
                if (!(this.owner.field_70170_p.field_72995_K && !(this.owner instanceof EntityPlayer) || TF2weapons.squakeLoaded && this.owner instanceof EntityPlayer)) {
                    double speed = Math.sqrt(this.owner.field_70159_w * this.owner.field_70159_w + this.owner.field_70179_y * this.owner.field_70179_y);
                    Vec3d moveDir = TF2Util.getMovementVector(this.owner);
                    double combSpeed = this.owner.field_70159_w * moveDir.field_72450_a + this.owner.field_70179_y * moveDir.field_72448_b;
                    double maxSpeed = charging != null ? (double)this.owner.func_70689_ay() * 2.16 : 0.026;
                    double friction = charging != null ? 0.08 : 0.4;
                    combSpeed = maxSpeed - combSpeed;
                    double accel = Math.max(speed, maxSpeed) * friction;
                    if (accel > combSpeed) {
                        accel = combSpeed;
                    }
                    if (accel > 0.0) {
                        this.owner.field_70159_w += moveDir.field_72450_a * accel;
                        this.owner.field_70179_y += moveDir.field_72448_b * accel;
                    }
                    this.owner.field_70159_w /= 0.91;
                    this.owner.field_70179_y /= 0.91;
                }
                this.owner.field_70181_x /= 0.98;
                this.owner.field_70181_x += 0.08 - (double)TF2ConfigVars.explosiveJumpGravity;
            }
            this.owner.func_174813_aQ();
        } else if (this.oldFactor != 0.0f) {
            this.owner.field_70747_aH = this.oldFactor;
            this.oldFactor = 0.0f;
        }
        if (this.isExpJump() || charging != null) {
            double motion;
            Vec3d vec = new Vec3d(this.owner.field_70159_w, this.owner.field_70181_x, this.owner.field_70179_y);
            Vec3d vec2 = new Vec3d(this.owner.field_70159_w, 0.0, this.owner.field_70179_y);
            if (this.owner.field_70122_E) {
                vec = vec2;
            }
            if ((motion = vec.func_72433_c()) >= 0.375 && (TF2ConfigVars.allowTrimp == 2 || TF2ConfigVars.allowTrimp == 1 && EnumFacing.func_176737_a((float)((float)vec.field_72450_a), (float)((float)vec.field_72448_b), (float)((float)vec.field_72449_c)) != EnumFacing.DOWN)) {
                vec2 = vec2.func_72432_b();
                Vec3d entPos = this.owner.func_174791_d();
                Vec3d vecOff = vec.func_178787_e(vec2.func_186678_a((double)this.owner.field_70130_N * 1.5));
                RayTraceResult rayTrace = this.owner.field_70170_p.func_72933_a(entPos, entPos.func_178787_e(vecOff));
                BlockPos pos = new BlockPos(vecOff.func_178787_e(entPos));
                if (rayTrace != null) {
                    pos = rayTrace.func_178782_a().func_177972_a(rayTrace.field_178784_b);
                }
                if (this.owner.field_70170_p.func_175665_u(pos.func_177977_b())) {
                    Vec3d step = TF2Util.getHeightVec(this.owner.field_70170_p, pos);
                    Vec3d normal = step.func_72432_b();
                    if (normal.field_72448_b != 1.0 && normal.func_72430_b(vecOff) < 0.0 && (charging == null || !(normal.field_72448_b > 0.75))) {
                        double backoff = vec.func_72430_b(normal);
                        vec = new Vec3d(vec.field_72450_a - normal.field_72450_a * backoff, vec.field_72448_b - normal.field_72448_b * backoff, vec.field_72449_c - normal.field_72449_c * backoff);
                        this.owner.field_70159_w = vec.field_72450_a;
                        this.owner.field_70181_x = vec.field_72448_b;
                        this.owner.field_70179_y = vec.field_72449_c;
                        if (charging != null) {
                            double mult = motion / vec.func_72433_c();
                            this.owner.field_70159_w *= mult;
                            this.owner.field_70181_x *= mult;
                            this.owner.field_70179_y *= mult;
                        }
                        if ((rayTrace = this.owner.field_70170_p.func_72933_a(vecOff.func_178787_e(entPos), vecOff.func_178787_e(entPos).func_178787_e(vec))) != null) {
                            this.owner.func_70107_b(this.owner.field_70165_t, this.owner.field_70163_u + 1.0 - rayTrace.field_72307_f.field_72448_b + (double)rayTrace.func_178782_a().func_177956_o(), this.owner.field_70161_v);
                        }
                    }
                }
            }
        }
        if (!this.owner.field_70170_p.field_72995_K && this.disguiseTicks > 0) {
            if (++this.disguiseTicks >= 40) {
                this.disguise();
            } else if (this.invisTicks < 20) {
                ((WorldServer)this.owner.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_LARGE, this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v, 2, 0.2, 1.0, 0.2, (double)0.04f, new int[0]);
            }
        }
        if (this.owner.field_70170_p.field_72995_K) {
            ClientProxy.doChargeTick(this.owner);
        }
        if (!this.owner.field_70170_p.field_72995_K && charging != null) {
            if (ItemChargingTarge.getChargingShield(this.owner).func_190926_b()) {
                this.owner.func_184589_d(TF2weapons.charging);
            }
            Vec3d start = this.owner.func_174791_d().func_72441_c(0.0, (double)(this.owner.field_70131_O / 2.0f), 0.0);
            Vec3d end = start.func_72441_c((double)(-MathHelper.func_76126_a((float)(this.owner.field_70177_z / 180.0f * (float)Math.PI))) * 0.7, 0.0, (double)MathHelper.func_76134_b((float)(this.owner.field_70177_z / 180.0f * (float)Math.PI)) * 0.7);
            RayTraceResult result = TF2Util.pierce(this.owner.field_70170_p, (Entity)this.owner, start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c, false, 0.5f, false).get(0);
            if (result.field_72308_g != null) {
                float damage = 5.0f;
                if (charging.func_76459_b() > 30) {
                    damage *= 0.5f;
                }
                TF2Util.dealDamage(result.field_72308_g, result.field_72308_g.field_70170_p, this.owner, ItemChargingTarge.getChargingShield(this.owner), 0, damage, TF2Util.causeDirectDamage(ItemChargingTarge.getChargingShield(this.owner), (Entity)this.owner, 0));
                boolean bl = this.bashCritical = charging.func_76459_b() < 20;
                if (charging.func_76459_b() < 12) {
                    TF2Util.playSound((Entity)this.owner, TF2Sounds.WEAPON_SHIELD_HIT_RANGE, 3.0f, 1.0f);
                } else {
                    TF2Util.playSound((Entity)this.owner, TF2Sounds.WEAPON_SHIELD_HIT, 0.8f, 1.0f);
                }
                this.ticksBash = 20;
                this.owner.field_70159_w = 0.0;
                this.owner.field_70179_y = 0.0;
                this.owner.func_184589_d(TF2weapons.charging);
            }
        }
        if (this.owner.field_70170_p.field_72995_K && WeaponsCapability.get((Entity)this.owner).isDisguised() != this.lastDisgused) {
            this.lastDisgused = WeaponsCapability.get((Entity)this.owner).isDisguised();
            if (this.owner instanceof EntityPlayer) {
                ((EntityPlayer)this.owner).refreshDisplayName();
            }
        }
        String disguisetype = this.getDisguiseType();
        if (this.owner.field_70170_p.field_72995_K && !disguisetype.equals(this.lastDisguiseValue)) {
            if (this.owner instanceof EntityPlayer) {
                ((EntityPlayer)this.owner).refreshDisplayName();
            }
            this.lastDisguiseValue = disguisetype;
            if (this.getDisguiseType().startsWith("P:")) {
                this.skinDisguise = null;
                this.skinType = DefaultPlayerSkin.func_177332_b((UUID)this.owner.func_110124_au());
                THREAD_POOL.submit(new Runnable(){

                    @Override
                    public void run() {
                        GameProfile profile = TileEntitySkull.func_174884_b((GameProfile)new GameProfile(WeaponsCapability.this.owner.func_110124_au(), WeaponsCapability.this.getDisguiseType().substring(2)));
                        if (profile.getId() != null) {
                            WeaponsCapability.this.skinType = DefaultPlayerSkin.func_177332_b((UUID)profile.getId());
                            WeaponsCapability.this.skinDisguise = DefaultPlayerSkin.func_177334_a((UUID)profile.getId());
                        }
                        Minecraft.func_71410_x().func_152342_ad().func_152790_a(profile, new SkinManager.SkinAvailableCallback(){

                            public void func_180521_a(MinecraftProfileTexture.Type typeIn, ResourceLocation location, MinecraftProfileTexture profileTexture) {
                                if (typeIn == MinecraftProfileTexture.Type.SKIN) {
                                    if (typeIn == MinecraftProfileTexture.Type.SKIN) {
                                        WeaponsCapability.this.skinDisguise = location;
                                    }
                                    WeaponsCapability.this.skinType = profileTexture.getMetadata("model");
                                    if (WeaponsCapability.this.skinType == null) {
                                        WeaponsCapability.this.skinType = "default";
                                    }
                                }
                            }
                        }, false);
                    }
                });
            }
        }
        if (this.owner.field_70170_p.field_72995_K && this.owner != ClientProxy.getLocalPlayer()) {
            Iterator iterator = this.owner.func_70651_bq().iterator();
            while (iterator.hasNext()) {
                PotionEffect effect = (PotionEffect)iterator.next();
                if (effect.func_76459_b() > 0 || !(effect.func_188419_a() instanceof PotionTF2) && !(effect.func_188419_a() instanceof PotionTF2Item)) continue;
                iterator.remove();
            }
        }
        if (!this.owner.field_70170_p.field_72995_K && this.owner.field_70173_aa % 10 == 0 && this.isFeign() && ItemCloak.getFeignDeathWatch(this.owner).func_190926_b()) {
            this.setFeign(false);
        }
        if (!this.owner.field_70170_p.field_72995_K && this.owner.field_70143_R > 0.0f && this.owner.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() == TF2weapons.itemMantreads) {
            TF2Util.stomp(this.owner);
        }
        if (this.isInvisible()) {
            boolean active;
            Entity ent;
            List closeEntities;
            Iterator iterator;
            boolean visible;
            ItemStack cloak = (ItemStack)ItemCloak.searchForWatches(this.owner).func_76340_b();
            boolean feign = !cloak.func_190926_b() && ((ItemCloak)cloak.func_77973_b()).isFeignDeath(cloak, this.owner);
            boolean bl = visible = this.owner.field_70737_aN == 10 && !feign;
            if (!visible && !feign && (iterator = (closeEntities = this.owner.field_70170_p.func_175674_a((Entity)this.owner, this.owner.func_174813_aQ().func_72314_b(1.0, 2.0, 1.0), (Predicate)new Predicate<Entity>(){

                public boolean apply(Entity input) {
                    return input instanceof EntityLivingBase && !TF2Util.isOnSameTeam((Entity)WeaponsCapability.this.owner, input);
                }
            })).iterator()).hasNext() && (ent = (Entity)iterator.next()).func_70068_e((Entity)this.owner) < 1.0) {
                visible = true;
            }
            if (visible) {
                this.invisTicks = Math.min(10, this.invisTicks);
                this.owner.func_82142_c(false);
            }
            if (feign) {
                this.invisTicks = 20;
            }
            this.invisTicks += 2;
            if (((WeaponsCapability)this.owner.getCapability(TF2weapons.WEAPONS_CAP, null)).invisTicks >= 20 && !this.owner.func_82150_aj()) {
                this.owner.func_82142_c(true);
            }
            boolean bl3 = active = this.owner.field_70170_p.field_72995_K || !cloak.func_190926_b();
            if (!active) {
                this.setInvisible(false);
                this.owner.func_82142_c(false);
            }
        } else if (((WeaponsCapability)this.owner.getCapability(TF2weapons.WEAPONS_CAP, null)).invisTicks > 0) {
            this.invisTicks = Math.min(20, this.invisTicks - 1);
            if (((WeaponsCapability)this.owner.getCapability(TF2weapons.WEAPONS_CAP, null)).invisTicks == 0) {
                this.owner.func_82142_c(false);
            }
        }
        this.lastPosX = this.owner.field_70165_t;
        this.lastPosY = this.owner.field_70163_u;
        this.lastPosZ = this.owner.field_70161_v;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return TF2weapons.WEAPONS_CAP != null && capability == TF2weapons.WEAPONS_CAP;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (TF2weapons.WEAPONS_CAP != null && capability == TF2weapons.WEAPONS_CAP) {
            return (T)TF2weapons.WEAPONS_CAP.cast((Object)this);
        }
        return null;
    }

    public boolean startedPress() {
        if (this.pressedStart) {
            this.pressedStart = false;
            return true;
        }
        return false;
    }

    public boolean shouldShoot(EntityLivingBase player, int state, EnumHand hand, int actualState) {
        return (player.field_70170_p.field_72995_K || !(player instanceof EntityPlayer) || !this.predictionList[hand.ordinal() + (state == 1 ? 0 : 2)].isEmpty()) && (!player.field_70170_p.field_72995_K && player instanceof EntityPlayer || (actualState & state) == state);
    }

    public void stateDo(EntityLivingBase player, ItemStack stack, EnumHand hand, int state) {
        TF2Message.PredictionMessage message;
        if (!TF2Util.canInteract(player)) {
            return;
        }
        ItemUsable item = (ItemUsable)stack.func_77973_b();
        WeaponData.WeaponDataCapability stackcap = WeaponData.getCapability(stack);
        if ((state & 1) != 0 && ((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).active == 2) {
            item.fireTick(stack, player, player.field_70170_p);
        }
        while (stackcap.fire1Cool <= 0 && this.shouldShoot(player, 1, hand, state)) {
            message = null;
            if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayer) {
                message = this.predictionList[hand.ordinal()].pollLast();
            }
            if (message == null) {
                boolean canFire = item.canFireInternal(player.field_70170_p, player, stack, hand);
                if (!canFire) {
                    break;
                }
            } else {
                boolean bl = this.mainHand = message.hand == EnumHand.MAIN_HAND;
                if (message.hand != hand || !item.canFireInternal(player.field_70170_p, player, stack, hand)) break;
            }
            int fireRate = item.getFiringSpeed(stack, player);
            stackcap.fire1Cool += Math.max(1, fireRate);
            if (ItemUsable.isDoubleWielding(player)) {
                if (hand == EnumHand.MAIN_HAND) {
                    this.setPrimaryCooldown(EnumHand.OFF_HAND, Math.max(this.getPrimaryCooldown(EnumHand.OFF_HAND), fireRate / 2 - 50));
                } else if (hand == EnumHand.OFF_HAND) {
                    this.setPrimaryCooldown(EnumHand.MAIN_HAND, Math.max(this.getPrimaryCooldown(EnumHand.MAIN_HAND), fireRate / 2 - 50));
                }
            }
            if (player instanceof EntityTF2Character) {
                ((EntityTF2Character)player).onShot();
            }
            if (!(item instanceof ItemSapper)) {
                this.setDisguised(false);
            }
            double oldX = player.field_70165_t;
            double oldY = player.field_70163_u;
            double oldZ = player.field_70161_v;
            float oldPitch = player.field_70125_A;
            float oldYaw = player.field_70759_as;
            if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayer) {
                this.preparePlayerPrediction(player, message);
            }
            if (player.field_70170_p.field_72995_K && player == ClientProxy.getLocalPlayer()) {
                message = new TF2Message.PredictionMessage(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70125_A, player.field_70759_as, 1, hand);
            }
            item.use(stack, player, player.field_70170_p, hand, message);
            player.func_184589_d(TF2weapons.charging);
            if (player.field_70170_p.field_72995_K && player == ClientProxy.getLocalPlayer()) {
                TF2weapons.network.sendToServer(message);
            }
            player.field_70165_t = oldX;
            player.field_70163_u = oldY;
            player.field_70161_v = oldZ;
            player.field_70759_as = oldYaw;
            player.field_70125_A = oldPitch;
            this.lastFire = 1250;
            this.fireCoolReduced = false;
            if (stack.func_77973_b() instanceof ItemWeapon) {
                this.stopReload();
            }
            if (stackcap.fire1Cool <= 200) continue;
            this.predictionList[hand.ordinal()].clear();
        }
        if ((state & 2) != 0 && ((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).active == 2) {
            ((ItemUsable)stack.func_77973_b()).altFireTick(stack, player, player.field_70170_p);
        }
        while (stackcap.fire2Cool <= 0 && this.shouldShoot(player, 2, hand, state)) {
            message = null;
            if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayer) {
                message = this.predictionList[hand.ordinal() + 2].pollLast();
            }
            if (item.getAltFiringSpeed(stack, player) == Short.MAX_VALUE || !item.canAltFireInternal(player.field_70170_p, player, stack, hand)) break;
            stackcap.fire2Cool += item.getAltFiringSpeed(stack, player);
            this.setDisguised(false);
            double oldX = player.field_70165_t;
            double oldY = player.field_70163_u;
            double oldZ = player.field_70161_v;
            float oldPitch = player.field_70125_A;
            float oldYaw = player.field_70759_as;
            if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayer) {
                this.preparePlayerPrediction(player, message);
            }
            ((ItemUsable)stack.func_77973_b()).altUse(stack, player, player.field_70170_p);
            player.func_184589_d(TF2weapons.charging);
            if (player.field_70170_p.field_72995_K && player == ClientProxy.getLocalPlayer()) {
                TF2weapons.network.sendToServer(new TF2Message.PredictionMessage(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70125_A, player.field_70759_as, 2, EnumHand.MAIN_HAND));
            }
            player.field_70165_t = oldX;
            player.field_70163_u = oldY;
            player.field_70161_v = oldZ;
            player.field_70759_as = oldYaw;
            player.field_70125_A = oldPitch;
            if (!player.field_70170_p.field_72995_K) {
                ++ItemUsable.sps;
            }
            if (stack.func_77973_b() instanceof ItemWeapon) {
                this.stopReload();
            }
            if (stackcap.fire2Cool <= 200) continue;
            this.predictionList[hand.ordinal() + 2].clear();
        }
    }

    public void updateExpJump() {
    }

    public void preparePlayerPrediction(EntityLivingBase player, TF2Message.PredictionMessage message) {
        player.field_70165_t = message.x;
        player.field_70163_u = message.y;
        player.field_70161_v = message.z;
        player.field_70759_as = message.yaw;
        player.field_70125_A = message.pitch;
        this.mainHand = message.hand == EnumHand.MAIN_HAND;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("VisTicks", (byte)this.invisTicks);
        tag.func_74774_a("DisguiseTicks", (byte)this.disguiseTicks);
        NBTTagCompound cld = new NBTTagCompound();
        for (Map.Entry<String, Integer> entry : this.effectsCool.entrySet()) {
            cld.func_74768_a(entry.getKey(), entry.getValue().intValue());
        }
        tag.func_74782_a("Cooldowns", (NBTBase)cld);
        tag.func_74768_a("HealTarget", this.getHealTarget());
        tag.func_74777_a("Heads", ((Integer)this.dataManager.func_187225_a(HEADS)).shortValue());
        tag.func_74777_a("HeadsCool", (short)(this.collectedHeadsTime - this.owner.field_70173_aa));
        tag.func_74757_a("Cloaked", this.isInvisible());
        tag.func_74757_a("Disguised", this.isDisguised());
        tag.func_74778_a("DisguiseType", this.getDisguiseType());
        tag.func_74768_a("KillsSpinning", this.killsSpinning);
        tag.func_74768_a("FocusedShot", this.focusShotTicks);
        tag.func_74768_a("KnockbackFANCool", this.fanCool);
        tag.func_74768_a("Metal", this.getMetal());
        tag.func_74776_a("MaxMetal", this.maxmetal);
        for (RageType rage : RageType.values()) {
            tag.func_74776_a(rage.toString(), this.getRage(rage));
            tag.func_74757_a(rage.toString() + "active", this.isRageActive(rage));
            if (!this.isRageActive(rage)) continue;
            tag.func_74776_a(rage.toString() + "drain", this.rageDrain[rage.ordinal()]);
        }
        tag.func_74772_a("TicksTotal", this.ticksTotal);
        if (this.forcedClass) {
            tag.func_74774_a("Token", (byte)this.getUsedToken());
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.invisTicks = nbt.func_74771_c("VisTicks");
        this.disguiseTicks = nbt.func_74771_c("DisguiseTicks");
        NBTTagCompound cld = nbt.func_74775_l("Cooldowns");
        for (String key : cld.func_150296_c()) {
            this.effectsCool.put(key, cld.func_74762_e(key));
        }
        this.dataManager.func_187227_b(HEADS, (Object)nbt.func_74765_d("Heads"));
        this.collectedHeadsTime = nbt.func_74765_d("HeadsCool");
        this.setInvisible(nbt.func_74767_n("Cloaked"));
        this.setDisguised(nbt.func_74767_n("Disguised"));
        this.setDisguiseType(nbt.func_74779_i("DisguiseType"));
        if (this.isDisguised()) {
            this.disguise();
        }
        this.killsSpinning = nbt.func_74762_e("KillsSpinning");
        this.focusShotTicks = nbt.func_74762_e("FocusedShot");
        this.fanCool = nbt.func_74762_e("KnockbackFANCool");
        this.maxmetal = nbt.func_74760_g("MaxMetal");
        this.setMetal(nbt.func_74762_e("Metal"));
        this.ticksTotal = nbt.func_74763_f("TicksTotal");
        for (RageType rage : RageType.values()) {
            this.setRage(rage, nbt.func_74760_g(rage.toString()));
            this.setRageActive(rage, nbt.func_74767_n(rage.toString() + "active"), nbt.func_74760_g(rage.toString() + "drain"));
        }
        if (nbt.func_74764_b("Token")) {
            ((ItemToken)TF2weapons.itemToken).updateAttributes(new ItemStack(TF2weapons.itemToken, 1, (int)nbt.func_74771_c("Token")), this.owner);
            this.forcedClass = true;
        }
    }

    public int getMaxAirJumps() {
        int amount = 0;
        if (this.owner instanceof EntityScout) {
            ++amount;
        } else if (this.owner instanceof EntityPlayer && (this.getUsedToken() == 0 || ItemToken.allowUse(this.owner, "scout") && this.owner.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() == TF2weapons.itemScoutBoots)) {
            ++amount;
        }
        amount = (int)TF2Attribute.getModifier("Triple Jump", this.owner.func_184614_ca(), amount, this.owner);
        return amount;
    }

    public static EntityDataManager getDataManager(Entity ent) {
        return ((WeaponsCapability)ent.getCapability(TF2weapons.WEAPONS_CAP, null)).dataManager;
    }

    public static WeaponsCapability get(Entity ent) {
        return (WeaponsCapability)ent.getCapability(TF2weapons.WEAPONS_CAP, null);
    }

    public int getMinimalCooldown() {
        if (!this.owner.field_70170_p.field_72995_K && this.owner instanceof EntityPlayer) {
            return -200;
        }
        return 0;
    }

    public int getPrimaryCooldown() {
        return Math.max(this.getPrimaryCooldown(EnumHand.MAIN_HAND), this.getPrimaryCooldown(EnumHand.OFF_HAND));
    }

    public void setPrimaryCooldown(int fire1Cool) {
        this.setPrimaryCooldown(EnumHand.MAIN_HAND, fire1Cool);
        this.setPrimaryCooldown(EnumHand.OFF_HAND, fire1Cool);
    }

    public int getPrimaryCooldown(EnumHand hand) {
        if (this.owner.func_184586_b(hand).func_77973_b() instanceof ItemUsable) {
            return ((WeaponData.WeaponDataCapability)this.owner.func_184586_b((EnumHand)hand).getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).fire1Cool - this.getMinimalCooldown();
        }
        return 0;
    }

    public void setPrimaryCooldown(EnumHand hand, int fire1Cool) {
        if (this.owner.func_184586_b(hand).hasCapability(TF2weapons.WEAPONS_DATA_CAP, null)) {
            ((WeaponData.WeaponDataCapability)this.owner.func_184586_b((EnumHand)hand).getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).fire1Cool = fire1Cool + this.getMinimalCooldown();
        }
    }

    public int getSecondaryCooldown() {
        return Math.max(this.getSecondaryCooldown(EnumHand.MAIN_HAND), this.getSecondaryCooldown(EnumHand.OFF_HAND));
    }

    public void setSecondaryCooldown(int fire1Cool) {
        this.setSecondaryCooldown(EnumHand.MAIN_HAND, fire1Cool);
        this.setSecondaryCooldown(EnumHand.OFF_HAND, fire1Cool);
    }

    public int getSecondaryCooldown(EnumHand hand) {
        if (this.owner.func_184586_b(hand).func_77973_b() instanceof ItemUsable) {
            return ((WeaponData.WeaponDataCapability)this.owner.func_184586_b((EnumHand)hand).getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).fire2Cool - this.getMinimalCooldown();
        }
        return 0;
    }

    public void setSecondaryCooldown(EnumHand hand, int fire1Cool) {
        if (this.owner.func_184586_b(hand).hasCapability(TF2weapons.WEAPONS_DATA_CAP, null)) {
            ((WeaponData.WeaponDataCapability)this.owner.func_184586_b((EnumHand)hand).getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).fire2Cool = fire1Cool + this.getMinimalCooldown();
        }
    }

    public void stopReload() {
        this.reloadCool = 0;
        this.reloadingHand = null;
    }

    public boolean canExpJump() {
        return this.canExpJump;
    }

    public void setCanExpJump(boolean canExpJump) {
        this.canExpJump = canExpJump;
    }

    public void setActiveHand(EnumHand hand, ItemStack stack) {
        this.stackActive.put(hand, stack);
        ((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).active = 2;
        ((ItemUsable)stack.func_77973_b()).draw(this, stack, this.owner, this.owner.field_70170_p);
        if ((this.state & 3) > 0) {
            this.state &= 7;
            if ((this.state & 3) > 0) {
                ((ItemUsable)stack.func_77973_b()).startUse(stack, this.owner, this.owner.field_70170_p, 0, this.state & 3);
            }
        }
    }

    public void setInactiveHand(EnumHand hand, ItemStack stack) {
        this.stackActive.remove(hand);
        if (((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).active == 2 && (this.state & 3) > 0) {
            ((ItemUsable)stack.func_77973_b()).endUse(stack, this.owner, this.owner.field_70170_p, this.state, 0);
        }
        ((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).active = 0;
        ((ItemUsable)stack.func_77973_b()).holster(this, stack, this.owner, this.owner.field_70170_p);
    }

    public void disguise() {
        this.setDisguised(true);
        if (this.invisTicks < 20 && this.owner.field_70170_p instanceof WorldServer) {
            ((WorldServer)this.owner.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_LARGE, this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v, 20, 0.2, 1.0, 0.2, (double)0.04f, new int[0]);
        }
    }

    static {
        for (RageType type : RageType.values()) {
            RAGE.put(type, (DataParameter<Float>)new DataParameter(127 - type.ordinal() * 2, DataSerializers.field_187193_c));
            RAGE_ACTIVE.put(type, (DataParameter<Boolean>)new DataParameter(126 - type.ordinal() * 2, DataSerializers.field_187198_h));
        }
    }

    public static enum RageType {
        PHLOG,
        MINICRIT,
        KNOCKBACK,
        BANNER;

    }
}

