/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.common;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.text.TextFormatting;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.entity.projectile.EntityProjectileBase;
import rafradek.TF2weapons.entity.projectile.EntityProjectileSimple;
import rafradek.TF2weapons.item.ItemAirblast;
import rafradek.TF2weapons.item.ItemBackpack;
import rafradek.TF2weapons.item.ItemBulletWeapon;
import rafradek.TF2weapons.item.ItemChargingTarge;
import rafradek.TF2weapons.item.ItemCloak;
import rafradek.TF2weapons.item.ItemFlameThrower;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemJetpack;
import rafradek.TF2weapons.item.ItemKnife;
import rafradek.TF2weapons.item.ItemMedigun;
import rafradek.TF2weapons.item.ItemMinigun;
import rafradek.TF2weapons.item.ItemPDA;
import rafradek.TF2weapons.item.ItemProjectileWeapon;
import rafradek.TF2weapons.item.ItemSniperRifle;
import rafradek.TF2weapons.item.ItemSoldierBackpack;
import rafradek.TF2weapons.item.ItemUsable;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.item.ItemWrench;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.WeaponData;

public class TF2Attribute {
    public static TF2Attribute[] attributes = new TF2Attribute[256];
    public static List<TF2Attribute> listUpgrades;
    public int id;
    public String name;
    public Type typeOfValue;
    public String effect;
    public float defaultValue;
    public State state;
    private Predicate<ItemStack> canApply = Predicates.alwaysFalse();
    public int numLevels;
    public float perLevel;
    public float perKill;
    public int cost;
    public int weight;
    public float austrUpgrade;
    private boolean fullCost;
    public static final Predicate<ItemStack> ITEM_WEAPON;
    public static final Predicate<ItemStack> NOT_FLAMETHROWER;
    public static final Predicate<ItemStack> FLAMETHROWER;
    public static final Predicate<ItemStack> IGNITE;
    public static final Predicate<ItemStack> WITH_CLIP;
    public static final Predicate<ItemStack> WITH_SPREAD;
    public static final Predicate<ItemStack> WITH_AMMO;
    public static final Predicate<ItemStack> CHARGE_RATE;
    public static final Predicate<ItemStack> DURATION;
    public static final Predicate<ItemStack> ITEM_BULLET;
    public static final Predicate<ItemStack> ITEM_PROJECTILE;
    public static final Predicate<ItemStack> ITEM_MINIGUN;
    public static final Predicate<ItemStack> ITEM_SNIPER_RIFLE;
    public static final Predicate<ItemStack> EXPLOSIVE;
    public static final Predicate<ItemStack> MEDIGUN;
    public static final Predicate<ItemStack> BANNER;
    public static final Predicate<ItemStack> BACKPACK;
    public static final Predicate<ItemStack> SHIELD;
    public static final Predicate<ItemStack> WATCH;
    public static final Predicate<ItemStack> WRENCH;
    public static final Predicate<ItemStack> JETPACK;
    public static final Predicate<ItemStack> PDA;
    public static final Predicate<ItemStack> JUMPER;
    public static final Predicate<ItemStack> ROCKET;
    public static final Predicate<ItemStack> GRENADE;
    public static final Predicate<ItemStack> KNIFE;

    public TF2Attribute(int id, String name, String effect, Type typeOfValue, float defaultValue, State state) {
        this.id = id;
        TF2Attribute.attributes[id] = this;
        MapList.nameToAttribute.put(name, this);
        this.name = name;
        this.effect = effect;
        this.typeOfValue = typeOfValue;
        this.defaultValue = defaultValue;
        this.state = state;
    }

    public TF2Attribute setUpgrade(Predicate<ItemStack> canApply, float perLevel, int numLevels, int cost, int weight) {
        this.canApply = canApply;
        this.numLevels = numLevels;
        this.perLevel = perLevel;
        this.cost = cost;
        this.weight = weight;
        return this;
    }

    public TF2Attribute setKillstreak(float perKill) {
        this.perKill = perKill;
        return this;
    }

    public TF2Attribute setAustralium(float austr) {
        this.austrUpgrade = austr;
        return this;
    }

    public TF2Attribute setNoCostReduce() {
        this.fullCost = true;
        return this;
    }

    public static void initAttributes() {
        new TF2Attribute(0, "DamageBonus", "Damage", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade((Predicate<ItemStack>)Predicates.and(ITEM_WEAPON, (Predicate)Predicates.not(KNIFE)), 0.2f, 5, 160, 8).setKillstreak(0.04f).setAustralium(1.0f).setNoCostReduce();
        new TF2Attribute(1, "DamagePenalty", "Damage", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(2, "ClipSizeBonus", "Clip Size", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(WITH_CLIP, 0.5f, 4, 120, 6).setKillstreak(0.09f).setAustralium(1.0f);
        new TF2Attribute(3, "ClipSizePenalty", "Clip Size", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(4, "MinigunSpinBonus", "Minigun Spinup", Type.INVERTED_PERCENTAGE, 1.0f, State.POSITIVE);
        new TF2Attribute(5, "MinigunSpinPenalty", "Minigun Spinup", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(6, "FireRateBonus", "Fire Rate", Type.INVERTED_PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(NOT_FLAMETHROWER, -0.08f, 5, 80, 8).setKillstreak(-0.043f).setAustralium(1.5f);
        new TF2Attribute(7, "FireRatePenalty", "Fire Rate", Type.INVERTED_PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(8, "SpreadBonus", "Spread", Type.INVERTED_PERCENTAGE, 1.0f, State.POSITIVE);
        new TF2Attribute(9, "SpreadPenalty", "Spread", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(10, "PelletBonus", "Pellet Count", Type.PERCENTAGE, 1.0f, State.POSITIVE);
        new TF2Attribute(11, "PelletPenalty", "Pellet Count", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(12, "ReloadRateBonus", "Reload Time", Type.INVERTED_PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade((Predicate<ItemStack>)Predicates.and(WITH_CLIP, stack -> !ItemFromData.getData(stack).getBoolean(PropertyType.RELOADS_FULL_CLIP)), -0.2f, 3, 100, 5).setKillstreak(-0.05f).setAustralium(0.75f).setNoCostReduce();
        new TF2Attribute(13, "ReloadRatePenalty", "Reload Time", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(14, "KnockbackBonus", "Knockback", Type.PERCENTAGE, 1.0f, State.POSITIVE);
        new TF2Attribute(15, "KnockbackPenalty", "Knockback", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(16, "ChargeBonus", "Charge", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(CHARGE_RATE, 0.25f, 4, 100, 8).setKillstreak(0.055f).setAustralium(1.6f);
        new TF2Attribute(17, "ChargePenalty", "Charge", Type.INVERTED_PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(18, "SpreadAdd", "Spread", Type.ADDITIVE, 0.0f, State.NEGATIVE);
        new TF2Attribute(19, "ProjectileSpeedBonus", "Proj Speed", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(ITEM_PROJECTILE, 0.25f, 4, 80, 6).setAustralium(2.0f);
        new TF2Attribute(20, "ProjectileSpeedPenalty", "Proj Speed", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(21, "ExplosionRadiusBonus", "Explosion Radius", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(EXPLOSIVE, 0.2f, 4, 80, 2).setAustralium(1.5f);
        new TF2Attribute(22, "ExplosionRadiusPenalty", "Explosion Radius", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(23, "DestroyOnImpact", "Coll Remove", Type.ADDITIVE, 0.0f, State.NEGATIVE);
        new TF2Attribute(24, "AmmoEfficiencyBonus", "Ammo Eff", Type.INVERTED_PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(WITH_AMMO, -0.2f, 3, 120, 6).setKillstreak(-0.04f).setAustralium(0.75f);
        new TF2Attribute(25, "AmmoEfficiencyPenalty", "Ammo Eff", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(26, "Penetration", "Penetration", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade(ITEM_BULLET, 1.0f, 1, 200, 1);
        new TF2Attribute(27, "HealRateBonus", "Heal", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(MEDIGUN, 0.25f, 4, 100, 8).setAustralium(1.0f);
        new TF2Attribute(28, "HealRatePenalty", "Heal", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(29, "OverHealBonus", "Overheal", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(MEDIGUN, 0.25f, 4, 100, 4).setAustralium(1.0f);
        new TF2Attribute(30, "OverHealPenalty", "Overheal", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(31, "BurnTimeBonus", "Burn Time", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(IGNITE, 0.5f, 4, 140, 3);
        new TF2Attribute(32, "BurnTimePenalty", "Burn Time", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(33, "HealthOnKill", "Health Kill", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade(ITEM_WEAPON, 2.0f, 4, 80, 2);
        new TF2Attribute(34, "AccuracyBonus", "Accuracy", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(WITH_SPREAD, 0.25f, 3, 160, 4).setKillstreak(0.05f).setAustralium(1.0f);
        new TF2Attribute(35, "EffectDurationBonus", "Effect Duration", Type.PERCENTAGE, 1.0f, State.POSITIVE);
        new TF2Attribute(36, "FlameRangeBonus", "Flame Range", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(FLAMETHROWER, 0.25f, 4, 80, 5);
        new TF2Attribute(37, "CritBurning", "Crit Burn", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(38, "BurnOnHit", "Burn Hit", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(39, "DestroyBlock", "Destroy Block", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade((Predicate<ItemStack>)Predicates.or(ITEM_BULLET, EXPLOSIVE), 1.0f, 2, 200, 1).setAustralium(0.75f);
        new TF2Attribute(40, "NoRandomCrit", "Random Crit", Type.ADDITIVE, 0.0f, State.NEGATIVE);
        new TF2Attribute(41, "CritRocket", "Crit Rocket", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(42, "CritMini", "Crit Mini", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(43, "UberOnHit", "Uber Hit", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(44, "BallRelease", "Ball Release", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(45, "HealthPenalty", "Health", Type.ADDITIVE, 0.0f, State.HIDDEN);
        new TF2Attribute(46, "MovementBonus", "Speed", Type.PERCENTAGE, 1.0f, State.HIDDEN);
        new TF2Attribute(47, "MarkForDeathSelf", "Mark Death", Type.ADDITIVE, 0.0f, State.NEGATIVE);
        new TF2Attribute(48, "CritOnKill", "Crit Kill", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(49, "FireResistBonus", "Fire Resist", Type.INVERTED_PERCENTAGE, 1.0f, State.POSITIVE);
        new TF2Attribute(50, "DamageResistPenalty", "Damage Resist", Type.INVERTED_PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(51, "ExplosionResistBonus", "Explosion Resist", Type.INVERTED_PERCENTAGE, 1.0f, State.POSITIVE);
        new TF2Attribute(52, "DamageNonBurnPenalty", "Damage Non Burn", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(53, "CollectHeads", "Kill Count", Type.ADDITIVE, 0.0f, State.HIDDEN);
        new TF2Attribute(54, "ExplodeDeath", "Explode Death", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(55, "RechargeBonus", "Charge", Type.PERCENTAGE, 1.0f, State.POSITIVE);
        new TF2Attribute(56, "UberRateBonus", "Uber Rate", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(MEDIGUN, 0.25f, 4, 120, 1).setAustralium(1.0f);
        new TF2Attribute(57, "UberRatePenalty", "Uber Rate", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(58, "RangeIncrease", "Range", Type.PERCENTAGE, 1.0f, State.NEUTRAL);
        new TF2Attribute(59, "ExplosiveBullets", "Explode Bullet", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(60, "WeaponMode", "Weapon Mode", Type.ADDITIVE, 0.0f, State.HIDDEN);
        new TF2Attribute(61, "HealthOnHit", "Health Hit", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(62, "Breakable", "Breakable", Type.ADDITIVE, 0.0f, State.HIDDEN);
        new TF2Attribute(63, "Focus", "Focus", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade(ITEM_WEAPON, 1.0f, 2, 200, 1);
        new TF2Attribute(64, "KnockbackFAN", "KnockbackFAN", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(65, "MinicritAirborne", "Minicrit Airborne", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(66, "CannotAirblast", "Cannot Airblast", Type.ADDITIVE, 0.0f, State.NEGATIVE);
        new TF2Attribute(67, "RageCrit", "Rage Crit", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(68, "NoAmmo", "No Ammo", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(69, "DamageBurnBonus", "Damage Burning", Type.PERCENTAGE, 1.0f, State.POSITIVE);
        new TF2Attribute(70, "RingFire", "Ring Fire", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(71, "AmmoDrainSpinned", "Ammo Spinned", Type.ADDITIVE, 0.0f, State.NEGATIVE);
        new TF2Attribute(72, "StickybombBonus", "Stickybomb Count", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(73, "StickyControl", "Weapon Mode", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(74, "ArmTimePenalty", "Arm Time", Type.ADDITIVE, 0.0f, State.NEGATIVE);
        new TF2Attribute(75, "RepairBuilding", "Repair Building", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(76, "PickBuilding", "Pick Building", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(77, "Headshot", "Headshot", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(78, "HealTarget", "Heal Target", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(79, "NeedScope", "Weapon Mode", Type.ADDITIVE, 0.0f, State.NEGATIVE);
        new TF2Attribute(80, "DamageBonusCharged", "Damage Charged", Type.PERCENTAGE, 1.0f, State.POSITIVE);
        new TF2Attribute(81, "SelfDamageReduced", "Self Damage", Type.PERCENTAGE, 1.0f, State.POSITIVE);
        new TF2Attribute(82, "StickybombPenalty", "Stickybomb Count", Type.ADDITIVE, 0.0f, State.NEGATIVE);
        new TF2Attribute(83, "SpeedOnHitAlly", "Speed Hit", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(84, "ChargedGrenades", "Charged Grenades", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(85, "MetalAsAmmo", "Metal Ammo", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(86, "MetalOnHit", "Metal Hit", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(87, "EffectDurationBonus", "Effect Duration", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(DURATION, 0.25f, 3, 120, 4).setAustralium(1.0f);
        new TF2Attribute(88, "CloakRegenBonus", "Charge", Type.PERCENTAGE, 1.0f, State.POSITIVE);
        new TF2Attribute(89, "CloakDrainActivate", "Cloak Drain", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(90, "NoExternalCloak", "No External Cloak", Type.ADDITIVE, 0.0f, State.NEGATIVE);
        new TF2Attribute(91, "CritStunned", "Crit Stun", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(92, "BleedingDuration", "Bleed", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(93, "MiniCritDistance", "Minicrit Distance", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(94, "MaxHealthOnKill", "Max Health Kill", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(95, "SpeedOnKill", "Speed Kill", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(96, "ClipOnKill", "Clip Kill", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(97, "AirborneBonus", "Airborne Bonus", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(98, "DestroyProjectiles", "Destroy Projectiles", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade(ITEM_BULLET, 1.0f, 2, 180, 1);
        new TF2Attribute(99, "KnockbackRage", "Knockback Rage", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade(ITEM_MINIGUN, 1.0f, 3, 120, 1);
        new TF2Attribute(100, "DeployTimeBonus", "Deploy Time", Type.INVERTED_PERCENTAGE, 0.0f, State.POSITIVE);
        new TF2Attribute(101, "FireRateHealthBonus", "Fire Rate Health", Type.PERCENTAGE, 0.0f, State.POSITIVE);
        new TF2Attribute(102, "SpreadHealthPenalty", "Spread Health", Type.PERCENTAGE, 0.0f, State.NEGATIVE);
        new TF2Attribute(103, "AutoFireClip", "Auto Fire", Type.ADDITIVE, 0.0f, State.NEGATIVE);
        new TF2Attribute(104, "HealthRegen", "Health Regen", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(105, "Gravity", "Gravity", Type.ADDITIVE, 0.0f, State.NEGATIVE);
        new TF2Attribute(106, "FireRateHitBonus", "Fire Rate Hit", Type.PERCENTAGE, 1.0f, State.POSITIVE);
        new TF2Attribute(107, "ConstructionRateBonus", "Construction Rate", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(WRENCH, 0.4f, 3, 160, 4);
        new TF2Attribute(108, "ConstructionRatePenalty", "Construction Rate", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(109, "UpgradeRatePenalty", "Upgrade Rate", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(110, "TeleportCost", "Teleporter Cost", Type.PERCENTAGE, 1.0f, State.POSITIVE);
        new TF2Attribute(111, "MetalUsedOnHitPenalty", "Metal Used", Type.INVERTED_PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(112, "Looting", "Looting", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade(ITEM_WEAPON, 1.0f, 3, 220, 3);
        new TF2Attribute(113, "ArmorBonus", "Armor", Type.ADDITIVE, 0.0f, State.HIDDEN).setUpgrade(BACKPACK, 1.0f, 3, 240, 5);
        new TF2Attribute(114, "MeleeResistPenalty", "Melee Resist", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(115, "RangedResistBonus", "Ranged Resist", Type.PERCENTAGE, 1.0f, State.POSITIVE);
        new TF2Attribute(116, "HolsterTimePenalty", "Holster Time", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(117, "Unblockable", "Unblockable", Type.ADDITIVE, 1.0f, State.POSITIVE);
        new TF2Attribute(118, "SelfPushForceBonus", "Self Push Force", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade((Predicate<ItemStack>)Predicates.or(JUMPER, JETPACK), 0.2f, 5, 160, 4).setAustralium(1.25f);
        new TF2Attribute(119, "Jetpack", "Jetpack", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade(JETPACK, 1.0f, 1, 250, 4);
        new TF2Attribute(120, "SentryBonus", "Sentry Bonus", Type.PERCENTAGE, 1.0f, State.POSITIVE);
        new TF2Attribute(121, "BuildingHealthBonus", "Building Health", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(PDA, 0.6f, 5, 240, 6).setAustralium(0.8f);
        new TF2Attribute(122, "SentryFireRateBonus", "Sentry Fire Rate", Type.INVERTED_PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(PDA, -0.1f, 3, 160, 6).setAustralium(1.0f);
        new TF2Attribute(123, "DispenserRangeBonus", "Dispenser Range", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(PDA, 1.0f, 4, 120, 4);
        new TF2Attribute(124, "ExtraSentryBonus", "Extra Sentry", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade(PDA, 1.0f, 3, 200, 3).setAustralium(1.0f);
        new TF2Attribute(125, "OnyxProjectile", "Onyx Projectile", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(126, "AirblastRatePenalty", "Airblast Rate", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(127, "NoHeadshot", "No Headshot", Type.ADDITIVE, 0.0f, State.NEGATIVE);
        new TF2Attribute(128, "JarateOnHit", "Jarate Hit", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(129, "NoBackstab", "No Backstab", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(130, "AfterburnReductionBonus", "Afterburn Reduction", Type.INVERTED_PERCENTAGE, 0.0f, State.POSITIVE);
        new TF2Attribute(131, "ChargesBonus", "Charges", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade(JETPACK, 1.0f, 3, 200, 6);
        new TF2Attribute(132, "DamageBuildingPenalty", "Damage Building", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(133, "HitCrit", "Hit Crit", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(134, "PiercingShots", "Piercing", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade(PDA, 1.0f, 2, 180, 3);
        new TF2Attribute(135, "JetpackNoItem", "Jetpack Item", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade(JETPACK, 1.0f, 1, 320, 3);
        new TF2Attribute(136, "SelfDamageIncreased", "Self Damage", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(137, "MiniCritBurning", "Crit Burn", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(138, "DetonateFlare", "Detonate", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(139, "BombEnemy", "Bomb Enemy", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(140, "SilentKill", "Silent Kill", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(141, "DisguiseBackstab", "Disguise Backstab", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(142, "NoDisguiseKit", "No Disguise Kit", Type.ADDITIVE, 0.0f, State.NEGATIVE);
        new TF2Attribute(143, "SentryRangeBonus", "Sentry Range", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(PDA, 0.1f, 3, 160, 2);
        new TF2Attribute(144, "MetalBonus", "Max Metal", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(PDA, 0.5f, 4, 140, 5);
        new TF2Attribute(145, "DamagePlayerPenalty", "Damage Player", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(146, "MinicritAirborneSelf", "Minicrit Airborne Self", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(147, "DeployTimePenalty", "Deploy Time", Type.PERCENTAGE, 1.0f, State.NEGATIVE);
        new TF2Attribute(148, "GrantsTripleJump", "Triple Jump", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(149, "DealDamageRage", "Build Rage Damage", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(150, "MinicritRage", "Minicrit Rage", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(151, "RocketSpecialist", "Rocket Specialist", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade(ROCKET, 1.0f, 4, 80, 3);
        new TF2Attribute(152, "GrenadeSpecialist", "Grenade Specialist", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade(GRENADE, 1.0f, 3, 160, 3);
        new TF2Attribute(153, "FireSpecialist", "Fire Specialist", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade(FLAMETHROWER, 1.0f, 2, 120, 2);
        new TF2Attribute(154, "RegenOnHit", "Regen On Hit", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade(ITEM_WEAPON, 1.0f, 4, 80, 5).setAustralium(1.75f);
        new TF2Attribute(155, "TraceRound", "Trace Round", Type.ADDITIVE, 0.0f, State.NEGATIVE);
        new TF2Attribute(156, "LifeSteal", "Life Steal", Type.ADDITIVE, 0.0f, State.POSITIVE).setUpgrade(MEDIGUN, 1.0f, 3, 120, 2);
        new TF2Attribute(157, "BackstabDamageBonus", "Backstab Damage", Type.PERCENTAGE, 1.0f, State.POSITIVE).setUpgrade(KNIFE, 0.25f, 4, 240, 6).setAustralium(1.0f).setNoCostReduce();
        new TF2Attribute(158, "StunOnHit", "Stun On Hit", Type.ADDITIVE, 0.0f, State.POSITIVE);
        new TF2Attribute(159, "FuseTimeBonus", "Fuse Time", Type.ADDITIVE, 0.0f, State.POSITIVE);
    }

    public static float addValue(float value, NBTTagCompound attributelist, String effect) {
        for (String name : attributelist.func_150296_c()) {
            TF2Attribute attribute;
            NBTBase tag = attributelist.func_74781_a(name);
            if (!(tag instanceof NBTTagFloat) || (attribute = attributes[Integer.parseInt(name)]) == null || !attribute.effect.equals(effect)) continue;
            if (attribute.typeOfValue == Type.ADDITIVE) {
                value += ((NBTTagFloat)tag).func_150288_h();
                continue;
            }
            value *= ((NBTTagFloat)tag).func_150288_h();
        }
        return value;
    }

    public static float getModifier(String effect, ItemStack stack, float initial, EntityLivingBase entity) {
        if (!stack.hasCapability(TF2weapons.WEAPONS_DATA_CAP, null)) {
            return initial;
        }
        float value = ((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).getAttributeValue(stack, effect, initial);
        if (entity != null && entity instanceof EntityTF2Character) {
            value *= ((EntityTF2Character)entity).getAttributeModifier(effect);
        }
        return value;
    }

    public String getTranslatedString(float value, boolean withColor) {
        String valueStr = String.valueOf(value);
        if (this.typeOfValue == Type.PERCENTAGE) {
            valueStr = Integer.toString(Math.round((value - 1.0f) * 100.0f)) + "%";
        } else if (this.typeOfValue == Type.INVERTED_PERCENTAGE) {
            valueStr = Integer.toString(Math.round((1.0f - value) * 100.0f)) + "%";
        } else if (this.typeOfValue == Type.ADDITIVE) {
            valueStr = new DecimalFormat("##.#").format(value);
        }
        if (withColor) {
            TextFormatting color = this.state == State.POSITIVE ? TextFormatting.AQUA : (this.state == State.NEGATIVE ? TextFormatting.RED : TextFormatting.WHITE);
            return color + I18n.func_135052_a((String)("weaponAttribute." + this.name), (Object[])new Object[]{valueStr});
        }
        return I18n.func_135052_a((String)("weaponAttribute." + this.name), (Object[])new Object[]{valueStr});
    }

    public static List<TF2Attribute> getAllPassibleAttributesForUpgradeStation() {
        if (listUpgrades != null) {
            return listUpgrades;
        }
        ArrayList<TF2Attribute> list = new ArrayList<TF2Attribute>();
        for (TF2Attribute attr : attributes) {
            if (attr == null || attr.canApply == Predicates.alwaysFalse() || attr.state == State.NEGATIVE) continue;
            list.add(attr);
        }
        return list;
    }

    public static void setAttribute(ItemStack stack, TF2Attribute attr, float value) {
        if (!stack.func_190926_b() && stack.func_77942_o() && WeaponData.getCapability(stack) != null) {
            stack.func_77978_p().func_74775_l("Attributes").func_74776_a(String.valueOf(attr.id), value);
            WeaponData.getCapability((ItemStack)stack).cached = false;
        }
    }

    public static void upgradeItemStack(ItemStack stack, int value, Random rand) {
        if (WeaponData.getCapability(stack) == null) {
            return;
        }
        ArrayList<TF2Attribute> list = new ArrayList<TF2Attribute>();
        int lowestCost = Integer.MAX_VALUE;
        int maxCount = value / 30;
        for (TF2Attribute attr : attributes) {
            if (attr == null || !attr.canApply(stack) || attr.state != State.POSITIVE) continue;
            for (int i = 0; i < attr.weight; ++i) {
                list.add(attr);
            }
            lowestCost = Math.min(lowestCost, attr.cost);
        }
        if (list.size() > 0) {
            int i = 0;
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("Attributes");
            while (i < maxCount && value >= lowestCost) {
                ++i;
                TF2Attribute attr = (TF2Attribute)list.get(rand.nextInt(list.size()));
                if (attr.cost > value || attr.calculateCurrLevel(stack) > attr.numLevels) continue;
                value -= attr.cost;
                String key = String.valueOf(attr.id);
                if (!tag.func_74764_b(key)) {
                    tag.func_74776_a(key, attr.defaultValue);
                }
                tag.func_74776_a(key, tag.func_74760_g(key) + attr.getPerLevel(stack));
            }
        }
        WeaponData.getCapability((ItemStack)stack).cached = false;
    }

    public float getPerLevel(ItemStack stack) {
        float def = this.perLevel;
        if (stack.func_77973_b() instanceof ItemMinigun && this.effect.equals("Damage")) {
            def *= 0.5f;
        } else if (stack.func_77973_b() instanceof ItemJetpack && this.effect.equals("Self Push Force")) {
            def *= 0.75f;
        } else if (stack.func_77973_b() instanceof ItemChargingTarge && this.effect.equals("Charge")) {
            def *= 2.4f;
        } else if (stack.func_77973_b() instanceof ItemSniperRifle && this.effect.equals("Destroy Block")) {
            def *= 2.52f;
        }
        return def;
    }

    public int calculateCurrLevel(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (!stack.func_77978_p().func_74775_l("Attributes").func_74764_b(String.valueOf(this.id))) {
            return 0;
        }
        float valueOfAttr = stack.func_77978_p().func_74775_l("Attributes").func_74760_g(String.valueOf(this.id));
        float floatVal = (valueOfAttr - this.defaultValue) / this.getPerLevel(stack);
        return Math.round(floatVal - 0.3f);
    }

    public TF2Attribute getAttributeReplacement(ItemStack stack) {
        return this;
    }

    public int getUpgradeCost(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemFromData)) {
            return this.cost;
        }
        int baseCost = (int)((float)this.cost * TF2ConfigVars.xpMult);
        if (stack.func_77973_b() instanceof ItemWeapon) {
            if (ItemFromData.getData(stack).getInt(PropertyType.COST) <= 12) {
                baseCost = (int)((float)baseCost * (this.fullCost ? 0.75f : 0.5f));
            } else if (ItemFromData.getData(stack).getInt(PropertyType.COST) <= 18) {
                baseCost = (int)((float)baseCost * (this.fullCost ? 1.0f : 0.75f));
            }
        }
        if (TF2Attribute.getModifier("Damage", stack, 1.0f, null) <= 0.0f) {
            baseCost /= 2;
        }
        if (this.effect.equals("Fire Rate") && !ItemFromData.getData(stack).getBoolean(PropertyType.RELOADS_CLIP)) {
            baseCost = (int)((float)baseCost * 1.5f);
        }
        if (this.effect.equals("Clip Size") && ItemFromData.getData(stack).getBoolean(PropertyType.RELOADS_FULL_CLIP)) {
            baseCost = (int)((float)baseCost * 1.33335f);
        }
        if (this.effect.equals("Accuracy") && ItemFromData.getData(stack).getFloat(PropertyType.SPREAD) <= 0.025f) {
            baseCost /= 2;
        }
        if (stack.func_77976_d() > 1) {
            baseCost = baseCost / 3 * stack.func_190916_E();
        }
        if (stack.func_77973_b() instanceof ItemCloak) {
            baseCost *= 2;
        } else if (stack.func_77973_b() instanceof ItemJetpack && this.effect.equals("Self Push Force")) {
            baseCost = (int)((double)baseCost * 0.75);
        }
        int lastUpgradesCost = stack.func_77978_p().func_74762_e("TotalCost");
        int baseCostPre = baseCost;
        baseCost = (int)((float)baseCost * (1.0f + (float)lastUpgradesCost / 800.0f));
        if (this.calculateCurrLevel(stack) == this.numLevels - 1 && this.numLevels > 1) {
            baseCost = (int)((float)baseCost + (float)baseCostPre * (this.numLevels > 2 ? 2.0f : 1.25f) * (1.0f + (float)stack.func_77978_p().func_74762_e("LastUpgradesCost") / 800.0f));
        }
        return Math.min(1400, baseCost);
    }

    public String toString() {
        return this.name;
    }

    public boolean canApply(ItemStack stack) {
        return !stack.func_190926_b() && this.canApply.apply((Object)stack);
    }

    public static int getMaxExperience(ItemStack stack, EntityPlayer playerIn) {
        if (playerIn != null && playerIn.field_71075_bZ.field_75098_d) {
            return 99999;
        }
        int base = 1400;
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("Australium")) {
            base += 1000;
        }
        if (stack.func_77973_b() instanceof ItemPDA) {
            base = (int)((double)base * 1.75);
        }
        if (!(stack.func_77973_b() instanceof ItemWeapon)) {
            base *= 2;
        }
        int strangeLevel = 0;
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("Strange")) {
            strangeLevel = stack.func_77978_p().func_74762_e("StrangeLevel");
        }
        return (int)Math.min((float)TF2ConfigVars.xpCap, (float)(base + strangeLevel * strangeLevel * 40) * TF2ConfigVars.xpMult);
    }

    static {
        ITEM_WEAPON = input -> input.func_77973_b() instanceof ItemWeapon;
        NOT_FLAMETHROWER = input -> input.func_77973_b() instanceof ItemWeapon && !(input.func_77973_b() instanceof ItemFlameThrower);
        FLAMETHROWER = input -> input.func_77973_b() instanceof ItemFlameThrower;
        IGNITE = input -> input.func_77973_b() instanceof ItemAirblast || TF2Attribute.getModifier("BurnOnHit", input, 0.0f, null) > 0.0f;
        WITH_CLIP = input -> input.func_77973_b() instanceof ItemWeapon && ((ItemWeapon)input.func_77973_b()).hasClip((ItemStack)input);
        WITH_SPREAD = input -> input.func_77973_b() instanceof ItemWeapon && (((ItemWeapon)input.func_77973_b()).getWeaponSpreadBase((ItemStack)input, null) != 0.0f || ((ItemWeapon)input.func_77973_b()).getWeaponMinDamage((ItemStack)input, null) != 1.0f);
        WITH_AMMO = input -> input.func_77973_b() instanceof ItemUsable && ItemFromData.getData(input).getInt(PropertyType.AMMO_TYPE) != 0;
        CHARGE_RATE = input -> input.func_77973_b() instanceof ItemSniperRifle || input.func_77973_b() instanceof ItemChargingTarge || input.func_77973_b() instanceof ItemCloak;
        DURATION = input -> input.func_77973_b() instanceof ItemChargingTarge || input.func_77973_b() instanceof ItemSoldierBackpack || input.func_77973_b() instanceof ItemCloak;
        ITEM_BULLET = input -> {
            if (input.func_77973_b() instanceof ItemBulletWeapon && !ItemFromData.getData(input).hasProperty(PropertyType.PROJECTILE)) {
                return true;
            }
            Class<? extends EntityProjectileBase> clazz = MapList.projectileClasses.get(ItemFromData.getData(input).getString(PropertyType.PROJECTILE));
            return clazz != null && EntityProjectileSimple.class.isAssignableFrom(clazz);
        };
        ITEM_PROJECTILE = input -> input.func_77973_b() instanceof ItemProjectileWeapon || ItemFromData.getData(input).hasProperty(PropertyType.PROJECTILE);
        ITEM_MINIGUN = input -> input.func_77973_b() instanceof ItemMinigun;
        ITEM_SNIPER_RIFLE = input -> input.func_77973_b() instanceof ItemSniperRifle;
        EXPLOSIVE = input -> !(!(input.func_77973_b() instanceof ItemProjectileWeapon) && !ItemFromData.getData(input).hasProperty(PropertyType.PROJECTILE) || input.func_77973_b() instanceof ItemFlameThrower || MapList.projectileClasses.get(ItemFromData.getData(input).getString(PropertyType.PROJECTILE)) != null && EntityProjectileSimple.class.isAssignableFrom(MapList.projectileClasses.get(ItemFromData.getData(input).getString(PropertyType.PROJECTILE))));
        MEDIGUN = input -> input.func_77973_b() instanceof ItemMedigun;
        BANNER = input -> input.func_77973_b() instanceof ItemSoldierBackpack;
        BACKPACK = input -> input.func_77973_b() instanceof ItemBackpack;
        SHIELD = input -> input.func_77973_b() instanceof ItemChargingTarge;
        WATCH = input -> input.func_77973_b() instanceof ItemCloak;
        WRENCH = input -> input.func_77973_b() instanceof ItemWrench;
        JETPACK = input -> input.func_77973_b() instanceof ItemJetpack;
        PDA = input -> input.func_77973_b() instanceof ItemPDA;
        JUMPER = input -> TF2Attribute.getModifier("Self Damage", input, 1.0f, null) <= 0.0f;
        ROCKET = input -> ItemFromData.isSameType(input, "rocketlauncher");
        GRENADE = input -> ItemFromData.isSameType(input, "grenadelauncher");
        KNIFE = input -> input.func_77973_b() instanceof ItemKnife;
    }

    public static enum State {
        POSITIVE,
        NEGATIVE,
        NEUTRAL,
        HIDDEN;

    }

    public static enum Type {
        PERCENTAGE,
        INVERTED_PERCENTAGE,
        ADDITIVE;

    }
}

