/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.command;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.WeaponData;

public class CommandGenerateReferences
extends CommandBase {
    public String func_71518_a(ICommandSender p_71518_1_) {
        return "commands.generatereferences.usage";
    }

    public String func_71517_b() {
        return "generatereferences";
    }

    public int func_82362_a() {
        return 4;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        File dir = new File(TF2weapons.instance.weaponDir.getParentFile(), "TF2References");
        if (!dir.exists()) {
            dir.mkdir();
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(dir, "attributes.txt")));
            writer.write("ID - Name - Class - Default - Nice name");
            writer.newLine();
            for (TF2Attribute attr : TF2Attribute.attributes) {
                if (attr == null) continue;
                writer.write(attr.id + "\t" + attr.name + "\t" + attr.effect + "\t" + attr.defaultValue + "\t" + I18n.func_135052_a((String)("weaponAttribute." + attr.name), (Object[])new Object[]{Float.valueOf(attr.defaultValue)}));
                writer.newLine();
            }
            writer.close();
            writer = new BufferedWriter(new FileWriter(new File(dir, "properties.txt")));
            writer.write("ID - Name - Type");
            writer.newLine();
            for (PropertyType<?> prop : WeaponData.propertyTypes) {
                if (prop == null) continue;
                writer.write(prop.id + "\t" + prop.name + "\t" + prop.type.toString());
                writer.newLine();
            }
            writer.close();
            writer = new BufferedWriter(new FileWriter(new File(dir, "effects.txt")));
            writer.write("ID - Name");
            writer.newLine();
            for (Potion effect : GameRegistry.findRegistry(Potion.class)) {
                if (effect == null || !effect.getRegistryName().func_110624_b().equals("rafradek_tf2_weapons")) continue;
                writer.write(effect.getRegistryName() + "\t" + I18n.func_135052_a((String)effect.func_76393_a(), (Object[])new Object[0]));
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

