/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.command;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandClientDebug
extends CommandBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private long profileStartTime;
    private int profileStartTick;

    public String func_71517_b() {
        return "debugcl";
    }

    public int func_82362_a() {
        return 0;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.debug.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException("commands.debug.usage", new Object[0]);
        }
        if ("start".equals(args[0])) {
            if (args.length != 1) {
                throw new WrongUsageException("commands.debug.usage", new Object[0]);
            }
            CommandClientDebug.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.debug.start", (Object[])new Object[0]);
            Minecraft.func_71410_x().field_71474_y.field_74329_Q = true;
            this.profileStartTime = MinecraftServer.func_130071_aq();
            this.profileStartTick = server.func_71259_af();
        } else {
            if (!"stop".equals(args[0])) {
                throw new WrongUsageException("commands.debug.usage", new Object[0]);
            }
            if (args.length != 1) {
                throw new WrongUsageException("commands.debug.usage", new Object[0]);
            }
            if (!Minecraft.func_71410_x().field_71424_I.field_76327_a) {
                throw new CommandException("commands.debug.notStarted", new Object[0]);
            }
            long i = MinecraftServer.func_130071_aq();
            int j = server.func_71259_af();
            long k = i - this.profileStartTime;
            int l = j - this.profileStartTick;
            this.saveProfilerResults(k, l, server);
            Minecraft.func_71410_x().field_71474_y.field_74329_Q = false;
            CommandClientDebug.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.debug.stop", (Object[])new Object[]{String.format("%.2f", Float.valueOf((float)k / 1000.0f)), l});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProfilerResults(long timeSpan, int tickSpan, MinecraftServer server) {
        File file1 = new File(server.func_71209_f("debug"), "profile-results-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + ".txt");
        file1.getParentFile().mkdirs();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file1), StandardCharsets.UTF_8);
            writer.write(this.getProfilerResults(timeSpan, tickSpan, Minecraft.func_71410_x().field_71424_I));
        }
        catch (Throwable throwable) {
            try {
                LOGGER.error("Could not save profiler results to {}", (Object)file1, (Object)throwable);
            }
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(writer);
                throw throwable2;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    private String getProfilerResults(long timeSpan, int tickSpan, Profiler server) {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("---- Minecraft Profiler Results ----\n");
        stringbuilder.append("// ");
        stringbuilder.append(CommandClientDebug.getWittyComment());
        stringbuilder.append("\n\n");
        stringbuilder.append("Time span: ").append(timeSpan).append(" ms\n");
        stringbuilder.append("Tick span: ").append(tickSpan).append(" ticks\n");
        stringbuilder.append("// This is approximately ").append(String.format("%.2f", Float.valueOf((float)tickSpan / ((float)timeSpan / 1000.0f)))).append(" ticks per second. It should be ").append(20).append(" ticks per second\n\n");
        stringbuilder.append("--- BEGIN PROFILE DUMP ---\n\n");
        this.appendProfilerResults(0, "root", stringbuilder, server);
        stringbuilder.append("--- END PROFILE DUMP ---\n\n");
        return stringbuilder.toString();
    }

    private void appendProfilerResults(int depth, String sectionName, StringBuilder builder, Profiler server) {
        List list = server.func_76321_b(sectionName);
        if (list != null && list.size() >= 3) {
            for (int i = 1; i < list.size(); ++i) {
                Profiler.Result profiler$result = (Profiler.Result)list.get(i);
                builder.append(String.format("[%02d] ", depth));
                for (int j = 0; j < depth; ++j) {
                    builder.append("|   ");
                }
                builder.append(profiler$result.field_76331_c).append(" - ").append(String.format("%.2f", profiler$result.field_76332_a)).append("%/").append(String.format("%.2f", profiler$result.field_76330_b)).append("%\n");
                if ("unspecified".equals(profiler$result.field_76331_c)) continue;
                try {
                    this.appendProfilerResults(depth + 1, sectionName + "." + profiler$result.field_76331_c, builder, server);
                    continue;
                }
                catch (Exception exception) {
                    builder.append("[[ EXCEPTION ").append(exception).append(" ]]");
                }
            }
        }
    }

    private static String getWittyComment() {
        String[] astring = new String[]{"Shiny numbers!", "Am I not running fast enough? :(", "I'm working as hard as I can!", "Will I ever be good enough for you? :(", "Speedy. Zoooooom!", "Hello world", "40% better than a crash report.", "Now with extra numbers", "Now with less numbers", "Now with the same numbers", "You should add flames to things, it makes them go faster!", "Do you feel the need for... optimization?", "*cracks redstone whip*", "Maybe if you treated it better then it'll have more motivation to work faster! Poor server."};
        try {
            return astring[(int)(System.nanoTime() % (long)astring.length)];
        }
        catch (Throwable var2) {
            return "Witty comment unavailable :(";
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return args.length == 1 ? CommandClientDebug.func_71530_a((String[])args, (String[])new String[]{"start", "stop"}) : Collections.emptyList();
    }
}

