/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.client.renderer.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.client.TF2EventsClient;
import rafradek.TF2weapons.client.model.ModelHeavy;
import rafradek.TF2weapons.client.model.ModelTF2Character;
import rafradek.TF2weapons.client.renderer.LayerArmorTint;
import rafradek.TF2weapons.client.renderer.LayerWearables;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.mercenary.EntityHeavy;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemMeleeWeapon;
import rafradek.TF2weapons.item.ItemToken;
import rafradek.TF2weapons.util.TF2Util;

public class RenderTF2Character
extends RenderBiped<EntityTF2Character> {
    private static final String TEXTURE_PATH_BASE = "rafradek_tf2_weapons:textures/entity/tf2/";
    private static final ResourceLocation[] RED_TEXTURES = RenderTF2Character.putResourcesFor("red");
    private static final ResourceLocation[] BLU_TEXTURES = RenderTF2Character.putResourcesFor("blu");
    public static final ResourceLocation[] ROBOT_TEXTURES = RenderTF2Character.putResourcesFor("robot");
    private static final ResourceLocation[] ROBOT_BLU_TEXTURES;
    private static final ResourceLocation[] ROBOT_RED_TEXTURES;
    public ModelBiped modelHeavy = new ModelHeavy();
    public ModelBiped modelMain = (ModelBiped)this.field_77045_g;

    private static ResourceLocation[] putResourcesFor(String name) {
        ResourceLocation[] location = new ResourceLocation[9];
        for (int i = 0; i < 9; ++i) {
            location[i] = new ResourceLocation(TEXTURE_PATH_BASE + name + "/" + ItemToken.CLASS_NAMES[i] + ".png");
        }
        return location;
    }

    public RenderTF2Character(RenderManager renderManager) {
        super(renderManager, (ModelBiped)new ModelTF2Character(), 0.5f);
        this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
        this.func_177094_a(new LayerArmorTint((RenderLivingBase<?>)this));
        this.func_177094_a(new LayerWearables((RenderLivingBase<?>)this));
        this.field_177097_h.removeIf(layer -> layer instanceof LayerCustomHead);
    }

    protected ResourceLocation getEntityTexture(EntityTF2Character par1EntityLiving) {
        boolean sameTeam = Minecraft.func_71410_x().field_71439_g != null && TF2Util.isOnSameTeam((Entity)Minecraft.func_71410_x().field_71439_g, (Entity)par1EntityLiving);
        int clazz = !sameTeam && WeaponsCapability.get((Entity)par1EntityLiving).isDisguised() && WeaponsCapability.get((Entity)par1EntityLiving).getDisguiseType().startsWith("T:") ? ItemToken.getClassID(WeaponsCapability.get((Entity)par1EntityLiving).getDisguiseType().substring(2).toLowerCase()) : par1EntityLiving.getClassIndex();
        if (par1EntityLiving.getEntTeam() == 2 && !WeaponsCapability.get((Entity)par1EntityLiving).isDisguised()) {
            if (par1EntityLiving.func_184753_b() != null) {
                if (par1EntityLiving.func_96124_cp() == par1EntityLiving.func_190670_t_().func_96441_U().func_96508_e("BLU")) {
                    return ROBOT_BLU_TEXTURES[clazz];
                }
                return ROBOT_RED_TEXTURES[clazz];
            }
            return ROBOT_TEXTURES[clazz];
        }
        if (par1EntityLiving.getEntTeam() == 0 || !sameTeam && par1EntityLiving.getEntTeam() == 1 && WeaponsCapability.get((Entity)par1EntityLiving).isDisguised()) {
            return RED_TEXTURES[clazz];
        }
        return BLU_TEXTURES[clazz];
    }

    public void doRender(EntityTF2Character living, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        this.setModel((EntityLivingBase)living);
        boolean sniperZoomed = false;
        if (living.func_184614_ca() != null && !(living.func_184614_ca().func_77973_b() instanceof ItemMeleeWeapon)) {
            sniperZoomed = living.getCapability(TF2weapons.WEAPONS_CAP, null).isCharging();
            ((ModelBiped)this.field_77045_g).field_187076_m = (living.getCapability(TF2weapons.WEAPONS_CAP, null).state & 3) > 0 || sniperZoomed ? ModelBiped.ArmPose.BOW_AND_ARROW : ModelBiped.ArmPose.EMPTY;
        }
        super.func_76986_a((EntityLiving)living, p_76986_2_, p_76986_4_, p_76986_6_, p_76986_8_, p_76986_9_);
        if (living.func_70089_S()) {
            TF2EventsClient.renderBeam((EntityLivingBase)living, p_76986_9_, 0.04f);
            if (sniperZoomed) {
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder renderer = tessellator.func_178180_c();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)p_76986_2_), (float)((float)p_76986_4_ + living.func_70047_e()), (float)((float)p_76986_6_));
                GL11.glRotatef((float)((living.field_70758_at + (living.field_70759_as - living.field_70758_at) * p_76986_9_) * -1.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(living.field_70127_C + (living.field_70125_A - living.field_70127_C) * p_76986_9_), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179140_f();
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                ClientProxy.setColor(TF2Util.getTeamColor((Entity)living), 0.28f, 0.0f, 0.0f, 1.0f);
                renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                renderer.func_181662_b(-0.03, -0.03, 0.0).func_181675_d();
                renderer.func_181662_b(0.03, 0.03, 0.0).func_181675_d();
                renderer.func_181662_b(0.03, 0.03, 50.0).func_181675_d();
                renderer.func_181662_b(-0.03, -0.03, 50.0).func_181675_d();
                tessellator.func_78381_a();
                renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                renderer.func_181662_b(-0.03, -0.03, 50.0).func_181675_d();
                renderer.func_181662_b(0.03, 0.03, 50.0).func_181675_d();
                renderer.func_181662_b(0.03, 0.03, 0.0).func_181675_d();
                renderer.func_181662_b(-0.03, -0.03, 0.0).func_181675_d();
                tessellator.func_78381_a();
                renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                renderer.func_181662_b(0.03, -0.03, 0.0).func_181675_d();
                renderer.func_181662_b(-0.03, 0.03, 0.0).func_181675_d();
                renderer.func_181662_b(-0.03, 0.03, 50.0).func_181675_d();
                renderer.func_181662_b(0.03, -0.03, 50.0).func_181675_d();
                tessellator.func_78381_a();
                renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                renderer.func_181662_b(0.03, -0.03, 50.0).func_181675_d();
                renderer.func_181662_b(-0.03, 0.03, 50.0).func_181675_d();
                renderer.func_181662_b(-0.03, 0.03, 0.0).func_181675_d();
                renderer.func_181662_b(0.03, -0.03, 0.0).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3042);
                GlStateManager.func_179098_w();
                GlStateManager.func_179145_e();
                GlStateManager.func_179121_F();
            }
        }
    }

    protected void preRenderCallback(EntityTF2Character entitylivingbaseIn, float partialTickTime) {
        float f = 0.9375f;
        if (entitylivingbaseIn instanceof EntityHeavy) {
            f = 1.0f;
        }
        if (entitylivingbaseIn.getRobotSize() == 2) {
            f *= 1.75f;
        } else if (entitylivingbaseIn.getRobotSize() == 3) {
            f *= 2.0f;
        }
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
    }

    private void setModel(EntityLivingBase living) {
        this.field_77045_g = living instanceof EntityHeavy ? this.modelHeavy : this.modelMain;
    }

    static {
        ROBOT_RED_TEXTURES = RenderTF2Character.putResourcesFor("robot_red");
        ROBOT_BLU_TEXTURES = RenderTF2Character.putResourcesFor("robot_blu");
    }
}

