/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.client.renderer.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.client.model.ModelBuild;
import rafradek.TF2weapons.client.model.ModelDispenser;
import rafradek.TF2weapons.client.model.ModelDispenser2;
import rafradek.TF2weapons.client.model.ModelDispenser3;
import rafradek.TF2weapons.entity.building.EntityDispenser;
import rafradek.TF2weapons.util.TF2Util;

public class RenderDispenser
extends RenderLiving<EntityDispenser> {
    private static final ResourceLocation DISPENSER_RED = new ResourceLocation("rafradek_tf2_weapons", "textures/entity/tf2/red/Dispenser.png");
    private static final ResourceLocation DISPENSER_BLU = new ResourceLocation("rafradek_tf2_weapons", "textures/entity/tf2/blu/Dispenser.png");
    private static final ResourceLocation DISPENSER_ROBOT = new ResourceLocation("rafradek_tf2_weapons", "textures/entity/tf2/robot/Dispenser.png");
    private static final ResourceLocation BOX_RED = new ResourceLocation("rafradek_tf2_weapons", "textures/entity/tf2/red/box.png");
    private static final ResourceLocation BOX_BLU = new ResourceLocation("rafradek_tf2_weapons", "textures/entity/tf2/blu/box.png");
    public ModelBase level1;
    public ModelBase level2;
    public ModelBase level3;
    public ModelBase box;

    public RenderDispenser(RenderManager renderManager) {
        super(renderManager, (ModelBase)new ModelDispenser(), 0.8f);
        this.level1 = this.field_77045_g;
        this.level2 = new ModelDispenser2();
        this.level3 = new ModelDispenser3();
        this.box = new ModelBuild();
    }

    protected ResourceLocation getEntityTexture(EntityDispenser par1EntityLiving) {
        boolean constr = par1EntityLiving.isConstructing();
        switch (par1EntityLiving.getEntTeam()) {
            case 0: {
                return constr ? BOX_RED : DISPENSER_RED;
            }
            case 1: {
                return constr ? BOX_BLU : DISPENSER_BLU;
            }
            case 2: {
                return constr ? BOX_BLU : DISPENSER_ROBOT;
            }
        }
        return constr ? BOX_BLU : DISPENSER_BLU;
    }

    public void doRender(EntityDispenser living, double p_76986_2_, double p_76986_4_, double p_76986_6_, float p_76986_8_, float p_76986_9_) {
        this.field_77045_g = living.isConstructing() ? this.box : (living.getLevel() == 1 ? this.level1 : (living.getLevel() == 2 ? this.level2 : this.level3));
        super.func_76986_a((EntityLiving)living, p_76986_2_, p_76986_4_, p_76986_6_, p_76986_8_, p_76986_9_);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        if (living.dispenserTarget != null) {
            for (EntityLivingBase target : living.dispenserTarget) {
                double xPos2 = target.field_70169_q + (target.field_70165_t - target.field_70169_q) * (double)p_76986_9_;
                double yPos2 = target.field_70167_r + (target.field_70163_u - target.field_70167_r) * (double)p_76986_9_;
                double zPos2 = target.field_70166_s + (target.field_70161_v - target.field_70166_s) * (double)p_76986_9_;
                double xDist = xPos2 - (living.field_70169_q + (living.field_70165_t - living.field_70169_q) * (double)p_76986_9_);
                double yDist = yPos2 + (double)(target.field_70131_O / 2.0f) - (living.field_70167_r + (living.field_70163_u - living.field_70167_r) * (double)p_76986_9_ + (double)(living.field_70131_O / 2.0f));
                double zDist = zPos2 - (living.field_70166_s + (living.field_70161_v - living.field_70166_s) * (double)p_76986_9_);
                float f = MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist));
                float fullDist = MathHelper.func_76133_a((double)(xDist * xDist + yDist * yDist + zDist * zDist));
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)p_76986_2_), (float)((float)p_76986_4_ + living.field_70131_O / 2.0f), (float)((float)p_76986_6_));
                GL11.glRotatef((float)((float)(Math.atan2(xDist, zDist) * 180.0 / Math.PI)), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)((float)(Math.atan2(yDist, f) * 180.0 / Math.PI) * -1.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179140_f();
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                ClientProxy.setColor(TF2Util.getTeamColor((Entity)living), 0.23f, 0.0f, 0.0f, 1.0f);
                renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                renderer.func_181662_b(-0.04, -0.04, 0.0).func_181675_d();
                renderer.func_181662_b(0.04, 0.04, 0.0).func_181675_d();
                renderer.func_181662_b(0.04, 0.04, (double)fullDist).func_181675_d();
                renderer.func_181662_b(-0.04, -0.04, (double)fullDist).func_181675_d();
                tessellator.func_78381_a();
                renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                renderer.func_181662_b(-0.04, -0.04, (double)fullDist).func_181675_d();
                renderer.func_181662_b(0.04, 0.04, (double)fullDist).func_181675_d();
                renderer.func_181662_b(0.04, 0.04, 0.0).func_181675_d();
                renderer.func_181662_b(-0.04, -0.04, 0.0).func_181675_d();
                tessellator.func_78381_a();
                renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                renderer.func_181662_b(0.04, -0.04, 0.0).func_181675_d();
                renderer.func_181662_b(-0.04, 0.04, 0.0).func_181675_d();
                renderer.func_181662_b(-0.04, 0.04, (double)fullDist).func_181675_d();
                renderer.func_181662_b(0.04, -0.04, (double)fullDist).func_181675_d();
                tessellator.func_78381_a();
                renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                renderer.func_181662_b(0.04, -0.04, (double)fullDist).func_181675_d();
                renderer.func_181662_b(-0.04, 0.04, (double)fullDist).func_181675_d();
                renderer.func_181662_b(-0.04, 0.04, 0.0).func_181675_d();
                renderer.func_181662_b(0.04, -0.04, 0.0).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3042);
                GlStateManager.func_179145_e();
                GlStateManager.func_179098_w();
                GlStateManager.func_179121_F();
            }
        }
    }
}

