/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.client.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.inventory.InventoryLoadout;
import rafradek.TF2weapons.inventory.InventoryWearables;
import rafradek.TF2weapons.item.ItemAmmoBelt;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemWearable;
import rafradek.TF2weapons.util.PropertyType;

@SideOnly(value=Side.CLIENT)
public class LayerWearables
implements LayerRenderer<EntityLivingBase> {
    public final ModelBiped modelBig;
    public final ModelBiped modelMedium;
    public final ModelBiped modelSmall;
    public RenderLivingBase<?> renderer;

    public LayerWearables(RenderLivingBase<?> render) {
        this.renderer = render;
        this.modelBig = new ModelBiped(1.15f);
        this.modelMedium = new ModelBiped(0.75f);
        this.modelSmall = new ModelBiped(0.25f);
    }

    public void func_177141_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        InventoryWearables inventory = (InventoryWearables)((Object)entitylivingbaseIn.getCapability(TF2weapons.INVENTORY_CAP, null));
        if (inventory != null) {
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                this.renderModel(entitylivingbaseIn, stack, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
            }
        }
        if (entitylivingbaseIn instanceof EntityTF2Character) {
            InventoryLoadout loadout = ((EntityTF2Character)entitylivingbaseIn).loadout;
            for (int i = 0; i < loadout.getSlots(); ++i) {
                ItemStack stack = loadout.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                this.renderModel(entitylivingbaseIn, stack, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
            }
        }
        for (ItemStack stack : entitylivingbaseIn.func_184193_aE()) {
            if (stack.func_190926_b()) continue;
            this.renderModel(entitylivingbaseIn, stack, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    public void renderModel(EntityLivingBase living, ItemStack stack, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (stack.func_77973_b() instanceof ItemFromData) {
            Minecraft minecraft = Minecraft.func_71410_x();
            int visibility = ((ItemFromData)stack.func_77973_b()).getVisibilityFlags(stack, living);
            if ((visibility & 1) == 1) {
                GlStateManager.func_179094_E();
                if (living.func_70093_af()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
                }
                this.getHead().func_78794_c(0.0625f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.65f, (float)-0.65f, (float)-0.65f);
                ItemWearable.usedModel = 2;
                minecraft.func_175597_ag().func_178099_a(living, stack, ItemCameraTransforms.TransformType.HEAD);
                GlStateManager.func_179121_F();
            }
            if ((visibility & 2) == 2) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                if (living.func_70093_af()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.0f);
                }
                this.getBody().func_78794_c(0.0f);
                ItemWearable.usedModel = 1;
                minecraft.func_175597_ag().func_178099_a(living, stack, ItemCameraTransforms.TransformType.HEAD);
                GlStateManager.func_179121_F();
            }
            if (!ItemFromData.getData(stack).getString(PropertyType.ARMOR_IMAGE).isEmpty()) {
                this.renderer.func_110776_a(this.getArmorResource((Entity)living, stack, EntityEquipmentSlot.CHEST, null));
                ModelBiped model = this.modelBig;
                model.func_178686_a(this.renderer.func_177087_b());
                model.func_78086_a(living, limbSwing, limbSwingAmount, partialTicks);
                model.func_78088_a((Entity)living, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            }
            ItemWearable.usedModel = 0;
        }
        if (stack.func_77973_b() instanceof ItemAmmoBelt) {
            this.renderer.func_110776_a(this.getArmorResource((Entity)living, stack, EntityEquipmentSlot.CHEST, null));
            ModelBiped model = this.modelBig;
            model.func_178686_a(this.renderer.func_177087_b());
            model.func_78086_a(living, limbSwing, limbSwingAmount, partialTicks);
            model.func_78088_a((Entity)living, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EntityEquipmentSlot slot, String type) {
        return new ResourceLocation(ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)"", (EntityEquipmentSlot)slot, (String)type));
    }

    public boolean func_177142_b() {
        return false;
    }

    private ModelRenderer getHead() {
        return ((ModelBiped)this.renderer.func_177087_b()).field_78116_c;
    }

    private ModelRenderer getBody() {
        return ((ModelBiped)this.renderer.func_177087_b()).field_78115_e;
    }
}

