/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rafradek.TF2weapons.client.TF2EventsClient;
import rafradek.TF2weapons.util.TF2Util;

public class EntityBulletTracer
extends Particle {
    private float duration;
    private boolean nextDead;
    private float length;
    private boolean motionless;

    public EntityBulletTracer(World par1World, double startX, double startY, double startZ, double x, double y, double z, int speed, int color, float length) {
        super(par1World, startX, startY, startZ);
        this.field_70544_f = 0.2f;
        double dist = new Vec3d(startX, startY, startZ).func_72438_d(new Vec3d(x, y, z));
        if (speed > 0) {
            this.duration = (float)dist / (float)speed;
            this.field_187129_i = (x - startX) / (double)this.duration;
            this.field_187130_j = (y - startY) / (double)this.duration;
            this.field_187131_k = (z - startZ) / (double)this.duration;
            this.length = length;
        } else {
            this.motionless = true;
            this.duration = length;
            this.length = (float)dist * 1000.0f;
            this.field_187129_i = (x - startX) / dist * 0.001;
            this.field_187130_j = (y - startY) / dist * 0.001;
            this.field_187131_k = (z - startZ) / dist * 0.001;
        }
        this.field_70547_e = 200;
        this.func_187115_a(0.025f, 0.025f);
        this.func_187117_a(TF2EventsClient.pelletIcon[0]);
        this.func_70541_f(2.0f);
        if (color == 0) {
            this.func_70538_b(0.97f, 0.76f, 0.51f);
        } else {
            this.func_70538_b((float)(color >> 16) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        }
    }

    public EntityBulletTracer(World par1World, double startX, double startY, double startZ, double x, double y, double z, int duration, int crits, EntityLivingBase shooter, int type, float length) {
        this(par1World, startX, startY, startZ, x, y, z, duration, 0, length);
        if (crits != 2) {
            this.func_70538_b(0.97f, 0.76f, 0.51f);
        } else {
            int color = TF2Util.getTeamColor((Entity)shooter);
            this.func_70538_b(MathHelper.func_76131_a((float)((float)(color >> 16) / 255.0f), (float)0.2f, (float)1.0f), MathHelper.func_76131_a((float)((float)(color >> 8 & 0xFF) / 255.0f), (float)0.2f, (float)1.0f), MathHelper.func_76131_a((float)((float)(color & 0xFF) / 255.0f), (float)0.2f, (float)1.0f));
        }
    }

    public void func_189213_a() {
        if (this.nextDead) {
            this.func_187112_i();
        }
        this.nextDead = true;
        super.func_189213_a();
        this.field_187129_i *= 1.025;
        this.field_187130_j *= 1.025;
        this.field_187131_k *= 1.025;
        if (this.duration > 0.0f) {
            this.duration -= 1.0f;
            if (this.duration <= 0.0f) {
                this.func_187112_i();
            }
        }
    }

    public void func_180434_a(BufferBuilder worldRendererIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float zNext;
        float yNext;
        float xNext;
        float x = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float y = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float z = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        Vec3d rightVec = new Vec3d(this.field_187129_i, this.field_187130_j, this.field_187131_k).func_72431_c(Minecraft.func_71410_x().func_175606_aa().func_70676_i(1.0f)).func_72432_b();
        float f4 = 0.1f * this.field_70544_f;
        int i = this.func_189214_a(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        if (this.motionless) {
            xNext = (float)((double)x + this.field_187129_i * (double)this.length);
            yNext = (float)((double)y + this.field_187130_j * (double)this.length);
            zNext = (float)((double)z + this.field_187131_k * (double)this.length);
        } else {
            float length = 2.0f * this.length;
            if (this.duration < 1.0f) {
                length *= this.duration - (float)((int)this.duration);
            }
            xNext = (float)((double)x + this.field_187129_i * (double)length);
            yNext = (float)((double)y + this.field_187130_j * (double)length);
            zNext = (float)((double)z + this.field_187131_k * (double)length);
        }
        float xMin = this.field_187119_C.func_94209_e();
        float xMax = this.field_187119_C.func_94212_f();
        float yMin = this.field_187119_C.func_94206_g();
        float yMax = this.field_187119_C.func_94210_h();
        worldRendererIn.func_181662_b((double)x - rightVec.field_72450_a * (double)f4, (double)y - rightVec.field_72448_b * (double)f4, (double)z - rightVec.field_72449_c * (double)f4).func_187315_a((double)xMax, (double)yMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        worldRendererIn.func_181662_b((double)x + rightVec.field_72450_a * (double)f4, (double)y + rightVec.field_72448_b * (double)f4, (double)z + rightVec.field_72449_c * (double)f4).func_187315_a((double)xMax, (double)yMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        worldRendererIn.func_181662_b((double)xNext + rightVec.field_72450_a * (double)f4, (double)yNext + rightVec.field_72448_b * (double)f4, (double)zNext + rightVec.field_72449_c * (double)f4).func_187315_a((double)xMin, (double)yMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        worldRendererIn.func_181662_b((double)xNext - rightVec.field_72450_a * (double)f4, (double)yNext - rightVec.field_72448_b * (double)f4, (double)zNext - rightVec.field_72449_c * (double)f4).func_187315_a((double)xMin, (double)yMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
    }

    public void func_187110_a(double x, double y, double z) {
        this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        this.func_187118_j();
    }

    public int func_70537_b() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_189214_a(float p_70070_1_) {
        return 0xF000F0;
    }

    public float getBrightness(float p_70013_1_) {
        return 1.0f;
    }

    public static class Factory
    implements IParticleFactory {
        public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... p_178902_15_) {
            return new EntityBulletTracer(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, p_178902_15_[0], p_178902_15_[1], (float)p_178902_15_[2] / 64.0f);
        }
    }
}

