/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.client.gui.inventory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.gui.GuiTooltip;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.inventory.ContainerUpgrades;
import rafradek.TF2weapons.tileentity.TileEntityUpgrades;

public class GuiUpgradeStation
extends GuiContainer {
    private static final ResourceLocation UPGRADES_GUI_TEXTURES = new ResourceLocation("rafradek_tf2_weapons", "textures/gui/container/upgrades.png");
    public ArrayList<GuiTooltip> tooltip = new ArrayList();
    public GuiButton[] buttons = new GuiButton[12];
    public GuiButton refund;
    public int firstIndex;
    public float scroll;
    public int tabid;
    public ItemStack craftingTabStack = new ItemStack(TF2weapons.itemAmmo, 1, 1);
    public ItemStack chestTabStack = new ItemStack((Block)Blocks.field_150486_ae);
    public TileEntityUpgrades station;
    private boolean isScrolling;
    private boolean wasClicking;

    public GuiUpgradeStation(Container inventorySlotsIn) {
        super(inventorySlotsIn);
    }

    public GuiUpgradeStation(InventoryPlayer playerInv, TileEntityUpgrades station, World worldIn, BlockPos blockPosition) {
        super((Container)new ContainerUpgrades((EntityPlayer)Minecraft.func_71410_x().field_71439_g, playerInv, station, worldIn, blockPosition));
        this.station = station;
        this.field_146999_f = 230;
        this.field_147000_g = 225;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tooltip.clear();
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 3; ++y) {
                GuiButton guiButton = new GuiButton(x * 2 + y * 4, this.field_147003_i + 81 + x * 101, this.field_147009_r + 47 + y * 30, 12, 12, "+");
                this.buttons[x * 2 + y * 4] = guiButton;
                this.field_146292_n.add(guiButton);
                GuiButton guiButton2 = new GuiButton(x * 2 + y * 4 + 1, this.field_147003_i + 94 + x * 101, this.field_147009_r + 47 + y * 30, 12, 12, "-");
                this.buttons[x * 2 + y * 4 + 1] = guiButton2;
                this.field_146292_n.add(guiButton2);
            }
        }
        this.tooltip.add(new GuiTooltip(this.field_147003_i + 128, this.field_147009_r + 15, 100, 12, I18n.func_135052_a((String)"container.upgrades.info", (Object[])new Object[0]), (GuiScreen)this));
        this.refund = new GuiButton(12, this.field_147003_i + 123, this.field_147009_r + 121, 100, 20, I18n.func_135052_a((String)"container.upgrades.refund", (Object[])new Object[0]));
        this.field_146292_n.add(this.refund);
        this.setButtons();
    }

    public void setButtons() {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int size;
        this.func_146276_q_();
        boolean flag = Mouse.isButtonDown((int)0);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        int k = i + 209;
        int l = j + 30;
        int i1 = k + 14;
        int j1 = l + 96;
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = true;
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling && (size = ((ContainerUpgrades)this.field_147002_h).applicable.size()) >= 6) {
            this.scroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.scroll = MathHelper.func_76131_a((float)this.scroll, (float)0.0f, (float)1.0f);
            this.firstIndex = Math.round(this.scroll * (float)(size - 6) / 2.0f) * 2;
            this.setButtons();
        }
        this.refund.field_146124_l = !((Slot)this.field_147002_h.field_75151_b.get(0)).func_75211_c().func_190926_b() && ((Slot)this.field_147002_h.field_75151_b.get(0)).func_75211_c().func_77978_p().func_74762_e("TotalSpent") > 0;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        for (GuiTooltip tooltip : this.tooltip) {
            tooltip.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
        for (int m = 0; m < 6; ++m) {
        }
    }

    public void func_146283_a(List<String> textLines, int x, int y) {
        this.drawHoveringText(textLines, x, y, this.field_146289_q);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k < 12) {
            this.field_146297_k.field_71442_b.func_78756_a(this.field_147002_h.field_75152_c, button.field_146127_k + this.firstIndex * 2);
        } else if (button.field_146127_k == 12) {
            this.field_146297_k.field_71442_b.func_78756_a(this.field_147002_h.field_75152_c, -1);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int expPoints = ((ContainerUpgrades)this.field_147002_h).playerCredits;
        int size = ((ContainerUpgrades)this.field_147002_h).applicable.size();
        ItemStack stack = ((Slot)this.field_147002_h.field_75151_b.get(0)).func_75211_c();
        for (int i = 0; i < 6; ++i) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(UPGRADES_GUI_TEXTURES);
            if (i + this.firstIndex < size) {
                int cost;
                TF2Attribute attr = ((ContainerUpgrades)this.field_147002_h).applicable.get(i + this.firstIndex).getAttributeReplacement(stack);
                TF2Attribute attrorig = ((ContainerUpgrades)this.field_147002_h).applicable.get(i + this.firstIndex);
                if (attr == null) continue;
                int xOffset = 101 * (i % 2);
                int yOffset = i / 2 * 30;
                int currLevel = attr.calculateCurrLevel(stack);
                int austrUpgrade = stack.func_77978_p().func_74764_b("AusUpg") ? (int)stack.func_77978_p().func_74765_d("AusUpg") : -1;
                boolean austr = currLevel == attr.numLevels && attr.austrUpgrade != 0.0f && stack.func_77978_p().func_74767_n("Australium") && austrUpgrade != attr.id;
                boolean hasAustr = austrUpgrade == attr.id;
                for (int j = 0; j < this.station.attributes.get(attrorig); ++j) {
                    this.func_73729_b(9 + xOffset + j * 9, 50 + yOffset, currLevel > j ? 240 : 248, !hasAustr ? 24 : 32, 8, 8);
                }
                int n = cost = austr ? 0 : attr.getUpgradeCost(stack);
                if (currLevel < this.station.attributes.get(attrorig)) {
                    this.field_146289_q.func_78276_b(String.valueOf(cost), 56 + xOffset, 50 + yOffset, 0xFFFFFF);
                }
                this.field_146289_q.func_78279_b(attr.getTranslatedString((float)(attr.typeOfValue != TF2Attribute.Type.ADDITIVE ? 1 : 0) + attr.getPerLevel(stack) * (austr ? attr.austrUpgrade : 1.0f), false), 9 + xOffset, 32 + yOffset, 98, 0xFFFFFF);
                this.buttons[i * 2].field_146125_m = true;
                this.buttons[i * 2 + 1].field_146125_m = true;
                if (!attr.canApply(stack) || currLevel >= this.station.attributes.get(attrorig) && !austr || cost > expPoints || cost + stack.func_77978_p().func_74762_e("TotalSpent") > TF2Attribute.getMaxExperience(stack, (EntityPlayer)this.field_146297_k.field_71439_g)) {
                    this.buttons[i * 2].field_146124_l = false;
                    this.buttons[i * 2 + 1].field_146124_l = currLevel > 0;
                    this.func_73733_a(8 + xOffset, 31 + yOffset, 107 + xOffset, 59 + yOffset, 0x77000000, 0x77000000);
                    continue;
                }
                this.buttons[i * 2].field_146124_l = true;
                this.buttons[i * 2 + 1].field_146124_l = currLevel > 0;
                continue;
            }
            this.buttons[i * 2].field_146125_m = false;
            this.buttons[i * 2 + 1].field_146125_m = false;
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.upgrades", (Object[])new Object[0]), 8, 5, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.currency", (Object[])new Object[]{String.valueOf(expPoints)}), 128, 5, 0x404040);
        if (!stack.func_190926_b()) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.currencyLeft", (Object[])new Object[]{String.valueOf(stack.func_77978_p().func_74762_e("TotalSpent")), String.valueOf(TF2Attribute.getMaxExperience(stack, (EntityPlayer)this.field_146297_k.field_71439_g))}), 128, 15, 0x404040);
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 36, this.field_147000_g - 96 + 3, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(UPGRADES_GUI_TEXTURES);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        x = this.field_147003_i + 210;
        y = this.field_147009_r + 31;
        int k = y + 96;
        this.func_73729_b(x, y + (int)((float)(k - y - 17) * this.scroll), 232, 0, 12, 15);
    }
}

