/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.client.gui.inventory;

import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.entity.building.EntityTeleporter;
import rafradek.TF2weapons.inventory.ContainerEnergy;
import rafradek.TF2weapons.message.TF2Message;

public class GuiTeleporter
extends GuiContainer {
    public EntityTeleporter teleporter;
    public GuiButton doneBtn;
    public GuiButton teleportUpBtn;
    public GuiButton teleportDownBtn;
    public GuiButton exitToggle;
    public GuiButton grab;
    private GuiTextField teleportField;
    public int channel;
    public boolean exit;
    private static final ResourceLocation GUI_TEXTURES = new ResourceLocation("rafradek_tf2_weapons", "textures/gui/container/building.png");

    public GuiTeleporter(EntityTeleporter teleporter) {
        super((Container)new ContainerEnergy(teleporter, Minecraft.func_71410_x().field_71439_g.field_71071_by));
        this.teleporter = teleporter;
        this.exit = this.teleporter.isExit();
        this.channel = this.teleporter.getID();
        this.field_146999_f = 212;
        this.field_147000_g = 195;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.teleportField = new GuiTextField(5, this.field_146289_q, this.field_146294_l / 2 - 40, this.field_146295_m / 2 - 40, 30, 20);
        this.teleportField.func_146203_f(3);
        this.teleportField.func_146195_b(true);
        this.teleportField.func_146180_a(Integer.toString(this.channel + 1));
        this.teleportUpBtn = new GuiButton(1, this.field_146294_l / 2 - 60, this.field_146295_m / 2 - 40, 20, 20, "+");
        this.field_146292_n.add(this.teleportUpBtn);
        this.teleportDownBtn = new GuiButton(2, this.field_146294_l / 2 - 10, this.field_146295_m / 2 - 40, 20, 20, "-");
        this.field_146292_n.add(this.teleportDownBtn);
        this.exitToggle = new GuiButton(3, this.field_146294_l / 2 + 10, this.field_146295_m / 2 - 40, 50, 20, "Exit");
        this.field_146292_n.add(this.exitToggle);
        this.grab = new GuiButton(4, this.field_147003_i + 86, this.field_147009_r + 90, 40, 20, I18n.func_135052_a((String)"gui.teleporter.drop", (Object[])new Object[0]));
        this.field_146292_n.add(this.grab);
        if (this.channel == 127) {
            this.teleportField.func_146184_c(false);
            this.teleportUpBtn.field_146124_l = false;
            this.teleportDownBtn.field_146124_l = false;
            this.exitToggle.field_146124_l = false;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button.field_146127_k == 1) {
                ++this.channel;
                if (this.channel >= 127) {
                    this.channel = 0;
                }
                this.teleportField.func_146180_a(Integer.toString(this.channel + 1));
            } else if (button.field_146127_k == 2) {
                --this.channel;
                if (this.channel < 0) {
                    this.channel = 126;
                }
                this.teleportField.func_146180_a(Integer.toString(this.channel + 1));
            } else if (button.field_146127_k == 3 && !this.teleporter.isExit()) {
                this.exit = !this.exit;
            } else if (button.field_146127_k == 4) {
                this.field_146297_k.func_147108_a(null);
                TF2weapons.network.sendToServer(new TF2Message.GuiConfigMessage(this.teleporter.func_145782_y(), 127, 0));
            }
        }
    }

    public void func_146281_b() {
        TF2weapons.network.sendToServer(new TF2Message.GuiConfigMessage(this.teleporter.func_145782_y(), 0, this.channel));
        TF2weapons.network.sendToServer(new TF2Message.GuiConfigMessage(this.teleporter.func_145782_y(), 1, this.exit ? 1 : 0));
        super.func_146281_b();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.teleportField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.teleportField.func_146201_a(typedChar, keyCode);
        if (this.channel == 127) {
            return;
        }
        try {
            this.channel = MathHelper.func_76125_a((int)(Integer.parseInt(this.teleportField.func_146179_b()) - 1), (int)0, (int)126);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.teleporter.info", (Object[])new Object[0]), 8, 5, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 25, 99, 0x404040);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.exitToggle.field_146126_j = this.exit ? "Exit" : "Entry";
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.teleportField.func_146194_f();
        if (mouseX >= this.field_147003_i + 7 && mouseX < this.field_147003_i + 23 && mouseY >= this.field_147009_r + 15 && mouseY < this.field_147009_r + 75) {
            if (ClientProxy.buildingsUseEnergy) {
                this.func_146279_a("Energy: " + this.teleporter.getInfoEnergy() + "/" + this.teleporter.energy.getMaxEnergyStored(), mouseX, mouseY);
            } else {
                this.func_146279_a("Energy use is disabled", mouseX, mouseY);
            }
        }
        if (mouseX >= this.field_147003_i + 5 && mouseX < this.field_147003_i + 23 && mouseY >= this.field_147009_r + 112 && mouseY < this.field_147009_r + 130) {
            this.func_146283_a(Arrays.asList(I18n.func_135052_a((String)"gui.teleporter.help", (Object[])new Object[0]).split(Pattern.quote("\\n"))), mouseX, mouseY);
        }
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.teleportField.func_146178_a();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURES);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73733_a(this.field_147003_i + 7, this.field_147009_r + 75 - (int)((float)this.teleporter.getInfoEnergy() / (float)this.teleporter.energy.getMaxEnergyStored() * 60.0f), this.field_147003_i + 23, this.field_147009_r + 75, -4259840, -8454144);
    }
}

