/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.client.gui.inventory;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.inventory.ContainerMercenary;

public class GuiMercenary
extends GuiMerchant {
    private static final ResourceLocation GUI_TEXTURES = new ResourceLocation("rafradek_tf2_weapons", "textures/gui/container/mercenary.png");
    public EntityTF2Character mercenary;
    public GuiButton hireBtn;
    public GuiButton shareBtn;
    public GuiButton orderBtn;
    public GuiButton[] mainWeaponButton = new GuiButton[3];
    public InventoryPlayer inv;

    public GuiMercenary(InventoryPlayer inv, EntityTF2Character mercenary, World worldIn) {
        super(inv, (IMerchant)mercenary, worldIn);
        this.mercenary = mercenary;
        this.inv = inv;
        this.field_147002_h = new ContainerMercenary((EntityPlayer)Minecraft.func_71410_x().field_71439_g, mercenary, worldIn);
        this.field_146999_f += 54;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.hireBtn = new GuiButton(60, this.field_147003_i + this.field_146999_f / 2 - 75, this.field_147009_r - 25, 150, 20, "Hire mercenary (1 Australium ingot)");
        this.field_146292_n.add(this.hireBtn);
        this.shareBtn = new GuiButton(62, this.field_147003_i + this.field_146999_f / 2 - 75, this.field_147009_r + this.field_147000_g + 5, 150, 20, "Share loot (1 Australium ingot)");
        this.field_146292_n.add(this.shareBtn);
        this.orderBtn = new GuiButton(61, this.field_147003_i + 179, this.field_147009_r + 123, 48, 20, "Order");
        this.field_146292_n.add(this.orderBtn);
        for (int i = 0; i < 3; ++i) {
            this.mainWeaponButton[i] = new GuiButton(63 + i, this.field_147003_i + 223, this.field_147009_r + 12 + i * 18, 4, 6, "");
            this.field_146292_n.add(this.mainWeaponButton[i]);
        }
        this.updateButtons();
    }

    public void updateButtons() {
        if (this.mercenary.isRobot()) {
            this.hireBtn.field_146125_m = false;
            this.shareBtn.field_146125_m = false;
        }
        if (this.mercenary.func_184753_b() == null) {
            this.hireBtn.field_146124_l = this.inv.func_70431_c(new ItemStack(TF2weapons.itemTF2, 1, 2));
            this.hireBtn.field_146126_j = "Hire this mercenary (1 Australium ingot)";
            this.orderBtn.field_146124_l = false;
            this.shareBtn.field_146125_m = false;
        } else if (this.mercenary.func_184753_b().equals(this.field_146297_k.field_71439_g.func_110124_au())) {
            this.hireBtn.field_146124_l = true;
            this.hireBtn.field_146126_j = "Fire this mercenary";
            this.orderBtn.field_146124_l = true;
            this.orderBtn.field_146126_j = this.mercenary.getOrder().toString();
            if (!this.mercenary.isRobot()) {
                this.shareBtn.field_146125_m = true;
                this.shareBtn.field_146124_l = !this.mercenary.isSharing() && this.inv.func_70431_c(new ItemStack(TF2weapons.itemTF2, 1, 2));
            }
        } else {
            this.hireBtn.field_146124_l = false;
            this.hireBtn.field_146126_j = this.mercenary.ownerName != null ? "Hired mercenary" : "Hired by: " + this.mercenary.ownerName;
            this.orderBtn.field_146124_l = false;
            this.shareBtn.field_146125_m = false;
        }
        for (int i = 0; i < 3; ++i) {
            this.mainWeaponButton[i].field_146124_l = this.field_146297_k.field_71439_g.func_110124_au().equals(this.mercenary.func_184753_b()) || this.field_146297_k.field_71439_g.func_184812_l_();
            this.mainWeaponButton[i].field_146126_j = this.mercenary.getMainWeapon() == i ? "|" : "";
        }
    }

    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 61) {
            if (this.mercenary.getOrder() == EntityTF2Character.Order.FOLLOW) {
                this.mercenary.setOrder(EntityTF2Character.Order.HOLD);
            } else {
                this.mercenary.setOrder(EntityTF2Character.Order.FOLLOW);
            }
            this.field_146297_k.field_71442_b.func_78756_a(this.field_147002_h.field_75152_c, 10 + this.mercenary.getOrder().ordinal());
        } else if (button.field_146127_k == 60) {
            this.field_146297_k.field_71442_b.func_78756_a(this.field_147002_h.field_75152_c, 0);
            if (this.mercenary.func_184753_b() == null) {
                this.mercenary.setOwner((EntityLivingBase)this.field_146297_k.field_71439_g);
            } else {
                this.mercenary.setOwner(null);
            }
        } else if (button.field_146127_k == 62) {
            this.field_146297_k.field_71442_b.func_78756_a(this.field_147002_h.field_75152_c, 1);
            this.mercenary.setSharing(true);
        } else if (button.field_146127_k >= 63 && button.field_146127_k < 66) {
            this.field_146297_k.field_71442_b.func_78756_a(this.field_147002_h.field_75152_c, button.field_146127_k - 13);
            if (this.mercenary.getMainWeapon() == button.field_146127_k - 63) {
                this.mercenary.setMainWeapon(-1);
            } else {
                this.mercenary.setMainWeapon(button.field_146127_k - 63);
            }
        }
        this.updateButtons();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.hireBtn.func_146115_a()) {
            this.func_146279_a("Lost australium can be recovered at Mann Co store", mouseX, mouseY);
        } else if (this.shareBtn.func_146115_a()) {
            this.func_146279_a("Allows the owner to collect loot from enemies", mouseX, mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURES);
        int i = this.field_147003_i + this.field_146999_f - 54;
        int j = this.field_147009_r;
        this.func_73729_b(i, j, 176, 0, 54, 146);
        this.field_146289_q.func_78276_b("Refill", i + 7, j + 80, 0x404040);
        this.field_146289_q.func_78276_b(Integer.toString(((ContainerMercenary)this.field_147002_h).primaryAmmo), i + 10, j + 113, 0x404040);
        this.field_146289_q.func_78276_b(Integer.toString(((ContainerMercenary)this.field_147002_h).secondaryAmmo), i + 33, j + 113, 0x404040);
        GlStateManager.func_179145_e();
        GlStateManager.func_179091_B();
        RenderHelper.func_74520_c();
        this.field_146296_j.field_77023_b = 0.0f;
        for (int k = 0; k < 4; ++k) {
            ItemStack stack = this.mercenary.loadout.getStackInSlot(k);
            if (stack.func_190926_b()) continue;
            if (k < 4 && !this.field_147002_h.func_75139_a(k + 43).func_75216_d()) {
                this.field_146296_j.func_175042_a(stack, this.field_147002_h.func_75139_a((int)(k + 43)).field_75223_e + this.field_147003_i, this.field_147002_h.func_75139_a((int)(k + 43)).field_75221_f + this.field_147009_r);
                continue;
            }
            if (k < 3 || this.field_147002_h.func_75139_a(k + 36).func_75216_d()) continue;
            this.field_146296_j.func_175042_a(stack, this.field_147002_h.func_75139_a((int)(k - 3)).field_75221_f, this.field_147002_h.func_75139_a((int)(k - 3)).field_75223_e);
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURES);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
    }

    protected void func_191948_b(int p_191948_1_, int p_191948_2_) {
        int id;
        super.func_191948_b(p_191948_1_, p_191948_2_);
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().func_75216_d() && (id = this.getSlotUnderMouse().field_75222_d) >= 43 && id < 47 && !this.mercenary.loadout.getStackInSlot(id - 43).func_190926_b()) {
            this.func_146285_a(this.mercenary.loadout.getStackInSlot(id - 43), p_191948_1_, p_191948_2_);
        }
    }
}

