/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.client.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.mercenary.EntitySpy;
import rafradek.TF2weapons.message.TF2Message;

public class GuiDisguiseKit
extends GuiScreen {
    public GuiButton playerDisguise;
    private GuiTextField playerNameField;
    public EntityPlayer player;
    public ArrayList<EntityLivingBase> mobList = new ArrayList();
    public boolean needUpdating;
    public int ticksUpdate;
    public int firstIndex;
    public float scroll;
    private boolean isScrolling;
    private boolean wasClicking;
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES = new ResourceLocation("rafradek_tf2_weapons", "textures/gui/container/cabinet.png");

    public void func_73866_w_() {
        this.player = new EntityOtherPlayerMP((World)this.field_146297_k.field_71441_e, new GameProfile(this.field_146297_k.field_71439_g.func_110124_au(), "name"));
        for (ResourceLocation entry : ForgeRegistries.ENTITIES.getKeys()) {
            Entity entity = EntityList.func_188429_b((ResourceLocation)entry, (World)this.field_146297_k.field_71441_e);
            if (!(entity instanceof EntityLivingBase) || !(entity.field_70130_N + entity.field_70131_O < 6.0f && entity.func_184222_aU() && entity instanceof EntityCreature) && !this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) continue;
            this.mobList.add((EntityLivingBase)entity);
            if (!(entity instanceof EntitySpy)) continue;
            ((WeaponsCapability)entity.getCapability(TF2weapons.WEAPONS_CAP, null)).invisTicks = 0;
        }
        Collections.sort(this.mobList, new Comparator<EntityLivingBase>(){

            @Override
            public int compare(EntityLivingBase o1, EntityLivingBase o2) {
                return EntityList.func_191301_a((Entity)o2).toString().compareTo(EntityList.func_191301_a((Entity)o1).toString());
            }
        });
        Keyboard.enableRepeatEvents((boolean)true);
        this.playerNameField = new GuiTextField(6, this.field_146289_q, this.field_146294_l / 2 + 26, this.field_146295_m / 2 + 60, 108, 19);
        this.playerNameField.func_146203_f(64);
        this.playerNameField.func_146195_b(true);
        this.field_146292_n.clear();
        for (int i = 0; i < 16; ++i) {
            this.field_146292_n.add(new GuiButton(i, this.field_146294_l / 2 - 135 + i % 2 * 70, this.field_146295_m / 2 - 60 + i / 2 * 20, 70, 20, I18n.func_135052_a((String)EntityList.func_191302_a((ResourceLocation)EntityList.func_191306_a(EntityZombie.class)), (Object[])new Object[0])));
        }
        this.playerDisguise = new GuiButton(30, this.field_146294_l / 2 + 25, this.field_146295_m / 2 + 80, 110, 20, "Player");
        this.field_146292_n.add(this.playerDisguise);
        this.setButtons();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button.field_146127_k == 30) {
                TF2weapons.network.sendToServer(new TF2Message.DisguiseMessage("P:" + this.playerNameField.func_146179_b()));
            }
            if (button.field_146127_k < 16) {
                TF2weapons.network.sendToServer(new TF2Message.DisguiseMessage("M:" + EntityList.func_191301_a((Entity)((Entity)this.mobList.get(button.field_146127_k + this.firstIndex))).toString()));
            }
            this.field_146297_k.func_147108_a(null);
        }
    }

    public void setButtons() {
        for (int i = 0; i < 16; ++i) {
            if (i + this.firstIndex < this.mobList.size()) {
                ((GuiButton)this.field_146292_n.get((int)i)).field_146126_j = this.mobList.get(i + this.firstIndex).func_70005_c_();
                ((GuiButton)this.field_146292_n.get((int)i)).field_146125_m = true;
                continue;
            }
            ((GuiButton)this.field_146292_n.get((int)i)).field_146125_m = false;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.playerNameField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.playerNameField.func_146201_a(typedChar, keyCode);
        if (this.playerNameField.func_146206_l()) {
            this.needUpdating = true;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.disguise.info", (Object[])new Object[0]), this.field_146294_l / 2 - 5, 20, 0xFFFFFF);
        int entdraw = -1;
        for (int i = 0; i < 16; ++i) {
            if (i + this.firstIndex >= this.mobList.size() || !((GuiButton)this.field_146292_n.get(i)).func_146115_a()) continue;
            entdraw = i + this.firstIndex;
            break;
        }
        if (entdraw == -1) {
            GuiDisguiseKit.drawEntityOnScreen(this.field_146294_l / 2 + 75, this.field_146295_m / 2 + 40, 35, (EntityLivingBase)this.player);
        } else {
            GuiDisguiseKit.drawEntityOnScreen(this.field_146294_l / 2 + 75, this.field_146295_m / 2 + 40, 35, this.mobList.get(entdraw));
        }
        boolean flag = Mouse.isButtonDown((int)0);
        int i = this.field_146294_l / 2;
        int j = this.field_146295_m / 2;
        int k = i + 5;
        int l = j - 60;
        int i1 = k + 14;
        int j1 = l + 160;
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = true;
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            int size = this.mobList.size();
            this.scroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.scroll = MathHelper.func_76131_a((float)this.scroll, (float)0.0f, (float)1.0f);
            int rows = -(-this.mobList.size() / 2) - 7;
            this.firstIndex = Math.round(this.scroll * (float)rows) * 2;
            this.setButtons();
        }
        this.field_146297_k.func_110434_K().func_110577_a(CRAFTING_TABLE_GUI_TEXTURES);
        k = this.field_146294_l / 2 + 6;
        l = this.field_146295_m / 2 - 59;
        i = l + 160;
        this.func_73729_b(k, l + (int)((float)(i - l - 17) * this.scroll), 232, 0, 12, 15);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.playerNameField.func_146194_f();
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, EntityLivingBase ent) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        ent.field_70761_aq = 0.0f;
        ent.field_70177_z = 0.0f;
        ent.field_70125_A = 0.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        this.playerNameField.func_146178_a();
        if (--this.ticksUpdate < 0 && this.needUpdating && !StringUtils.isBlank((CharSequence)this.playerNameField.func_146179_b())) {
            this.needUpdating = false;
            this.ticksUpdate = 12;
            WeaponsCapability.THREAD_POOL.submit(new Runnable(){

                @Override
                public void run() {
                    GameProfile profile = TileEntitySkull.func_174884_b((GameProfile)new GameProfile(GuiDisguiseKit.this.field_146297_k.field_71439_g.func_110124_au(), GuiDisguiseKit.this.playerNameField.func_146179_b()));
                    GuiDisguiseKit.this.player = new EntityOtherPlayerMP((World)GuiDisguiseKit.this.field_146297_k.field_71441_e, profile);
                    WeaponsCapability.get((Entity)GuiDisguiseKit.this.player).setDisguised(true);
                    WeaponsCapability.get((Entity)GuiDisguiseKit.this.player).setDisguiseType("P:" + GuiDisguiseKit.this.playerNameField.func_146179_b());
                    final WeaponsCapability cap = (WeaponsCapability)GuiDisguiseKit.this.player.getCapability(TF2weapons.WEAPONS_CAP, null);
                    cap.skinType = DefaultPlayerSkin.func_177332_b((UUID)GuiDisguiseKit.this.player.func_110124_au());
                    if (profile.getId() != null) {
                        cap.skinType = DefaultPlayerSkin.func_177332_b((UUID)profile.getId());
                    }
                    Minecraft.func_71410_x().func_152342_ad().func_152790_a(profile, new SkinManager.SkinAvailableCallback(){

                        public void func_180521_a(MinecraftProfileTexture.Type typeIn, ResourceLocation location, MinecraftProfileTexture profileTexture) {
                            if (typeIn == MinecraftProfileTexture.Type.SKIN) {
                                if (typeIn == MinecraftProfileTexture.Type.SKIN) {
                                    cap.skinDisguise = location;
                                }
                                cap.skinType = profileTexture.getMetadata("model");
                                if (cap.skinType == null) {
                                    cap.skinType = "default";
                                }
                            }
                        }
                    }, false);
                }
            });
        }
    }
}

