/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumHand;
import net.minecraft.util.MovementInput;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.CustomModLoadingErrorDisplayException;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.TF2EventsClient;
import rafradek.TF2weapons.client.audio.BuildingSound;
import rafradek.TF2weapons.client.audio.OnFireSound;
import rafradek.TF2weapons.client.audio.ReloadSound;
import rafradek.TF2weapons.client.audio.WeaponLoopSound;
import rafradek.TF2weapons.client.audio.WeaponSound;
import rafradek.TF2weapons.client.gui.GuiConfirm;
import rafradek.TF2weapons.client.gui.GuiDisguiseKit;
import rafradek.TF2weapons.client.gui.inventory.GuiSentry;
import rafradek.TF2weapons.client.gui.inventory.GuiTeleporter;
import rafradek.TF2weapons.client.model.ModelRocket;
import rafradek.TF2weapons.client.particle.EntityBisonEffect;
import rafradek.TF2weapons.client.particle.EntityBulletTracer;
import rafradek.TF2weapons.client.particle.EntityCritEffect;
import rafradek.TF2weapons.client.particle.EntityFlameEffect;
import rafradek.TF2weapons.client.particle.EntityMuzzleFlash;
import rafradek.TF2weapons.client.particle.EnumTF2Particles;
import rafradek.TF2weapons.client.particle.ParticleBulletHole;
import rafradek.TF2weapons.client.particle.ParticleExplosion;
import rafradek.TF2weapons.client.renderer.LayerWearables;
import rafradek.TF2weapons.client.renderer.entity.RenderBall;
import rafradek.TF2weapons.client.renderer.entity.RenderDispenser;
import rafradek.TF2weapons.client.renderer.entity.RenderFlare;
import rafradek.TF2weapons.client.renderer.entity.RenderGrenade;
import rafradek.TF2weapons.client.renderer.entity.RenderHHH;
import rafradek.TF2weapons.client.renderer.entity.RenderJar;
import rafradek.TF2weapons.client.renderer.entity.RenderMerasmus;
import rafradek.TF2weapons.client.renderer.entity.RenderMonoculus;
import rafradek.TF2weapons.client.renderer.entity.RenderPlayerDisguised;
import rafradek.TF2weapons.client.renderer.entity.RenderProjectile;
import rafradek.TF2weapons.client.renderer.entity.RenderProjectileSimple;
import rafradek.TF2weapons.client.renderer.entity.RenderRocket;
import rafradek.TF2weapons.client.renderer.entity.RenderSentry;
import rafradek.TF2weapons.client.renderer.entity.RenderSprite;
import rafradek.TF2weapons.client.renderer.entity.RenderStatue;
import rafradek.TF2weapons.client.renderer.entity.RenderStickybomb;
import rafradek.TF2weapons.client.renderer.entity.RenderTF2Character;
import rafradek.TF2weapons.client.renderer.entity.RenderTeleporter;
import rafradek.TF2weapons.client.renderer.tileentity.RenderDoor;
import rafradek.TF2weapons.client.renderer.tileentity.RenderRobotDeploy;
import rafradek.TF2weapons.common.CommonProxy;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.entity.EntityStatue;
import rafradek.TF2weapons.entity.boss.EntityHHH;
import rafradek.TF2weapons.entity.boss.EntityMerasmus;
import rafradek.TF2weapons.entity.boss.EntityMonoculus;
import rafradek.TF2weapons.entity.building.EntityDispenser;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.entity.building.EntityTeleporter;
import rafradek.TF2weapons.entity.mercenary.EntitySaxtonHale;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.entity.mercenary.InvasionEvent;
import rafradek.TF2weapons.entity.projectile.EntityBall;
import rafradek.TF2weapons.entity.projectile.EntityFlare;
import rafradek.TF2weapons.entity.projectile.EntityFuryFireball;
import rafradek.TF2weapons.entity.projectile.EntityGrenade;
import rafradek.TF2weapons.entity.projectile.EntityJar;
import rafradek.TF2weapons.entity.projectile.EntityOnyx;
import rafradek.TF2weapons.entity.projectile.EntityProjectileSimple;
import rafradek.TF2weapons.entity.projectile.EntityRocket;
import rafradek.TF2weapons.entity.projectile.EntityRocketEffect;
import rafradek.TF2weapons.entity.projectile.EntityStickybomb;
import rafradek.TF2weapons.item.ItemAmmo;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemKillstreakFabricator;
import rafradek.TF2weapons.item.ItemKillstreakKit;
import rafradek.TF2weapons.item.ItemRobotPart;
import rafradek.TF2weapons.item.ItemUsable;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.tileentity.TileEntityOverheadDoor;
import rafradek.TF2weapons.tileentity.TileEntityRobotDeploy;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;
import rafradek.TF2weapons.util.WeaponData;

public class ClientProxy
extends CommonProxy {
    public static HashMap<String, ModelBase> entityModel = new HashMap();
    public static HashMap<String, ResourceLocation> textureDisguise = new HashMap();
    public static RenderCustomModel disguiseRender;
    public static RenderLivingBase disguiseRenderPlayer;
    public static RenderLivingBase disguiseRenderPlayerSmall;
    public static TextureMap particleMap;
    public static KeyBinding reload;
    public static KeyBinding backpackitem;
    public static ResourceLocation scopeTexture;
    public static BiMap<EntityLivingBase, WeaponSound> fireSounds;
    public static Map<EntityLivingBase, ReloadSound> reloadSounds;
    public static Map<String, ModelResourceLocation> nameToModel;
    public static ConcurrentMap<EntityLivingBase, ItemStack> soundsToStart;
    public static ResourceLocation blackTexture;
    public static ResourceLocation circleTexture;
    public static ResourceLocation healingTexture;
    public static ResourceLocation buildingTexture;
    public static ResourceLocation blueprintTexture;
    public static ResourceLocation chargeTexture;
    public static final ResourceLocation WIDGETS_TEXTURE_MC;
    public static final ResourceLocation VIGNETTE;
    public static List<WeaponSound> weaponSoundsToStart;
    public static int renderCritGlow;
    public static boolean inRenderHand;
    public static boolean inRenderHandTicked;
    public static boolean buildingsUseEnergy;
    public static EnumMap<EnumTF2Particles, IParticleFactory> particleFactories;
    public static final Logger LOGGER;
    public static Set<Class<? extends Block>> interactingBlocks;

    @Override
    public void registerItemBlock(ItemBlock item) {
        for (int i = 0; i < 16; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    public static void RegisterWeaponData(WeaponData weapon) {
        Item item = MapList.weaponClasses.get(weapon.getString(PropertyType.CLASS));
        if (item instanceof ItemFromData) {
            ((ItemFromData)item).registerModels(weapon);
        }
    }

    @Override
    public void registerRenderInformation() {
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
            if (stack.func_77952_i() < 25) {
                return stack.func_77952_i() < 9 ? 0xFF0000 : 255;
            }
            if (stack.func_77952_i() / 2 == 13) {
                return 0xFFFFFF;
            }
            if (stack.func_77952_i() == 28) {
                return 7615745;
            }
            if (stack.func_77952_i() == 29) {
                return 1769786;
            }
            if (stack.func_77952_i() == 30) {
                return 2119723;
            }
            if (stack.func_77952_i() < 45) {
                return 0x2AAAFF;
            }
            return stack.func_77952_i() / 2 == 13 ? 0xFFFFFF : (stack.func_77952_i() % 2 == 0 ? 0xFF0000 : 255);
        }, new Item[]{TF2weapons.itemPlacer});
        ArrayList<Item> items = new ArrayList<Item>(ForgeRegistries.ITEMS.getValues());
        items.removeIf(item -> !(item instanceof ItemFromData) && !(item instanceof ItemTool) && !(item instanceof ItemSword) && !(item instanceof ItemBow));
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (ItemFromData.getData(stack).hasProperty(PropertyType.COLOR)) {
                    return ItemFromData.getData(stack).getInt(PropertyType.COLOR);
                }
                if (renderCritGlow > 15) {
                    int color = TF2Util.colorCode[renderCritGlow % 16];
                    if (renderCritGlow < 32) {
                        color |= 0x7F7F7F;
                    }
                    if (renderCritGlow == 28) {
                        color = 16756832;
                    } else if (renderCritGlow == 25) {
                        color = 6336767;
                    } else if (renderCritGlow == 44) {
                        color = 0xFF5050;
                    } else if (renderCritGlow == 41) {
                        color = 0x5050FF;
                    }
                    return color;
                }
                if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("Australium")) {
                    return 16765952;
                }
                if (stack.func_77973_b() instanceof ItemUsable && tintIndex == 1) {
                    return TF2Util.colorCode[renderCritGlow % 16];
                }
                return 0xFFFFFF;
            }
        }, items.toArray(new Item[items.size()]));
        for (RenderPlayer render : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            render.func_177094_a((LayerRenderer)new LayerWearables((RenderLivingBase<?>)render));
        }
        reloadSounds = new HashMap<EntityLivingBase, ReloadSound>();
        soundsToStart = new ConcurrentHashMap<EntityLivingBase, ItemStack>();
        weaponSoundsToStart = new ArrayList<WeaponSound>();
        fireSounds = HashBiMap.create();
        ClientRegistry.registerKeyBinding((KeyBinding)reload);
        ClientRegistry.registerKeyBinding((KeyBinding)backpackitem);
        disguiseRenderPlayer = new RenderPlayerDisguised(Minecraft.func_71410_x().func_175598_ae(), false);
        disguiseRenderPlayerSmall = new RenderPlayerDisguised(Minecraft.func_71410_x().func_175598_ae(), true);
        interactingBlocks = new HashSet<Class<? extends Block>>();
        Method usemethod = null;
        for (Method method : Block.class.getMethods()) {
            if (!method.getName().equals("onBlockActivated") && !method.getName().equals("func_180639_a")) continue;
            usemethod = method;
        }
        block4: for (Block block : ForgeRegistries.BLOCKS.getValuesCollection()) {
            try {
                if (interactingBlocks.contains(block.getClass())) continue;
                for (Method method : block.getClass().getMethods()) {
                    if (!method.getName().equals("onBlockActivated") && !method.getName().equals("func_180639_a") || method.equals(usemethod)) continue;
                    interactingBlocks.add(block.getClass());
                    continue block4;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
        }
        particleFactories.put(EnumTF2Particles.EXPLOSION, new ParticleExplosion.Factory());
        particleFactories.put(EnumTF2Particles.BULLET_TRACER, new EntityBulletTracer.Factory());
    }

    @Override
    public EntityPlayer getPlayerForSide(MessageContext ctx) {
        return ctx.side == Side.SERVER ? ctx.getServerHandler().field_147369_b : Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void preInit() {
        int i;
        MinecraftForge.EVENT_BUS.register((Object)new TF2EventsClient());
        OBJLoader.INSTANCE.addDomain("rafradek_tf2_weapons".toLowerCase());
        for (int i2 = 1; i2 < ItemAmmo.AMMO_TYPES.length; ++i2) {
            if (i2 == 10 || i2 == 12) continue;
            ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemAmmo, (int)i2, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:ammo_" + ItemAmmo.AMMO_TYPES[i2], "inventory"));
        }
        nameToModel = new HashMap<String, ModelResourceLocation>();
        for (WeaponData weapon : MapList.nameToData.values()) {
            ClientProxy.RegisterWeaponData(weapon);
        }
        for (Item item : MapList.weaponClasses.values()) {
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)((ItemFromData)item).getMeshDefinition());
        }
        ModelResourceLocation spawnEgg = new ModelResourceLocation("spawn_egg", "inventory");
        ModelBakery.registerItemVariants((Item)TF2weapons.itemPlacer, (ResourceLocation[])new ResourceLocation[]{spawnEgg});
        ModelLoader.setCustomMeshDefinition((Item)TF2weapons.itemPlacer, stack -> spawnEgg);
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemDisguiseKit, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:disguise_kit", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemSandvich, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:sandvich", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemAmmoBelt, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:ammo_belt", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemStatue, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:statue", "inventory"));
        final ModelResourceLocation sentryRed = new ModelResourceLocation("rafradek_tf2_weapons:sentryred", "inventory");
        final ModelResourceLocation sentryBlu = new ModelResourceLocation("rafradek_tf2_weapons:sentryblu", "inventory");
        final ModelResourceLocation dispenserRed = new ModelResourceLocation("rafradek_tf2_weapons:dispenserred", "inventory");
        final ModelResourceLocation dispenserBlu = new ModelResourceLocation("rafradek_tf2_weapons:dispenserblu", "inventory");
        final ModelResourceLocation teleporterRed = new ModelResourceLocation("rafradek_tf2_weapons:teleporterred", "inventory");
        final ModelResourceLocation teleporterBlu = new ModelResourceLocation("rafradek_tf2_weapons:teleporterblu", "inventory");
        final ModelResourceLocation killstreak = new ModelResourceLocation("rafradek_tf2_weapons:killstreak_kit", "inventory");
        final ModelResourceLocation killstreakSpec = new ModelResourceLocation("rafradek_tf2_weapons:killstreak_kit_specialized", "inventory");
        final ModelResourceLocation killstreakPro = new ModelResourceLocation("rafradek_tf2_weapons:killstreak_kit_professional", "inventory");
        ModelResourceLocation ammoBox = new ModelResourceLocation("rafradek_tf2_weapons:ammo_box", "inventory");
        ModelResourceLocation ammoBoxSmall = new ModelResourceLocation("rafradek_tf2_weapons:ammo_box_small", "inventory");
        ModelBakery.registerItemVariants((Item)TF2weapons.itemBuildingBox, (ResourceLocation[])new ResourceLocation[]{sentryRed, sentryBlu, dispenserRed, dispenserBlu, teleporterRed, teleporterBlu});
        ModelLoader.setCustomMeshDefinition((Item)TF2weapons.itemBuildingBox, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                if (stack.func_77952_i() == 18) {
                    return sentryRed;
                }
                if (stack.func_77952_i() == 19) {
                    return sentryBlu;
                }
                if (stack.func_77952_i() == 20) {
                    return dispenserRed;
                }
                if (stack.func_77952_i() == 21) {
                    return dispenserBlu;
                }
                if (stack.func_77952_i() == 22) {
                    return teleporterRed;
                }
                return teleporterBlu;
            }
        });
        ModelBakery.registerItemVariants((Item)TF2weapons.itemKillstreak, (ResourceLocation[])new ResourceLocation[]{killstreak, killstreakSpec, killstreakPro});
        ModelLoader.setCustomMeshDefinition((Item)TF2weapons.itemKillstreak, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                switch (((ItemKillstreakKit)stack.func_77973_b()).getLevel(stack)) {
                    case 1: {
                        return killstreak;
                    }
                    case 2: {
                        return killstreakSpec;
                    }
                    case 3: {
                        return killstreakPro;
                    }
                }
                return killstreak;
            }
        });
        ModelBakery.registerItemVariants((Item)TF2weapons.itemAmmoPackage, (ResourceLocation[])new ResourceLocation[]{ammoBox, ammoBoxSmall});
        ModelLoader.setCustomMeshDefinition((Item)TF2weapons.itemAmmoPackage, stack -> stack.func_77960_j() / 16 == 0 ? ammoBoxSmall : ammoBox);
        final ModelResourceLocation killstreakFab = new ModelResourceLocation("rafradek_tf2_weapons:killstreak_fabricator", "inventory");
        final ModelResourceLocation killstreakFabSpec = new ModelResourceLocation("rafradek_tf2_weapons:killstreak_fabricator_spec", "inventory");
        final ModelResourceLocation killstreakFabPro = new ModelResourceLocation("rafradek_tf2_weapons:killstreak_fabricator_pro", "inventory");
        ModelBakery.registerItemVariants((Item)TF2weapons.itemKillstreakFabricator, (ResourceLocation[])new ResourceLocation[]{killstreakFab, killstreakFabSpec, killstreakFabPro});
        ModelLoader.setCustomMeshDefinition((Item)TF2weapons.itemKillstreakFabricator, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                switch (((ItemKillstreakFabricator)stack.func_77973_b()).getLevel(stack)) {
                    case 1: {
                        return killstreakFab;
                    }
                    case 2: {
                        return killstreakFabSpec;
                    }
                    case 3: {
                        return killstreakFabPro;
                    }
                }
                return killstreakFab;
            }
        });
        for (i = 0; i < ItemRobotPart.LEVEL.length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemRobotPart, (int)i, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:robot_part_" + i, "inventory"));
        }
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemAmmoFire, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:ammo_fire", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemAmmoPistol, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:pistol_mag", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemAmmoSMG, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:smg_mag", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemAmmoSyringe, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:ammo_syringe", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemAmmoMinigun, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:ammo_minigun", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemStrangifier, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:strangifier", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemChocolate, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:chocolate", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemTarget, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:target", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemHorn, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:horn", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemMantreads, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:mantreads", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemScoutBoots, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:scout_shoes", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemGunboats, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:gunboats", "inventory"));
        for (i = 0; i < InvasionEvent.DIFFICULTY.length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemEventMaker, (int)i, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:tour_ticket", "inventory"));
        }
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemAmmoMedigun, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:ammo_medigun", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemTF2, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:copper_ingot", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemTF2, (int)1, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:lead_ingot", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemTF2, (int)2, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:australium_ingot", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemTF2, (int)3, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:scrap_metal", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemTF2, (int)4, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:reclaimed_metal", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemTF2, (int)5, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:refined_metal", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemTF2, (int)6, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:australium_nugget", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemTF2, (int)7, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:key", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemTF2, (int)8, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:crate", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemTF2, (int)9, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:random_weapon", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemTF2, (int)10, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:random_hat", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemTF2, (int)11, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:logic_board", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemTF2, (int)12, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:robot_part_pack", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemTF2, (int)13, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:robot_part_pack", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemToken, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:token_scout", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemToken, (int)1, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:token_soldier", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemToken, (int)2, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:token_pyro", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemToken, (int)3, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:token_demoman", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemToken, (int)4, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:token_heavy", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemToken, (int)5, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:token_engineer", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemToken, (int)6, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:token_medic", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemToken, (int)7, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:token_sniper", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemToken, (int)8, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:token_spy", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemDoorController, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:door_controller_player", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemDoorController, (int)1, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:door_controller_entity", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemDoorController, (int)2, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:door_controller_red", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemDoorController, (int)3, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:door_controller_blu", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemBossSpawn, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:boss_hhh", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemBossSpawn, (int)1, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:boss_monoculus", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemBossSpawn, (int)2, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:boss_merasmus", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemMoney, (int)0, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:money_small", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemMoney, (int)1, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:money_normal", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)TF2weapons.itemMoney, (int)2, (ModelResourceLocation)new ModelResourceLocation("rafradek_tf2_weapons:money_big", "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityOverheadDoor.class, (TileEntitySpecialRenderer)new RenderDoor());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRobotDeploy.class, (TileEntitySpecialRenderer)new RenderRobotDeploy());
        RenderingRegistry.registerEntityRenderingHandler(EntityTF2Character.class, (IRenderFactory)new IRenderFactory<EntityTF2Character>(){

            public Render<EntityTF2Character> createRenderFor(RenderManager manager) {
                return new RenderTF2Character(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityRocket.class, (IRenderFactory)new IRenderFactory<EntityRocket>(){

            public Render<EntityRocket> createRenderFor(RenderManager manager) {
                return new RenderRocket(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityGrenade.class, (IRenderFactory)new IRenderFactory<EntityGrenade>(){

            public Render<EntityGrenade> createRenderFor(RenderManager manager) {
                return new RenderGrenade(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityStickybomb.class, (IRenderFactory)new IRenderFactory<EntityStickybomb>(){

            public Render<EntityStickybomb> createRenderFor(RenderManager manager) {
                return new RenderStickybomb(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectileSimple.class, (IRenderFactory)new IRenderFactory<EntityProjectileSimple>(){

            public Render<EntityProjectileSimple> createRenderFor(RenderManager manager) {
                return new RenderProjectileSimple(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityBall.class, (IRenderFactory)new IRenderFactory<EntityBall>(){

            public Render<EntityBall> createRenderFor(RenderManager manager) {
                return new RenderBall(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityFlare.class, (IRenderFactory)new IRenderFactory<EntityFlare>(){

            public Render<EntityFlare> createRenderFor(RenderManager manager) {
                return new RenderFlare(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityJar.class, (IRenderFactory)new IRenderFactory<EntityJar>(){

            public Render<EntityJar> createRenderFor(RenderManager manager) {
                return new RenderJar(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityOnyx.class, manager -> {
            ResourceLocation texture = new ResourceLocation("rafradek_tf2_weapons", "textures/entity/projectile/onyx.png");
            return new RenderProjectile(new ModelRocket(), texture, texture, manager);
        });
        RenderingRegistry.registerEntityRenderingHandler(EntitySentry.class, (IRenderFactory)new IRenderFactory<EntitySentry>(){

            public Render<EntitySentry> createRenderFor(RenderManager manager) {
                return new RenderSentry(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityDispenser.class, (IRenderFactory)new IRenderFactory<EntityDispenser>(){

            public Render<EntityDispenser> createRenderFor(RenderManager manager) {
                return new RenderDispenser(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityTeleporter.class, (IRenderFactory)new IRenderFactory<EntityTeleporter>(){

            public Render<EntityTeleporter> createRenderFor(RenderManager manager) {
                return new RenderTeleporter(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityStatue.class, (IRenderFactory)new IRenderFactory<EntityStatue>(){

            public Render<EntityStatue> createRenderFor(RenderManager manager) {
                return new RenderStatue(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityHHH.class, (IRenderFactory)new IRenderFactory<EntityHHH>(){

            public Render<EntityHHH> createRenderFor(RenderManager manager) {
                return new RenderHHH(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityMerasmus.class, (IRenderFactory)new IRenderFactory<EntityMerasmus>(){

            public Render<EntityMerasmus> createRenderFor(RenderManager manager) {
                return new RenderMerasmus(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityMonoculus.class, (IRenderFactory)new IRenderFactory<EntityMonoculus>(){

            public Render<EntityMonoculus> createRenderFor(RenderManager manager) {
                return new RenderMonoculus(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityFuryFireball.class, (IRenderFactory)new IRenderFactory<EntityFuryFireball>(){

            public RenderSprite<EntityFuryFireball> createRenderFor(RenderManager manager) {
                return new RenderSprite<EntityFuryFireball>(manager, 1.0f, null){

                    @Override
                    protected TextureAtlasSprite getSprite(EntityFuryFireball entity) {
                        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178082_a(Items.field_151059_bz);
                    }
                };
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntitySaxtonHale.class, (IRenderFactory)new IRenderFactory<EntitySaxtonHale>(){

            public Render<EntitySaxtonHale> createRenderFor(RenderManager manager) {
                return new RenderBiped<EntitySaxtonHale>(manager, new ModelBiped(), 0.5f){
                    private final ResourceLocation TEXTURE;
                    {
                        this.TEXTURE = new ResourceLocation("rafradek_tf2_weapons", "textures/entity/tf2/SaxtonHale.png");
                    }

                    protected ResourceLocation getEntityTexture(EntitySaxtonHale entity) {
                        return this.TEXTURE;
                    }
                };
            }
        });
    }

    public static void playBuildingSound(BuildingSound sound) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
    }

    @Override
    public void registerTicks() {
    }

    public static void spawnFlameParticle(World world, EntityLivingBase ent, float step, boolean heater) {
        EntityFlameEffect entity = EntityFlameEffect.createNewEffect(world, ent, step, heater);
        ClientProxy.spawnParticle(world, entity);
    }

    public static void spawnBulletParticle(World world, EntityLivingBase living, double startX, double startY, double startZ, double endX, double endY, double endZ, int j, int crits, int type, float length) {
        EntityBulletTracer entity = new EntityBulletTracer(world, startX, startY, startZ, endX, endY, endZ, j, crits, living, type, length);
        ClientProxy.spawnParticle(world, entity);
    }

    public static void spawnCritParticle(World world, double pX, double pY, double pZ, int teamForDisplay) {
        EntityCritEffect entity = new EntityCritEffect(world, pX, pY, pZ, teamForDisplay);
        ClientProxy.spawnParticle(world, entity);
    }

    public static void spawnBisonParticle(World world, double pX, double pY, double pZ, int teamForDisplay) {
        EntityBisonEffect entity = new EntityBisonEffect(world, pX, pY, pZ, teamForDisplay);
        ClientProxy.spawnParticle(world, entity);
    }

    public static void spawnBulletHoleParticle(World world, RayTraceResult origin) {
        ParticleBulletHole entity = new ParticleBulletHole(world, origin);
        ClientProxy.spawnParticle(world, entity);
    }

    public static void spawnFlashParticle(World world, EntityLivingBase ent, EnumHand hand) {
        EntityMuzzleFlash entity = new EntityMuzzleFlash(world, ent, hand);
        ClientProxy.spawnParticle(world, entity);
    }

    public static void spawnParticle(World world, Particle entity) {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().func_175606_aa() != null && Minecraft.func_71410_x().field_71452_i != null) {
            int i = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
            if (i == 1 && world.field_73012_v.nextInt(3) == 0) {
                i = 2;
            }
            if (i > 1) {
                entity.func_187112_i();
                return;
            }
            Minecraft.func_71410_x().field_71452_i.func_78873_a(entity);
        }
    }

    @Override
    public void playReloadSound(EntityLivingBase player, ItemStack stack) {
        if (!Thread.currentThread().getName().equals("Client thread") || !(stack.func_77973_b() instanceof ItemUsable)) {
            return;
        }
        SoundEvent event = ItemFromData.getSound(stack, PropertyType.RELOAD_SOUND);
        if (event != null) {
            ReloadSound sound = new ReloadSound(event, (Entity)player);
            if (reloadSounds.get(player) != null) {
                ClientProxy.reloadSounds.get((Object)player).done = true;
            }
            reloadSounds.put(player, sound);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        }
    }

    public static WeaponSound playWeaponSound(EntityLivingBase living, SoundEvent playSound, boolean loop, int type, ItemStack stack) {
        if (playSound == null) {
            return null;
        }
        WeaponSound sound = loop ? new WeaponLoopSound(playSound, living, type < 2, ItemFromData.getData(stack), type == 1, type) : new WeaponSound(playSound, living, type, ItemFromData.getData(stack));
        if (fireSounds.get((Object)living) != null) {
            ((WeaponSound)((Object)fireSounds.get((Object)living))).setDone();
        }
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        fireSounds.put((Object)living, (Object)sound);
        return sound;
    }

    public static void removeReloadSound(EntityLivingBase entity) {
        if (reloadSounds.get(entity) != null) {
            ClientProxy.reloadSounds.remove((Object)entity).done = true;
        }
    }

    public static void playOnFireSound(Entity target, SoundEvent playSound) {
        if (!Thread.currentThread().getName().equals("Client thread") || playSound == null) {
            return;
        }
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new OnFireSound(playSound, target));
    }

    public static void spawnRocketParticle(World world, EntityRocket rocket) {
        ClientProxy.spawnParticle(world, new EntityRocketEffect(world, rocket));
    }

    public static EntityPlayer getLocalPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static void showGuiTeleporter(EntityTeleporter entityTeleporter) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiTeleporter(entityTeleporter));
    }

    public static void displayScreenConfirm(String str1, String str2) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiConfirm(str1, str2));
    }

    public static void displayScreenJoinTeam() {
        final GuiScreen prevScreen = Minecraft.func_71410_x().field_71462_r;
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

            public void func_73878_a(boolean result, int id) {
                if (result) {
                    TF2weapons.network.sendToServer(new TF2Message.ActionMessage(16));
                } else {
                    TF2weapons.network.sendToServer(new TF2Message.ActionMessage(17));
                }
                Minecraft.func_71410_x().func_147108_a(prevScreen);
            }
        }, "Choose your team", "Before using the store, you need to join a team", "RED", "BLU", 0));
    }

    public static void doChargeTick(EntityLivingBase player) {
        if (player == Minecraft.func_71410_x().field_71439_g) {
            if (player.func_70660_b(TF2weapons.charging) != null && !(Minecraft.func_71410_x().field_71439_g.field_71158_b instanceof MovementInputCharging)) {
                ((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).lastMovementInput = Minecraft.func_71410_x().field_71439_g.field_71158_b;
                Minecraft.func_71410_x().field_71439_g.field_71158_b = new MovementInputCharging();
                KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151463_i(), (boolean)true);
                Minecraft.func_71410_x().field_71474_y.field_74341_c *= 0.1f;
            } else if (player.func_70660_b(TF2weapons.charging) == null && ((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).lastMovementInput != null) {
                Minecraft.func_71410_x().field_71439_g.field_71158_b = ((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).lastMovementInput;
                ((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).lastMovementInput = null;
                Minecraft.func_71410_x().field_71474_y.field_74341_c *= 10.0f;
            }
        }
    }

    public static void showGuiSentry(EntitySentry entitySentry) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSentry(entitySentry));
    }

    public static void showGuiDisguise() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiDisguiseKit());
    }

    public static void removeSprint() {
        KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151463_i(), (boolean)false);
    }

    public static void setColor(int color, float alpha, float darken, float min, float max) {
        GlStateManager.func_179131_c((float)MathHelper.func_76131_a((float)((float)(color >> 16) / 255.0f + darken), (float)min, (float)max), (float)MathHelper.func_76131_a((float)((float)(color >> 8 & 0xFF) / 255.0f + darken), (float)min, (float)max), (float)MathHelper.func_76131_a((float)((float)(color & 0xFF) / 255.0f + darken), (float)min, (float)max), (float)alpha);
    }

    @Override
    public void displayCorruptedFileError() {
        throw new CorruptedFileException();
    }

    static {
        reload = new KeyBinding("key.reload", 19, "TF2");
        backpackitem = new KeyBinding("key.activatebackpack", 11, "TF2");
        scopeTexture = new ResourceLocation("rafradek_tf2_weapons", "textures/misc/scope.png");
        blackTexture = new ResourceLocation("rafradek_tf2_weapons", "textures/misc/black.png");
        circleTexture = new ResourceLocation("rafradek_tf2_weapons", "textures/misc/circle.png");
        healingTexture = new ResourceLocation("rafradek_tf2_weapons", "textures/gui/healing.png");
        buildingTexture = new ResourceLocation("rafradek_tf2_weapons", "textures/gui/buildings.png");
        blueprintTexture = new ResourceLocation("rafradek_tf2_weapons", "textures/gui/blueprints.png");
        chargeTexture = new ResourceLocation("rafradek_tf2_weapons", "textures/misc/charge.png");
        WIDGETS_TEXTURE_MC = new ResourceLocation("textures/gui/widgets.png");
        VIGNETTE = new ResourceLocation("textures/misc/vignette.png");
        particleFactories = new EnumMap(EnumTF2Particles.class);
        LOGGER = (Logger)LogManager.getLogger();
    }

    public static class CorruptedFileException
    extends CustomModLoadingErrorDisplayException {
        private static final long serialVersionUID = 1L;

        public void initGui(GuiErrorScreen errorScreen, FontRenderer fontRenderer) {
        }

        public void drawScreen(GuiErrorScreen errorScreen, FontRenderer fontRenderer, int mouseRelX, int mouseRelY, float tickTime) {
            errorScreen.func_73732_a(fontRenderer, "TF2 Stuff Mod", errorScreen.field_146294_l / 2, 70, 0xFFFFFF);
            errorScreen.func_73732_a(fontRenderer, "Failed to copy weapon files. Restart the game and try again", errorScreen.field_146294_l / 2, 90, 0xFFFFFF);
        }
    }

    public static class MovementInputCharging
    extends MovementInput {
        public MovementInputCharging() {
            this.field_78902_a = 0.0f;
            this.field_192832_b = 1.0f;
        }
    }

    public static class RenderCustomModel
    extends RenderLivingBase<EntityLivingBase> {
        private ResourceLocation texture;

        public RenderCustomModel(RenderManager renderManagerIn, ModelBase modelBaseIn, float shadowSizeIn) {
            super(renderManagerIn, modelBaseIn, shadowSizeIn);
        }

        protected ResourceLocation getEntityTexture(EntityLivingBase entity) {
            return this.texture;
        }

        public void setRenderOptions(ModelBase model, ResourceLocation texture) {
            this.field_77045_g = model;
            this.texture = texture;
        }

        protected boolean func_177070_b(EntityLivingBase entity) {
            return false;
        }
    }
}

