/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.tileentity.TileEntityOverheadDoor;

public class BlockOverheadDoor
extends BlockContainer {
    public static final PropertyBool HOLDER = PropertyBool.func_177716_a((String)"holder");
    public static final PropertyBool SLIDING = PropertyBool.func_177716_a((String)"sliding");
    public static final PropertyBool CONTROLLER = PropertyBool.func_177716_a((String)"controller");
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.03125);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.96875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.96875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.03125, 1.0, 1.0);

    public BlockOverheadDoor() {
        super(Material.field_151573_f, MapColor.field_151668_h);
        this.func_149713_g(TF2ConfigVars.doorBlockLight ? 255 : 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)HOLDER, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)SLIDING, (Comparable)Boolean.valueOf(false)));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if ((meta & 4) == 4) {
            return new TileEntityOverheadDoor();
        }
        return null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return SOUTH_AABB;
            }
            case EAST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return NORTH_AABB;
            }
            case WEST: {
                return EAST_AABB;
            }
        }
        return field_185505_j;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)SLIDING)).booleanValue()) {
            return field_185506_k;
        }
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return SOUTH_AABB;
            }
            case EAST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return NORTH_AABB;
            }
            case WEST: {
                return EAST_AABB;
            }
        }
        return field_185506_k;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == state.func_177229_b((IProperty)FACING) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)SLIDING) != false ? 0 : super.getLightOpacity(state, world, pos);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(2 + (meta & 3)))).func_177226_a((IProperty)HOLDER, (Comparable)Boolean.valueOf((meta & 4) == 4)).func_177226_a((IProperty)SLIDING, (Comparable)Boolean.valueOf((meta & 8) == 8));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() - 2 + ((Boolean)state.func_177229_b((IProperty)HOLDER) != false ? 4 : 0) + ((Boolean)state.func_177229_b((IProperty)SLIDING) != false ? 8 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HOLDER, SLIDING});
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        BlockPos off = pos;
        while (worldIn.func_180495_p(off = off.func_177984_a()).func_177230_c() == this) {
            worldIn.func_175655_b(off, true);
        }
        off = pos;
        while (worldIn.func_180495_p(off = off.func_177977_b()).func_177230_c() == this) {
            worldIn.func_175655_b(off, true);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return (Boolean)state.func_177229_b((IProperty)HOLDER) != false ? super.func_180660_a(state, rand, fortune) : Items.field_190931_a;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity ent = worldIn.func_175625_s(pos);
        if (ent instanceof TileEntityOverheadDoor) {
            ((TileEntityOverheadDoor)ent).powered = worldIn.func_175640_z(pos);
        }
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.getAiPathNodeType(state, world, pos);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        if (((Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)SLIDING)).booleanValue()) {
            return true;
        }
        for (int y = 0; y < 5; ++y) {
            BlockPos off = pos.func_177982_a(0, y, 0);
            if (!(worldIn.func_175625_s(off) instanceof TileEntityOverheadDoor)) continue;
            TileEntityOverheadDoor ent = (TileEntityOverheadDoor)worldIn.func_175625_s(off);
            return ent.allow == TileEntityOverheadDoor.Allow.ENTITY || ent.allow == TileEntityOverheadDoor.Allow.TEAM;
        }
        return false;
    }
}

