/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons;

import com.google.common.base.Predicate;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.client.CPacketInput;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.MovementInput;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.common.TF2Achievements;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.entity.boss.EntityHHH;
import rafradek.TF2weapons.entity.boss.EntityMerasmus;
import rafradek.TF2weapons.entity.boss.EntityMonoculus;
import rafradek.TF2weapons.entity.boss.EntityTF2Boss;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.item.ItemAmmo;
import rafradek.TF2weapons.item.ItemBackpack;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemMoney;
import rafradek.TF2weapons.item.ItemPDA;
import rafradek.TF2weapons.item.ItemWrench;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.util.Contract;
import rafradek.TF2weapons.util.PlayerPersistStorage;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2Util;

public class TF2PlayerCapability
implements ICapabilityProvider,
INBTSerializable<NBTTagCompound> {
    public EntityPlayer owner;
    public boolean pressedStart;
    public int zombieHuntTicks;
    public boolean wornEye;
    public int cratesOpened;
    public float dodgedDmg;
    public int tickAirblasted;
    public ItemStackHandler lostItems;
    public HashMap<Class<? extends Entity>, Short> highestBossLevel = new HashMap();
    public int nextBossTicks;
    public int stickybombKilled;
    public boolean engineerKilled;
    public boolean sentryKilled;
    public boolean dispenserKilled;
    public int[] cachedAmmoCount = new int[ItemAmmo.AMMO_TYPES.length];
    public int sapperTime;
    public int headshotsRow;
    public EntityLivingBase buildingOwnerKill;
    public MovementInput lastMovementInput;
    public ArrayList<Contract> contracts = new ArrayList();
    public int mercenariesKilled;
    public int nextContractDay = -1;
    public boolean newContracts;
    public boolean newRewards;
    public int fastKillTimer;
    public float healed;
    public boolean sendContractsNextTick;
    public EntityLivingBase lastMedic;
    public short udpServerId;
    public int medicCall;
    public boolean medicCharge;
    public boolean breakBlocks;
    public boolean blockUse;
    public float robotsKilledInvasion;
    public NBTTagCompound carrying;
    public int carryingType;
    public int maxInvasionBeaten;
    public int hhhSummonedDay;
    public int monoculusSummonedDay;
    public int merasmusSummonedDay;
    public long bossSpawnTicks;
    public EntityTF2Boss bossToSpawn;
    public int lastDayInvasion;
    private float[] lastDamage = new float[20];
    private float totalLastDamage;
    private boolean backpackItemEquipped;
    public EntityDataManager dataManager;
    private static final NBTTagCompound EMPTY = new NBTTagCompound();
    public static final DataParameter<NBTTagCompound> SENTRY_VIEW = new DataParameter(0, DataSerializers.field_192734_n);
    public static final DataParameter<NBTTagCompound> DISPENSER_VIEW = new DataParameter(1, DataSerializers.field_192734_n);
    public static final DataParameter<NBTTagCompound> TELEPORTERA_VIEW = new DataParameter(2, DataSerializers.field_192734_n);
    public static final DataParameter<NBTTagCompound> TELEPORTERB_VIEW = new DataParameter(3, DataSerializers.field_192734_n);
    public static final DataParameter<ItemStack> BACKPACK_ITEM_HOLD = new DataParameter(4, DataSerializers.field_187196_f);
    public static final DataParameter<Float> INVASION_ATTACK_DIR = new DataParameter(5, DataSerializers.field_187193_c);
    public Multimap<String, AttributeModifier>[] wearablesAttrib = new Multimap[5];

    public TF2PlayerCapability(EntityPlayer entity) {
        this.owner = entity;
        this.lostItems = new ItemStackHandler(27);
        this.nextBossTicks = (int)(entity.field_70170_p.func_72820_D() + (long)entity.func_70681_au().nextInt(360000));
        this.highestBossLevel.put(EntityHHH.class, (short)0);
        this.highestBossLevel.put(EntityMonoculus.class, (short)0);
        this.highestBossLevel.put(EntityMerasmus.class, (short)0);
        this.dataManager = new EntityDataManager((Entity)entity);
        this.dataManager.func_187214_a(SENTRY_VIEW, (Object)EMPTY);
        this.dataManager.func_187214_a(DISPENSER_VIEW, (Object)EMPTY);
        this.dataManager.func_187214_a(TELEPORTERA_VIEW, (Object)EMPTY);
        this.dataManager.func_187214_a(TELEPORTERB_VIEW, (Object)EMPTY);
        this.dataManager.func_187214_a(BACKPACK_ITEM_HOLD, (Object)ItemStack.field_190927_a);
        this.dataManager.func_187214_a(INVASION_ATTACK_DIR, (Object)Float.valueOf(Float.MIN_VALUE));
    }

    public void tick() {
        if (Float.isNaN(this.owner.func_110143_aJ())) {
            this.owner.func_70606_j(this.owner.func_110138_aP());
            this.owner.func_110149_m(0.0f);
        }
        --this.zombieHuntTicks;
        --this.sapperTime;
        if (this.fastKillTimer > 0) {
            --this.fastKillTimer;
        }
        if (this.dodgedDmg > 0.0f && this.owner.func_70660_b(TF2weapons.bonk) == null) {
            this.dodgedDmg = 0.0f;
        }
        if (!this.owner.field_70170_p.field_72995_K) {
            int contractDay;
            if (this.backpackItemEquipped) {
                ItemStack backpack = ItemBackpack.getBackpack((EntityLivingBase)this.owner);
                if (backpack.func_77973_b() instanceof ItemBackpack && (this.owner.field_71071_by.field_70461_c == 0 || this.owner.field_71071_by.field_70461_c == 8)) {
                    ItemStack toUse = ((ItemBackpack)backpack.func_77973_b()).getBackpackItemToUse(backpack, (EntityLivingBase)this.owner);
                    if (!toUse.func_77969_a(this.owner.func_184614_ca())) {
                        if (!this.owner.func_184614_ca().func_190926_b()) {
                            this.owner.func_71019_a(this.getBackpackItemHold(), false);
                            this.setBackpackItemHold(this.owner.func_184614_ca());
                        }
                        this.owner.func_184611_a(EnumHand.MAIN_HAND, toUse.func_77946_l());
                    }
                } else {
                    this.setEquipBackpackItem(false);
                }
            }
            if (this.owner.field_70173_aa % 2 == 0) {
                this.updateBuildings();
            }
            if (this.owner.field_70173_aa % 20 == 0) {
                this.totalLastDamage = 0.0f;
                for (int i = 19; i >= 0; --i) {
                    if (i > 0) {
                        this.lastDamage[i] = this.lastDamage[i - 1];
                        this.totalLastDamage += this.lastDamage[i];
                        continue;
                    }
                    this.lastDamage[0] = 0.0f;
                }
                if (this.medicCharge) {
                    this.medicCharge = false;
                }
                Iterator<BlockPos> it = PlayerPersistStorage.get((EntityPlayer)this.owner).lostMercPos.iterator();
                while (it.hasNext()) {
                    BlockPos pos = it.next();
                    ArrayList list = new ArrayList();
                    this.owner.field_70170_p.func_175726_f(pos).func_177430_a(EntityTF2Character.class, new AxisAlignedBB(pos), list, test -> test.getOrder() == EntityTF2Character.Order.FOLLOW && this.owner.func_110124_au().equals(test.func_184753_b()));
                    boolean success = false;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        EntityTF2Character living = (EntityTF2Character)iterator.next();
                        success = TF2Util.teleportSafe((EntityLiving)living, (Entity)this.owner);
                    }
                    if (!success && !list.isEmpty()) continue;
                    it.remove();
                }
            }
            --this.medicCall;
            if (this.sendContractsNextTick) {
                for (int i = 0; i < this.contracts.size(); ++i) {
                    TF2weapons.network.sendTo(new TF2Message.ContractMessage(i, this.contracts.get(i)), (EntityPlayerMP)this.owner);
                }
            }
            if (this.bossSpawnTicks != 0L && this.bossToSpawn != null && this.bossSpawnTicks < this.owner.field_70170_p.func_72820_D()) {
                if (this.owner.field_70170_p.func_72820_D() % 24000L < 13000L) {
                    this.bossToSpawn = null;
                    this.bossSpawnTicks = 0L;
                } else {
                    BlockPos spawnPos = null;
                    int i = 0;
                    do {
                        spawnPos = this.owner.field_70170_p.func_175672_r(this.owner.func_180425_c().func_177982_a(this.owner.func_70681_au().nextInt(48) - 24, 0, this.owner.func_70681_au().nextInt(48) - 24));
                        this.bossToSpawn.func_70107_b(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
                    } while (++i < 2 && !this.owner.field_70170_p.func_184144_a(null, this.bossToSpawn.func_174813_aQ()).isEmpty());
                    if (spawnPos != null) {
                        this.bossToSpawn.func_180482_a(this.owner.field_70170_p.func_175649_E(this.bossToSpawn.func_180425_c()), null);
                        this.owner.field_70170_p.func_72838_d((Entity)this.bossToSpawn);
                        this.bossToSpawn = null;
                        this.bossSpawnTicks = 0L;
                    }
                }
            }
            if (!PlayerPersistStorage.get((EntityPlayer)this.owner).itemsToGive.isEmpty()) {
                TextComponentTranslation text = new TextComponentTranslation("gui.robotinvasion.reward", new Object[0]);
                text.func_150256_b().func_150238_a(TextFormatting.GOLD);
                this.owner.func_145747_a((ITextComponent)text);
                for (ItemStack stack : PlayerPersistStorage.get((EntityPlayer)this.owner).itemsToGive) {
                    this.owner.func_145747_a((ITextComponent)new TextComponentString(stack.func_82833_r()));
                    if (stack.func_77973_b() instanceof ItemMoney) {
                        ItemMoney.collect(stack, this.owner);
                    }
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)this.owner, (ItemStack)stack);
                }
                PlayerPersistStorage.get((EntityPlayer)this.owner).itemsToGive.clear();
            }
            if (!TF2ConfigVars.disableContracts && this.contracts.size() < 2 && (contractDay = ((EntityPlayerMP)this.owner).func_147099_x().func_77444_a(TF2Achievements.CONTRACT_DAY)) != 0 && this.owner.field_70170_p.func_72820_D() % 24000L > 1000L && this.owner.field_70170_p.func_72820_D() / 24000L >= (long)contractDay) {
                String name = "kill";
                do {
                    switch (this.owner.func_70681_au().nextInt(10)) {
                        case 0: {
                            name = "scout";
                            break;
                        }
                        case 1: {
                            name = "pyro";
                            break;
                        }
                        case 2: {
                            name = "soldier";
                            break;
                        }
                        case 3: {
                            name = "demoman";
                            break;
                        }
                        case 4: {
                            name = "heavy";
                            break;
                        }
                        case 5: {
                            name = "engineer";
                            break;
                        }
                        case 6: {
                            name = "medic";
                            break;
                        }
                        case 7: {
                            name = "sniper";
                            break;
                        }
                        case 8: {
                            name = "spy";
                            break;
                        }
                        default: {
                            name = "kill";
                        }
                    }
                } while (this.contracts.size() > 0 && this.contracts.get((int)0).className.equals(name));
                ((EntityPlayerMP)this.owner).func_147099_x().func_150873_a(this.owner, TF2Achievements.CONTRACT_DAY, (int)(this.owner.field_70170_p.func_72820_D() / 24000L + 7L));
                Contract contract = new Contract(name, 0, this.owner.func_70681_au());
                this.contracts.add(contract);
                TF2weapons.network.sendTo(new TF2Message.ContractMessage(-1, contract), (EntityPlayerMP)this.owner);
            }
            if (this.dataManager.func_187223_a()) {
                TF2weapons.network.sendTo(new TF2Message.PlayerCapabilityMessage((Entity)this.owner, false), (EntityPlayerMP)this.owner);
            }
        } else if (this.owner == Minecraft.func_71410_x().field_71439_g) {
            ((EntityPlayerSP)this.owner).field_71174_a.func_147297_a((Packet)new CPacketInput(this.owner.field_70702_br, this.owner.field_191988_bg, ((EntityPlayerSP)this.owner).field_71158_b.field_78901_c, ((EntityPlayerSP)this.owner).field_71158_b.field_78899_d));
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return TF2weapons.PLAYER_CAP != null && capability == TF2weapons.PLAYER_CAP;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (TF2weapons.PLAYER_CAP != null && capability == TF2weapons.PLAYER_CAP) {
            return (T)TF2weapons.PLAYER_CAP.cast((Object)this);
        }
        return null;
    }

    public void completeObjective(Contract.Objective objective, ItemStack stack) {
        int i = 0;
        for (Contract contract : this.contracts) {
            if (contract.active) {
                for (Contract.Objective objective2 : contract.objectives) {
                    if (objective2 != objective || !contract.className.equals("kill") && !ItemFromData.getData(stack).get(PropertyType.SLOT).containsKey(contract.className)) continue;
                    int oldProgress = contract.progress;
                    contract.progress += objective.getPoints();
                    if (oldProgress < 40 && contract.progress >= 40) {
                        ++contract.rewards;
                    }
                    if (oldProgress < 135 && contract.progress >= 135) {
                        contract.rewards += 2;
                    }
                    if (contract.progress > 135) {
                        contract.progress = 135;
                    }
                    ((EntityPlayerMP)this.owner).func_145747_a((ITextComponent)new TextComponentTranslation("gui.contracts.progress", new Object[]{contract.className, contract.progress}));
                    TF2weapons.network.sendTo(new TF2Message.ContractMessage(i, contract), (EntityPlayerMP)this.owner);
                    break;
                }
            }
            ++i;
        }
    }

    public ItemStack getBackpackItemHold() {
        return (ItemStack)this.dataManager.func_187225_a(BACKPACK_ITEM_HOLD);
    }

    public void setBackpackItemHold(ItemStack stack) {
        this.dataManager.func_187227_b(BACKPACK_ITEM_HOLD, (Object)stack);
    }

    public float getInvasionDir() {
        return ((Float)this.dataManager.func_187225_a(INVASION_ATTACK_DIR)).floatValue();
    }

    public void setInvasionDir(float dir) {
        this.dataManager.func_187227_b(INVASION_ATTACK_DIR, (Object)Float.valueOf(dir));
    }

    public NBTTagCompound getSentryView() {
        return (NBTTagCompound)this.dataManager.func_187225_a(SENTRY_VIEW);
    }

    public NBTTagCompound getDispenserView() {
        return (NBTTagCompound)this.dataManager.func_187225_a(DISPENSER_VIEW);
    }

    public NBTTagCompound getTeleporterAView() {
        return (NBTTagCompound)this.dataManager.func_187225_a(TELEPORTERA_VIEW);
    }

    public NBTTagCompound getTeleporterBView() {
        return (NBTTagCompound)this.dataManager.func_187225_a(TELEPORTERB_VIEW);
    }

    public void updateBuildings() {
        PlayerPersistStorage storage = PlayerPersistStorage.get(this.owner);
        if (storage.buildings[0] != null) {
            this.dataManager.func_187227_b(SENTRY_VIEW, storage.buildings[0].func_76340_b());
            this.dataManager.func_187217_b(SENTRY_VIEW);
        } else {
            this.dataManager.func_187227_b(SENTRY_VIEW, (Object)EMPTY);
        }
        if (storage.buildings[1] != null) {
            this.dataManager.func_187227_b(DISPENSER_VIEW, storage.buildings[1].func_76340_b());
            this.dataManager.func_187217_b(DISPENSER_VIEW);
        } else {
            this.dataManager.func_187227_b(DISPENSER_VIEW, (Object)EMPTY);
        }
        if (storage.buildings[2] != null) {
            this.dataManager.func_187227_b(TELEPORTERA_VIEW, storage.buildings[2].func_76340_b());
            this.dataManager.func_187217_b(TELEPORTERA_VIEW);
        } else {
            this.dataManager.func_187227_b(TELEPORTERA_VIEW, (Object)EMPTY);
        }
        if (storage.buildings[3] != null) {
            this.dataManager.func_187227_b(TELEPORTERB_VIEW, storage.buildings[3].func_76340_b());
            this.dataManager.func_187217_b(TELEPORTERB_VIEW);
        } else {
            this.dataManager.func_187227_b(TELEPORTERB_VIEW, (Object)EMPTY);
        }
    }

    public void addLastDamage(float damage, boolean isPlayerTarget) {
        if (!isPlayerTarget) {
            damage *= 0.5f;
            if (this.getTotalLastDamage() + damage > 60.0f) {
                damage = 60.0f - this.getTotalLastDamage();
            }
        }
        this.lastDamage[0] = this.lastDamage[0] + damage;
    }

    public float getTotalLastDamage() {
        return this.totalLastDamage + this.lastDamage[0];
    }

    public int calculateMaxSentries() {
        ItemStack wrench = TF2Util.getBestItem((IInventory)this.owner.field_71071_by, (stack1, stack2) -> {
            float sentries2;
            float sentries1 = TF2Attribute.getModifier("Sentry Bonus", stack1, 1.0f, (EntityLivingBase)this.owner);
            return sentries1 > (sentries2 = TF2Attribute.getModifier("Sentry Bonus", stack2, 1.0f, (EntityLivingBase)this.owner)) ? 1 : (sentries1 == sentries2 ? 0 : -1);
        }, (Predicate<ItemStack>)((Predicate)stack -> stack.func_77973_b() instanceof ItemWrench));
        ItemStack pda = TF2Util.getBestItem((IInventory)this.owner.field_71071_by, (stack1, stack2) -> {
            float sentries2;
            float sentries1 = TF2Attribute.getModifier("Extra Sentry", stack1, 0.0f, (EntityLivingBase)this.owner);
            return sentries1 > (sentries2 = TF2Attribute.getModifier("Extra Sentry", stack2, 0.0f, (EntityLivingBase)this.owner)) ? 1 : (sentries1 == sentries2 ? 0 : -1);
        }, (Predicate<ItemStack>)((Predicate)stack -> stack.func_77973_b() instanceof ItemPDA));
        return (int)(TF2Attribute.getModifier("Sentry Bonus", wrench, 1.0f, (EntityLivingBase)this.owner) * TF2Attribute.getModifier("Extra Sentry", pda, 0.0f, (EntityLivingBase)this.owner));
    }

    public void setEquipBackpackItem(boolean equip) {
        ItemStack backpack = ItemBackpack.getBackpack((EntityLivingBase)this.owner);
        if (backpack.func_190926_b() || this.owner.field_71071_by.field_70461_c != 0 && this.owner.field_71071_by.field_70461_c != 8) {
            equip = false;
        }
        if (!this.owner.field_70170_p.field_72995_K) {
            ItemStack toUse = ItemStack.field_190927_a;
            if (!backpack.func_190926_b()) {
                toUse = ((ItemBackpack)backpack.func_77973_b()).getBackpackItemToUse(backpack, (EntityLivingBase)this.owner);
            }
            if (toUse.func_190926_b()) {
                equip = false;
            }
            if (equip) {
                if (!toUse.func_77969_a(this.owner.func_184614_ca())) {
                    this.owner.func_71019_a(this.getBackpackItemHold(), false);
                    this.setBackpackItemHold(this.owner.func_184614_ca());
                }
                this.owner.func_184611_a(EnumHand.MAIN_HAND, toUse.func_77946_l());
            } else {
                if (toUse.func_77969_a(this.owner.func_184614_ca())) {
                    this.owner.func_184611_a(EnumHand.MAIN_HAND, this.getBackpackItemHold());
                } else {
                    this.owner.func_71019_a(this.getBackpackItemHold(), false);
                }
                this.setBackpackItemHold(ItemStack.field_190927_a);
            }
            if (this.owner instanceof EntityPlayerMP) {
                TF2weapons.network.sendTo(new TF2Message.ActionMessage(equip ? 31 : 32, (EntityLivingBase)this.owner), (EntityPlayerMP)this.owner);
            }
        }
        this.backpackItemEquipped = equip;
    }

    public boolean isBackpackItemEquipped() {
        return this.backpackItemEquipped;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound bossInfo = new NBTTagCompound();
        for (Map.Entry<Class<? extends Entity>, Short> entry : this.highestBossLevel.entrySet()) {
            bossInfo.func_74777_a(EntityList.func_191306_a(entry.getKey()).toString(), entry.getValue().shortValue());
        }
        tag.func_74782_a("BossInfo", (NBTBase)bossInfo);
        tag.func_74768_a("NextBossTick", this.nextBossTicks);
        tag.func_74776_a("DodgedDmg", this.dodgedDmg);
        NBTTagList list = new NBTTagList();
        tag.func_74782_a("Contracts", (NBTBase)list);
        for (Contract contract : this.contracts) {
            NBTTagCompound com = new NBTTagCompound();
            com.func_74757_a("Active", contract.active);
            com.func_74777_a("Progress", (short)contract.progress);
            com.func_74774_a("Rewards", (byte)contract.rewards);
            byte[] objs = new byte[contract.objectives.length];
            for (int i = 0; i < contract.objectives.length; ++i) {
                objs[i] = (byte)contract.objectives[i].ordinal();
            }
            com.func_74773_a("Objectives", objs);
            com.func_74778_a("Name", contract.className);
            list.func_74742_a((NBTBase)com);
        }
        tag.func_74768_a("NextContractDay", this.nextContractDay);
        if (this.carrying != null) {
            tag.func_74782_a("Carrying", (NBTBase)this.carrying);
            tag.func_74774_a("CarryingType", (byte)this.carryingType);
        }
        tag.func_74776_a("RobotsKilled", (float)((short)this.robotsKilledInvasion));
        tag.func_74774_a("MaxInvasionBeaten", (byte)this.maxInvasionBeaten);
        tag.func_74772_a("BossSpawnTime", this.bossSpawnTicks);
        tag.func_74757_a("HHHSummonedDay", (long)this.hhhSummonedDay == this.owner.field_70170_p.func_72820_D() / 24000L);
        tag.func_74757_a("MonoculusSummonedDay", (long)this.monoculusSummonedDay == this.owner.field_70170_p.func_72820_D() / 24000L);
        tag.func_74757_a("MerasmusSummonedDay", (long)this.merasmusSummonedDay == this.owner.field_70170_p.func_72820_D() / 24000L);
        if (this.bossToSpawn != null) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            this.bossToSpawn.func_70039_c(nBTTagCompound);
            tag.func_74782_a("BossSpawn", (NBTBase)nBTTagCompound);
        }
        tag.func_74768_a("LastDayInvasion", this.lastDayInvasion);
        tag.func_74757_a("BackpackEquip", this.backpackItemEquipped);
        tag.func_74782_a("BackpackEquipItem", (NBTBase)this.getBackpackItemHold().serializeNBT());
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        Entity ent;
        NBTTagCompound bossInfo = nbt.func_74775_l("BossInfo");
        for (String key : bossInfo.func_150296_c()) {
            this.highestBossLevel.put(EntityList.getClass((ResourceLocation)new ResourceLocation(key)), bossInfo.func_74765_d(key));
        }
        this.nextBossTicks = nbt.func_74762_e("NextBossTick");
        this.dodgedDmg = nbt.func_74760_g("DodgedDmg");
        NBTTagList list = (NBTTagList)nbt.func_74781_a("Contracts");
        this.contracts.clear();
        if (list != null) {
            for (int i = 0; i < list.func_74745_c() && i < 16; ++i) {
                NBTTagCompound com = list.func_150305_b(i);
                byte[] objsb = com.func_74770_j("Objectives");
                Contract.Objective[] objs = new Contract.Objective[objsb.length];
                for (int j = 0; j < objsb.length; ++j) {
                    objs[j] = Contract.Objective.values()[objsb[j]];
                }
                Contract contract = new Contract(com.func_74779_i("Name"), 0, objs);
                contract.active = com.func_74767_n("Active");
                contract.progress = com.func_74765_d("Progress");
                contract.rewards = com.func_74771_c("Rewards");
                this.contracts.add(contract);
            }
        }
        this.nextContractDay = nbt.func_74762_e("NextContractDay");
        this.carrying = (NBTTagCompound)nbt.func_74781_a("Carrying");
        this.carryingType = nbt.func_74771_c("CarryingType");
        this.robotsKilledInvasion = nbt.func_74760_g("RobotsKilled");
        this.maxInvasionBeaten = nbt.func_74771_c("MaxInvasionBeaten");
        this.bossSpawnTicks = nbt.func_74763_f("BossSpawnTime");
        if (nbt.func_74767_n("HHHSummonedDay")) {
            this.hhhSummonedDay = (int)(this.owner.field_70170_p.func_72820_D() / 24000L);
        }
        if (nbt.func_74767_n("MonoculusSummonedDay")) {
            this.monoculusSummonedDay = (int)(this.owner.field_70170_p.func_72820_D() / 24000L);
        }
        if (nbt.func_74767_n("MerasmusSummonedDay")) {
            this.merasmusSummonedDay = (int)(this.owner.field_70170_p.func_72820_D() / 24000L);
        }
        if ((ent = EntityList.func_75615_a((NBTTagCompound)nbt.func_74775_l("BossSpawn"), (World)this.owner.field_70170_p)) instanceof EntityTF2Boss) {
            this.bossToSpawn = (EntityTF2Boss)ent;
        }
        this.lastDayInvasion = nbt.func_74762_e("LastDayInvasion");
        this.backpackItemEquipped = nbt.func_74767_n("BackpackEquip");
        this.setBackpackItemHold(new ItemStack(nbt.func_74775_l("BackpackEquipItem")));
    }

    public static TF2PlayerCapability get(EntityPlayer player) {
        return (TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null);
    }

    public void onChangeValue(DataParameter<?> key, Object value) {
    }
}

