/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import rafradek.TF2weapons.TF2ConfigVars;
import rafradek.TF2weapons.TF2PlayerCapability;
import rafradek.TF2weapons.TF2weapons;
import rafradek.TF2weapons.client.ClientProxy;
import rafradek.TF2weapons.client.audio.TF2Sounds;
import rafradek.TF2weapons.common.MapList;
import rafradek.TF2weapons.common.TF2Attribute;
import rafradek.TF2weapons.common.WeaponsCapability;
import rafradek.TF2weapons.entity.EntityDummy;
import rafradek.TF2weapons.entity.EntityStatue;
import rafradek.TF2weapons.entity.IEntityTF2;
import rafradek.TF2weapons.entity.boss.EntityHHH;
import rafradek.TF2weapons.entity.boss.EntityMerasmus;
import rafradek.TF2weapons.entity.boss.EntityMonoculus;
import rafradek.TF2weapons.entity.boss.EntityTF2Boss;
import rafradek.TF2weapons.entity.building.EntityBuilding;
import rafradek.TF2weapons.entity.building.EntityDispenser;
import rafradek.TF2weapons.entity.building.EntitySentry;
import rafradek.TF2weapons.entity.building.EntityTeleporter;
import rafradek.TF2weapons.entity.mercenary.EntityDemoman;
import rafradek.TF2weapons.entity.mercenary.EntityEngineer;
import rafradek.TF2weapons.entity.mercenary.EntityHeavy;
import rafradek.TF2weapons.entity.mercenary.EntityMedic;
import rafradek.TF2weapons.entity.mercenary.EntityPyro;
import rafradek.TF2weapons.entity.mercenary.EntityScout;
import rafradek.TF2weapons.entity.mercenary.EntitySniper;
import rafradek.TF2weapons.entity.mercenary.EntitySoldier;
import rafradek.TF2weapons.entity.mercenary.EntitySpy;
import rafradek.TF2weapons.entity.mercenary.EntityTF2Character;
import rafradek.TF2weapons.entity.mercenary.InvasionEvent;
import rafradek.TF2weapons.entity.projectile.EntityProjectileBase;
import rafradek.TF2weapons.inventory.ContainerMercenary;
import rafradek.TF2weapons.inventory.InventoryLoadout;
import rafradek.TF2weapons.inventory.InventoryWearables;
import rafradek.TF2weapons.item.IBackpackItem;
import rafradek.TF2weapons.item.ItemAmmo;
import rafradek.TF2weapons.item.ItemAmmoPackage;
import rafradek.TF2weapons.item.ItemBackpack;
import rafradek.TF2weapons.item.ItemCloak;
import rafradek.TF2weapons.item.ItemDisguiseKit;
import rafradek.TF2weapons.item.ItemFoodThrowable;
import rafradek.TF2weapons.item.ItemFromData;
import rafradek.TF2weapons.item.ItemHuntsman;
import rafradek.TF2weapons.item.ItemJetpack;
import rafradek.TF2weapons.item.ItemKillstreakKit;
import rafradek.TF2weapons.item.ItemMedigun;
import rafradek.TF2weapons.item.ItemMeleeWeapon;
import rafradek.TF2weapons.item.ItemMinigun;
import rafradek.TF2weapons.item.ItemMoney;
import rafradek.TF2weapons.item.ItemSniperRifle;
import rafradek.TF2weapons.item.ItemSoldierBackpack;
import rafradek.TF2weapons.item.ItemStickyLauncher;
import rafradek.TF2weapons.item.ItemToken;
import rafradek.TF2weapons.item.ItemUsable;
import rafradek.TF2weapons.item.ItemWeapon;
import rafradek.TF2weapons.item.ItemWearable;
import rafradek.TF2weapons.message.TF2Message;
import rafradek.TF2weapons.message.udp.TF2UdpClient;
import rafradek.TF2weapons.message.udp.TF2UdpServer;
import rafradek.TF2weapons.util.Contract;
import rafradek.TF2weapons.util.PlayerPersistStorage;
import rafradek.TF2weapons.util.PropertyType;
import rafradek.TF2weapons.util.TF2DamageSource;
import rafradek.TF2weapons.util.TF2Util;
import rafradek.TF2weapons.util.WeaponData;
import rafradek.TF2weapons.world.gen.structure.MannCoBuilding;
import rafradek.TF2weapons.world.gen.structure.ScatteredFeatureTF2Base;

public class TF2EventsCommon {
    public int tickleft;
    public static EntityBuilding teleporterBView;
    public static EntityBuilding teleporterAView;
    public static EntityBuilding dispenserView;
    public static EntityBuilding sentryView;
    public static final String[] STRANGE_TITLES;
    public static final int[] STRANGE_KILLS;
    public static HashMap<EntityLivingBase, EntityLivingBase> fakeEntities;
    public static ArrayList<EntityLivingBase> pathsToDefine;
    public static final DataParameter<Float> ENTITY_OVERHEAL;
    public static final UUID REMOVE_ARMOR;
    public static long[] tickTimeLiving;
    public static long[] tickTimeMercUpdate;
    public static long[] tickTimeOther;

    @SubscribeEvent
    public void untargetable(LivingSetAttackTargetEvent event) {
        boolean notarget;
        boolean bl = notarget = event.getTarget() == null;
        if (!(event.getEntityLiving() instanceof EntityLiving)) {
            return;
        }
        if (notarget && event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111265_b).func_111127_a(TF2Util.FOLLOW_MODIFIER) != null) {
            event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111265_b).func_188479_b(TF2Util.FOLLOW_MODIFIER);
            event.getEntityLiving().getEntityData().func_82580_o("TF2AM");
        }
        if (!notarget && event.getTarget().hasCapability(TF2weapons.WEAPONS_CAP, null) && ((WeaponsCapability)event.getTarget().getCapability(TF2weapons.WEAPONS_CAP, null)).invisTicks >= 45) {
            ((EntityLiving)event.getEntity()).func_70624_b(null);
        }
        if (event.getTarget() instanceof EntityTF2Character && event.getEntity() instanceof EntityGolem && ((IEntityOwnable)event.getTarget()).func_70902_q() != null) {
            ((EntityLiving)event.getEntity()).func_70624_b(null);
        }
        if (!notarget && event.getEntityLiving().func_184222_aU() && event.getTarget().hasCapability(TF2weapons.WEAPONS_CAP, null) && ItemDisguiseKit.isDisguised(event.getTarget(), event.getEntityLiving()) && event.getEntityLiving().func_94060_bK() != event.getTarget() && event.getEntityLiving() instanceof EntityLiving) {
            ((EntityLiving)event.getEntity()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public void serverTickEnd(TickEvent.ServerTickEvent event) {
    }

    public static double avg(long[] values) {
        long totalticktime = 0L;
        for (long val : values) {
            totalticktime += val;
        }
        return (double)(totalticktime /= (long)values.length) * 1.0E-6;
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == Side.SERVER) {
            Object entry;
            long worldTime = event.world.func_72820_D();
            TF2WorldStorage events = (TF2WorldStorage)event.world.getCapability(TF2weapons.WORLD_CAP, null);
            Iterator<Map.Entry<Entity, InboundDamage>> it = events.damage.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Entity, InboundDamage> entry2 = it.next();
                if (entry2.getKey().field_70128_L) {
                    it.remove();
                    continue;
                }
                float f = entry2.getKey().field_70172_ad;
                float f2 = entry2.getKey() instanceof EntityLivingBase ? (float)((EntityLivingBase)entry2.getKey()).field_70771_an / 2.0f : 10.0f;
                if (!(f <= f2)) continue;
                TF2Util.dealDamageActual(entry2.getKey(), event.world, entry2.getValue().living, entry2.getValue().stack, entry2.getValue().critical, entry2.getValue().damage, entry2.getValue().source);
                it.remove();
            }
            if (worldTime % 4L == 0L) {
                for (int i = events.destroyProgress.size() - 1; i >= 0; --i) {
                    entry = events.destroyProgress.get(i);
                    int count = 0;
                    if (entry == null || ((DestroyBlockEntry)entry).world != event.world) continue;
                    ((DestroyBlockEntry)entry).curDamage -= 0.05f;
                    if (((DestroyBlockEntry)entry).curDamage <= 0.0f || ((DestroyBlockEntry)entry).world.func_175623_d(((DestroyBlockEntry)entry).pos) || ++count >= 100) {
                        events.destroyProgress.set(i, null);
                        event.world.func_175715_c(Math.min(Integer.MAX_VALUE, 65535 + i), ((DestroyBlockEntry)entry).pos, -1);
                        continue;
                    }
                    if (worldTime % 20L != 0L) continue;
                    int val = (int)(((DestroyBlockEntry)entry).curDamage / TF2Util.getHardness(((DestroyBlockEntry)entry).world.func_180495_p(((DestroyBlockEntry)entry).pos), ((DestroyBlockEntry)entry).world, ((DestroyBlockEntry)entry).pos) * 10.0f);
                    event.world.func_175715_c(Math.min(Integer.MAX_VALUE, 65535 + i), ((DestroyBlockEntry)entry).pos, val);
                }
            }
            Iterator<Map.Entry<UUID, InvasionEvent>> ite = events.invasions.entrySet().iterator();
            while (ite.hasNext()) {
                entry = ite.next();
                entry.getValue().onUpdate();
                if (!((InvasionEvent)entry.getValue()).finished) continue;
                ite.remove();
            }
            if (event.world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
                int dayTime = (int)(worldTime % 24000L);
                int dayNum = (int)(worldTime / 24000L);
                if (dayTime == 1 && events != null) {
                    Random random = new Random(event.world.func_72905_C() + worldTime * worldTime * 4987142L + worldTime * 5947611L);
                    if (random.nextFloat() <= TF2ConfigVars.invasionChance) {
                        for (EntityPlayer player : event.world.field_73010_i) {
                            if (player.func_96124_cp() == null || !(player.func_70681_au().nextFloat() < (float)(dayNum - TF2PlayerCapability.get((EntityPlayer)player).lastDayInvasion - TF2ConfigVars.invasionMinDay) * 0.055f)) continue;
                            events.startInvasion(player, Math.min(TF2PlayerCapability.get((EntityPlayer)player).maxInvasionBeaten, MathHelper.func_76125_a((int)MathHelper.func_76123_f((float)((float)worldTime / 960000.0f)), (int)0, (int)2)), false);
                        }
                    }
                }
                if (!TF2ConfigVars.disableBossSpawn && dayTime >= 13000 && dayTime <= 20000 && dayTime % 1000 == 0 && event.world.func_130001_d() == 1.0f && worldTime > 24000L) {
                    for (EntityPlayer player : event.world.field_73010_i) {
                        EntityTF2Boss boss;
                        if ((long)((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).nextBossTicks > worldTime || !event.world.func_72872_a(EntityTF2Boss.class, player.func_174813_aQ().func_72314_b(200.0, 200.0, 200.0)).isEmpty()) continue;
                        ((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).nextBossTicks = (int)(worldTime + (long)Math.min(40000, TF2ConfigVars.bossReappear) + (long)player.func_70681_au().nextInt(Math.max(1, TF2ConfigVars.bossReappear - 40000)));
                        short bosslowest = 31;
                        int bossid = 0;
                        if (TF2PlayerCapability.get((EntityPlayer)player).highestBossLevel.get(EntityHHH.class) < bosslowest) {
                            bosslowest = TF2PlayerCapability.get((EntityPlayer)player).highestBossLevel.get(EntityHHH.class);
                            bossid = 0;
                        }
                        if (TF2PlayerCapability.get((EntityPlayer)player).highestBossLevel.get(EntityMonoculus.class) < bosslowest) {
                            bosslowest = TF2PlayerCapability.get((EntityPlayer)player).highestBossLevel.get(EntityMonoculus.class);
                            bossid = 1;
                        }
                        if (TF2PlayerCapability.get((EntityPlayer)player).highestBossLevel.get(EntityMerasmus.class) < bosslowest) {
                            bosslowest = TF2PlayerCapability.get((EntityPlayer)player).highestBossLevel.get(EntityMerasmus.class);
                            bossid = 2;
                        }
                        switch (bossid) {
                            case 0: {
                                boss = new EntityHHH(event.world);
                                break;
                            }
                            case 1: {
                                boss = new EntityMonoculus(event.world);
                                break;
                            }
                            default: {
                                boss = new EntityMerasmus(event.world);
                            }
                        }
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("boss.message", new Object[]{boss.func_70005_c_()}));
                        TF2PlayerCapability.get((EntityPlayer)player).bossSpawnTicks = worldTime + 1200L;
                        TF2PlayerCapability.get((EntityPlayer)player).bossToSpawn = boss;
                    }
                }
            }
        }
    }

    public static boolean isSpawnEvent(World world) {
        return world.hasCapability(TF2weapons.WORLD_CAP, null) && ((TF2WorldStorage)world.getCapability(TF2weapons.WORLD_CAP, null)).eventFlag == 1;
    }

    @SubscribeEvent
    public void stopHurt(LivingAttackEvent event) {
        ItemStack backpack;
        if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityLivingBase && (event.getSource().field_76373_n.equals("mob") || event.getSource().field_76373_n.equals("player"))) {
            EntityLivingBase damageSource = (EntityLivingBase)event.getSource().func_76346_g();
            if (!TF2Util.canInteract(damageSource)) {
                event.setCanceled(true);
            }
            if (damageSource.hasCapability(TF2weapons.WEAPONS_CAP, null)) {
                WeaponsCapability.get((Entity)damageSource).setDisguised(false);
            }
        }
        if (event.getSource().func_76346_g() instanceof EntityLivingBase && event.getSource() instanceof TF2DamageSource && ((TF2DamageSource)event.getSource()).hasAttackFlag(1) && !(backpack = ItemBackpack.getBackpack(event.getEntityLiving())).func_190926_b() && backpack.func_77978_p().func_74765_d("Cooldown") <= 0 && TF2Attribute.getModifier("No Backstab", backpack, 0.0f, event.getEntityLiving()) != 0.0f) {
            ((EntityLivingBase)event.getSource().func_76346_g()).func_70690_d(new PotionEffect(TF2weapons.stun, 40));
            event.setCanceled(true);
            TF2Util.playSound((Entity)event.getEntityLiving(), TF2Sounds.RAZORBACK_BREAK, 1.0f, 1.0f);
            backpack.func_77978_p().func_74777_a("Cooldown", (short)((ItemBackpack)backpack.func_77973_b()).getCooldown(backpack));
            return;
        }
        if (!(event.getSource().func_151517_h() || event.getSource().func_76357_e() || event.getEntityLiving().func_70660_b(TF2weapons.bonk) == null && event.getEntityLiving().func_70660_b(TF2weapons.uber) == null || event.getSource().func_76357_e())) {
            event.setCanceled(true);
            if (event.getEntityLiving() instanceof EntityPlayer && event.getEntityLiving().func_70660_b(TF2weapons.bonk) != null) {
                ((TF2PlayerCapability)event.getEntityLiving().getCapability(TF2weapons.PLAYER_CAP, null)).dodgedDmg += event.getAmount();
            }
            return;
        }
        if (!event.isCanceled() && event.getAmount() > 0.0f) {
            event.getEntityLiving().getEntityData().func_74768_a("lasthit", event.getEntityLiving().field_70173_aa);
        }
    }

    @SubscribeEvent
    public void clonePlayer(PlayerEvent.Clone event) {
        int i;
        InventoryWearables oldInv = (InventoryWearables)((Object)event.getOriginal().getCapability(TF2weapons.INVENTORY_CAP, null));
        InventoryWearables newInv = (InventoryWearables)((Object)event.getEntityPlayer().getCapability(TF2weapons.INVENTORY_CAP, null));
        if (event.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            for (i = 0; i < oldInv.func_70302_i_(); ++i) {
                newInv.func_70299_a(i, oldInv.func_70301_a(i));
                if (oldInv.func_70301_a(i).func_190926_b()) continue;
                Multimap modifiers = oldInv.func_70301_a(i).func_111283_C(EntityEquipmentSlot.CHEST);
                if (i == 2) {
                    modifiers.removeAll((Object)SharedMonsterAttributes.field_188791_g.func_111108_a());
                    modifiers.removeAll((Object)SharedMonsterAttributes.field_189429_h.func_111108_a());
                }
                event.getEntityPlayer().func_110140_aT().func_111147_b(modifiers);
                if (i >= TF2PlayerCapability.get((EntityPlayer)event.getEntityPlayer()).wearablesAttrib.length) continue;
                TF2PlayerCapability.get((EntityPlayer)event.getEntityPlayer()).wearablesAttrib[i] = modifiers;
            }
        } else {
            for (i = 0; i < 2; ++i) {
                newInv.func_70299_a(i, oldInv.func_70301_a(i));
            }
            newInv.func_70299_a(4, oldInv.func_70301_a(4));
            for (i = 5; i < 8; ++i) {
                newInv.func_70299_a(i, oldInv.func_70301_a(i));
            }
        }
        WeaponsCapability cap = WeaponsCapability.get((Entity)event.getEntityPlayer());
        cap.forcedClass = WeaponsCapability.get((Entity)event.getOriginal()).forcedClass;
        ((ItemToken)TF2weapons.itemToken).updateAttributes(cap.forcedClass ? new ItemStack(TF2weapons.itemToken, 1, cap.getUsedToken()) : newInv.func_70301_a(4), (EntityLivingBase)event.getEntityPlayer());
        cap.ticksTotal = WeaponsCapability.get((Entity)event.getOriginal()).ticksTotal += 1000000L;
        for (Map.Entry<Class<? extends Entity>, Short> entry : ((TF2PlayerCapability)event.getOriginal().getCapability(TF2weapons.PLAYER_CAP, null)).highestBossLevel.entrySet()) {
            ((TF2PlayerCapability)event.getEntityPlayer().getCapability(TF2weapons.PLAYER_CAP, null)).highestBossLevel.put(entry.getKey(), entry.getValue());
        }
        ((TF2PlayerCapability)event.getEntityPlayer().getCapability(TF2weapons.PLAYER_CAP, null)).udpServerId = ((TF2PlayerCapability)event.getOriginal().getCapability(TF2weapons.PLAYER_CAP, null)).udpServerId;
        if (event.getEntityPlayer() instanceof EntityPlayerMP && TF2weapons.udpServer != null) {
            TF2weapons.udpServer.playerList.put(((TF2PlayerCapability)event.getOriginal().getCapability(TF2weapons.PLAYER_CAP, null)).udpServerId, (EntityPlayerMP)event.getEntityPlayer());
        }
        ((TF2PlayerCapability)event.getEntityPlayer().getCapability(TF2weapons.PLAYER_CAP, null)).contracts = ((TF2PlayerCapability)event.getOriginal().getCapability(TF2weapons.PLAYER_CAP, null)).contracts;
        ((TF2PlayerCapability)event.getEntityPlayer().getCapability(TF2weapons.PLAYER_CAP, null)).newContracts = ((TF2PlayerCapability)event.getOriginal().getCapability(TF2weapons.PLAYER_CAP, null)).newContracts;
        ((TF2PlayerCapability)event.getEntityPlayer().getCapability(TF2weapons.PLAYER_CAP, null)).nextContractDay = ((TF2PlayerCapability)event.getOriginal().getCapability(TF2weapons.PLAYER_CAP, null)).nextContractDay;
        if (event.getEntityPlayer() != null && event.getEntityPlayer() instanceof EntityPlayerMP) {
            ((TF2PlayerCapability)event.getEntityPlayer().getCapability(TF2weapons.PLAYER_CAP, null)).sendContractsNextTick = true;
        }
    }

    @SubscribeEvent
    public void uber(LivingHurtEvent event) {
        if (event.isCanceled() || event.getAmount() <= 0.0f) {
            return;
        }
        EntityLivingBase attacker = null;
        EntityLivingBase target = event.getEntityLiving();
        if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            attacker = (EntityLivingBase)event.getSource().func_76346_g();
        }
        if (target.func_70660_b(TF2weapons.crit) != null) {
            event.setAmount(event.getAmount() * 1.1f);
        }
        if (!event.getSource().func_151517_h() && !event.getSource().func_76357_e()) {
            ItemStack backpack;
            if (target.hasCapability(TF2weapons.WEAPONS_CAP, null)) {
                ItemStack watch;
                if (attacker != null) {
                    WeaponsCapability.get((Entity)target).lastAttacked = attacker;
                }
                if (WeaponsCapability.get((Entity)target).getUsedToken() == 2 && event.getSource() == DamageSource.field_76370_b) {
                    event.setCanceled(true);
                    target.func_70066_B();
                }
                if (WeaponsCapability.get((Entity)target).isInvisible()) {
                    if (TF2Attribute.getModifier("Weapon Mode", (ItemStack)ItemCloak.searchForWatches(target).func_76340_b(), 0.0f, target) == 1.0f) {
                        event.setAmount(event.getAmount() * 0.5f);
                    } else {
                        event.setAmount(event.getAmount() * 0.8f);
                    }
                }
                if (WeaponsCapability.get((Entity)target).isFeign() && !(watch = ItemCloak.getFeignDeathWatch(target)).func_190926_b()) {
                    InventoryPlayer inv = null;
                    if (target instanceof EntityPlayer) {
                        inv = new InventoryPlayer((EntityPlayer)target);
                        inv.func_70455_b(((EntityPlayer)target).field_71071_by);
                    }
                    event.setAmount(event.getAmount() * 0.15f);
                    target.func_110142_aN().func_94547_a(event.getSource(), target.func_110143_aJ(), event.getAmount());
                    if (TF2ConfigVars.deadRingerTrigger) {
                        target.func_70645_a(event.getSource());
                    }
                    TF2Util.sendTracking(new TF2Message.ActionMessage(24, target), (Entity)target);
                    target.func_70066_B();
                    for (EntityLiving living2 : target.field_70170_p.func_175647_a(EntityLiving.class, target.func_174813_aQ().func_186662_g(80.0), living -> living.func_70638_az() == living)) {
                        living2.func_70624_b(null);
                    }
                    if (target instanceof EntityPlayer) {
                        ((EntityPlayer)target).field_71071_by.func_70455_b(inv);
                    }
                    ((ItemCloak)watch.func_77973_b()).setCloak(true, watch, target, target.func_130014_f_());
                    WeaponsCapability.get((Entity)target).invisTicks = 20;
                    target.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 60, 1, false, false));
                    WeaponsCapability.get((Entity)target).setFeign(false);
                    target.func_174810_b(true);
                }
                if (((WeaponsCapability)target.getCapability(TF2weapons.WEAPONS_CAP, null)).isExpJump()) {
                    if (event.getAmount() > 1.0f && event.getSource() == DamageSource.field_76379_h) {
                        event.setAmount((float)Math.sqrt(event.getAmount()));
                        WeaponsCapability.get(event.getEntity()).setExpJump(false);
                    }
                    target.field_70133_I = false;
                    target.func_70690_d(new PotionEffect(TF2weapons.noKnockback, 1));
                }
            }
            if (!(backpack = ItemBackpack.getBackpack(target)).func_190926_b()) {
                event.setAmount(TF2EventsCommon.getDamageReductionFromItem(backpack, event.getSource(), target, event.getAmount()));
            }
            for (ItemStack stack : target.func_184209_aF()) {
                if (stack.func_190926_b() || stack.func_77973_b() instanceof ItemBackpack) continue;
                event.setAmount(TF2EventsCommon.getDamageReductionFromItem(stack, event.getSource(), target, event.getAmount()));
            }
            if (target.func_70660_b(TF2weapons.backup) != null) {
                if (event.getSource().func_76364_f() instanceof EntityArrow) {
                    event.setAmount(Math.min(event.getAmount(), 8.0f));
                }
                if ((event.getSource().field_76373_n.equals("mob") || event.getSource().field_76373_n.equals("player")) && attacker != null && attacker.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e) != null && attacker.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111127_a(UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF")) != null) {
                    event.setAmount((float)Math.min((double)event.getAmount(), 1.0 + attacker.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111127_a(UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF")).func_111164_d()));
                }
                event.setAmount(event.getAmount() * 0.65f);
            }
            if (target instanceof EntityTF2Character && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() == event.getEntity()) {
                event.setAmount(event.getAmount() * 0.35f);
            }
        }
        int crit = 0;
        if (attacker != null && attacker.hasCapability(TF2weapons.WEAPONS_CAP, null)) {
            WeaponsCapability.get((Entity)attacker).lastAttacked = target;
            if (attacker.func_70660_b(TF2weapons.it) != null && (event.getSource().field_76373_n.equals("mob") || event.getSource().field_76373_n.equals("player"))) {
                attacker.func_184589_d(TF2weapons.it);
                ((WeaponsCapability)attacker.getCapability(TF2weapons.WEAPONS_CAP, null)).itProtection = 15;
                target.func_70690_d(new PotionEffect(TF2weapons.it, 600));
            }
            if (attacker.func_70660_b(TF2weapons.bonk) != null) {
                event.setCanceled(true);
            }
            ItemStack stack = attacker == event.getSource().func_76364_f() ? attacker.func_184614_ca() : ItemStack.field_190927_a;
            crit = TF2Util.calculateCritPre(stack, attacker);
            ItemStack backpack = ItemBackpack.getBackpack(attacker);
            if (backpack.func_77973_b() instanceof ItemSoldierBackpack && !WeaponsCapability.get((Entity)attacker).isRageActive(WeaponsCapability.RageType.BANNER)) {
                ((ItemSoldierBackpack)backpack.func_77973_b()).addRage(backpack, event.getAmount(), target, attacker);
            }
            if (attacker.func_70660_b(TF2weapons.conch) != null) {
                attacker.func_70691_i(0.35f * TF2Util.getDamageReduction(event.getSource(), target, event.getAmount()));
            }
            if (target.func_70660_b(TF2weapons.madmilk) != null) {
                attacker.func_70691_i(0.6f * TF2Util.getDamageReduction(event.getSource(), target, event.getAmount()));
            }
        }
        if (!(event.getSource() instanceof TF2DamageSource)) {
            if (event.getSource().func_76364_f() != null && event.getSource().func_76364_f().getEntityData().func_74767_n("CritHeadshot")) {
                crit = 2;
            }
            if ((crit = TF2Util.calculateCritPost((Entity)target, attacker, crit, ItemStack.field_190927_a)) == 1) {
                event.setAmount(event.getAmount() * 1.35f);
                TF2Util.playSound((Entity)target, TF2Sounds.MISC_MINI_CRIT, 1.5f, 1.2f / (target.func_70681_au().nextFloat() * 0.2f + 0.9f));
            } else if (crit == 2) {
                event.setAmount(event.getAmount() * 2.2f);
                TF2Util.playSound((Entity)target, TF2Sounds.MISC_CRIT, 1.5f, 1.2f / (target.func_70681_au().nextFloat() * 0.2f + 0.9f));
            }
        }
        if (!target.field_70170_p.field_72995_K && ((Float)target.func_184212_Q().func_187225_a(ENTITY_OVERHEAL)).floatValue() > 0.0f) {
            target.func_184212_Q().func_187227_b(ENTITY_OVERHEAL, (Object)Float.valueOf(target.func_110139_bj()));
            if (((Float)target.func_184212_Q().func_187225_a(ENTITY_OVERHEAL)).floatValue() <= 0.0f) {
                target.func_184212_Q().func_187227_b(ENTITY_OVERHEAL, (Object)Float.valueOf(-1.0f));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void reduceDamageArmor(LivingHurtEvent event) {
        if (event.getSource() instanceof TF2DamageSource && event.getAmount() > 0.0f) {
            float orig;
            EntityLivingBase living = event.getEntityLiving();
            float protect = orig = CombatRules.func_189427_a((float)event.getAmount(), (float)living.func_70658_aO(), (float)((float)living.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e())) / event.getAmount();
            ItemStack weapon = ((TF2DamageSource)event.getSource()).getWeapon();
            if (!weapon.func_190926_b() && weapon.func_77973_b() instanceof ItemWeapon) {
                float damage = ((ItemWeapon)weapon.func_77973_b()).getDamageForArmor(weapon, (EntityLivingBase)event.getSource().func_76346_g(), (Entity)living);
                protect = CombatRules.func_189427_a((float)damage, (float)living.func_70658_aO(), (float)((float)living.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e())) / damage;
            }
            if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g().hasCapability(TF2weapons.WEAPONS_CAP, null) && ((WeaponsCapability)event.getSource().func_76346_g().getCapability(TF2weapons.WEAPONS_CAP, null)).focusShotRemaining > 0) {
                float focus = TF2Attribute.getModifier("Focus", ((TF2DamageSource)event.getSource()).getWeapon(), 0.0f, null);
                float hpDamage = event.getAmount() + Math.min(35.0f * focus, event.getAmount() * (living.func_110138_aP() - living.func_110143_aJ()) / living.func_110138_aP() * focus * 0.6f);
                event.setAmount(hpDamage);
            }
            TF2Util.addModifierSafe(living, SharedMonsterAttributes.field_188791_g, new AttributeModifier(REMOVE_ARMOR, "remove_arm", (double)(-event.getEntityLiving().func_70658_aO()), 0), false);
            TF2Util.addModifierSafe(living, SharedMonsterAttributes.field_189429_h, new AttributeModifier(REMOVE_ARMOR, "remove_armt", -event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e(), 0), false);
            event.setAmount(event.getAmount() * protect);
            if (WeaponsCapability.get((Entity)event.getEntityLiving()) != null) {
                WeaponsCapability cap = WeaponsCapability.get((Entity)event.getEntityLiving());
                float armorDamage = event.getAmount();
                cap.damageArmorMin = (armorDamage += cap.damageArmorMin) % 4.0f;
                if ((armorDamage /= 4.0f) >= 1.0f) {
                    for (ItemStack armor : event.getEntityLiving().func_184193_aE()) {
                        if (!(armor.func_77973_b() instanceof ItemArmor)) continue;
                        armor.func_77972_a((int)armorDamage, event.getEntityLiving());
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void reduceDamageArmor(LivingDamageEvent event) {
        if (event.getSource() instanceof TF2DamageSource) {
            event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_188791_g).func_188479_b(REMOVE_ARMOR);
            event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_189429_h).func_188479_b(REMOVE_ARMOR);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void healFromAttack(LivingDamageEvent event) {
        EntityLivingBase attacker = null;
        if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
            attacker = (EntityLivingBase)event.getSource().func_76346_g();
        }
        EntityLivingBase target = event.getEntityLiving();
        if (attacker != null) {
            if (attacker.func_70660_b(TF2weapons.conch) != null) {
                attacker.func_70691_i(TF2Util.getReducedHealing(attacker, target, 0.35f * event.getAmount()));
            }
            if (target.func_70660_b(TF2weapons.madmilk) != null) {
                attacker.func_70691_i(TF2Util.getReducedHealing(attacker, target, 0.6f * event.getAmount()));
            }
        }
    }

    public static float getDamageReductionFromItem(ItemStack stack, DamageSource source, EntityLivingBase target, float damage) {
        float mult;
        float initialDamage = damage;
        if (TF2Attribute.getModifier("Breakable", stack, 0.0f, target) != 0.0f && stack.func_77952_i() == stack.func_77958_k()) {
            return damage;
        }
        damage = TF2Attribute.getModifier("Damage Resist", stack, damage, target);
        if (source.func_94541_c()) {
            damage = TF2Attribute.getModifier("Explosion Resist", stack, damage, target);
        }
        if (source.func_76347_k()) {
            damage = TF2Attribute.getModifier("Fire Resist", stack, damage, target);
        }
        if (target.func_184614_ca() == stack) {
            if (source.func_76352_a() || source.func_94541_c() || source instanceof EntityDamageSourceIndirect) {
                damage = TF2Attribute.getModifier("Ranged Resist", stack, damage, target);
            } else if (!source.func_76352_a() && !source.func_94541_c() && !source.func_82725_o() && source instanceof EntityDamageSource) {
                damage = TF2Attribute.getModifier("Melee Resist", stack, damage, target);
            }
        }
        if (source == DamageSource.field_76379_h && stack.func_77973_b() instanceof ItemJetpack && stack.func_77978_p().func_74767_n("Active")) {
            damage *= 0.4f;
        }
        if (initialDamage != damage && (mult = TF2Attribute.getModifier("Breakable", stack, 0.0f, target)) != 0.0f) {
            stack.func_77972_a(MathHelper.func_76123_f((float)((initialDamage - damage) * mult)), target);
            if (stack.func_190926_b()) {
                stack.func_190920_e(1);
                stack.func_77964_b(stack.func_77958_k());
            }
        }
        return damage;
    }

    @SubscribeEvent
    public void stopBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer().func_184586_b(EnumHand.MAIN_HAND) != null && event.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemUsable && !TF2PlayerCapability.get((EntityPlayer)event.getPlayer()).breakBlocks) {
            event.setCanceled(true);
        }
        if (event.getPlayer().func_70660_b(TF2weapons.bonk) != null) {
            event.setCanceled(true);
        }
        if (((WeaponsCapability)event.getPlayer().getCapability(TF2weapons.WEAPONS_CAP, null)).invisTicks > 0) {
            event.setCanceled(true);
        }
        if (event.getPlayer().func_70660_b(TF2weapons.stun) != null) {
            event.setCanceled(true);
        }
        WeaponsCapability.get((Entity)event.getPlayer()).setDisguised(false);
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityItem && ((EntityItem)event.getEntity()).func_92059_d().func_77973_b() instanceof IBackpackItem) {
            event.getEntity().func_70106_y();
            event.setCanceled(true);
        }
        if (event.getEntity() instanceof EntityCreature && TF2Util.isHostile((EntityLivingBase)event.getEntity()) && !(event.getEntity() instanceof IEntityTF2) && event.getEntity().func_184222_aU()) {
            if (TF2ConfigVars.targetSentries) {
                ((EntityCreature)event.getEntity()).field_70715_bh.func_75776_a(535, (EntityAIBase)new EntityAINearestAttackableTarget<EntitySentry>((EntityCreature)event.getEntity(), EntitySentry.class, 10, true, false, sentry -> sentry.func_184753_b() != null){

                    protected double func_111175_f() {
                        return super.func_111175_f() * (double)0.45f;
                    }
                });
            }
            if (TF2ConfigVars.attackMobs) {
                ((EntityCreature)event.getEntity()).field_70715_bh.func_75776_a(536, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)event.getEntity(), EntityTF2Character.class, 10, true, false, target -> !target.isRobot()));
            }
        }
        if (event.getEntity() instanceof EntityPlayer) {
            if (event.getEntity().field_70170_p.field_72995_K) {
                if (event.getEntity() == ClientProxy.getLocalPlayer()) {
                    TF2weapons.network.sendToServer(new TF2Message.InitClientMessage(TF2weapons.conf));
                }
                TF2weapons.network.sendToServer(new TF2Message.ActionMessage(99, (EntityLivingBase)event.getEntity()));
            }
            if (event.getEntity().field_70170_p != null && !event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
                player.field_71069_bz.func_75132_a((IContainerListener)new TF2ContainerListener(player));
            }
        }
    }

    @SubscribeEvent
    public void entityConstructing(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            event.getEntity().func_184212_Q().func_187214_a(ENTITY_OVERHEAL, (Object)Float.valueOf(0.0f));
        }
        if (event.getEntity() instanceof EntityPlayer && TF2UdpClient.instance != null) {
            TF2UdpClient.instance.shutdown();
            TF2UdpClient.instance = null;
        }
    }

    @SubscribeEvent
    public void cleanPlayer(PlayerEvent.PlayerLoggedOutEvent event) {
        if (TF2weapons.udpServer != null) {
            TF2weapons.udpServer.playerList.remove(((TF2PlayerCapability)event.player.getCapability(TF2weapons.PLAYER_CAP, null)).udpServerId);
        }
    }

    @SubscribeEvent
    public void loadPlayer(PlayerEvent.PlayerLoggedInEvent event) {
        if (TF2weapons.server.func_71262_S() || Minecraft.func_71410_x().func_71401_C().func_71344_c()) {
            TF2weapons.network.sendTo(new TF2Message.WeaponDataMessage(TF2weapons.itemDataCompressed), (EntityPlayerMP)event.player);
        }
        int i = 0;
        for (Contract contract : ((TF2PlayerCapability)event.player.getCapability(TF2weapons.PLAYER_CAP, null)).contracts) {
            TF2weapons.network.sendTo(new TF2Message.ContractMessage(i, contract), (EntityPlayerMP)event.player);
            ++i;
        }
        int udpport = -1;
        if (TF2weapons.udpServer != null) {
            ((TF2PlayerCapability)event.player.getCapability(TF2weapons.PLAYER_CAP, null)).udpServerId = TF2UdpServer.nextPlayerId;
            TF2weapons.udpServer.playerList.put(TF2UdpServer.nextPlayerId, (EntityPlayerMP)event.player);
            udpport = TF2weapons.udpServer.port;
            TF2UdpServer.nextPlayerId = (short)(TF2UdpServer.nextPlayerId + 1);
        }
        TF2weapons.network.sendTo(new TF2Message.InitMessage(udpport, TF2UdpServer.nextPlayerId, TF2ConfigVars.buildingsUseEnergy), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void stopUsing(PlayerInteractEvent.RightClickBlock event) {
        if (!TF2Util.canInteract(event.getEntityLiving())) {
            event.setCanceled(true);
        }
        event.getEntityPlayer().func_184589_d(TF2weapons.charging);
    }

    @SubscribeEvent
    public void stopUsing(PlayerInteractEvent.RightClickItem event) {
        ItemStack item = event.getEntityPlayer().func_184586_b(event.getHand());
        if (!(TF2Util.canInteract(event.getEntityLiving()) || item.func_77973_b() instanceof ItemDisguiseKit || item.func_77973_b() instanceof ItemCloak && (item.func_77978_p().func_74767_n("Active") || WeaponsCapability.get(event.getEntity()).isFeign() && TF2Attribute.getModifier("Weapon Mode", item, 0.0f, event.getEntityLiving()) == 1.0f))) {
            event.setCanceled(true);
            return;
        }
        if (!(item.func_77973_b() instanceof ItemFood || item.func_77973_b() instanceof ItemCloak || item.func_77973_b() instanceof ItemDisguiseKit)) {
            WeaponsCapability.get(event.getEntity()).setDisguised(false);
        }
        event.getEntityPlayer().func_184589_d(TF2weapons.charging);
    }

    @SubscribeEvent
    public void stopUsing(PlayerInteractEvent.EntityInteract event) {
        if (!TF2Util.canInteract(event.getEntityLiving())) {
            event.setCanceled(true);
            return;
        }
        if (!(event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() instanceof ItemFood)) {
            WeaponsCapability.get(event.getEntity()).setDisguised(false);
        }
        event.getEntityPlayer().func_184589_d(TF2weapons.charging);
    }

    @SubscribeEvent
    public void stopUsing(PlayerInteractEvent.LeftClickBlock event) {
        if (!TF2Util.canInteract(event.getEntityLiving())) {
            event.setCanceled(true);
        }
        event.getEntityPlayer().func_184589_d(TF2weapons.charging);
    }

    @SubscribeEvent
    public void stopJump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living.func_70660_b(TF2weapons.stun) != null && living.func_70660_b(TF2weapons.bombmrs) == null || living.func_70660_b(TF2weapons.charging) != null || living.func_184614_ca() != null && (living.func_184614_ca().func_77973_b() instanceof ItemMinigun || living.func_184614_ca().func_77973_b() instanceof ItemHuntsman) && living.hasCapability(TF2weapons.WEAPONS_CAP, null) && ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).chargeTicks > 0) {
            living.field_70160_al = false;
            living.field_70181_x -= 0.5;
            if (living.func_70051_ag()) {
                float f = living.field_70177_z * ((float)Math.PI / 180);
                living.field_70159_w += (double)(MathHelper.func_76126_a((float)f) * 0.2f);
                living.field_70179_y -= (double)(MathHelper.func_76134_b((float)f) * 0.2f);
            }
        }
        if (living.func_184614_ca().func_77973_b() instanceof ItemSniperRifle && living.hasCapability(TF2weapons.WEAPONS_CAP, null)) {
            ((ItemSniperRifle)living.func_184614_ca().func_77973_b()).disableZoom(living.func_184614_ca(), living);
        }
    }

    @SubscribeEvent
    public void livingUpdate(LivingEvent.LivingUpdateEvent event) {
        event.getEntity().func_130014_f_().field_72984_F.func_76320_a("TF2TickEvent");
        EntityLivingBase living = event.getEntityLiving();
        if (living.hasCapability(TF2weapons.INVENTORY_CAP, null)) {
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = ((InventoryWearables)((Object)living.getCapability(TF2weapons.INVENTORY_CAP, null))).func_70301_a(i);
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemWearable) {
                    ((ItemWearable)stack.func_77973_b()).onUpdateWearing(stack, living.field_70170_p, living);
                    continue;
                }
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBackpack)) continue;
                ((ItemBackpack)stack.func_77973_b()).onArmorTickAny(living.field_70170_p, living, stack);
            }
            if (!living.field_70170_p.field_72995_K && living.field_70173_aa % 2 == 0) {
                ((InventoryWearables)((Object)living.getCapability(TF2weapons.INVENTORY_CAP, null))).updateSlots();
            }
        }
        if (living.hasCapability(TF2weapons.PLAYER_CAP, null)) {
            ((TF2PlayerCapability)living.getCapability(TF2weapons.PLAYER_CAP, null)).tick();
        }
        if (living.func_70089_S() && living.hasCapability(TF2weapons.WEAPONS_CAP, null)) {
            WeaponsCapability cap = (WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null);
            cap.tick();
        }
        if (living.func_70643_av() != null && living.func_70643_av().hasCapability(TF2weapons.WEAPONS_CAP, null) && ((WeaponsCapability)living.func_70643_av().getCapability(TF2weapons.WEAPONS_CAP, null)).invisTicks >= 45) {
            living.func_70604_c(null);
        }
        if (living instanceof EntityLiving && ((EntityLiving)living).func_70638_az() != null) {
            if (living.getEntityData().func_74764_b("TF2AM") && living.func_130014_f_().func_82737_E() - (long)living.getEntityData().func_74762_e("TF2AM") > 360L) {
                living.getEntityData().func_82580_o("TF2AM");
                living.func_110148_a(SharedMonsterAttributes.field_111265_b).func_188479_b(TF2Util.FOLLOW_MODIFIER);
            } else if (((EntityLiving)living).func_70638_az().hasCapability(TF2weapons.WEAPONS_CAP, null) && ((WeaponsCapability)((EntityLiving)living).func_70638_az().getCapability(TF2weapons.WEAPONS_CAP, null)).invisTicks >= 45) {
                ((EntityLiving)living).func_70624_b(null);
            }
        }
        if (((Float)living.func_184212_Q().func_187225_a(ENTITY_OVERHEAL)).floatValue() == -1.0f) {
            living.func_184212_Q().func_187227_b(ENTITY_OVERHEAL, (Object)Float.valueOf(0.0f));
            living.func_110149_m(0.0f);
        }
        if (((Float)living.func_184212_Q().func_187225_a(ENTITY_OVERHEAL)).floatValue() > 0.0f) {
            if (living.field_70170_p.field_72995_K) {
                living.func_110149_m(((Float)living.func_184212_Q().func_187225_a(ENTITY_OVERHEAL)).floatValue());
            }
            living.func_110149_m(living.func_110139_bj() - living.func_110138_aP() * 0.001666f);
            if (!living.field_70170_p.field_72995_K && living.field_70173_aa % 4 == 0) {
                if (living.func_110139_bj() <= 0.0f) {
                    living.func_184212_Q().func_187227_b(ENTITY_OVERHEAL, (Object)Float.valueOf(-1.0f));
                } else {
                    living.func_184212_Q().func_187227_b(ENTITY_OVERHEAL, (Object)Float.valueOf(living.func_110139_bj()));
                }
            }
        }
        living.field_70170_p.field_72984_F.func_76319_b();
    }

    @SubscribeEvent
    public void loadWorld(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            sentryView = new EntitySentry(event.getWorld());
            sentryView.func_70645_a(DamageSource.field_76377_j);
            dispenserView = new EntityDispenser(event.getWorld());
            dispenserView.func_70645_a(DamageSource.field_76377_j);
            teleporterAView = new EntityTeleporter(event.getWorld());
            teleporterAView.func_70645_a(DamageSource.field_76377_j);
            teleporterBView = new EntityTeleporter(event.getWorld());
            teleporterBView.func_70645_a(DamageSource.field_76377_j);
        }
        if (TF2weapons.dummyEnt == null) {
            TF2weapons.dummyEnt = new EntityDummy(event.getWorld());
        }
        if (!event.getWorld().func_82736_K().func_82765_e("doTF2AI")) {
            event.getWorld().func_82736_K().func_180262_a("doTF2AI", "true", GameRules.ValueType.BOOLEAN_VALUE);
        }
        if (!event.getWorld().field_72995_K && event.getWorld().func_96441_U().func_96508_e("RED") == null) {
            ScorePlayerTeam teamRed = event.getWorld().func_96441_U().func_96527_f("RED");
            ScorePlayerTeam teamBlu = event.getWorld().func_96441_U().func_96527_f("BLU");
            teamRed.func_98300_b(true);
            teamRed.func_96660_a(false);
            teamBlu.func_98300_b(true);
            teamBlu.func_96660_a(false);
            teamRed.func_96666_b(TextFormatting.RED.toString());
            teamBlu.func_96666_b(TextFormatting.BLUE.toString());
            teamRed.func_178774_a(TextFormatting.RED);
            teamBlu.func_178774_a(TextFormatting.BLUE);
            event.getWorld().func_96441_U().func_96538_b(teamRed);
            event.getWorld().func_96441_U().func_96538_b(teamBlu);
        }
        if (!event.getWorld().field_72995_K && event.getWorld().func_96441_U().func_96508_e("TF2Bosses") == null) {
            ScorePlayerTeam teamBosses = event.getWorld().func_96441_U().func_96527_f("TF2Bosses");
            teamBosses.func_98300_b(true);
            teamBosses.func_96660_a(false);
            teamBosses.func_96666_b(TextFormatting.DARK_PURPLE.toString());
            teamBosses.func_178774_a(TextFormatting.DARK_PURPLE);
            event.getWorld().func_96441_U().func_96538_b(teamBosses);
        }
        if (!event.getWorld().field_72995_K && event.getWorld().func_96441_U().func_96508_e("Robots") == null) {
            ScorePlayerTeam teamRobots = event.getWorld().func_96441_U().func_96527_f("Robots");
            teamRobots.func_98300_b(true);
            teamRobots.func_96660_a(false);
            teamRobots.func_96666_b(TextFormatting.AQUA.toString());
            teamRobots.func_178774_a(TextFormatting.AQUA);
            event.getWorld().func_96441_U().func_96538_b(teamRobots);
        }
        if (!event.getWorld().field_72995_K && event.getWorld().func_96441_U().func_96508_e("RED").func_178775_l() == TextFormatting.RESET) {
            event.getWorld().func_96441_U().func_96508_e("RED").func_178774_a(TextFormatting.RED);
            event.getWorld().func_96441_U().func_96508_e("BLU").func_178774_a(TextFormatting.BLUE);
        }
    }

    @SubscribeEvent
    public void unloadWorld(WorldEvent.Unload event) {
        if (TF2weapons.dummyEnt != null && TF2weapons.dummyEnt.field_70170_p == event.getWorld()) {
            TF2weapons.dummyEnt = null;
        }
        if (event.getWorld().field_72995_K && TF2EventsCommon.sentryView.field_70170_p == event.getWorld()) {
            sentryView = null;
            dispenserView = null;
            teleporterAView = null;
            teleporterBView = null;
        }
    }

    @SubscribeEvent
    public void medicSpawn(LivingSpawnEvent.SpecialSpawn event) {
        float chance = 0.0f;
        if (event.getEntity() instanceof EntityHeavy) {
            chance = 0.16f;
        } else if (event.getEntity() instanceof EntitySoldier) {
            chance = 0.08f;
        } else if (event.getEntity() instanceof EntityDemoman) {
            chance = 0.07f;
        } else if (event.getEntity() instanceof EntityPyro) {
            chance = 0.06f;
        } else if (event.getEntity() instanceof EntityScout) {
            chance = 0.03f;
        } else {
            return;
        }
        chance *= TF2ConfigVars.medicChance;
        if (event.getWorld().field_73012_v.nextFloat() < (float)event.getWorld().func_175659_aa().func_151525_a() * chance) {
            ((EntityTF2Character)event.getEntity()).spawnMedic = true;
        }
    }

    @SubscribeEvent
    public void attachCapabilityEnt(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("rafradek_tf2_weapons", "weaponcapability"), (ICapabilityProvider)new WeaponsCapability((EntityLivingBase)event.getObject()));
            if (!((Entity)event.getObject()).hasCapability(TF2weapons.INVENTORY_CAP, null)) {
                InventoryWearables inv = new InventoryWearables((EntityLivingBase)((EntityPlayer)event.getObject()));
                event.addCapability(new ResourceLocation("rafradek_tf2_weapons", "wearablescapability"), (ICapabilityProvider)inv);
            }
            event.addCapability(new ResourceLocation("rafradek_tf2_weapons", "playercapability"), (ICapabilityProvider)new TF2PlayerCapability((EntityPlayer)event.getObject()));
        }
    }

    @SubscribeEvent
    public void attachCapabilityWorld(AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("rafradek_tf2_weapons", "tf2worldcapability"), (ICapabilityProvider)new TF2WorldStorage((World)event.getObject()));
    }

    @SubscribeEvent
    public void placeBanner(BlockEvent.PlaceEvent event) {
        List<BannerPattern> patterns;
        TileEntity banner = event.getWorld().func_175625_s(event.getBlockSnapshot().getPos());
        if (banner != null && banner instanceof TileEntityBanner && ((patterns = TF2EventsCommon.getPatterns((TileEntityBanner)banner)).contains(TF2weapons.redPattern) || patterns.contains(TF2weapons.bluPattern) || patterns.contains(TF2weapons.neutralPattern))) {
            ((TF2WorldStorage)event.getWorld().getCapability(TF2weapons.WORLD_CAP, null)).banners.add(event.getPos());
        }
    }

    @SubscribeEvent
    public void removeBanner(BlockEvent.BreakEvent event) {
        TileEntity banner = event.getWorld().func_175625_s(event.getPos());
        if (banner != null && banner instanceof TileEntityBanner && TF2EventsCommon.getPatterns((TileEntityBanner)banner).contains(TF2weapons.redPattern)) {
            ((TF2WorldStorage)event.getWorld().getCapability(TF2weapons.WORLD_CAP, null)).banners.remove(event.getPos());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void craftItem(PlayerEvent.ItemCraftedEvent event) {
        ItemStack withPattern = ItemStack.field_190927_a;
        ItemStack noPattern = ItemStack.field_190927_a;
        for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
            ItemStack stack = event.craftMatrix.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBanner)) continue;
            if (TileEntityBanner.func_175113_c((ItemStack)stack) > 0) {
                withPattern = stack;
            } else {
                noPattern = stack;
            }
            if (withPattern.func_190926_b() || noPattern.func_190926_b()) continue;
            withPattern.func_190918_g(1);
        }
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!event.getEntity().field_70170_p.field_72995_K && event.getSource() != null && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            ItemStack stack = ItemStack.field_190927_a;
            final EntityLivingBase living = (EntityLivingBase)event.getSource().func_76346_g();
            boolean isEnemy = TF2Util.isEnemy(living, event.getEntityLiving());
            stack = event.getSource() instanceof TF2DamageSource ? ((TF2DamageSource)event.getSource()).getWeaponOrig() : living.func_184614_ca();
            if (living instanceof EntityPlayerMP && isEnemy) {
                EntityPlayerMP player = (EntityPlayerMP)living;
                TF2PlayerCapability plcap = (TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null);
                if (event.getEntity() instanceof EntityTF2Character && !((EntityTF2Character)event.getEntity()).isRobot()) {
                    if ((plcap.fastKillTimer += 120) > 360) {
                        plcap.fastKillTimer = 0;
                        plcap.completeObjective(Contract.Objective.KILLS, stack);
                    }
                    plcap.completeObjective(Contract.Objective.KILL, stack);
                    if (event.getSource() instanceof TF2DamageSource && ((TF2DamageSource)event.getSource()).hasAttackFlag(2)) {
                        plcap.completeObjective(Contract.Objective.HEADSHOT, stack);
                    }
                    if (event.getSource() instanceof TF2DamageSource && ((TF2DamageSource)event.getSource()).hasAttackFlag(1)) {
                        plcap.completeObjective(Contract.Objective.BACKSTAB, stack);
                    }
                    if (event.getSource().func_76364_f() instanceof EntityProjectileBase && ((EntityProjectileBase)event.getSource().func_76364_f()).reflected) {
                        plcap.completeObjective(Contract.Objective.KILL_REFLECTED, stack);
                    }
                    if (stack.func_77973_b() instanceof ItemStickyLauncher) {
                        plcap.completeObjective(Contract.Objective.STICKY_KILL, stack);
                    }
                    if (stack.func_77973_b() instanceof ItemMeleeWeapon) {
                        plcap.completeObjective(Contract.Objective.KILL_MELEE, stack);
                    }
                    if (((WeaponsCapability)player.getCapability(TF2weapons.WEAPONS_CAP, null)).isExpJump()) {
                        plcap.completeObjective(Contract.Objective.KILL_BLAST, stack);
                    }
                    if (((WeaponsCapability)player.getCapability(TF2weapons.WEAPONS_CAP, null)).airJumps > 0) {
                        plcap.completeObjective(Contract.Objective.KILL_DOUBLE, stack);
                    }
                    if (event.getEntity() instanceof EntityScout) {
                        plcap.completeObjective(Contract.Objective.KILL_SCOUT, stack);
                    } else if (event.getEntity() instanceof EntityPyro) {
                        plcap.completeObjective(Contract.Objective.KILL_PYRO, stack);
                    } else if (event.getEntity() instanceof EntitySoldier) {
                        plcap.completeObjective(Contract.Objective.KILL_SOLDIER, stack);
                    } else if (event.getEntity() instanceof EntityHeavy) {
                        plcap.completeObjective(Contract.Objective.KILL_HEAVY, stack);
                    } else if (event.getEntity() instanceof EntityDemoman) {
                        plcap.completeObjective(Contract.Objective.KILL_DEMOMAN, stack);
                    } else if (event.getEntity() instanceof EntityEngineer) {
                        plcap.completeObjective(Contract.Objective.KILL_ENGINEER, stack);
                    } else if (event.getEntity() instanceof EntityMedic) {
                        plcap.completeObjective(Contract.Objective.KILL_MEDIC, stack);
                    } else if (event.getEntity() instanceof EntitySpy) {
                        plcap.completeObjective(Contract.Objective.KILL_SPY, stack);
                    } else if (event.getEntity() instanceof EntitySniper) {
                        plcap.completeObjective(Contract.Objective.KILL_SNIPER, stack);
                    }
                }
            } else if (living instanceof EntityPlayerMP && event.getEntity() instanceof EntityBuilding && !TF2Util.isOnSameTeam((Entity)living, event.getEntity())) {
                ((TF2PlayerCapability)living.getCapability(TF2weapons.PLAYER_CAP, null)).completeObjective(Contract.Objective.DESTROY_BUILDING, stack);
            }
            if (event.getEntity() instanceof EntitySentry) {
                for (EntityPlayerMP player : living.field_70170_p.func_175647_a(EntityPlayerMP.class, living.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), (Predicate)new Predicate<EntityPlayerMP>(){

                    public boolean apply(EntityPlayerMP input) {
                        return ((WeaponsCapability)input.getCapability(TF2weapons.WEAPONS_CAP, null)).getHealTarget() == living.func_145782_y() && input.func_184614_ca().func_77978_p().func_74767_n("Activated");
                    }
                })) {
                    ((TF2PlayerCapability)player.getCapability(TF2weapons.PLAYER_CAP, null)).completeObjective(Contract.Objective.DESTROY_SENTRY_UBER, stack);
                }
            }
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemWeapon) {
                ItemStack held;
                float toHeal;
                if (!(event.getEntity() instanceof EntityPlayer) && TF2Attribute.getModifier("Silent Kill", stack, 0.0f, null) != 0.0f) {
                    event.getEntity().func_174810_b(true);
                }
                if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("Strange")) {
                    if (!(event.getEntityLiving() instanceof EntityPlayer)) {
                        stack.func_77978_p().func_74768_a("Kills", stack.func_77978_p().func_74762_e("Kills") + 1);
                    } else {
                        stack.func_77978_p().func_74768_a("PlayerKills", stack.func_77978_p().func_74762_e("PlayerKills") + 1);
                    }
                    TF2EventsCommon.onStrangeUpdate(stack, living);
                }
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("StrAtt") && isEnemy) {
                    stack.func_77978_p().func_74768_a("StrKil", stack.func_77978_p().func_74762_e("StrKil") + 1);
                    stack.func_77978_p().func_74772_a("StrCol", WeaponsCapability.get((Entity)living).ticksTotal + (long)ItemKillstreakKit.getCooldown(stack.func_77978_p().func_74771_c("StrLev"), stack.func_77978_p().func_74762_e("StrKil")));
                    stack.func_77978_p().func_74772_a("StrLst", WeaponsCapability.get((Entity)living).ticksTotal);
                    stack.func_77978_p().func_74777_a("StrRed", (short)1);
                    ((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).cached = false;
                }
                if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("Australium") && TF2ConfigVars.australiumStatue) {
                    event.getEntity().field_70170_p.func_72838_d((Entity)new EntityStatue(event.getEntity().field_70170_p, event.getEntityLiving(), false));
                    TF2Util.sendTracking(new TF2Message.ActionMessage(19, event.getEntityLiving()), event.getEntity());
                    event.getEntity().func_184185_a(TF2Sounds.WEAPON_TO_GOLD, 1.5f, 2.0f);
                    if (!(event.getEntity() instanceof EntityPlayer)) {
                        event.getEntity().func_174810_b(true);
                    }
                }
                if (isEnemy && living.hasCapability(TF2weapons.WEAPONS_CAP, null) && TF2Attribute.getModifier("Kill Count", stack, 0.0f, living) != 0.0f) {
                    ((WeaponsCapability)living.getCapability(TF2weapons.WEAPONS_CAP, null)).addHead(stack);
                }
                if ((toHeal = TF2Attribute.getModifier("Health Kill", stack, 0.0f, living)) != 0.0f) {
                    living.func_70691_i(TF2Util.getReducedHealing(living, event.getEntityLiving(), isEnemy ? toHeal : toHeal * 0.35f));
                }
                if (TF2Attribute.getModifier("Crit Kill", stack, 0.0f, living) > 0.0f) {
                    living.func_70690_d(new PotionEffect(TF2weapons.critBoost, (int)TF2Attribute.getModifier("Crit Kill", stack, -1.0f, living) * 20, 1));
                }
                if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntity().field_70170_p.field_72995_K && !(held = event.getEntityLiving().func_184614_ca()).func_190926_b() && held.func_77973_b() instanceof ItemUsable) {
                    ((ItemUsable)held.func_77973_b()).holster((WeaponsCapability)event.getEntityLiving().getCapability(TF2weapons.WEAPONS_CAP, null), held, event.getEntityLiving(), event.getEntityLiving().field_70170_p);
                }
            }
        }
        if (event.getEntityLiving().getEntityData().func_74764_b("Cleavers")) {
            NBTTagList list = event.getEntity().getEntityData().func_150295_c("Cleavers", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                event.getEntityLiving().func_70099_a(new ItemStack(list.func_150305_b(i)), 0.0f);
            }
            event.getEntityLiving().getEntityData().func_82580_o("Cleavers");
        }
    }

    @SubscribeEvent
    public void generateStructures(PopulateChunkEvent.Pre event) {
        if (event.getWorld().field_73011_w.getDimension() == 0 && !TF2ConfigVars.disableGeneration && event.getWorld().func_72912_H().func_76089_r()) {
            ((TF2WorldStorage)event.getWorld().getCapability(TF2weapons.WORLD_CAP, null)).mannCoGenerator.func_186125_a(event.getWorld(), event.getChunkX(), event.getChunkZ(), new ChunkPrimer());
            ((TF2WorldStorage)event.getWorld().getCapability(TF2weapons.WORLD_CAP, null)).mannCoGenerator.func_175794_a(event.getWorld(), event.getRand(), new ChunkPos(event.getChunkX(), event.getChunkZ()));
            ((TF2WorldStorage)event.getWorld().getCapability(TF2weapons.WORLD_CAP, null)).tf2BaseGenerator.func_186125_a(event.getWorld(), event.getChunkX(), event.getChunkZ(), new ChunkPrimer());
            ((TF2WorldStorage)event.getWorld().getCapability(TF2weapons.WORLD_CAP, null)).tf2BaseGenerator.func_175794_a(event.getWorld(), event.getRand(), new ChunkPos(event.getChunkX(), event.getChunkZ()));
        }
    }

    @SubscribeEvent
    public void generateOres(OreGenEvent.Post event) {
        if (event.getWorld().field_73011_w.getDimension() == 0) {
            if (TF2weapons.generateCopper) {
                this.generateOre(TF2weapons.blockCopperOre.func_176223_P(), 7, 9, 32, 80, event.getWorld(), event.getRand(), event.getPos());
                this.generateOre(TF2weapons.blockCopperOre.func_176223_P(), 7, 1, 0, 32, event.getWorld(), event.getRand(), event.getPos());
            }
            if (TF2weapons.generateLead) {
                this.generateOre(TF2weapons.blockLeadOre.func_176223_P(), 5, 7, 24, 74, event.getWorld(), event.getRand(), event.getPos());
                this.generateOre(TF2weapons.blockLeadOre.func_176223_P(), 5, 1, 0, 24, event.getWorld(), event.getRand(), event.getPos());
            }
            if (TF2weapons.generateAustralium) {
                this.generateOre(TF2weapons.blockAustraliumOre.func_176223_P(), 3, 4, 0, 24, event.getWorld(), event.getRand(), event.getPos());
            }
        }
    }

    public void generateOre(IBlockState state, int size, int count, int minY, int maxY, World world, Random random, BlockPos chunkPos) {
        for (int i = 0; i < count; ++i) {
            BlockPos pos = chunkPos.func_177982_a(random.nextInt(16), minY + random.nextInt(maxY - minY), random.nextInt(16));
            new WorldGenMinable(state, size).func_180709_b(world, random, pos);
        }
    }

    @SubscribeEvent
    public void pickAmmo(EntityItemPickupEvent event) {
        ItemStack stack = event.getItem().func_92059_d();
        if (event.getItem().getEntityData().func_74767_n("Fake")) {
            event.setResult(Event.Result.ALLOW);
            return;
        }
        if (stack.func_77973_b() instanceof ItemFoodThrowable && stack.func_77942_o() && stack.func_77978_p().func_74767_n("IsHealing")) {
            if (event.getEntityPlayer().func_110143_aJ() < event.getEntityPlayer().func_110138_aP()) {
                event.getEntityPlayer().func_70691_i(event.getEntityPlayer().func_110138_aP() * (float)((ItemFood)TF2weapons.itemSandvich).func_150905_g(stack) / 28.0f);
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    event.setResult(Event.Result.ALLOW);
                }
            } else {
                event.getEntityPlayer().func_184811_cZ().func_185145_a(stack.func_77973_b(), 0);
            }
            stack.func_77982_d(null);
            return;
        }
        if (WeaponsCapability.get(event.getEntity()).isInvisible()) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
            return;
        }
        if (stack.func_77973_b() instanceof ItemAmmoPackage) {
            ItemStack weapon = event.getEntityPlayer().func_184614_ca();
            int ammoType = stack.func_77960_j() % 16;
            if (!weapon.func_190926_b() && weapon.func_77973_b() instanceof ItemUsable && ((ItemUsable)weapon.func_77973_b()).getAmmoType(weapon) != 0 && ((ItemUsable)weapon.func_77973_b()).getAmmoType(weapon) < ItemAmmo.AMMO_TYPES.length) {
                ammoType = ((ItemUsable)weapon.func_77973_b()).getAmmoType(weapon);
            } else {
                for (ItemStack invstack : event.getEntityPlayer().field_71071_by.field_70462_a) {
                    if (invstack.func_190926_b() || !(invstack.func_77973_b() instanceof ItemUsable) || ((ItemUsable)invstack.func_77973_b()).getAmmoType(invstack) == 0 || ((ItemUsable)invstack.func_77973_b()).getAmmoType(invstack) >= ItemAmmo.AMMO_TYPES.length) continue;
                    ammoType = ((ItemUsable)invstack.func_77973_b()).getAmmoType(invstack);
                    break;
                }
            }
            stack = ItemAmmoPackage.convertPackage(stack, event.getEntityPlayer(), ammoType);
            event.getItem().func_92058_a(stack);
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
            return;
        }
        if (stack.func_77973_b() instanceof ItemMoney) {
            ItemMoney.collect(stack, event.getEntityPlayer());
            event.setResult(Event.Result.ALLOW);
        }
        ItemStack stackam = TF2Util.pickAmmo(stack, event.getEntityPlayer(), false);
        stack.func_190920_e(stackam.func_190916_E());
        if (stack.func_190926_b()) {
            event.setResult(Event.Result.ALLOW);
            return;
        }
        event.setResult(Event.Result.DEFAULT);
    }

    public static void onStrangeUpdate(ItemStack stack, EntityLivingBase player) {
        int points = 0;
        if (stack.func_77973_b() instanceof ItemMedigun) {
            points = stack.func_77978_p().func_74762_e("Ubercharges");
        } else if (stack.func_77973_b() instanceof ItemCloak) {
            points = stack.func_77978_p().func_74762_e("CloakTicks") / 400;
        } else {
            points = stack.func_77978_p().func_74762_e("Kills");
            points += stack.func_77978_p().func_74762_e("PlayerKills") * 5;
        }
        int calculatedLevel = 0;
        if (points >= STRANGE_KILLS[STRANGE_KILLS.length - 1]) {
            calculatedLevel = STRANGE_KILLS.length - 1;
        } else {
            for (int i = 1; i < STRANGE_KILLS.length; ++i) {
                if (points >= STRANGE_KILLS[i]) continue;
                calculatedLevel = i - 1;
                break;
            }
        }
        if (calculatedLevel > stack.func_77978_p().func_74762_e("StrangeLevel")) {
            stack.func_77978_p().func_74768_a("StrangeLevel", calculatedLevel);
            if (player instanceof EntityPlayer) {
                int rewardLevel = calculatedLevel < 10 ? calculatedLevel : calculatedLevel * 2 - 10;
                TF2Util.setExperiencePoints((EntityPlayer)player, TF2Util.getExperiencePoints((EntityPlayer)player) + 35 * rewardLevel);
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)player), (ItemStack)new ItemStack(TF2weapons.itemTF2, MathHelper.func_76123_f((float)((float)rewardLevel / 2.0f)), 6));
                if (calculatedLevel == 20) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)player), (ItemStack)new ItemStack(TF2weapons.itemTF2, 2, 7));
                }
            }
        }
    }

    @SubscribeEvent
    public void addTable(LootTableLoadEvent event) {
        if (!TF2ConfigVars.disableLoot && (event.getName().equals((Object)LootTableList.field_186422_d) || event.getName().equals((Object)LootTableList.field_186421_c) || event.getName().equals((Object)LootTableList.field_186425_g) || event.getName().equals((Object)LootTableList.field_186424_f) || event.getName().equals((Object)LootTableList.field_186428_j))) {
            event.getTable().addPool(TF2EventsCommon.getLootPool(new ResourceLocation("rafradek_tf2_weapons", event.getName().func_110623_a())));
        }
    }

    @SubscribeEvent
    public void craftEvent(PlayerEvent.ItemCraftedEvent event) {
    }

    @SubscribeEvent
    public void itemToss(ItemTossEvent event) {
        ItemStack stack = event.getEntityItem().func_92059_d();
        if (!event.getPlayer().field_70170_p.field_72995_K && stack.func_77973_b() instanceof ItemUsable && ((WeaponData.WeaponDataCapability)stack.getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).active > 0) {
            WeaponsCapability.get((Entity)event.getPlayer()).setInactiveHand(EnumHand.MAIN_HAND, stack);
        }
        if (stack.func_77973_b() instanceof ItemFoodThrowable && !event.getPlayer().func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            event.getPlayer().func_184811_cZ().func_185145_a(stack.func_77973_b(), ((ItemFoodThrowable)stack.func_77973_b()).waitTime / (TF2ConfigVars.fastItemCooldown ? 2 : 1));
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74757_a("IsHealing", true);
        }
        if (stack.func_77973_b() instanceof ItemFromData && stack.func_77942_o() && (stack.func_77978_p().func_74767_n("Bought") || stack.func_77978_p().func_74767_n("Valve"))) {
            event.getEntity().func_184224_h(true);
            event.getEntityItem().func_145799_b(event.getPlayer().func_70005_c_());
        }
    }

    @SubscribeEvent
    public void itemExpire(ItemExpireEvent event) {
        ItemStack stack = event.getEntityItem().func_92059_d();
        String thrower = event.getEntityItem().func_145800_j();
        if (stack.func_77973_b() instanceof ItemFromData && thrower != null) {
            HashMap<String, MerchantRecipeList> map = ((TF2WorldStorage)event.getEntityItem().field_70170_p.getCapability(TF2weapons.WORLD_CAP, null)).lostItems;
            if (!map.containsKey(thrower)) {
                map.put(thrower, new MerchantRecipeList());
            }
            int cost = ItemFromData.getData(stack).getInt(PropertyType.COST) / 3;
            ItemStack ingot = new ItemStack(TF2weapons.itemTF2, cost / 9, 2);
            ItemStack nugget = new ItemStack(TF2weapons.itemTF2, cost % 9, 6);
            map.get(thrower).add((Object)new MerchantRecipe(ingot.func_190916_E() > 0 ? ingot : nugget, nugget.func_190916_E() > 0 && ingot.func_190916_E() > 0 ? nugget : ItemStack.field_190927_a, stack, 0, 1));
        }
    }

    @SubscribeEvent
    public void startTrack(PlayerEvent.StartTracking event) {
        if (event.getTarget().hasCapability(TF2weapons.WEAPONS_CAP, null)) {
            TF2weapons.network.sendTo(new TF2Message.ActionMessage(WeaponsCapability.get((Entity)event.getTarget()).state, (EntityLivingBase)event.getTarget()), (EntityPlayerMP)event.getEntityPlayer());
            TF2weapons.network.sendTo(new TF2Message.CapabilityMessage(event.getTarget(), true), (EntityPlayerMP)event.getEntityPlayer());
        }
        if (event.getTarget().hasCapability(TF2weapons.PLAYER_CAP, null) && event.getTarget() == event.getEntityPlayer()) {
            TF2weapons.network.sendTo(new TF2Message.PlayerCapabilityMessage(event.getTarget(), true), (EntityPlayerMP)event.getEntityPlayer());
        }
        if (event.getTarget().hasCapability(TF2weapons.INVENTORY_CAP, null) && !event.getTarget().field_70170_p.field_72995_K) {
            InventoryWearables inv = (InventoryWearables)((Object)event.getTarget().getCapability(TF2weapons.INVENTORY_CAP, null));
            TF2weapons.network.sendTo(new TF2Message.WearableChangeMessage(event.getTarget(), 0, inv.func_70301_a(0)), (EntityPlayerMP)event.getEntityPlayer());
            TF2weapons.network.sendTo(new TF2Message.WearableChangeMessage(event.getTarget(), 1, inv.func_70301_a(1)), (EntityPlayerMP)event.getEntityPlayer());
            TF2weapons.network.sendTo(new TF2Message.WearableChangeMessage(event.getTarget(), 2, inv.func_70301_a(2)), (EntityPlayerMP)event.getEntityPlayer());
            TF2weapons.network.sendTo(new TF2Message.WearableChangeMessage(event.getTarget(), 3, inv.func_70301_a(3)), (EntityPlayerMP)event.getEntityPlayer());
        }
        if (event.getTarget() instanceof EntityTF2Character) {
            InventoryLoadout loadout = ((EntityTF2Character)event.getTarget()).loadout;
            for (int i = 0; i < loadout.getSlots(); ++i) {
                TF2weapons.network.sendTo(new TF2Message.WearableChangeMessage(event.getTarget(), 20 + i, loadout.getStackInSlot(i)), (EntityPlayerMP)event.getEntityPlayer());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void dropFakeItems(PlayerDropsEvent event) {
        if (WeaponsCapability.get(event.getEntity()).isFeign()) {
            for (EntityItem item : event.getDrops()) {
                item.getEntityData().func_74757_a("Fake", true);
                item.func_70288_d();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void dropItems(PlayerDropsEvent event) {
        int i;
        InventoryWearables inv = (InventoryWearables)((Object)event.getEntityLiving().getCapability(TF2weapons.INVENTORY_CAP, null));
        for (i = 2; i < 4; ++i) {
            if (inv.func_70301_a(i) == null) continue;
            event.getEntityPlayer().func_146097_a(inv.func_70301_a(i), true, false);
        }
        for (i = 5; i < 8; ++i) {
            if (inv.func_70301_a(i) == null) continue;
            event.getEntityPlayer().func_146097_a(inv.func_70301_a(i).func_77979_a(MathHelper.func_76141_d((float)((float)inv.func_70301_a(i).func_190916_E() * 0.25f))), true, false);
        }
    }

    @SubscribeEvent
    public void register(RegistryEvent.Register<SoundEvent> event) {
        TF2Sounds.registerSounds();
        for (WeaponData weapon : MapList.nameToData.values()) {
            for (PropertyType<String> propertyType : weapon.properties.keySet()) {
                ResourceLocation soundLocation;
                if (!propertyType.name.contains("sound") || "".equals((soundLocation = new ResourceLocation(weapon.getString(propertyType))).func_110623_a())) continue;
                TF2Sounds.register(soundLocation);
                if (propertyType != PropertyType.FIRE_SOUND && propertyType != PropertyType.FIRE_LOOP_SOUND && propertyType != PropertyType.CHARGED_FIRE_SOUND) continue;
                TF2Sounds.register(new ResourceLocation(weapon.getString(propertyType) + ".crit"));
            }
        }
        for (SoundEvent sevent : TF2Sounds.SOUND_EVENTS.values()) {
            event.getRegistry().register((IForgeRegistryEntry)sevent);
        }
    }

    @SubscribeEvent
    public void looting(LootingLevelEvent event) {
        if (event.getDamageSource() instanceof TF2DamageSource) {
            event.setLootingLevel(event.getLootingLevel() + (int)TF2Attribute.getModifier("Looting", ((TF2DamageSource)event.getDamageSource()).getWeapon(), 0.0f, (EntityLivingBase)event.getDamageSource().func_76346_g()));
        }
    }

    @SubscribeEvent
    public void containerOpen(PlayerContainerEvent.Open event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K && event.getContainer() instanceof ContainerMercenary) {
            ((ContainerMerchant)event.getContainer()).func_75174_d();
            ((ContainerMercenary)event.getContainer()).mercenary.func_145748_c_();
            MerchantRecipeList merchantrecipelist = ((ContainerMercenary)event.getContainer()).mercenary.func_70934_b(event.getEntityPlayer());
            if (merchantrecipelist != null) {
                PacketBuffer packetbuffer = new PacketBuffer(Unpooled.buffer());
                packetbuffer.writeInt(event.getContainer().field_75152_c);
                merchantrecipelist.func_151391_a(packetbuffer);
                ((EntityPlayerMP)event.getEntityPlayer()).field_71135_a.func_147359_a((Packet)new SPacketCustomPayload("MC|TrList", packetbuffer));
            }
        }
    }

    @SubscribeEvent
    public void equipItem(LivingEquipmentChangeEvent event) {
        if (event.getEntityLiving().hasCapability(TF2weapons.WEAPONS_CAP, null) && WeaponsCapability.get((Entity)event.getEntityLiving()).getUsedToken() >= 0 && event.getTo().hasCapability(TF2weapons.WEAPONS_DATA_CAP, null)) {
            ((WeaponData.WeaponDataCapability)event.getTo().getCapability(TF2weapons.WEAPONS_DATA_CAP, null)).usedClass = WeaponsCapability.get((Entity)event.getEntityLiving()).getUsedToken();
        }
    }

    @SubscribeEvent
    public void drops(LivingDropsEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer && TF2Util.isEnemy((EntityLivingBase)event.getSource().func_76346_g(), event.getEntityLiving()) && !(event.getEntityLiving() instanceof IEntityTF2) && event.getSource() instanceof TF2DamageSource && event.getEntityLiving().func_70681_au().nextFloat() < TF2ConfigVars.dropAmmo) {
            event.getDrops().add(event.getEntityLiving().func_70099_a(new ItemStack(TF2weapons.itemAmmoPackage, 1, 1 + event.getEntityLiving().func_70681_au().nextInt(ItemAmmoPackage.AMMO_PACKAGE_MIN.length - 1)), 0.0f));
        }
    }

    @SubscribeEvent
    public void arrowHeadshot(ProjectileImpactEvent.Arrow event) {
        if (event.getRayTraceResult().field_72308_g instanceof EntityLivingBase && event.getArrow().getEntityData().func_74767_n("TF2Arrow")) {
            RayTraceResult trace = (RayTraceResult)Iterables.getFirst(TF2Util.pierce(event.getEntity().field_70170_p, event.getArrow().field_70250_c, event.getArrow().field_70165_t, event.getArrow().field_70163_u, event.getArrow().field_70161_v, event.getArrow().field_70165_t + event.getArrow().field_70159_w, event.getArrow().field_70163_u + event.getArrow().field_70181_x, event.getArrow().field_70161_v + event.getArrow().field_70179_y, true, 0.08f, false), null);
            float armor = (float)((EntityLivingBase)event.getRayTraceResult().field_72308_g).func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e();
            if (trace.hitInfo instanceof Boolean && ((Boolean)trace.hitInfo).booleanValue()) {
                event.getArrow().getEntityData().func_74757_a("CritHeadshot", true);
                if (((EntityLivingBase)event.getRayTraceResult().field_72308_g).func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
                    event.getArrow().func_70239_b(event.getArrow().func_70242_d() * 1.25);
                }
                event.getArrow().func_70239_b(event.getArrow().func_70242_d() * (1.0 - (double)armor * 0.0115));
            }
            event.getArrow().func_70239_b(event.getArrow().func_70242_d() * (1.0 - (double)armor * 0.0152));
        }
    }

    public static LootPool getLootPool(ResourceLocation res) {
        return new LootPool(new LootEntry[]{new LootEntryTable(res, 1, 0, new LootCondition[0], "combined")}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f), "combined");
    }

    public static List<BannerPattern> getPatterns(TileEntityBanner banner) {
        ArrayList<BannerPattern> patterns = new ArrayList<BannerPattern>();
        patterns.add(BannerPattern.BASE);
        NBTTagList patternsnbt = banner.func_189515_b(new NBTTagCompound()).func_150295_c("Patterns", 10);
        block0: for (int i = 0; i < patternsnbt.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = patternsnbt.func_150305_b(i);
            for (BannerPattern pattern : BannerPattern.values()) {
                if (!pattern.func_190993_b().equals(nbttagcompound.func_74779_i("Pattern"))) continue;
                patterns.add(pattern);
                continue block0;
            }
        }
        return patterns;
    }

    static {
        STRANGE_TITLES = new String[]{"Strange", "Unremarkable", "Scarely lethal", "Mildly Menacing", "Somewhat threatening", "Uncharitable", "Notably dangerous", "Sufficiently lethal", "Truly feared", "Spectacularly lethal", "Gore-spatterer", "Wicked nasty", "Positively inhumane", "Totally ordinary", "Face-melting", "Rage-inducing", "Server-clearing", "Epic", "Legendary", "Australian", "Hale's own"};
        STRANGE_KILLS = new int[]{0, 10, 25, 45, 70, 100, 135, 175, 225, 275, 350, 500, 750, 999, 1000, 1500, 2500, 5000, 7500, 7616, 8500};
        fakeEntities = new HashMap();
        pathsToDefine = new ArrayList();
        ENTITY_OVERHEAL = new DataParameter(170, DataSerializers.field_187193_c);
        REMOVE_ARMOR = UUID.fromString("5a0959c5-90e8-486b-ae51-26f69f19a248");
        tickTimeLiving = new long[20];
        tickTimeMercUpdate = new long[20];
        tickTimeOther = new long[20];
    }

    public static class TF2ContainerListener
    implements IContainerListener {
        public EntityPlayerMP player;

        public TF2ContainerListener(EntityPlayerMP player) {
            this.player = player;
        }

        public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
            if (this.player.func_184614_ca().func_77973_b() instanceof ItemWeapon) {
                TF2weapons.network.sendTo(new TF2Message.UseMessage(((ItemWeapon)this.player.func_184614_ca().func_77973_b()).getClip(this.player.func_184614_ca()), false, ((ItemUsable)this.player.func_184614_ca().func_77973_b()).getAmmoAmount((EntityLivingBase)this.player, this.player.func_184614_ca()), EnumHand.MAIN_HAND), this.player);
            }
        }

        public void func_175173_a(Container containerIn, IInventory inventory) {
        }

        public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
        }

        public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
        }
    }

    public static class TF2WorldStorage
    implements ICapabilityProvider,
    INBTSerializable<NBTTagCompound> {
        public int eventFlag;
        public World world;
        public HashMap<Entity, InboundDamage> damage = new HashMap();
        public ArrayList<BlockPos> banners = new ArrayList();
        public HashMap<String, MerchantRecipeList> lostItems = new HashMap();
        private HashMap<UUID, PlayerPersistStorage> playerStorage = new HashMap();
        public Map<UUID, InvasionEvent> invasions = new HashMap<UUID, InvasionEvent>();
        public ArrayList<DestroyBlockEntry> destroyProgress = new ArrayList();
        public MannCoBuilding.MapGen mannCoGenerator = new MannCoBuilding.MapGen();
        public ScatteredFeatureTF2Base.MapGen tf2BaseGenerator = new ScatteredFeatureTF2Base.MapGen(null);
        public boolean silent;

        public TF2WorldStorage(World world) {
            this.world = world;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("Event", this.eventFlag);
            NBTTagCompound items = new NBTTagCompound();
            nbt.func_74782_a("Items", (NBTBase)items);
            NBTTagList bannersS = new NBTTagList();
            for (BlockPos blockPos : this.banners) {
                NBTTagList nBTTagList = new NBTTagList();
                nBTTagList.func_74742_a((NBTBase)new NBTTagInt(blockPos.func_177958_n()));
                nBTTagList.func_74742_a((NBTBase)new NBTTagInt(blockPos.func_177956_o()));
                nBTTagList.func_74742_a((NBTBase)new NBTTagInt(blockPos.func_177952_p()));
                bannersS.func_74742_a((NBTBase)nBTTagList);
            }
            nbt.func_74782_a("Banners", (NBTBase)bannersS);
            for (Map.Entry entry : this.lostItems.entrySet()) {
                items.func_74782_a((String)entry.getKey(), (NBTBase)((MerchantRecipeList)entry.getValue()).func_77202_a());
            }
            NBTTagCompound tagPlSt = new NBTTagCompound();
            nbt.func_74782_a("PlayerStorage", (NBTBase)tagPlSt);
            for (Map.Entry<UUID, PlayerPersistStorage> entry : this.playerStorage.entrySet()) {
                if (!entry.getValue().save) continue;
                tagPlSt.func_74782_a(entry.getKey().toString(), (NBTBase)entry.getValue().serializeNBT());
            }
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            for (Map.Entry<UUID, InvasionEvent> entry : this.invasions.entrySet()) {
                nBTTagCompound.func_74782_a(entry.getKey().toString(), (NBTBase)entry.getValue().serializeNBT());
            }
            nbt.func_74782_a("Invasions", (NBTBase)nBTTagCompound);
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.eventFlag = nbt.func_74762_e("Event");
            NBTTagCompound items = nbt.func_74775_l("Items");
            NBTTagCompound mercslost = nbt.func_74775_l("MercsLost");
            NBTTagCompound tagPlSt = nbt.func_74775_l("PlayerStorage");
            for (String key : items.func_150296_c()) {
                MerchantRecipeList handler = new MerchantRecipeList();
                handler.func_77201_a(items.func_74775_l(key));
                this.lostItems.put(key, handler);
            }
            for (String key : tagPlSt.func_150296_c()) {
                PlayerPersistStorage storage = new PlayerPersistStorage(UUID.fromString(key));
                storage.deserializeNBT(tagPlSt.func_74775_l(key));
                this.playerStorage.put(UUID.fromString(key), storage);
            }
            for (String key : mercslost.func_150296_c()) {
                if (!this.playerStorage.containsKey(UUID.fromString(key))) continue;
                NBTTagList list = nbt.func_150295_c(key, 11);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    int[] pos = list.func_150306_c(i);
                    this.playerStorage.get((Object)UUID.fromString((String)key)).lostMercPos.add(new BlockPos(pos[0], pos[1], pos[2]));
                }
            }
            NBTTagList bannersS = nbt.func_150295_c("Banners", 9);
            for (int i = 0; i < bannersS.func_74745_c(); ++i) {
                NBTTagList coords = (NBTTagList)bannersS.func_179238_g(i);
                this.banners.add(new BlockPos(coords.func_186858_c(0), coords.func_186858_c(1), coords.func_186858_c(2)));
            }
            NBTTagCompound invTag = nbt.func_74775_l("Invasions");
            for (String key : invTag.func_150296_c()) {
                this.invasions.put(UUID.fromString(key), new InvasionEvent(this.world, invTag.func_74775_l(key)));
            }
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return TF2weapons.WORLD_CAP != null && capability == TF2weapons.WORLD_CAP;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (TF2weapons.WORLD_CAP != null && capability == TF2weapons.WORLD_CAP) {
                return (T)TF2weapons.WORLD_CAP.cast((Object)this);
            }
            return null;
        }

        public PlayerPersistStorage getPlayerStorage(EntityPlayer player) {
            return this.getPlayerStorage(player.func_110124_au());
        }

        public PlayerPersistStorage getPlayerStorage(UUID player) {
            if (!this.playerStorage.containsKey(player)) {
                this.playerStorage.put(player, new PlayerPersistStorage(player));
            }
            return this.playerStorage.get(player);
        }

        public boolean startInvasion(EntityPlayer player, int difficulty, boolean force) {
            for (Map.Entry<UUID, InvasionEvent> entry : this.invasions.entrySet()) {
                if (!entry.getKey().equals(player.func_110124_au()) && !entry.getValue().isInRange(player.func_180425_c())) continue;
                if (force) {
                    entry.getValue().finish();
                    continue;
                }
                return false;
            }
            InvasionEvent event = new InvasionEvent(this.world, player.func_180425_c(), difficulty);
            this.invasions.put(player.func_110124_au(), event);
            return true;
        }
    }

    public static class InboundDamage {
        public DamageSource source;
        public float damage;
        public int critical;
        public EntityLivingBase living;
        public ItemStack stack;

        public InboundDamage(DamageSource source, float damage, int critical, EntityLivingBase living, ItemStack stack) {
            this.source = source;
            this.damage = damage;
            this.critical = critical;
            this.living = living;
            this.stack = stack;
        }
    }

    public static class DestroyBlockEntry {
        public BlockPos pos;
        public float curDamage;
        public World world;

        public DestroyBlockEntry(BlockPos pos, World world) {
            this.world = world;
            this.pos = pos;
        }
    }
}

