/*
 * Decompiled with CFR 0.152.
 */
package rafradek.TF2weapons;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.profiler.Profiler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FastProfiler
extends Profiler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<String> sectionList = Lists.newArrayList();
    private final List<Long> timestampList = Lists.newArrayList();
    private String profilingSection = "";
    private final Map<String, Long> profilingMap = Maps.newHashMap();
    private long nanotime;
    private String lastcaller = "";
    private long maxcomplex = 6L;
    private long complex = 0L;

    public void func_76317_a() {
        this.profilingMap.clear();
        this.profilingSection = "";
        this.sectionList.clear();
        this.nanotime = 0L;
    }

    public void func_76320_a(String name) {
        if (this.field_76327_a) {
            ++this.complex;
            if (this.nanotime == 0L) {
                long prev = System.nanoTime();
                long total = 0L;
                for (int i = 0; i < 100; ++i) {
                    total += System.nanoTime() - prev;
                }
                this.nanotime = total / 100L;
            }
            if (this.complex <= this.maxcomplex) {
                if (!this.profilingSection.isEmpty()) {
                    this.profilingSection = this.profilingSection + ".";
                }
                this.profilingSection = this.profilingSection + name;
                this.sectionList.add(this.profilingSection);
                this.timestampList.add(System.nanoTime());
            }
        }
    }

    public void func_194340_a(Supplier<String> p_194340_1_) {
        if (this.field_76327_a) {
            this.func_76320_a(p_194340_1_.get());
        }
    }

    public void func_76319_b() {
        if (this.field_76327_a) {
            --this.complex;
            if (this.complex < this.maxcomplex) {
                long i = System.nanoTime();
                long j = this.timestampList.remove(this.timestampList.size() - 1);
                this.sectionList.remove(this.sectionList.size() - 1);
                long k = i - j;
                if (this.profilingMap.containsKey(this.profilingSection)) {
                    this.profilingMap.put(this.profilingSection, this.profilingMap.get(this.profilingSection) + k);
                } else {
                    this.profilingMap.put(this.profilingSection, k);
                }
                if (k > 50000000L) {
                    LOGGER.warn("Something's taking too long! '{}' of {} took aprox {} ms", (Object)this.profilingSection, (Object)this.lastcaller, (Object)((double)k / 1000000.0));
                }
                this.profilingSection = this.sectionList.isEmpty() ? "" : this.sectionList.get(this.sectionList.size() - 1);
            }
        }
    }

    public List<Profiler.Result> func_76321_b(String profilerName) {
        if (!this.field_76327_a) {
            return Collections.emptyList();
        }
        long i = this.profilingMap.containsKey("root") ? this.profilingMap.get("root") : 0L;
        long j = this.profilingMap.containsKey(profilerName) ? this.profilingMap.get(profilerName) : -1L;
        ArrayList list = Lists.newArrayList();
        if (!profilerName.isEmpty()) {
            profilerName = profilerName + ".";
        }
        long k = 0L;
        for (String s : this.profilingMap.keySet()) {
            if (s.length() <= profilerName.length() || !s.startsWith(profilerName) || s.indexOf(".", profilerName.length() + 1) >= 0) continue;
            k += this.profilingMap.get(s).longValue();
        }
        float f = k;
        if (k < j) {
            k = j;
        }
        if (i < k) {
            i = k;
        }
        for (String s1 : this.profilingMap.keySet()) {
            if (s1.length() <= profilerName.length() || !s1.startsWith(profilerName) || s1.indexOf(".", profilerName.length() + 1) >= 0) continue;
            long l = this.profilingMap.get(s1);
            double d0 = (double)l * 100.0 / (double)k;
            double d1 = (double)l * 100.0 / (double)i;
            String s2 = s1.substring(profilerName.length());
            list.add(new Profiler.Result(s2, d0, d1));
        }
        for (String s3 : this.profilingMap.keySet()) {
            this.profilingMap.put(s3, this.profilingMap.get(s3) * 999L / 1000L);
        }
        if ((float)k > f) {
            list.add(new Profiler.Result("unspecified", (double)((float)k - f) * 100.0 / (double)k, (double)((float)k - f) * 100.0 / (double)i));
        }
        Collections.sort(list);
        list.add(0, new Profiler.Result(profilerName, 100.0, (double)k * 100.0 / (double)i));
        return list;
    }

    public void func_76318_c(String name) {
        this.func_76319_b();
        this.func_76320_a(name);
    }

    public String func_76322_c() {
        return this.sectionList.isEmpty() ? "[UNKNOWN]" : this.sectionList.get(this.sectionList.size() - 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_194339_b(Supplier<String> p_194339_1_) {
        this.func_76319_b();
        this.func_194340_a(p_194339_1_);
    }

    @Deprecated
    public void startSection(Class<?> profiledClass) {
        if (this.field_76327_a) {
            this.func_76320_a(profiledClass.getSimpleName());
        }
    }
}

