/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;

public interface IValueContainer {
    public List<Entry> getEntries();

    public String updateEntries(Map<String, String> var1, EntityPlayer var2);

    default public boolean requiresTool() {
        return true;
    }

    public BlockPos getContainerPos();

    public static class Entry {
        private String id;
        private String name;
        private Type type;
        private String value;

        public Entry(String id, String name, Type type, Object value) {
            this.id = id;
            this.name = name;
            this.type = type;
            if (value != null) {
                this.value = String.valueOf(value);
            }
        }

        public Entry(String id, String name, String value) {
            this.id = id;
            this.name = name;
            this.value = value;
        }

        public Entry(String id, String value) {
            this.id = id;
            this.value = value;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public Type getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public static enum Type {
            TEXT_FIELD,
            TOGGLE;


            @Nullable
            public static Type get(String name) {
                for (Type type : Type.values()) {
                    if (!type.name().equals(name)) continue;
                    return type;
                }
                return null;
            }
        }
    }
}

